#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile template.csh

setenv tval 3.091
setenv clustersize 80

foreach infile (`basename wb.3dtcorr1d.both.nii .nii`)
foreach subbrick ( 1 )

echo "######################################################################3dclust $subbrick"
3dclust \
-1Dformat \
-nosum \
-1dindex ${subbrick} \
-1tindex ${subbrick} \
-2thresh -${tval} ${tval} \
-savemask ${resdir}/${infile}.${subbrick}_mask.nii \
-dxyz=1 1.44 ${clustersize} \
${resdir}/${infile}.nii \
> ${resdir}/${infile}.${subbrick}_mask.1D

find ${resdir} -size 0 | xargs rm

if (-e ${resdir}/${infile}.${subbrick}_mask.1D) then

echo "######################################################################whereami $subbrick"
whereami \
-space MNI \
-atlas CA_ML_18_MNIA \
-coord_file ${resdir}/${infile}.${subbrick}_mask.1D'[1,2,3]' -tab > \
${resdir}/${infile}.${subbrick}_mask.whereami.1D

echo "######################################################################3dcalc $subbrick"
3dcalc -a ${resdir}/${infile}.${subbrick}_mask.nii \
-b ${resdir}/${infile}.nii"[${subbrick}]" \
-expr "step(a)*b" \
-prefix ${resdir}/${infile}.${subbrick}_fmask.nii

endif

end
end

more ${resdir}/*whereami.1D | grep -v + > ${resdir}/whereami.txt

