#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6




foreach subject (${subs})
foreach cond (thr saf)
foreach maskint ( 101      201      301      401      402      501      502      601      602      701      702      801   901      1001     1101     1102     1103     1201     1202     1301     1302     1303     1304     1401  1402     1403     1501     1502     1503     1601     1701     1702     1801     1802     1803     1901  1902     1903     1904     1905     2001     2101     2102     2103     2104     2201     2202     2203  2204     2205     2301     2302     2303     2401     2402     2501     2502     2503)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}.${maskint}
setenv infile ${logdir}/f10.afni2nifti.csh.${subject}.${cond}

setenv mask ${resdir}/ica.tscores.rank.mask.combine.nii

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

3dmaskave \
-quiet \
-mask ${mask}"<$maskint>" \
$subject.residuals.${cond}.clean.qwarp.blur+tlrc \
> ${stmdir}/${subject}.${cond}.${maskint}.3dtcorr1d.1D

3dTcorr1D \
-mask ${subject}.fs_aparc+aseg.mask.qwarp.3mm.nii \
-prefix $subject.${cond}.${maskint}.3dtcorr1d.nii \
$subject.residuals.${cond}.clean.qwarp.blur+tlrc \
${stmdir}/${subject}.${cond}.${maskint}.3dtcorr1d.1D
 
3dcalc \
-a $subject.${cond}.${maskint}.3dtcorr1d.nii \
-expr 'log((1+a)/(1-a))/2' \
-prefix $subject.${cond}.${maskint}.3dtcorr1d.z.nii

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end
end

#####run swarm command
swarm -t 2 -g 10 -module afni,python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
