#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6




foreach subject (${subs})
foreach cond (thr saf)
foreach maskint ( 1      2      3	both)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}.${maskint}
setenv infile ${logdir}/f10.afni2nifti.csh.${subject}.${cond}

setenv mask ${resdir}/wb.3dtcorrmap.zmean.group.1_mask.nii

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

if ($maskint == "both") then
setenv maskrange "2..3"
else
setenv maskrange $maskint
endif

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}

3dmaskave \
-quiet \
-mask ${mask}"<$maskrange>" \
$subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
> ${stmdir}/${subject}.${cond}.${maskint}.3dtcorr1d.1D

3dTcorr1D \
-mask ${subject}.fs_aparc+aseg.mask.qwarp.3mm.nii \
-prefix $subject.${cond}.${maskint}.3dtcorr1d.nii \
$subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
${stmdir}/${subject}.${cond}.${maskint}.3dtcorr1d.1D
 
3dcalc \
-a $subject.${cond}.${maskint}.3dtcorr1d.nii \
-expr 'log((1+a)/(1-a))/2' \
-prefix $subject.${cond}.${maskint}.3dtcorr1d.z.nii

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end
end

#####run swarm command
swarm -t 2 -g 10 -module afni,python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
