#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6



foreach subject (${subs})
foreach cond (thr saf)
foreach subbrick (wb 1	2	3	4	5	6	7	8	9	10	11	12	13	14	15	16	17	18	19	20	21	22	23	24	25)

setenv swarmfile ${scrdir}/rm.${outfile}.swarm
setenv logfile ${logdir}/${outfile}.${subject}.${cond}.${subbrick}
setenv infile ${logdir}/f10.afni2nifti.csh.${subject}.${cond}

if (${subbrick} == wb) then 
#	setenv mask ${subject}.fs_aparc+aseg.mask.qwarp.3mm.dilate.nii
	setenv mask ${resdir}/group.wm.mask.thresh.nii
else
	setenv mask ${resdir}/ica.tscores.components.mask.${subbrick}.nii
endif

if (-e ${infile}.log) then
if (-e ${logfile}.log) then 
	echo "this script has been run for subject $subject"
else

#####start of here file
cat > ${logfile} <<End-of-message-fool

cd ${subdir}/${subject}


3dTcorrMap \
-mask ${mask} \
-input $subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
-Zmean $subject.${cond}.${subbrick}.3dtcorrmap.zmean.group.nii

#####end of here file
End-of-message-fool

chmod a+rwx ${logfile}
echo "tcsh -c ${logfile} >> ${logfile}.log" >> ${swarmfile}

endif
else
	echo "please run ${infile} for $subject"
endif
end
end
end

#####run swarm command
swarm -t 2 -g 10 -module afni,python -f ${swarmfile}

#####remove swarm file
rm ${swarmfile}
