#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6

setenv mask ica.tscores.rank.mask.combine.nii
setenv statsfile ${outfile}.1D
cd $resdir
rm $statsfile

echo "mean subject cond maskint masksourceint" \
| tee -a $statsfile

foreach subject (${subs})
foreach cond (thr saf)
foreach maskint ( 101      201      301      401      402      501      502      601      602      701      702      801   901      1001     1101     1102     1103     1201     1202     1301     1302     1303     1304     1401  1402     1403     1501     1502     1503     1601     1701     1702     1801     1802     1803     1901  1902     1903     1904     1905     2001     2101     2102     2103     2104     2201     2202     2203  2204     2205     2301     2302     2303     2401     2402     2501     2502     2503)
foreach masksourceint ( 101      201      301      401      402      501      502      601      602      701      702      801   901      1001     1101     1102     1103     1201     1202     1301     1302     1303     1304     1401  1402     1403     1501     1502     1503     1601     1701     1702     1801     1802     1803     1901  1902     1903     1904     1905     2001     2101     2102     2103     2104     2201     2202     2203  2204     2205     2301     2302     2303     2401     2402     2501     2502     2503)

echo "mean $subject $cond $maskint $masksourceint" \
| tee -a $statsfile

3dmaskave \
-mask ${mask}"<$maskint>" \
${subdir}/${subject}/$subject.${cond}.${masksourceint}.3dtcorr1d.z.nii \
| tee -a rm.$statsfile.$cond.$maskint.$masksourceint

end
end
end
end

paste \
`ls rm.$statsfile*` \
>> $statsfile

rm rm*

