#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 6


foreach subject (${subs})
foreach cond (thr saf)

cd ${subdir}/${subject}

setenv mask ${resdir}/ica.tscores.rank.mask.combine.nii
3dNetCorr \
-fish_z \
-in_rois ${mask} \
-inset $subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
-prefix ${subject}.${cond}.ica.3dnetcorr

setenv mask ${resdir}/power.atlas.mni.10mm_sphere.3mm.nii
3dNetCorr \
-fish_z \
-in_rois ${mask} \
-inset $subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
-prefix ${subject}.${cond}.power.3dnetcorr


setenv mask ${subject}.fs_aparc+aseg.mask.qwarp.3mm.nii
3dNetCorr \
-fish_z \
-in_rois ${mask} \
-inset $subject.residuals.${cond}.clean.qwarp.blur.group+tlrc \
-prefix ${subject}.${cond}.aparc.3dnetcorr

end
end
