#!/bin/tcsh

setenv expdir `dirname $PWD`
setenv subdir ${expdir}/data
setenv scrdir ${expdir}/SCRIPTS
setenv logdir ${expdir}/logs
setenv stmdir ${expdir}/stimtimes
setenv resdir ${expdir}/results
setenv SUBJECTS_DIR ${expdir}/anat
setenv outfile `basename $0`
setenv subs `ls ${subdir}`
setenv subnum `ls ${subdir} | wc -l`
setenv tvalue 3
mkdir ${resdir}/${subnum}_subs





############################################
#
#
#be sure to run this after
#running the group level ICA
#
#
############################################







cd ${resdir}
setenv icafiles `ls ica_sub???_component_ica_s?_.nii` 

echo "##########################ttest"
3dttest++ \
-brickwise \
-setA ${icafiles} \
-prefix ica.ttest.nii

echo "##########################refit"
3drefit \
-space MNI \
-view tlrc \
ica.ttest.nii

echo "##########################allineate"
3dAllineate \
-base ${resdir}/MNI_avg152T1+tlrc \
-mast_dxyz 3 \
-input ica.ttest.nii \
-warp shift_rotate \
-prefix ica.ttest_al.nii

echo "##########################calc"
3dcalc \
-a 'ica.ttest_al.nii[1]' \
-expr 'step(a)' \
-prefix ica.tscores.zerobrick.nii

echo "##########################bucket"
3dbucket \
-prefix ica.tscores.nii \
ica.tscores.zerobrick.nii 'ica.ttest_al.nii[1,3,5,7,9,11,13,15,17,19,21,23,25,27,29,31,33,35,37,39,41,43,45,47,49]'

