function [hdr, record] = analyze_startle(fname, cfg)


cfg.codes = [8, 16];
cfg.upperfreq = 300;
cfg.lowerfreq = 30;
cfg.rectifyms = 20;
cfg.channel = 1;
cfg.ttlchannel = 3;
cfg.baselinelengthms = 50;
cfg.trialstartms = 20;
cfg.trialendms = 100;


%import data
[hdr, record] = edfread(fname);
subject = fname(1:length(fname)-4);

%set sampling rate
samplingrate = hdr.samples(cfg.channel);
nyquistrate = samplingrate/2;
baselinelength = cfg.baselinelengthms/1000*samplingrate;
trialstart = cfg.trialstartms/1000*samplingrate;
trialend = cfg.trialendms/1000*samplingrate;



%bandpass
[b,a] = butter(9,[cfg.lowerfreq cfg.upperfreq]/nyquistrate);
df = filter(b,a,record(cfg.channel,:));


%rectify
dabs = abs(df);

%smooth
windowsize = cfg.rectifyms/1000*samplingrate;
b = (1/windowsize)*ones(1,windowsize);
a = 1;
dsmooth = filter(b,a,dabs);

indices = [];
for i=1:length(cfg.codes)
    
    deriv = [0, diff(record(cfg.ttlchannel,:))];
    indices = [indices, find(deriv == cfg.codes(i))];
    
end;

trialonsets = sort(indices);


for j=1:length(trialonsets)
    baseline = dsmooth(trialonsets(j) - baselinelength:trialonsets(j));
    trial = dsmooth(trialonsets(j) + trialstart:trialonsets(j) + trialend);
    
    
    raw = record(cfg.channel,trialonsets(j) - baselinelength:trialonsets(j) + trialend);
    filtered = df(trialonsets(j) - baselinelength:trialonsets(j) + trialend);
    rectified = dabs(trialonsets(j) - baselinelength:trialonsets(j) + trialend);
    smoothed = dsmooth(trialonsets(j) - baselinelength:trialonsets(j) + trialend);
    ttlsignal = record(cfg.ttlchannel,trialonsets(j) - baselinelength:trialonsets(j) + trialend);
    
    onset(j) = trialonsets(j)/samplingrate;
    blmean(j) = mean(baseline);
    trialpeak(j) = max(trial);
    ttlval(j) = max(ttlsignal);
    
    titlestr = strcat(subject,'.', num2str(j), '.', num2str(ttlval(j)));
    figfname = strcat(titlestr, '.png');
    
    disp('################################save figure')
    clear gcf;
    close all;
    h = figure; set(h, 'Visible', 'Off'); hold on;
    title(titlestr);
    a1 = plot(raw);
    a2 = plot(filtered);
    a3 = plot(rectified);
    a4 = plot(smoothed);
    l1 = 'raw';
    l2 = 'filtered';
    l3 = 'rectified';
    l4 = 'smoothed';
    legend(l1, l2, l3, l4);
    saveas(gcf, figfname);
    
    
    
end;

try
data = [onset', ttlval', blmean', trialpeak'];
data(:,5) = data(:,4) - data(:,3);
data(:,6) = zscore(data(:,5))*10 + 50;
csvwrite(strcat(subject, '.csv'), data);
catch
end;
