% This matlab scritpt interpolates a line to points measured from a kymograph and assigns an x position to each frame.
% These positions can be used as input for the ImageJ plugin: 'Transform'.

%%clear old run
clearvars -except data

%% interpolate line to sample all x coords
vq = interp1(data(:,1),data(:,2),(1:max(data(:,1))));

%% round y values to integers
temp1 = round(vq)';
temp2 = (1:length(temp1));
out(:,1) = temp2;
out(:,2) = temp1-round(mean(temp1));
dlmwrite('out.csv',out,'delimiter','\t');