
#analysis of BIOLOG data. (used to generate Figure and table in Appendix 2)

pm2a<-read.csv("Source data 4.csv",header=T)
head(pm2a)

#subtract mean of blank plates at each timepoint from the respective timepoints for strain plates
adj<-list()
for (s in 1:length(levels(pm2a$substrate)))
{
	subx<-pm2a[pm2a$substrate==levels(pm2a$substrate)[s],]
	blankmean<-colMeans(subx[subx$strain=="blank",-c(1:3)])
	
	subt<-sweep(subx[subx$strain!="blank",-c(1:3)],2,blankmean,FUN="-")
	adjusted<-cbind(subx[subx$strain!="blank",c(1:3)],subt)
	adj[[s]]<-adjusted
	names(adj)[[s]]<-levels(pm2a$substrate)[s]
}
names(adj)

# compare final 48hr results
pvals<-matrix(NA, 96,2)
pvals<-c()
for (s in 1:length(adj))
{
	subx<-adj[[s]]
	pvals[s]<-summary(aov(X48 ~ strain, data=subx ))[[1]][1,5]
	names(pvals)[s]<-as.character(subx$substrate)[1]

}
sigp<-p.adjust(pvals,method="BH")
signif<-names(pvals)[sigp <0.05]
sigp[sigp<0.05]
#[1] "A10 Laminarin"            "A3 a-Cyclodextrin"        "D7 Turanose"              "F7 D-Ribono-1,4- Lactone" "G10 L-Leucine"            "G2 L-Alaninamide"        


cols<-c("grey","grey","#4BC5D8","#4BC5D8", "#4FD8A4","#4FD8A4","#FC7873","#FC7873")
par(mfrow=c(2,3))
for (i in 1:6)
{
	x<-adj[names(adj)== signif[i]][[1]]
	barplot(x$X48,names.arg=x$strain,col=cols)
}


# compare final 48hr results
pvals<-matrix(NA, 96,2)
pvals<-c()
for (s in 1:length(adj))
{
	subx<-adj[[s]]
	pvals[s]<-summary(aov(X24 ~ strain, data=subx ))[[1]][1,5]
	names(pvals)[s]<-as.character(subx$substrate)[1]

}
sigp<-p.adjust(pvals,method="BH")
signif<-names(pvals)[sigp <0.05]
par(mfrow=c(2,5))
for (i in 1:10)
{
	x<-adj[names(adj)== signif[i]][[1]]
	barplot(x$X48,names.arg=x$strain,col=cols)
	title(signif[i])
}

#calculate the relative change in Es/rems strains realtive to mj11
meands<-c(); means<-c()
for (i in 1:length(signif))
{
	x<-adj[names(adj)== signif[i]][[1]]
	dx<-x$X44-x$X0
	mean<-aggregate(dx, by=list(c(1,1,2,2,3,3,4,4)), FUN=mean)
means<-c(means, mean$x)
#	meand<-aggregate(dx, by=list(c(1,1,2,2,1,1,1,1)), FUN=mean) #mj is 2
	#meand<-

}
mat1<-matrix(means,ncol=4,byrow=T)
rownames(mat1)<-names(pvals)[sigp <0.05]
deltas2<-deltas
pvals2<-pvals
signif2<-signif

par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]
	barplot(x$X24,col=cols,yaxt="n")
	title(names(adj)[i],cex=0.2)
}

par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]
	barplot(x$X44,col=cols,yaxt="n")
	title(names(adj)[i],cex=0.2)
}

cols2<-c("#FC7873","grey","#4BC5D8","#4FD8A4")

par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]; x<-droplevels(x)
	plot(0,ylim=range(x[,-c(1:3)]),xlim=c(0,48),yaxt="n",xaxt="n",col="white")
	for (st in 1:4)
		{y<-colMeans(x[x$strain==levels(x$strain)[st],-c(1:3)])
	lines(seq(from=0,to=48,by=4),y,col=cols2[st])}
	legend("bottom",legend=names(adj)[i],bty="n",cex=0.8)
	if (i==1){legend("right",legend=levels(x$strain),text.col=cols2,cex=0.7,bty="n")}
}




#look at each strain's net change after 48 hours
deltas<-list()
for (s in 1:96)
{
	subx<-adj[s][[1]]
	delta<-subx$X48-subx$X0
	names(delta)<-subx$strain
	deltas[[s]]<-delta
	barplot(delta,col=cols,yaxt="n",xaxt="n")
	title(names(adj)[s])
}
deltas2<-deltas
pvals2<-pvals

#test<-adj[1][[1]]
#plot(1:13,test[8,-c(1:3)],ylim=c(-.25,.2))

#pm1 plates
pm1<-read.csv("Source data 3.csv",header=T)
head(pm1)

#subtract mean of blank plates at each timepoint from the respective timepoints for strain plates
adj<-list()
for (s in 1:length(levels(pm1 $substrate)))
{
	subx<-pm1[pm1$substrate==levels(pm1 $substrate)[s],]
	blankmean<-colMeans(subx[subx$strain=="blank",-c(1:3)])
	
	subt<-sweep(subx[subx$strain!="blank",-c(1:3)],2,blankmean,FUN="-")
	adjusted<-cbind(subx[subx$strain!="blank",c(1:3)],subt)
	adj[[s]]<-adjusted
	names(adj)[[s]]<-levels(pm1 $substrate)[s]
}
names(adj)

# final 48hr results
pvals<-matrix(NA, 96,2)
pvals<-c()
for (s in 1:length(adj))
{
	subx<-adj[[s]]
	pvals[s]<-summary(aov(X48 ~ strain, data=subx ))[[1]][1,5]
	names(pvals)[s]<-as.character(subx$substrate)[1]

}

sigp<-p.adjust(pvals,method="BH")
signif<-names(pvals)[sigp <0.05]
 # [1] "A11 D-Mannose "                  "A12 Dulcitol"                    "A2 L-Arabinose"                  "A3 N-Acetyl-D- Glucosamine"      "A4 D-Saccharic Acid"            
 # [6] "A6 D-Galactose"                  "A7 L-Aspartic Acid"              "A8 L-Proline"                    "A9 D-Alanine"                    "B11 D-Mannitol"                 
# [11] "B12 L-Glutamic Acid"             "B5 D-Glucuronic Acid"            "B6 D-Gluconic Acid"              "B7 D,L-a-Glycerol-Phosphate"     "B9 L-Lactic Acid"               
# [16] "C11 D-Melibiose"                 "C12 Thymidine"                   "C3 D,L-Malic Acid"               "C4 D-Ribose"                     "C5 Tween 20"                    
# [21] "C7 D-Fructose"                   "C8 Acetic Acid"                  "C9 a-D-Glucose"                  "D-1 L-Asparagine"                "D2 D-Aspartic Acid"             
# [26] "D5 Tween 40"                     "D6 a-Keto-Glutaric Acid"         "D8 a-Methyl-D- Galactoside"      "E1 L-Glutamine"                  "E2 m-Tartaric Acid"             
# [31] "E3 D-Glucose-1- Phosphate"       "E4 D-Fructose-6- Phosphate"      "E9 Adonitol"                     "F12 Inosine"                     "F3 m-Inositol"                  
# [36] "F4 D-Threonine"                  "F6 Bromo Succinic Acid"          "F7 Propionic Acid"               "F8 Mucic Acid"                   "F9 Glycolic Acid"               
# [41] "G10 Methyl Pyruvate"             "G11 D-Malic Acid"                "G3 L-Serine"                     "G5 L-Alanine"                    "G8 N-Acetyl-b-D- Mannosamine"   
# [46] "G9 Mono Methyl Succinate"        "H1 Glycyl-L-Proline"             "H10 D-Galacturonic Acid"         "H11 Phenylethylamine"            "H12 2-Aminoethanol"             
# [51] "H2 p-Hydroxy Phenyl Acetic Acid" "H4 Tyramine"                     "H5 D-Psicose"                    "H6 L-Lyxose"                     "H7 Glucuronamide"               
# [56] "H9 L-Galactonic Acid--Lactone"  


cols<-c("#4BC5D8", "#4BC5D8","#4FD8A4","#4FD8A4","#FC7873","#FC7873","grey","grey")
par(mfrow=c(8,12),mar=c(1,0,2,0))

#look at each strain's net change after 48 hours
deltas<-list()
for (s in 1:96)
{
	subx<-adj[s][[1]]
	delta<-subx$X48-subx$X0
	names(delta)<-subx$strain
	deltas[[s]]<-delta
	barplot(delta,col=cols,yaxt="n",xaxt="n")
	title(names(adj)[s])
}
deltas1<-deltas
pvals1<-pvals
signif1<-signif
#final timepoint measure for the signif genes
par(mfrow=c(5,7),mar=c(1,0,2,0))
for (i in 1:34)
{
	x<-adj[names(adj)== signif[i]][[1]]
	barplot(x$X48,col=cols,yaxt="n")
	title(signif[i])
}


		#RANDI"S observations


par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]
	barplot(x$X24,col=cols,yaxt="n")
	title(names(adj)[i],cex=0.2)
}

par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]
	barplot(x$X48,col=cols,yaxt="n")
	title(names(adj)[i],cex=0.2)
}

cols2<-c("#FC7873","grey","#4BC5D8","#4FD8A4")

par(mfrow=c(8,12),mar=c(0,0,1,0))
for (i in 1:96)
{
	x<-adj[i][[1]]; x<-droplevels(x)
	plot(0,ylim=range(x[,-c(1:3)]),xlim=c(0,48),yaxt="n",xaxt="n",col="white")
	for (st in 1:4)
		{y<-colMeans(x[x$strain==levels(x$strain)[st],-c(1:3)])
	lines(seq(from=0,to=48,by=4),y,col=cols2[st])}
	legend("top",legend=names(adj)[i],bty="n",cex=0.8)
	if (i==1){legend("right",legend=levels(x$strain),text.col=cols2,cex=0.7,bty="n")}
}


#Observations:
# MJ11 control well is weak relative to the other strains
controls<-pm1[pm1$substrate=="A1 PM1 Control",]
adj[1]

meands<-c(); means<-c()
for (i in 1:length(signif))
{
	x<-adj[names(adj)== signif[i]][[1]]
	dx<-x$X44-x$X0
	mean<-aggregate(dx, by=list(c(1,1,2,2,3,3,4,4)), FUN=mean)
means<-c(means, mean$x)
#	meand<-aggregate(dx, by=list(c(1,1,2,2,1,1,1,1)), FUN=mean) #mj is 2
	#meand<-

}
mat2<-matrix(means,ncol=4,byrow=T)
rownames(mat2)<-names(pvals)[sigp <0.05]

mat<-rbind(mat1,mat2)
colnames(mat)<-c("MJ11","p2p4","delta","ES114")
#write.csv(mat,file="~/Desktop/biologsignif.csv")
## column names in different order for plate 1 vs plate 2..correct in excel!!



#bionimal test 39 out of 190 show remS1 and es114 convergence, while mj11 is opposite
#

#39 out of 44 signif have remS1 responding  like ES114
binom.test(39,44)
	Exact binomial test

data:  39 and 44
number of successes = 39, number of trials = 44, p-value = 1.405e-07
alternative hypothesis: true probability of success is not equal to 0.5
95 percent confidence interval:
 0.7544232 0.9620563
sample estimates:
probability of success 
             0.8863636 
             
             
             
 library(lattice)

tmp2<-data.frame(matrix(unlist(deltas2),ncol=8,nrow=96,byrow=T))
rownames(tmp2)<-names(pvals2);colnames(tmp2)<-names(deltas2[[1]])

tmp<-data.frame(matrix(unlist(deltas1),ncol=8,nrow=96,byrow=T))
rownames(tmp)<-names(pvals1);colnames(tmp)<-names(deltas1[[1]])
tmp<-tmp[,c(7,8,1,2,3,4,5,6)]

both<-rbind(tmp,tmp2)
zscored<-matrix(dat=NA,ncol=8,nrow=nrow(both),dimnames=list(rownames(both),colnames(both)),byrow=T);
for (i in 1:nrow(both)){zscored[i,]<-scale(as.numeric(both[i,]), center=T,scale=T)}

mysubstrates<-rownames(both) %in% c(signif1,signif2)
tzscored<-t(zscored)
rownames(tzscored)
tzscored<-t(zscored[mysubstrates,])

#



rgb.palette <- colorRampPalette(c( "red","black","green"), space = "Lab")
library(gplots)
heatmap.2(tzscored,trace="none",dendrogram="none",key=F,col=rgb.palette(120),density.info=NULL)

par(oma=c(1,1,1,1))
heatmap.2(tzscored, trace="none", dendrogram="none",key=F, col=rgb.palette(120), density.info=NULL, Rowv=NULL)
# dev.off()

