function c = FitCost_BFSatLV_Dp(x)
% x = [100*rij 100*rji log10(Si) log10(Sj)]

global n1 n2 Nt taufe dtau ExtTh CSD r0i rsi Sii

Nc = 2;
taurng = 0:dtau:taufe;

% x is transformed so that its elements are of the same order of magnitude
% Here, true parameters are retrieved by transforming back the x vector  
rLVint = 0.01*[0 x(1); x(2) 0]; 

rpLV = 1/(n1(1)+n2(1))*[n1(1) n2(1)]; % cell distrbution

XLV = CSD*rpLV'; % initial number of each cell type

tau0 = 0; % in hours
tau = tau0;

XLVlm = zeros(Nc,Nt);
ctLV = 0;
while (tau<=taufe-dtau),
    ctLV = ctLV+1;
    tau = taurng(ctLV);
    rLVz = diag(r0i + rsi.*XLV./(XLV+Sii)) + rLVint;
    XLV = XLV + dtau*(rLVz*XLV);
    XLV(XLV<ExtTh) = 0;
    XLVlm(:,ctLV) = XLV;

end

nLV1 = XLVlm(1,1:ctLV);
nLV2 = XLVlm(2,1:ctLV);
% disp(Nt)
% disp(XLVlm(:,max(ctLV,1)))
%
% figure
% semilogy(taurng(1:Nt),n1(1:Nt))
% hold on
% semilogy(taurng(1:Nt),nLV1(1:Nt),':')
% pause

Nsec = 4; % number of sections for calculating the cost function
c = zeros(1,Nsec);
Nti = round(linspace(1,Nt,Nsec+1));
nLV1 = max(nLV1,ExtTh);
nLV2 = max(nLV2,ExtTh);
n1(1:Nt) = max(n1(1:Nt),ExtTh);
n2(1:Nt) = max(n2(1:Nt),ExtTh);
for i = 1:Nsec,
    c(i) = dtau*sum(sum(abs(log([n1(Nti(i):Nti(i+1)); n2(Nti(i):Nti(i+1))])-log([nLV1(Nti(i):Nti(i+1)); nLV2(Nti(i):Nti(i+1))])).^2));
end
% disp(c)

return;