function [r0_est rs_est Si_est] = DeriveBasalFitnessMM_WM_DpMM(r0,rint,CSD,A,B,KMM,tauf)
%% Estimates monoculture parameters of pairwise model (Step 1)

% This code is free to use for any purposes, provided any publications resulting from the use of this code reference the original code/author.
% Author:  Babak Momeni (bmomeni@gmail.com); August 2016
% The code is not guaranteed to be free of errors. Please notify the author of any bugs, and contribute any modifications or bug fixes back to the original author.

%% Deriving equivalent fitness model for chemically interacting species
% r0: population reproduction rates, per hour
% rint: matrix of interaction coefficients
% A: consumption matrix
% B: production matrix
% Si: population levels for influence saturation
% CSD: total initial cells
% dtau: simulation time-step
% tauf: total simulation time

global nm Nt dtau ExtTh DilTh


% Nc: # of cell types
% Nm: # of mediators
[Nc Nm] = size(A);

%% Cell-growth time-course
r0_est = zeros(Nc,1);
rs_est = zeros(Nc,1);
Si_est = zeros(Nc,1);

[Nd cref nref] = DynamicsMM_WM_MonocultureDpMM(r0,rint,CSD,A,B,KMM,ExtTh,DilTh,tauf,dtau);

for jj = 1:Nc,
    Nt = Nd(jj);
    nm = nref(jj,1:Nt);
    x0 = [10 0 6];
    x = lsqnonlin(@FitCost_BasalFitness,x0);

    r0_est(jj) = 0.01*x(1);
    rs_est(jj) = 0.01*x(2);
    Si_est(jj) = 10.^x(3);
%     CompareMonocultureDynamics(Nt,dtau,nm,CSD,r0_est(jj),rs_est(jj),Si_est(jj))
end

return;
