%% LFP_MUA_analysis_InhibIntern_light_stim: Parameters definition
% --> Filenames
% Please specify the full path (not the relative one)
dataFilename = 'D:\Valentina\Experiments\Fellin_group\ChR2_InhibitoryInterneuronsExcitation\13222002laserartLFP_MU.abf';
xlsChR2Template = 'D:\Valentina\Experiments\Fellin_group\code\FINAL_20130531\code\xlsChR2Template.xlsx';
xlsArchTemplate = 'D:\Valentina\Experiments\Fellin_group\code\FINAL_20130531\code\xlsArchTemplate.xlsx';
% --> Experiment type
type = 'ChR2';
% type = 'Arch'; 
% --> Pause option
pausing = 0;    % if 1 the program stops after each sweep analysis and waits for user input
% --> Artifact suppression options
artifact_removal = 1;     % 0, no fixed blanking window is applied
                          % 1, a fixed blanking window is applied
% if the exp type is Arch, the blanking is applied after the stimulus start
% and after the stimulus end; if the exp type is ChR2, the blanking is
% applied only after the stimulus end.
if artifact_removal > 0     % if artifact_removal > 0, please specify the duration of the blanking window to apply after the stimulus start
    artifact_window = 0.01; % in seconds
else
    artifact_window = 0;
end
stimChannelTh = 0.2;      % threshold for detecting a stimulus on the trigger channel
% Beside a fixed blanking, each window (pre-light, light and post-light) can be
% reduced of a fixed percentage (shrinking):
shrinking_factor = 1;     % if 1, no shrinking is performed; 
                          % if less than 1, (1-shrinking_factor) is removed from each window (symmetrically)
% --> Channel definition
stimch = 1;               % in order to select the proper stimulus channel (stimch)
recch_LFP = 2;            % in order to select the proper recording channel for LFP (recch_LFP) 
recch_MU = 3;             % in order to select the proper recording channel for MUA (recch_MUA) 
selected_sweep = [1 3];       % the user can select a subset of sweeps to analyze
% --> Acquisition parameters
sampling_frequency = 50000;
downsampling_factor = 50;   % LFP and stimulus channel are downsampled by downsampling_factor
% --> Spectral analysis parameters
pre_stimulus_window_lenght = 0.2;   % pre-stimulus window, in seconds
post_stimulus_window_lenght = 0.2;  % post-stimulus window, in seconds
% Spectrogram parameters
R = 0.1;            % time duration (in seconds) of the window used for the spectrogram computation
L = 0.001;           % time lapse between windows expressed in seconds
N = 500;            % nfft, number of points used for the computation of the fft (both Welch PSD and spectrogram)
% Welch PSD parameters
windowWelchFactor = 2;  % Welch window length = (1/windowWelchFactor)*signal_window_lenght
overlapPrc = 50;
% Frequency bands
f_ini_s = 1;            % global frequency range
f_fin_s = 100;
f_min_band1 = 2;        % delta frequency range
f_max_band1 = 4;
f_min_band2 = 15;       % alpha frequency range
f_max_band2 = 30;
f_min_band3 = 30;       % gamma low frequency range
f_max_band3 = 60;
f_min_band4 = 60;       % gamma high frequency range
f_max_band4 = 90;
relativePowerCompOnSpectrogram = 1;
% --> MUA Analysis parameters
bin_duration_s = 0.1;       % for PSTH computation, in seconds          
offset_value_mV = 0;        % can be applied to MUA raw data (?)        
threshold_MU_mV = 0.020;    % in mV (the same for all sweeps)