function [fwhm,rhs,lhs,xl,xr,xm] = UP_DOWN_DET_computeFWHM(x,fx,ratio)
% Written by Valentina Pasquale (2017)
% Contact: valentina.pasquale@iit.it
[m,n] = max(fx);                        %	Find maximum value and index
ind = fx>(m.*ratio);                    %	Find indices where I>=max(I)/2
% ind = find(fx>(m.*ratio));            %	Find indices where I>=max(I)/2
UPedges = find(diff(ind)==1)+1;
DOWNedges = find(diff(ind)==-1)+1;
nl = max(UPedges(UPedges-n<=0));
nr = min(DOWNedges(DOWNedges-n>=0));
if isempty(nl)
    xl = x(1);
else
    xl = interp1([fx(nl-1);fx(nl)],[x(nl-1);x(nl)],m.*ratio,'spline');
end
if isempty(nr)
    xr = x(end);
else
    xr = interp1([fx(nr-1);fx(nr)],[x(nr-1);x(nr)],m.*ratio,'spline');
end
%	Get FWHM
fwhm = abs(xr-xl);
rhs = abs(xr-x(n));
lhs = abs(x(n)-xl);
xm = x(n);
end