function syncIdx = UP_DOWN_DET_computeSyncIdx(data,lowFreqRange,highFreqRange,win_samples,welchWinSamples,welchOverlap,nfft,sfLFP)
% Written by Valentina Pasquale (2017)
% Contact: valentina.pasquale@iit.it
nSamples = length(data);
syncIdx = zeros(floor(nSamples./win_samples),1);
for ii = 1:length(syncIdx)
    [curPSD,curF] = pwelch(data((1:win_samples)+((ii-1)*win_samples)),welchWinSamples,welchOverlap,nfft,sfLFP);
    highFreqPower = sum(curPSD(curF>highFreqRange(1)&curF<=highFreqRange(2)));
    lowFreqPower = sum(curPSD(curF>lowFreqRange(1)&curF<=lowFreqRange(2)));
    syncIdx(ii) = lowFreqPower./highFreqPower;   
end
end