function [spikeTimes] = UP_DOWN_DET_detectSpikesJuxtasomal(data,HPcutOff,sf,multCoeff)
% Written by Valentina Pasquale (2017)
% Contact: valentina.pasquale@iit.it
data = data-mean(data);
Wn_norm = HPcutOff./(0.5*sf);
[b,a] = ellip(4,0.1,70,Wn_norm,'high');
dataFilter = filtfilt(b,a,data);
sigma = std(dataFilter);
th = multCoeff*sigma;
% data above threshold
over_thresh = dataFilter>th;
% find beginning and end of each group
spike_start = find(diff(over_thresh)==1)+1;
spike_end = find(diff(over_thresh)==-1);
if ~isempty(spike_start) && ~isempty(spike_end)
    if spike_end(1)<spike_start(1)
        spike_end = spike_end(2:end);
    end
    if spike_start(end)>spike_end(end)
        spike_start = spike_start(1:end-1);
    end
    % putting the spike time where is the peak of the neuron activity
    spikeTimes = zeros(length(spike_start),1);
    for i_spike = 1:length(spike_start)
        [~,max_spike] = max(dataFilter(spike_start(i_spike):spike_end(i_spike)));
        spikeTimes(i_spike) = max_spike+spike_start(i_spike)-1;
    end
else
    spikeTimes = [];
end