function [UP_states_DET, DOWN_states_DET] = UP_DOWN_DET_detectStates(variable, thUP, thDOWN, minInterv, minDuration)
% Written by Valentina Pasquale (2017)
% Contact: valentina.pasquale@iit.it
UP_states = variable>thUP;
UP_states_start = find(diff(UP_states)==1);
UP_states_end = find(diff(UP_states)==-1);
if ~isempty(UP_states_start) && ~isempty(UP_states_end)
    % correct boundaries
    if UP_states_end(1)<UP_states_start(1)
        UP_states_end = UP_states_end(2:end);
    end
    if ~isempty(UP_states_start) && ~isempty(UP_states_end)
        if UP_states_start(end)>UP_states_end(end)
            UP_states_start = UP_states_start(1:end-1);
        end
        if ~isempty(UP_states_start) && ~isempty(UP_states_end)
            % join periods of UP-state (above threshold) that are separated by less
            % than a pre-defined time threshold
            UP_states_DET = [UP_states_start UP_states_end]; % samples
            UP_states_interval = UP_states_DET(2:end,1)-UP_states_DET(1:end-1,2);
            UP_states_2join = find(UP_states_interval<=minInterv);
            joinPeriods = [UP_states_DET(UP_states_2join,2) UP_states_DET(UP_states_2join+1,1)];
            UP_states_signal = convert2stateSignal(UP_states_DET,length(variable));
            joinPeriodsSignal = convert2stateSignal(joinPeriods,length(variable));
            UP_states_signal_join = UP_states_signal | joinPeriodsSignal;
            %%
            UP_states_start = find(diff(UP_states_signal_join)==1);
            UP_states_end = find(diff(UP_states_signal_join)==-1);
            if UP_states_end(1)<UP_states_start(1)
                UP_states_start = [1; UP_states_start];
                %         UP_states_end = UP_states_end(2:end);
            end
            if UP_states_start(end)>UP_states_end(end)
                %             UP_states_start = UP_states_start(1:end-1);
                UP_states_end = [UP_states_end; length(variable)];
            end
            UP_states_DET = [UP_states_start UP_states_end]; % samples
%             UP_states_DET = [find(diff(UP_states_signal_join)==1)  find(diff(UP_states_signal_join)==-1)];
            %%
            % delete UP states shorter than a pre-defined time threshold
            UP_state_dur = UP_states_DET(:,2)-UP_states_DET(:,1);
            UP_states_OK = UP_state_dur>=minDuration;
            UP_states_DET = UP_states_DET(UP_states_OK,:);
        else
            UP_states_DET = [];
        end
    else
        UP_states_DET = [];
    end
else
    UP_states_DET = [];
end
%
DOWN_states = variable<thDOWN;
DOWN_states_start = find(diff(DOWN_states)==1);
DOWN_states_end = find(diff(DOWN_states)==-1);
if ~isempty(DOWN_states_start) && ~isempty(DOWN_states_end)
    if DOWN_states_end(1)<DOWN_states_start(1)
        DOWN_states_end = DOWN_states_end(2:end);
    end
    if ~isempty(DOWN_states_start) && ~isempty(DOWN_states_end)
        if DOWN_states_start(end)>DOWN_states_end(end)
            DOWN_states_start = DOWN_states_start(1:end-1);
        end
        if ~isempty(DOWN_states_start) && ~isempty(DOWN_states_end)
            % join periods of DOWN-state (below threshold) that are separated by less
            % than a pre-defined time threshold
            DOWN_states_DET = [DOWN_states_start DOWN_states_end]; % samples
            DOWN_states_interval = DOWN_states_DET(2:end,1)-DOWN_states_DET(1:end-1,2);
            DOWN_states_2join = find(DOWN_states_interval<=minInterv);
            joinPeriods = [DOWN_states_DET(DOWN_states_2join,2) DOWN_states_DET(DOWN_states_2join+1,1)];
            DOWN_states_signal = convert2stateSignal(DOWN_states_DET,length(variable));
            joinPeriodsSignal = convert2stateSignal(joinPeriods,length(variable));
            DOWN_states_signal_join = DOWN_states_signal | joinPeriodsSignal;
            %%
            DOWN_states_start = find(diff(DOWN_states_signal_join)==1);
            DOWN_states_end = find(diff(DOWN_states_signal_join)==-1);
            if DOWN_states_end(1)<DOWN_states_start(1)
                DOWN_states_start = [1; DOWN_states_start];
                %         DOWN_states_end = DOWN_states_end(2:end);
            end
            if DOWN_states_start(end)>DOWN_states_end(end)
                %             DOWN_states_start = DOWN_states_start(1:end-1);
                DOWN_states_end = [DOWN_states_end; length(variable)];
            end
            DOWN_states_DET = [DOWN_states_start DOWN_states_end]; % samples
%             DOWN_states_DET = [find(diff(DOWN_states_signal_join)==1)  find(diff(DOWN_states_signal_join)==-1)];
            %%
            % delete DOWN states shorter than a pre-defined time threshold
            DOWN_state_dur = DOWN_states_DET(:,2)-DOWN_states_DET(:,1);
            DOWN_states_OK = DOWN_state_dur>=minDuration;
            DOWN_states_DET = DOWN_states_DET(DOWN_states_OK,:);
        else
            DOWN_states_DET = [];
        end
    else
        DOWN_states_DET = [];
    end
else
    DOWN_states_DET = [];
end