function [fullTraces,series,sweeps] = UP_DOWN_DET_organizeData(filename, varargin)
% Script to re-organize data
% - pair LFP and intracellular recordings of the same sweeps
% - concatenate sweeps of the same series
% Written by Valentina Pasquale (2017)
% Contact: valentina.pasquale@iit.it

%% Join 1st and 2nd trace of the same sweep in a unique variable 
% 1st col: time
% 2nd col: Trace 1 (intra- o juxta-cellular)
% 3rd col: Trace 2 (LFP)
if nargin>1
    if nargin == 3
        series = varargin{1};
        sweeps = varargin{2};
    else if nargin ~= 3
            fullTraces = [];
            return
        end
    end
else if nargin == 1
        series = [];
        sweeps = [];
    end
end
load(filename);
trace_files = whos('Trace_*_1');    % finds variables containing 1st trace
trace_files_to_delete = whos('Trace_*_3');    % finds variables containing 1st trace
for jj = 1:length(trace_files_to_delete)
    clear(trace_files_to_delete(jj).name);
end
nTraces = length(trace_files);
for ii = 1:nTraces
    newVarName = trace_files(ii).name(1:end-2); % without _1
    firstTrace = eval(trace_files(ii).name);
    secondTrace = eval([trace_files(ii).name(1:end-2),'_2']);
    fullTrace = [firstTrace secondTrace(:,2)];
    eval([newVarName,'=fullTrace;']);
%     assignin('caller',newVarName,fullTrace);
    clear(trace_files(ii).name,[trace_files(ii).name(1:end-2),'_2']);
    clear firstTrace secondTrace fullTrace newVarName
end
clear ii trace_files
%% Join sweeps belonging to the same series (they are consecutive)
sweep_files = whos('Trace_*');    % finds variables containing traces
% nSweeps = length(sweep_files);
sweep_files_cell = struct2cell(sweep_files);
fileNames_cell = sweep_files_cell(1,:)';
expIdx = zeros(length(fileNames_cell),1);
seriesIdx = zeros(length(fileNames_cell),1); 
sweepIdx = zeros(length(fileNames_cell),1);
for ff = 1:length(fileNames_cell)
    idx_ = strfind(fileNames_cell{ff},'_');
    expIdx(ff) = str2double(fileNames_cell{ff}(idx_(1)+1:idx_(2)-1));
    seriesIdx(ff) = str2double(fileNames_cell{ff}(idx_(2)+1:idx_(3)-1));
    sweepIdx(ff) = str2double(fileNames_cell{ff}(idx_(3)+1:end));
end
sweepIdx(isnan(sweepIdx)) = 0;
% seriesNum = unique(seriesIdx);
% expNum = unique(expIdx);
expNum = 1; % only one exp is taken into consideration
for ii = 1:length(expNum)
    seriesNum = unique(seriesIdx(expIdx==expNum(ii)));
    if isempty(series)
        series = seriesNum;
    end
    fullTraces = cell(length(series),1);
    for jj = 1:length(seriesNum)
        if any(series==seriesNum(jj))
            sweepNum = sweepIdx(seriesIdx==seriesNum(jj)&expIdx==expNum(ii));
            sweepNumSort = sort(sweepNum,'ascend');
            fullTraces{jj} = [];
            if isempty(sweeps) || length(sweeps)<jj
%                 sweeps{jj} = [min(sweepNumSort) max(sweepNumSort)];
                sweeps{jj} = sweepNumSort;
            end
            for kk = 1:length(sweepNumSort)
%                 if (sweepNumSort(kk)>=sweeps{jj}(1) && sweepNumSort(kk)<=sweeps{jj}(2))
                if (any(sweeps{jj}==sweepNumSort(kk)))
                    fullTraces{jj} = [fullTraces{jj}; eval(fileNames_cell{expIdx==expNum(ii)&seriesIdx==seriesNum(jj)&sweepIdx==sweepNumSort(kk)})];
                end
                clear(fileNames_cell{expIdx==expNum(ii)&seriesIdx==seriesNum(jj)&sweepIdx==sweepNumSort(kk)});
            end
            %             newVarName = ['Trace_',num2str(expNum(ii)),'_',num2str(seriesNum(jj))];
            %             assignin('base',newVarName,fullTraces);
            %             clear newVarName fullTraces
        end
    end
end
series = series';
sweeps = sweeps';