%% Script to generate training data cubes

saveFolder = '';

segmentation_conf.parfolder = ['/gaba/u/mberning/backup/zdata_manuel/' ...
    'results/20130610cortexFwdPass/mag1'];
segmentation_conf.fileprefix = '2012-09-28_ex145_07x2_mag1';

knossos_conf.parfolder = ['/gaba/u/mberning/backup/zdata_manuel/data/' ...
    'cortex/2012-09-28_ex145_07x2/mag1'];
knossos_conf.fileprefix = '2012-09-28_ex145_07x2_mag1';

bboxes = {[1001 1500;1001 1500;1001 1200]; ...
          [1001 1500;1001 1500;3000 3200]; ...
          [1001 1500;2501 3000;1001 1200]; ...
          [1001 1500;3001 3500;1001 1200]; ...
          [1001 1500;501 1000;2000 2200]; ...
          [1001 1500;501 1000;500 700]; ...
          [1501 2000;1001 1500;1001 1200]; ...
          [1501 2000;1001 1500;2001 2200]; ...
          [1501 2000;1501 2000;1001 1200]; ...
          [1501 2000;1501 2000;1501 1700]; ...
          [1501 2000;1501 2000;2001 2200]; ...
          [1501 2000;501 1000;1401 1600]; ...
          [1501 2000;501 1000;2001 2200]; ...
          [1501 2000;501 1000;501 700]; ...
          [2001 2500;1001 1500;1001 1200]; ...
          [2001 2500;1501 2000;1401 1600]; ...
          [2001 2500;1501 2000;2801 3000]; ...
          [2001 2500;2001 2500;1901 2100]; ...
          [2001 2500;3001 3500;801 1000]; ...
          [3001 3500;3001 3500;1001 1200]; ...
          [3001 3500;3001 3500;1201 1400]; ...
          [3001 3500;3001 3500;1401 1600]; ...
          [3501 4000;1501 2000;1001 1200]; ...
          [4001 4500;1001 1500;2201 2400]; ...
          [4001 4500;1001 1500;801 1000]; ...
          [4001 4500;2501 3000;1001 1200]; ...
          [4001 4500;3001 3500;1501 1700]; ...
          [4001 4500;4001 4500;501 700]; ...
          [4501 5000;1001 1500;1001 1200]; ...
          [4501 5000;1001 1500;1601 1800]; ...
          [4501 5000;1001 1500;2601 2800]; ...
          [4501 5000;1501 2000;1001 1200]; ...
          [5001 5500;5001 5500;2001 2200]; ...
          [501 1000;1001 1500;2501 2700]; ...
          [501 1000;1001 1500;501 700]; ...
          [501 1000;1501 2000;2001 2200]; ...
          [501 1000;501 1000;501 700]; ...
          [6501 7000;1001 1500;501 700]; ...
          [7001 7500;5001 5500;1501 1700]; ...
          [735 1585;980 1581;769 1065]};

for i = 1:length(bboxes)
    bbox = bboxes{i};
    [ data, metadata ] = SynEM.Paper.TrainingSet.calculateContacts( ...
        knossos_conf, segmentation_conf, bbox, [40 80 160], true );
    save([SynEM.Util.addFilesep(saveFolder), knossos_conf.fileprefix, ...
        'x', bbox(1,1), '-', bbox(1,2), 'y', bbox(2,1), '-', bbox(2,2), ...
        'z', bbox(3,1), '-', bbox(3,2)], 'data','metadata');
end