function groupTrainingData( folder )
%GROUPTRAININGDATA Group the training data into trainining and validation
%set.
% INPUT folder: string
%           Path to folder containing the training data features
%           (see also calculateFeaturesForTrainingData).
% Author: Benedikt Staffler <benedikt.staffler@brain.mpg.de>

folder = SynEM.Util.addFilesep(folder);
trainPaper = { ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y1001-1500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y1001-1500_z3000-3200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y2501-3000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y3001-3500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y501-1000_z2000-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1001-1500_y501-1000_z500-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y1001-1500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y1001-1500_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y1501-2000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y501-1000_z1401-1600.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y501-1000_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y501-1000_z501-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y1501-2000_z1401-1600.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y1501-2000_z2801-3000.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x3001-3500_y3001-3500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x3001-3500_y3001-3500_z1201-1400.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x3501-4000_y1501-2000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4001-4500_y1001-1500_z2201-2400.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4001-4500_y1001-1500_z801-1000.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4001-4500_y3001-3500_z1501-1700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4001-4500_y4001-4500_z501-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y1001-1500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y1001-1500_z1601-1800.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y1001-1500_z2601-2800.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y1501-2000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x5001-5500_y5001-5500_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x501-1000_y1001-1500_z2501-2700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x501-1000_y1001-1500_z501-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x501-1000_y1501-2000_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x501-1000_y501-1000_z501-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x6501-7000_y1001-1500_z501-700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x735-1585_y980-1581_z769-1065.mat'};
validationCubes = { ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y1501-2000_z1501-1700.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x1501-2000_y1501-2000_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y1001-1500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y2001-2500_z1901-2100.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y3001-3500_z801-1000.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x3001-3500_y3001-3500_z1401-1600.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4001-4500_y2501-3000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x7001-7500_y5001-5500_z1501-1700.mat'};
trainingNew = { ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y2501-3000_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y2501-3000_z2001-2200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y4001-4500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y5001-5500_z1001-1200.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x2001-2500_y501-1000_z1401-1600.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y2501-3000_z401-600.mat', ...
    'Features_2012-09-28_ex145_07x2_mag1_x4501-5000_y501-1000_z801-1000.mat'};

if ~exist([folder 'train'],'dir')
    mkdir([folder 'train']);
end
if ~exist([folder 'val'],'dir')
    mkdir([folder 'val']);
end
if ~exist([folder 'unused'],'dir')
    mkdir([folder 'unused']);
end

s = what(folder);
fprintf('[%s] Found %d feature files.\n', datestr(now), length(s.mat));
for i = 1:length(s.mat)
    if any(strcmp(s.mat{i},validationCubes))
        movefile([folder s.mat{i}],[folder 'val' filesep]);
    elseif any(strcmp(s.mat{i},trainingNew))
        movefile([folder s.mat{i}],[folder 'unused' filesep]);
    elseif any(strcmp(s.mat{i},trainPaper))
        movefile([folder s.mat{i}],[folder 'train' filesep]);
    else
        fprintf('File %s not associated to any group.\n',s.mat{i});
    end
end
s1 = what([folder 'train']);
s2 = what([folder 'val']);
s3 = what([folder 'unused']);
fprintf(['[%s] Copied %d files to train folder, ' ...
         '%d files to val folder and %d files to unused folder.\n'], ...
          datestr(now), length(s1.mat), length(s2.mat), length(s3.mat));

end

