clear all;
% spm fmri

correctdir = 'C:\Experiments\DAD\TAB_art\';
anatdir = 'C:\Experiments\DAD\Anatomical\';

%

subj = {'D02','D03','D04','D05','D08','D11','D13','D14','D15','D16','D17','D18','D19',...
    'D20','D21','D22','D23','D24','D25','D26','D29','D30','D31','D33','D60','D61','D84','D85','D34',...
    'D35','D36','D37','D38','D39','D40','D42','D43','D46','D47','D48','D49','D50','D52','D55','D58',...
    'D62','D63','D64','D65','D66','D67','D70','D72','D80','D82','D83','D86','D90'};

maxframes = 330;
runs = 2;

four2three = 1;

slicecorr = 0;
maxframes = 330;
Outslice = 18; %default threshold for correction taken from SPM
repair_flag = 1;
mask_flag = 1;

timecorr = 1;

realign = 1;

smooth = 1;

normalise = 0;

movecorrect = 1;

for subjindx = 2:length(subj)
    
    if four2three
        for Run = 1:runs
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            cd(ScanDir)
            fname = sprintf('TABrun%d.nii', Run);
            abk_4Dto3D([correctdir char(subj(subjindx)) filesep sprintf('run%d', Run) filesep fname]);
        end
    end
    
    if slicecorr
        ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
        cd(ScanDir)
        filt        = '[_][0-9][0-9][0-9]';
        Pimages     =  spm_select('ExtList',pwd, filt, 1:maxframes);
        art_slice(Pimages, Outslice, repair_flag, mask_flag);
        delete('TABrun1_*');
    end
    
    if timecorr
        for Run = 1:runs
            filt         = sprintf('^TABrun%d[_][0-9][0-9][0-9]', Run);
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            cd(ScanDir)
            niifiles     = spm_select('ExtList',pwd, filt, 1:maxframes);
            scans        = cellstr([repmat([pwd filesep],size(niifiles,1),1) niifiles]);
            matlabbatch{1}.spm.temporal.st.scans    = {scans};
            matlabbatch{1}.spm.temporal.st.nslices  = 37;
            matlabbatch{1}.spm.temporal.st.tr       = 2;
            matlabbatch{1}.spm.temporal.st.ta       = 1.94594594594595;
            matlabbatch{1}.spm.temporal.st.so       = [1 3 5 7 9 11 13 15 17 19 21 23 25 27 29 31 33 35 37 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30 32 34 36];
            matlabbatch{1}.spm.temporal.st.refslice = 37;
            matlabbatch{1}.spm.temporal.st.prefix   = 'a';
            
            display(['slice time correcting' char(subj(subjindx)) ' ' ])
            spm_jobman('run',matlabbatch)
            
            clear matlabbatch;
            clear scans;
        end
    end
    
    if realign
        for Run = 1:runs
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            cd(ScanDir)
            filt        = '^a*';
            niifiles    = spm_select('ExtList',ScanDir, filt, 1:maxframes);
            scans{Run}  = cellstr([repmat([ScanDir filesep],size(niifiles,1),1) niifiles]);
        end
        
        matlabbatch{1}.spm.spatial.realign.estwrite.data = {scans{1}; scans{2}};
        
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.quality = 0.9;
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.sep = 4;
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.fwhm = 5;
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.rtm = 1;
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.interp = 2;
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.wrap = [0 0 0];
        matlabbatch{1}.spm.spatial.realign.estwrite.eoptions.weight = '';
        matlabbatch{1}.spm.spatial.realign.estwrite.roptions.which = [0 1];
        matlabbatch{1}.spm.spatial.realign.estwrite.roptions.interp = 4;
        matlabbatch{1}.spm.spatial.realign.estwrite.roptions.wrap = [0 0 0];
        matlabbatch{1}.spm.spatial.realign.estwrite.roptions.mask = 1;
        matlabbatch{1}.spm.spatial.realign.estwrite.roptions.prefix = 'r';
        
        display(['realigning' char(subj(subjindx)) ' '])
        spm_jobman('run',matlabbatch)
        
        clear matlabbatch;
        clear scans;
        delete('TABrun_*')
    end
    
    if smooth
        for Run = 1:runs
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            filt        = '^a*';
            niifiles    = spm_select('ExtList',ScanDir, filt, 1:maxframes);
            scans  = cellstr([repmat([ScanDir filesep],size(niifiles,1),1) niifiles]);
            
            matlabbatch{1}.spm.spatial.smooth.data = scans;
            matlabbatch{1}.spm.spatial.smooth.fwhm = [4 4 4];
            matlabbatch{1}.spm.spatial.smooth.dtype = 0;
            matlabbatch{1}.spm.spatial.smooth.im = 0;
            matlabbatch{1}.spm.spatial.smooth.prefix = 's';
            display(['smoothing ' char(subj(subjindx)) ' '])
            spm_jobman('run',matlabbatch)
            
            clear matlabbatch;
            clear scans;
            delete('aTABrun_*')
        end
    end
    
    if movecorrect
        for Run = 1:runs
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            cd(ScanDir)
            filt        = '^saT*';
            niifiles    = spm_select('ExtList',ScanDir, filt, 1:maxframes);
            Images      = [repmat([ScanDir filesep],size(niifiles,1),1) niifiles];
            RealignmentFile = spm_select('List',ScanDir, 'rp_*', 1);
            HeadMaskType = 4;
            RepairType = 2;
            
            art_global(Images, RealignmentFile, HeadMaskType, RepairType)
            clear Images RealignmentFile niifiles
            delete('^saT*')
        end
        
    end
    
    
    if normalise
        for Run = 1:runs
            ScanDir     = [correctdir char(subj(subjindx)) filesep sprintf('run%d', Run)];
            cd(ScanDir)
            filt             = '^vsa*';
            niifiles         = spm_select('ExtList',ScanDir, filt, 1:maxframes);
            Images          = cellstr([repmat([ScanDir filesep],size(niifiles,1),1) niifiles]);
            
            %% build loop here
            
            %%%
            %                 matlabbatch{1}.spm.tools.dartel.mni_norm.data.subj.images = {
            %                     sprintf('C:/Experiments/DAD/TAB/%s/run1/vsagTABrun1.nii',char(subj(subjindx)))
            %                     sprintf('C:/Experiments/DAD/TAB/%s/run2/vsagTABrun2.nii',char(subj(subjindx)))
            %                     };
            matlabbatch{1}.spm.tools.dartel.mni_norm.template = {[anatdir 'D02' filesep 'Template_6.nii']};
            matlabbatch{1}.spm.tools.dartel.mni_norm.data.subj.flowfield = {[anatdir subj{subjindx} filesep 'u_rc1T1w_Template.nii']};
            matlabbatch{1}.spm.tools.dartel.mni_norm.data.subj.images = Images;
            matlabbatch{1}.spm.tools.dartel.mni_norm.vox = [2 2 2];
            matlabbatch{1}.spm.tools.dartel.mni_norm.bb = [NaN NaN NaN; NaN NaN NaN];
            matlabbatch{1}.spm.tools.dartel.mni_norm.preserve = 0;
            matlabbatch{1}.spm.tools.dartel.mni_norm.fwhm = [7 7 7];
            display(['normalising ' char(subj(subjindx)) ' '])
            spm_jobman('run',matlabbatch)
            clear matlabbatch;
            clear Images
            delete('aTAB*')
        end
    end
    
    
end