%% This script extracts the residuals when predicting BOLD from the RW
% model, and the residuals when predicting BOLD from the Bayesian
% observer model so they can be compared. 
% For the manuscript "Dopaminergic, neural and computational contributions to 
% probabilistic reward learning in old age". 
% 
% Script by Lieke de Boer

clear all

subj =  {'D02','D03','D04','D05','D08','D11','D13','D14','D15','D16','D17','D18','D19',...
    'D20','D21','D22','D23','D24','D25','D26','D29','D31','D33','D60','D61','D84','D85','D34',...
    'D35','D36','D37','D38','D39','D40','D42','D43','D46','D47','D48','D49','D50','D52','D55','D58',...
    'D62','D63','D64','D65','D66','D67','D70','D72','D80','D82','D83','D86','D90'};

group=[ones(1,27)*2 ones(1,30)];

confolder = 'C:\Experiments\DAD\TAB_art\';
betaFold = 'results_beta2p_vc_outcome_RQVCd';
forgetFold = 'results_forget_Qoutcome';

V=spm_vol('C:\Experiments\DAD\TAB_art\2ndLvL\beta2p_vc_outcome_RPE\1sample_RPE\z_bothNacc_RPE_fwe05.img');
betaVStrMask=spm_read_vols(V);
betaVStrMask(isnan(betaVStrMask)) = 0;
betaVStrMask(betaVStrMask~=0) = 1;

V=spm_vol('C:\Experiments\DAD\TAB_art\2ndLvL\forget_PE\1sample_PE_all\z_nACC_both_fwe05PE.img');
forgetVStrMask=spm_read_vols(V);
forgetVStrMask(isnan(forgetVStrMask)) = 0;
forgetVStrMask(forgetVStrMask~=0) = 1;

V=spm_vol('C:\Experiments\DAD\Anatomical\whole_brain_masks\mask20_no_eyeballs.nii');
wbMask=spm_read_vols(V);
wbMask(isnan(wbMask)) = 0;
wbMask(wbMask~=0) = 1;

V=spm_vol('C:\Experiments\DAD\TAB_art\2ndLvL\beta2p_vc_choice_QVCd\1sample_Q\z_Qchoice_fwe05_vmPFC.img');
vmPFCbetamask=spm_read_vols(V);
vmPFCbetamask(isnan(vmPFCbetamask)) = 0;
vmPFCbetamask(vmPFCbetamask~=0) = 1;

V=spm_vol('C:\Experiments\DAD\TAB_art\2ndLvL\forget_Qchoice\1sample_Q_all\z_vmPFC_choice_fwe05.img');
vmPFCforgmask=spm_read_vols(V);
vmPFCforgmask(isnan(vmPFCforgmask)) = 0;
vmPFCforgmask(vmPFCforgmask~=0) = 1;

for sj=1:length(subj)
    V = spm_vol([confolder subj{sj} filesep betaFold filesep 'ResMS.img']);
    con = spm_read_vols(V);
    NABetaRes(sj, 1) = nanmean(con(betaVStrMask==1), 1);
    wbResBeta(sj,1) = nanmean(con(wbMask==1), 1);
    betavmPFCres(sj, 1) = nanmean(con(vmPFCbetamask==1), 1);
%     
    V = spm_vol([confolder subj{sj} filesep forgetFold filesep 'ResMS.img']);
    con = spm_read_vols(V);
    NAForgetRes(sj, 1) = nanmean(con(forgetVStrMask==1), 1);
    wbResForget(sj,1) = nanmean(con(wbMask==1), 1);
    forgetvmPFCres(sj, 1) = nanmean(con(vmPFCforgmask==1), 1);

end


