%% This is the script to make regressors for GLM 1, 2 and 3 in the eLife
% manuscript "Attenuation of dopamine-modulated prefrontal value signals 
                % underlies probabilistic reward learning deficits in old age.". 
% Script by Lieke de Boer and Marc Guitart-Masip. First revision round March 2017. 

clear

subjects={'dad02','dad03','dad04','dad05','dad08','dad11','dad13','dad14','dad15','dad16','dad17','dad18','dad19',...
    'dad20','dad21','dad22','dad23','dad24','dad25','dad26','dad29','dad31','dad33','dad60','dad61','dad84','dad85','dad34',...
    'dad35','dad36','dad37','dad38','dad39','dad40','dad42','dad43','dad46','dad47','dad48','dad49','dad50','dad52','dad55','dad58',...
    'dad62','dad63','dad64','dad65','dad66','dad67','dad70','dad72','dad80','dad82','dad83','dad86','dad90'};

group=[ones(1,27)*2 ones(1,30)];

NumbScans = 330;
TR = 2000;

fMRIsubj = {'D02','D03','D04','D05','D08','D11','D13','D14','D15','D16','D17','D18','D19',...
    'D20','D21','D22','D23','D24','D25','D26','D29','D31','D33','D60','D61','D84','D85','D34',...
    'D35','D36','D37','D38','D39','D40','D42','D43','D46','D47','D48','D49','D50','D52','D55','D58',...
    'D62','D63','D64','D65','D66','D67','D70','D72','D80','D82','D83','D86','D90'};

fileDir = 'C:\Experiments\DAD\Behaviour\TAB\';
outDir = 'C:\Experiments\DAD\TAB_art\';

w(1) = .77; % young
w(2) = .77; % old

f(1) = .63; % young
f(2) = .63; % old

for subjindx=1:length(subjects)
    
    cd(fileDir)
    load (sprintf('results_tab_%s_group_%d.mat',subjects{subjindx},group(subjindx)))
    
    Choice=[]; Outcome=[]; Misses=[];
    for ses=1:2
        
        if ses==1
            timegap=-results.TimeStart(ses);
        else
            timegap=-results.TimeStart(ses)+ NumbScans*TR;
        end
        matrix=results.TaskData{ses};
        
        Choice = [Choice; matrix(matrix(:,6)>0,5)+timegap]; %#ok<*AGROW>
        Outcome = [Outcome; matrix(matrix(:,6)>0,11)+timegap];
        Misses = [Misses; matrix(matrix(:,6)==0,5)+timegap];
        
    end
    if isempty(Misses)
        Misses=-1;
    end
    
    %% to calculate uncertainty
    Qc=[];
    Quc=[];
    Vuc=[];
    C=[];

    matrix=[results.TaskData{1}; results.TaskData{2}];
    a = matrix(matrix(:,6)>0,10);
    r = matrix(matrix(:,6)>0,13);
    
    Q = ones(2,2);
    qs = [0 0];
    
    for t=1:length(a)
        
        q(1)=Q(1,1)/sum(Q(1,:));
        q(2)=Q(2,1)/sum(Q(2,:));
        
        V(1) = (Q(1,1)*Q(1,2))/((Q(1,1)+Q(1,2))^2*(Q(1,1)+Q(1,2)+1));
        V(2) = (Q(2,1)*Q(2,2))/((Q(2,1)+Q(2,2))^2*(Q(2,1)+Q(2,2)+1));
        
        Qc(t)  = q(a(t)); %#ok<*SAGROW>
        Quc(t) = q(3-a(t));
        Vuc(t) = V(3-a(t));
        
        c=conf(Q(1,1),Q(1,2),Q(2,1),Q(2,2));
        C(t)=(1-2*c)*(3-2*a(t)); % this makes c(unchosen)-c(chosen)  for beta2p_vc_choice_QVCd
        qs = [0 0];
        qs(a(t)) = cfd(group(subjindx))*(1-2*c)*(3-2*a(t)); % this makes c(unchosen)-c(chosen)
        
        Q(a(t),:)      = w(group(subjindx))+(1-w(group(subjindx)))*Q(a(t),:);
        Q(a(t),2-r(t)) = Q(a(t),2-r(t))+1;
        Q(3-a(t),:)    = f(group(subjindx))+(1-f(group(subjindx)))*Q(3-a(t),:);
    end
    
    names{1}='Choice';
    names{2}='Outcome';
    names{3}='Misses';
    
    onsets{1}= Choice/1000; % non-competing
    onsets{2}= Outcome/1000;
    onsets{3}= Misses/1000;

    durations{1}=0;
    durations{2}=0;
    durations{3}=0;


     %% for non-competing, choice
    pmod(1).name{1}='Qc';
    pmod(1).param{1}=Qc';
    pmod(1).poly{1}=1;
    
    pmod(2).name{1}='R';
    pmod(2).param{1}=R;
    pmod(2).poly{1}=1;
 

%% for putative PE at outcome
%     pmod(2).name{1}='RPE';
%     pmod(2).param{1}=R-Qc';
%     pmod(2).poly{1}=1;

%    %% for R and Q at outcome
%     pmod(2).name{1}='R';
%     pmod(2).param{1}=R';
%     pmod(2).poly{1}=1;
%     
%     pmod(2).name{2}='Q';
%     pmod(2).param{2}=Qc';
%     pmod(2).poly{2}=1;


%     
    s=strcat('SPM_onsets_', fMRIsubj{subjindx});
    
    dir=[outDir char(fMRIsubj(subjindx))];
    cd(dir);
    mkdir results_beta_Qchoice_QVC; % change folder name depending on analysis
    dir=[outDir char(fMRIsubj(subjindx)) '\results_beta_Qchoice_QVC'];
    
    cd(dir);
    
    ntrial{subjindx} = length(Misses);
     save (s, 'durations', 'names', 'onsets', 'pmod');
%     
end
