% Script for eLife manuscript "Attenuation of dopamine-modulated prefrontal value signals underlies 
                                %  probabilistic reward learning deficits in old age."
% this script has all the first level analyses contained in it.

% Script by Lieke de Boer and Marc Guitart-Masip, June 2017

clear all;
spm fmri

TABdir = 'C:\Experiments\DAD\TAB_art\';
physDir = 'C:\Experiments\DAD\TAB\';

subj = {'D02','D03','D04','D05','D08','D11','D13','D14','D15','D16','D17','D18','D19','D20','D21','D22',...
    'D23','D24','D25','D26','D29','D31','D33','D60','D61','D84','D85','D34','D35','D36','D37','D38',...
    'D39','D40','D42','D43','D46','D47','D48','D49','D50','D52','D55','D58','D62','D63','D64','D65',...
    'D66','D67','D70','D72','D80','D82','D83','D86','D90'};


tasknames = 'TAB';
maxframes = 330;
runs = 2;

spec    = 1;
est     = 1;
con     = 1;

resultsFold = 'results_beta_QchRout';

for subjindx = 1:length(subj)
    subjDir = [TABdir filesep subj{subjindx}];
    cd(subjDir)
    R = [];
    
    for run = 1:runs %concatenate the movement parameter files
        cd([subjDir filesep sprintf('run%d', run)])
        if exist('physio_tapas', 'file')
            MovParFile = spm_select('List', [subjDir filesep sprintf('run%d', run)], 'physio_tapas');
            load(MovParFile)
            R = [R; physio_tapas];
        else
            MovParFile = spm_select('List', [subjDir filesep sprintf('run%d', run)], 'rp_*.*txt');
            R = [R; textread(MovParFile)];
        end
    end
    
    
    cd([subjDir filesep resultsFold]);
    R(:, end+1) = [ones(maxframes, 1); zeros(length(R)-maxframes, 1)]; % control for the effect of run
    cd([subjDir filesep resultsFold]);
    save('movPar.mat', 'R')
    
    regressFiles = spm_select('List', pwd, 'SPM_onsets*');
    %         delete('SPM.mat');
    
    
    if spec
        matlabbatch{1}.spm.stats.fmri_spec.dir = {[subjDir filesep resultsFold]}
        matlabbatch{1}.spm.stats.fmri_spec.timing.units = 'secs';
        matlabbatch{1}.spm.stats.fmri_spec.timing.RT = 2;
        matlabbatch{1}.spm.stats.fmri_spec.timing.fmri_t = 16;
        matlabbatch{1}.spm.stats.fmri_spec.timing.fmri_t0 = 1;
        
        
        %% define scans in all sessions
        for run = 1:runs
            cd([subjDir filesep sprintf('run%d', run)])
            f = spm_select('ExtList', pwd, '^swvsag*.*nii', 1:330);
            files{:, run}  = cellstr([repmat([pwd '\'],size(f,1),1) f]);
        end
        files = [files{1}; files{2}];
        matlabbatch{1}.spm.stats.fmri_spec.sess.scans = files;
        matlabbatch{1}.spm.stats.fmri_spec.sess.cond = struct('name', {}, 'onset', {}, 'duration', {}, 'tmod', {}, 'pmod', {}, 'orth', {});
        %         matlabbatch{1}.spm.stats.fmri_spec.sess.multi = {[subjDir filesep 'results_wholebrainmask' filesep regressFiles(run, :)]};
        matlabbatch{1}.spm.stats.fmri_spec.sess.multi = {[subjDir filesep resultsFold filesep regressFiles]};
        matlabbatch{1}.spm.stats.fmri_spec.sess.regress = struct('name', {}, 'val', {});
        %             matlabbatch{1}.spm.stats.fmri_spec.sess(run).multi_reg = {[subjDir filesep MovParFiles(1, :)]};
        matlabbatch{1}.spm.stats.fmri_spec.sess.multi_reg = {[subjDir filesep resultsFold filesep 'movPar.mat']}; % change this if you
        %             have one seperate movement parameter file per participant.
        %             matlabbatch{1}.spm.stats.fmri_spec.sess(run).hpf = 128;
        
        
        %% spec
        
        matlabbatch{1}.spm.stats.fmri_spec.fact = struct('name', {}, 'levels', {});
        matlabbatch{1}.spm.stats.fmri_spec.bases.hrf.derivs = [0 0];
        matlabbatch{1}.spm.stats.fmri_spec.volt = 1;
        matlabbatch{1}.spm.stats.fmri_spec.global = 'None';
        %         matlabbatch{1}.spm.stats.fmri_spec.mthresh = -Inf;
        matlabbatch{1}.spm.stats.fmri_spec.mask = {'C:\Experiments\DAD\Anatomical\whole_brain_masks\mask20_no_eyeballs.nii'};
        matlabbatch{1}.spm.stats.fmri_spec.cvi = 'AR(1)';
        spm_jobman('run',matlabbatch)
        clear matlabbatch;
        clear files;
    end
    
    %% this bit takes care of having two identical regressors for the sake of letting pmods compete for variance
    %     cd([TABdir subj{subjindx} filesep resultsFold])
    %     load SPM.mat
    %     SPM.xX.X=SPM.xX.X(:,[1 2 4 6:end]);
    %     SPM.xX.name=SPM.xX.name(:,[1 2 4 6:end]);
    %     SPM.xX.iB = SPM.xX.iB-2;
    %     save SPM.mat SPM
    
    %% est
    if est
        matlabbatch{1}.spm.stats.fmri_est.spmmat(1) = {[subjDir filesep resultsFold filesep 'SPM.mat']};
        matlabbatch{1}.spm.stats.fmri_est.write_residuals = 0;
        matlabbatch{1}.spm.stats.fmri_est.method.Classical = 1;
        spm_jobman('run',matlabbatch)
        clear matlabbatch;
    end
    
    %% consess tcon
    
    
    if con % for RPE (single regressor)
        matlabbatch{1}.spm.stats.con.spmmat(1) = {[subjDir filesep resultsFold filesep 'SPM.mat']};
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.name = 'RPE';
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.convec = [0 0 1 0 0 0];
        matlabbatch{1}.spm.stats.con.consess{1}.tcon.sessrep = 'repl';
        matlabbatch{1}.spm.stats.con.delete = 1;
        spm_jobman('run',matlabbatch)
        clear matlabbatch;
    end

     %     if con  % for R at outcome and Q at choice (GLM2)
    %         matlabbatch{1}.spm.stats.con.spmmat(1) = {[subjDir filesep resultsFold filesep 'SPM.mat']};
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.name = 'R';
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.convec = [0 0 0 1 0 0];
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.sessrep = 'repl';
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.name = 'Q';
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.convec = [0 1 0 0 0 0];
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.sessrep = 'repl';
    %         matlabbatch{1}.spm.stats.con.delete = 1;
    %         spm_jobman('run',matlabbatch)
    %         clear matlabbatch;
    %     end
        
    %     if con  % for R and Q at outcome (GLM3)
    %         matlabbatch{1}.spm.stats.con.spmmat(1) = {[subjDir filesep resultsFold filesep 'SPM.mat']};
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.name = 'R';
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.convec = [0 0 1 0 0 0];
    %         matlabbatch{1}.spm.stats.con.consess{1}.tcon.sessrep = 'repl';
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.name = 'Q';
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.convec = [0 0 0 1 0 0];
    %         matlabbatch{1}.spm.stats.con.consess{2}.tcon.sessrep = 'repl';
    %         matlabbatch{1}.spm.stats.con.delete = 1;
    %         spm_jobman('run',matlabbatch)
    %         clear matlabbatch;
    %     end
    

end