%% This is the script to extract the BPs from the ROIs that were converted by the script "convert_rois_to_pet"
% For the analysis in the eLife manuscript "Dopaminergic, neural and computational contributions to 
% probabilistic reward learning in old age". 
% Script by Lieke de Boer, Jan Axelsson and Marc Guitart-Masip. First revision round March 2017. 

clear all

subj = {'D02','D03','D04','D05','D07','D08','D11','D13','D14','D15','D16','D17','D18','D19',...
    'D20','D21','D22','D23','D24','D25','D26','D29','D31','D33','D60','D61','D85','D34',...
    'D35','D36','D37','D38','D39','D40','D42','D43','D46','D47','D48','D49','D50','D52','D55','D56','D58',...
    'D62','D63','D64','D65','D66','D67','D70','D72','D80','D82','D83','D86','D90'};
group=[ones(1,28)*2 ones(1,30)];

write_image=0;

files_to_use = {'all_rois' 'striatum'};

for filindx = 1:length(files_to_use)
    
    for sj=1:length(subj)
        %%
        imlook4d_current_handle =imlook4d(sprintf('C:\\Experiments\\DAD\\Win\\%s\\Sharp.nii',subj{sj}));
        EditField('PC_high_edit', '5') %% this two lines implement the pca
        Menu('Export filtered')
        %         Export  %% if without pca
        
        LoadROI(sprintf('C:\\Experiments\\DAD\\Win\\%s\\r%s%s.roi',subj{sj},subj{sj},files_to_use{filindx}));
        
        %%
        ExportROIs;
        
        numberOfROIs = 7;
        for i=1:numberOfROIs
            dataMatrix(1,i,1,:)=imlook4d_ROI_data.mean(:,i);  % Make image with one pixel per ROI
        end
        
        startFrame = 10;
        endFrame = 18;
        %%  ROI-based
        referenceData = imlook4d_ROI_data.mean(:,1);
        [slope     newX newY]=imlook4d_logan(dataMatrix, imlook4d_time, imlook4d_duration, startFrame, endFrame, referenceData, 'slope');
        BP(sj,:) = slope(1:numberOfROIs) -1;
        %% writee image
        if write_image == 1 && filindx == 1
            %             INPUTS = Parameters( {sprintf('C:\\Experiments\\DAD\\PET_analysis\\Win\\%s\\%smask.roi',subj{sj},subj{sj})});
            %             Menu('Load ROI')
            %             KeepPixels
            
            imlook4d_current_handles.model.functionHandle = @logan;
            %imlook4d_current_handles.model.functionHandle = [];
            imlook4d_current_handles.model.Logan.startFrame = 10;
            imlook4d_current_handles.model.Logan.endFrame = 18;
            imlook4d_current_handles.model.Logan.type = 'slope2';
            imlook4d_current_handles.model.Logan.referenceData = referenceData;
            
            INPUTS = {sprintf('C:\\Experiments\\DAD\\Win\\%s\\%slogan_pca',subj{sj},subj{sj})};
            imlook4d('SaveFile_Callback', imlook4d_current_handles.SaveFile,{} ,imlook4d_current_handles)
            close all
            %             clear
        end
        close all
    end
    cd 'C:\\Experiments\\DAD\\Win'
    save(sprintf('BP%s_pca', files_to_use{filindx}), 'BP')
end

