#!/bin/bash

OUTDIR=/home/ALDRECENTRUM/lieke.deboer/Experiments/DAD/PET/Anatomical
WINDIR=/home/ALDRECENTRUM/lieke.deboer/Experiments/DAD/Win

cd $OUTDIR

for i in D*; do

	# extract labels
	cd $OUTDIR/$i
 	mkdir $WINDIR/$i
 	cp T1w.nii $WINDIR/$i/T1w.nii

	gzip aparc+aseg.nii
	gzip firstseg_resampled.nii
	gzip T1w.nii
	
	
 	#cortical	
	mri_extract_label aparc+aseg.nii.gz 8 47 cerebellum.nii
	mri_extract_label aparc+aseg.nii.gz 2014 vmPFC_right.nii
	mri_extract_label aparc+aseg.nii.gz 1014 vmPFC_left.nii
 	mri_extract_label aparc+aseg.nii.gz 2003 caudalmed_front_r.nii	
 	mri_extract_label aparc+aseg.nii.gz 2027 rostralmed_front_r.nii
 	mri_extract_label aparc+aseg.nii.gz 2028 superior_front_r.nii
 	mri_extract_label aparc+aseg.nii.gz 1003 caudalmed_front_l.nii	
 	mri_extract_label aparc+aseg.nii.gz 1027 rostralmed_front_l.nii
 	mri_extract_label aparc+aseg.nii.gz 1028 superior_front_l.nii
	mri_extract_label aparc+aseg.nii.gz 2012 lat_OFC_right.nii
 	mri_extract_label aparc+aseg.nii.gz 1012 lat_OFC_left.nii
 	mri_extract_label aparc+aseg.nii.gz 2018 2019 2020 vlPFC_right.nii		
 	mri_extract_label aparc+aseg.nii.gz 1018 1019 1020 vlPFC_left.nii
	mri_extract_label aparc+aseg.nii.gz 2010 PCC_right.nii
 	mri_extract_label aparc+aseg.nii.gz 1010 PCC_left.nii
	mri_extract_label aparc+aseg.nii.gz 2026 ACC_right.nii
 	mri_extract_label aparc+aseg.nii.gz 1026 ACC_left.nii
 	mri_extract_label aparc+aseg.nii.gz 2025 precuneus_right.nii
 	mri_extract_label aparc+aseg.nii.gz 1025 precuneus_left.nii
	mri_extract_label aparc+aseg.nii.gz 2029 2008 parietal_right.nii
 	mri_extract_label aparc+aseg.nii.gz 1029 1008 parietal_left.nii		

 	#subcortical
	mri_extract_label firstseg_resampled.nii.gz 50 51 58 11 12 26 striatum.nii	
	mri_extract_label firstseg_resampled.nii.gz 50 51 58 striatum_right.nii
	mri_extract_label firstseg_resampled.nii.gz 11 12 26 striatum_left.nii
	mri_extract_label firstseg_resampled.nii.gz 58 accumbens_right.nii
	mri_extract_label firstseg_resampled.nii.gz 51 putamen_right.nii
	mri_extract_label firstseg_resampled.nii.gz 50 caudate_right.nii
	mri_extract_label firstseg_resampled.nii.gz 26 accumbens_left.nii
	mri_extract_label firstseg_resampled.nii.gz 12 putamen_left.nii
	mri_extract_label firstseg_resampled.nii.gz 11 caudate_left.nii	
	mri_extract_label firstseg_resampled.nii.gz 53 hippocampus_right.nii	
	mri_extract_label firstseg_resampled.nii.gz 17 hippocampus_left.nii
	mri_extract_label firstseg_resampled.nii.gz 54 amygdala_right.nii	
	mri_extract_label firstseg_resampled.nii.gz 18 amygdala_left.nii
	
	#create striatum_rois
	fslmaths cerebellum.nii 	-bin striatum_rois	
	fslmaths accumbens_left.nii 	-bin -mul 2 -add striatum_rois striatum_rois
	fslmaths accumbens_right.nii 	-bin -mul 3 -add striatum_rois striatum_rois
		
	fslmaths caudate_left.nii 	-bin -mul 4 -add striatum_rois striatum_rois
	fslmaths caudate_right.nii 	-bin -mul 5 -add striatum_rois striatum_rois
	
	fslmaths putamen_left.nii 	-bin -mul 6 -add striatum_rois striatum_rois
	fslmaths putamen_right.nii 	-bin -mul 7 -add striatum_rois striatum_rois

	gunzip striatum_rois.nii.gz
 	cp striatum_rois.nii $WINDIR/$i
 	cp striatum_rois.nii striatum-eroded.nii
	
	LABELS="4 5 6 7" #(labels you want)

	for LABEL in $LABELS; do
    	mri_morphology -l $LABEL striatum-eroded.nii erode 1 striatum-eroded.nii
	done

	cp striatum-eroded.nii $WINDIR/$i
	gzip striatum-eroded.nii
	gzip striatum_rois.nii

 	# create all_rois
	fslmaths cerebellum.nii 	-bin all_rois
	fslmaths striatum.nii 		-bin -mul 2 -add all_rois all_rois
	fslmaths vmPFC_left.nii 	-bin -mul 3 -add all_rois all_rois	
	fslmaths vmPFC_right.nii 	-bin -mul 4 -add all_rois all_rois
	fslmaths caudalmed_front_l.nii 	-bin -mul 5 -add all_rois all_rois	
 	fslmaths caudalmed_front_r.nii 	-bin -mul 6 -add all_rois all_rois
 	fslmaths superior_front_l.nii 	-bin -mul 7 -add all_rois all_rois
	fslmaths superior_front_r.nii 	-bin -mul 8 -add all_rois all_rois	
 	fslmaths rostralmed_front_l.nii -bin -mul 9 -add all_rois all_rois
 	fslmaths rostralmed_front_r.nii -bin -mul 10 -add all_rois all_rois
 	fslmaths vlPFC_left.nii 	-bin -mul 11 -add all_rois all_rois
	fslmaths vlPFC_right.nii 	-bin -mul 12 -add all_rois all_rois
 	fslmaths PCC_left.nii 		-bin -mul 13 -add all_rois all_rois
	fslmaths PCC_right.nii 		-bin -mul 14 -add all_rois all_rois
 	fslmaths ACC_left.nii 		-bin -mul 15 -add all_rois all_rois
	fslmaths ACC_right.nii 		-bin -mul 16 -add all_rois all_rois
 	fslmaths precuneus_left.nii 	-bin -mul 17 -add all_rois all_rois
	fslmaths precuneus_right.nii 	-bin -mul 18 -add all_rois all_rois
 	fslmaths parietal_left.nii 	-bin -mul 19 -add all_rois all_rois
	fslmaths parietal_right.nii 	-bin -mul 20 -add all_rois all_rois
 	fslmaths lat_OFC_left.nii 	-bin -mul 21 -add all_rois all_rois
	fslmaths lat_OFC_right.nii 	-bin -mul 22 -add all_rois all_rois
	#make invertedmask of ROIs up to here
	#cp these ROIs into mask
	#use fslmaths to invert
	#binv to invert mask\
	#fslmaths with -mas 
	#fslmaths hippocampus_left.nii -mas invmask -bin -mul 17 -add all_rois all_rois 	
	fslmaths hippocampus_left.nii 	-bin -mul 23 -add all_rois all_rois
	fslmaths hippocampus_right.nii 	-bin -mul 24 -add all_rois all_rois
 	fslmaths amygdala_left.nii 	-bin -mul 25 -add all_rois all_rois
	fslmaths amygdala_right.nii 	-bin -mul 26 -add all_rois all_rois

	rm *.nii

	gunzip all_rois.nii.gz
	gunzip T1w.nii.gz
	gunzip striatum_eroded.nii.gz
	gunzip striatum_rois.nii.gz

	fslmaths all_rois.nii -uthr 26 all_rois.nii

	cp all_rois.nii $WINDIR/$i
 	cp all_rois.nii all_rois-eroded.nii

	LABELS="2 23 24 25 26" #(labels you want)

	for LABEL in $LABELS; do
    	mri_morphology -l $LABEL all_rois-eroded.nii erode 1 all_rois-eroded.nii
	done 


	LABELS="3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22" #(labels you want)

	for LABEL in $LABELS; do
    	mri_morphology -l $LABEL all_rois-eroded.nii dilate 1 all_rois-eroded.nii
	done 
 	cp all_rois-eroded.nii $WINDIR/$i

	cd $OUTDIR
done
