%%%%%%%%%%%%%%%%%
%%% Written by Quentin J. M. Huys, UCL, London 2011
%%% Reference:
%%% Guitart-Masip M, Quentin JM, Fuentemilla LL, Dayan P, Duzel E, Dolan RJ (2012)
%%% Go and no-go learning in reward and punishment: Interaction between affect and effect NeuroImage doi:10.1016/j.neuroimage.2012.04.024

%% to start parfor
% c=parcluster;
% c.NumWorkers=22 ; % this is the maxnumber of workers you're allowed
% parpool(22) ; % same thing

%%
clear all;

load tab_data.mat

ff{1} = 'llba';
ff{2} = 'llbac';
ff{3} = 'llbacf';  % a model that forgets the unchosen option with a forgetting rate
ff{4} = 'llbbdist1p'; % this model learns p(reward) for each bandit as a beta distribution with equal alpha and beta parameter
ff{5} = 'llbbdist2p'; % as preceeding but with different alpha and beta parameter for the beta distribution
ff{6} = 'llbbdist2p_b';    % beta distribution + choice kernel
ff{7} = 'llbbdist2p_c';  % beta distribution + confidence bonus to chosen option on t-1
ff{8} = 'llbbdist2p_bc'; % beta distribution + choice kernel + confidence bonus to chosen option on t-1
ff{9} = 'llb5_test'; % beta distribution + choice kernel + confidence bonus to chosen option on t-1 (peter's version)
ff{10} = 'llbbdist2p_V';    % value of unchosen option on previous trial is modified according to the current uncertainty of that option (unchosen on previous trial)
ff{11} = 'llbbdist2p_bc3';   % beta distribution + choice kernel + confidence bonus to unchosen option on t-1
ff{12} = 'llbbdist2p_bv';    % beta distribution + choice kernel + variance on unchosen on t-1
ff{13} = 'llbbdist2p_bv2';    % beta distribution + choice kernel + variance on chosen t-1
ff{14} = 'llbbdist2p_V2';    % value of unchosen option on previous trial is modified according to the current uncertainty of that option (unchosen on previous trial)
ff{15} = 'llbbdist2p_c2';   % beta distribution + confidence bonus to unchosen option on t-1
ff{16} = 'llbbdist2p_vc';    % value of unchosen option on previous trial is modified according to the current uncertainty of that option (unchosen on previous trial) + confidence bonus on previously unchosen option
ff{17} = 'llb2a'; % simple RW model with 2 alpha for pos and neg PE respectively
Npar=[2 3 4 2 3 4 4 5 5 4 5 5 5 4 4 5 3];


options=optimset('display','off','DerivativeCheck','on');
warning('off','optim:fminunc:SwitchingMethod')
whichinf=17%1:10%:size(ff,2)


whichinf=16;
load '/home/ALDRECENTRUM/lieke.deboer/Documents/DAD/behaviour/TAB/tab_modelling/fit_models_fminsearch/form/mat/160808_EM_all-llbbdist2p_vc-ite1.mat';



% E step......................................................

for sj=1:size(E,2)
    fprintf('%2d\n',sj);
    a=A{sj};
    r=R{sj};
    
    est=E(:,sj);
    
    hess(:,:,sj)=NumHessian(@(x) feval(ff{whichinf},x, a, r, Z,1),est);
   
end

    
    
