#include "fintrf.h"
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCGatewayCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
      subroutine mexfunction(nlhs, plhs, nrhs, prhs)
      implicit none
      mwPointer plhs(*), prhs(*)
      integer nlhs, nrhs      
C input and output pointers
      mwPointer mxGetPr, mxGetPi, mxCreateDoubleMatrix, mxGetM, mxGetN
      integer mxIsNumeric, ip, iq, lnpfq, nsigfig
      mwPointer a_ptr, b_ptr, z_ptr
      mwPointer m, n
      mwSize size, row
      complex*16 a(3), b(2), z, out, PFQ
      integer ix
      INTEGER NOUT
      COMMON /IO    / NOUT
      CHARACTER msg(256)

      NOUT=6
!      OPEN(unit=6,file='tmp.txt',status='unknown')

C     Any other variables needed
C      write(*,*)
C     CHECK FOR PROPER NUMBER OF ARGUMENTS
      if (nrhs .ne. 3) then
         call mexerrmsgtxt('gh requires 6 input arguments')
      elseif (nlhs .ne. 1) then
         call mexerrmsgtxt('gh requires 1 output arguments')
      endif
C     Get the sizes of all the input variables
C     Create matrices for the return argument
      plhs(1)=mxCreateDoubleMatrix(1,1,1)
C     Copy right hand arguments to local arrays

      row=3
      call mxCopyPtrToComplex16(mxGetPr(prhs(1)),
     +                          mxGetPi(prhs(1)),a,row)

      row=2
      call mxCopyPtrToComplex16(mxGetPr(prhs(2)),
     +                          mxGetPi(prhs(2)),b,row)
      row=1
      call mxCopyPtrToComplex16(mxGetPr(prhs(3)),
     +                          mxGetPi(prhs(3)),z,row)
      lnpfq=0
      ix=3
      nsigfig=20
C     Allocate and copy data to arrays
C     Do the actual computations in a subroutine
      ip=3
      iq=2

!      WRITE (NOUT,333) REAL(a(1)), REAL(a(2)), REAL(a(3)),
!     +     REAL(b(1)), REAL(b(2)), REAL(z)

! 333  FORMAT(1D20.13,'.',1D20.13,',',1D20.13,',',1D20.13,',',
!     + 1D20.13,',',1D20.13,',')

!      call flush(6)

      IF (abs(a(3)+1)<1D-12) THEN
         out=1-a(1)*a(2)/(b(1)*b(2))
      ELSE
         out=PFQ(a,b,ip,iq,z,lnpfq,ix,nsigfig)
      ENDIF
      call mxCopyComplex16ToPtr(out,mxGetPr(plhs(1)),
     +                          mxGetPi(plhs(1)),1)
      return
      end


C------------------------------------------------------------------C
C     This file generated by matlab2fmex: 30-Sep-2004 07:19:07     C
C------------------------------------------------------------------C



!!!This is a mex file conversion of the matlab file genHyper.m

! function [pfq]=genHyper(a,b,z,lnpfq,ix,nsigfig)
! Description : A numerical evaluator for the generalized hypergeometric
!               function for complex arguments with large magnitudes
!               using a direct summation of the Gauss series.
!               pFq isdefined by (borrowed from Maple):
!   pFq = sum(z^k / k! * product(pochhammer(n[i], k), i=1..p) /
!         product(pochhammer(d[j], k), j=1..q), k=0..infinity )
!
! INPUTS:       a => array containing numerator parameters
!               b => array containing denominator parameters
!               z => complex argument (scalar)
!           lnpfq => (optional) set to 1 if desired result is the natural
!                    log of pfq (default is 0)
!              ix => (optional) maximum number of terms in a,b (see below)
!         nsigfig => number of desired significant figures (default=10)
!
! OUPUT:      pfq => result
!
! EXAMPLES:     a=[1+i,1]; b=[2-i,3,3]; z=1.5;
!               >> genHyper(a,b,z)
!               ans =
!                          1.02992154295955 +     0.106416425916656i
!               or with more precision,
!               >> genHyper(a,b,z,0,0,15)
!               ans =
!                          1.02992154295896 +     0.106416425915575i
!               using the log option,
!               >> genHyper(a,b,z,1,0,15)
!               ans =
!                        0.0347923403326305 +     0.102959427435454i
!               >> exp(ans)
!               ans =
!                          1.02992154295896 +     0.106416425915575i
!
!
! Translated from the original fortran using f2matlab.m
!  by Ben E. Barrowes - barrowes@alum.mit.edu, 7/04.
!
!
!! Original fortran documentation
!     ACPAPFQ.  A NUMERICAL EVALUATOR FOR THE GENERALIZED HYPERGEOMETRIC
!
!     1  SERIES.  W.F. PERGER, A. BHALLA, M. NARDIN.
!
!     REF. IN COMP. PHYS. COMMUN. 77 (1993) 249
!
!     ****************************************************************
!     *                                                              *
!     *    SOLUTION TO THE GENERALIZED HYPERGEOMETRIC FUNCTION       *
!     *                                                              *
!     *                           by                                 *
!     *                                                              *
!     *                      W. F. PERGER,                           *
!     *                                                              *
!     *              MARK NARDIN  and ATUL BHALLA                    *
!     *                                                              *
!     *                                                              *
!     *            Electrical Engineering Department                 *
!     *            Michigan Technological University                 *
!     *                  1400 Townsend Drive                         *
!     *                Houghton, MI  49931-1295   USA                *
!     *                     Copyright 1993                           *
!     *                                                              *
!     *               e-mail address: wfp@mtu.edu                    *
!     *                                                              *
!     *  Description : A numerical evaluator for the generalized     *
!     *    hypergeometric function for complex arguments with large  *
!     *    magnitudes using a direct summation of the Gauss series.  *
!     *    The method used allows an accuracy of up to thirteen      *
!     *    decimal places through the use of large integer arrays    *
!     *    and a single final division.                              *
!     *    (original subroutines for the confluent hypergeometric    *
!     *    written by Mark Nardin, 1989; modifications made to cal-  *
!     *    culate the generalized hypergeometric function were       *
!     *    written by W.F. Perger and A. Bhalla, June, 1990)         *
!     *                                                              *
!     *  The evaluation of the pFq series is accomplished by a func- *
!     *  ion call to PFQ, which is a double precision complex func-  *
!     *  tion.  The required input is:                               *
!     *  1. Double precision complex arrays A and B.  These are the  *
!     *     arrays containing the parameters in the numerator and de-*
!     *     nominator, respectively.                                 *
!     *  2. Integers IP and IQ.  These integers indicate the number  *
!     *     of numerator and denominator terms, respectively (these  *
!     *     are p and q in the pFq function).                        *
!     *  3. Double precision complex argument Z.                     *
!     *  4. Integer LNPFQ.  This integer should be set to '1' if the *
!     *     result from PFQ is to be returned as the natural logaritm*
!     *     of the series, or '0' if not.  The user can generally set*
!     *     LNPFQ = '0' and change it if required.                   *
!     *  5. Integer IX.  This integer should be set to '0' if the    *
!     *     user desires the program PFQ to estimate the number of   *
!     *     array terms (in A and B) to be used, or an integer       *
!     *     greater than zero specifying the number of integer pos-  *
!     *     itions to be used.  This input parameter is escpecially  *
!     *     useful as a means to check the results of a given run.   *
!     *     Specificially, if the user obtains a result for a given  *
!     *     set of parameters, then changes IX and re-runs the eval- *
!     *     uator, and if the number of array positions was insuffi- *
!     *     cient, then the two results will likely differ.  The rec-*
!     *     commended would be to generally set IX = '0' and then set*
!     *     it to 100 or so for a second run.  Note that the LENGTH  *
!     *     parameter currently sets the upper limit on IX to 777,   *
!     *     but that can easily be changed (it is a single PARAMETER *
!     *     statement) and the program recompiled.                   *
!     *  6. Integer NSIGFIG.  This integer specifies the requested   *
!     *     number of significant figures in the final result.  If   *
!     *     the user attempts to request more than the number of bits*
!     *     in the mantissa allows, the program will abort with an   *
!     *     appropriate error message.  The recommended value is 10. *
!     *                                                              *
!     *     Note: The variable NOUT is the file to which error mess- *
!     *           ages are written (default is 6).  This can be      *
!     *           changed in the FUNCTION PFQ to accomodate re-      *
!     *           of output to another file                          *
!     *                                                              *
!     *  Subprograms called: HYPER.                                  *
!     *                                                              *
!     ****************************************************************
!
!
!
!     



      FUNCTION PFQ(A,B,IP,IQ,Z,LNPFQ,IX,NSIGFIG)
!*--PFQ131
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      INTEGER NOUT
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
      COMMON /IO    / NOUT
!
! Dummy arguments
!
      INTEGER IP , IQ , IX , LNPFQ , NSIGFIG
      COMPLEX*16 Z
      COMPLEX*16 A(IP) , B(IQ)
      COMPLEX*16 PFQ
!     
! Local variables
!
      COMPLEX*16 A1(2) , B1(1) , GAM1 , GAM2 , GAM3 , GAM4 , GAM5
      COMPLEX*16 GAM6, GAM7 , HYPER1 , HYPER2 , Z1
      DOUBLE PRECISION ARGI , ARGR , DIFF , DNUM , PRECIS
      COMPLEX*16 CGAMMA , HYPER
      DOUBLE PRECISION DBLE
      INTEGER I
      INTEGER NINT
!
!*** End of declarations rewritten by SPAG
!
      
      
      NOUT=6
      
      IF ((LNPFQ/=0) .AND. (LNPFQ/=1)) THEN
         WRITE (NOUT,*) ' ERROR IN INPUT ARGUMENTS: LNPFQ /= 0 OR 1'
         STOP
      ENDIF
      IF ((IP>IQ) .AND. (ABS(Z)>ONE)) THEN
         WRITE (NOUT,300) IP , IQ , ABS(Z)
 300     FORMAT (/,1X,'IP=',1I2,3X,'IQ=',1I2,3X,'AND ABS(Z)=',
     +        1E12.5,2X,/,
     + ' WHICH IS GREATER THAN ONE--SERIES DOES',' NOT CONVERGE')
         STOP
      ENDIF
      IF (IP==2 .AND. IQ==1 .AND. ABS(Z)>0.9) THEN
         IF (LNPFQ/=1) THEN
!
!      Check to see if the Gamma function arguments are o.k.; if not,
!
!      then the series will have to be used.
!
!
!
!      PRECIS - MACHINE PRECISION
!
!
            PRECIS=ONE
            PRECIS=PRECIS/TWO
            DNUM=PRECIS+ONE
            do while (DNUM>ONE)
               PRECIS=PRECIS/TWO
               DNUM=PRECIS+ONE
            end do
            PRECIS=TWO*PRECIS
            DO I=1 , 6
               IF (I==1) THEN
                  ARGI=IMAG(B(1))
                  ARGR=DBLE(B(1))
               ELSEIF (I==2) THEN
                  ARGI=IMAG(B(1)-A(1)-A(2))
                  ARGR=DBLE(B(1)-A(1)-A(2))
               ELSEIF (I==3) THEN
                  ARGI=IMAG(B(1)-A(1))
                  ARGR=DBLE(B(1)-A(1))
               ELSEIF (I==4) THEN
                  ARGI=IMAG(A(1)+A(2)-B(1))
                  ARGR=DBLE(A(1)+A(2)-B(1))
               ELSEIF (I==5) THEN
                  ARGI=IMAG(A(1))
                  ARGR=DBLE(A(1))
               ELSEIF (I==6) THEN
                  ARGI=IMAG(A(2))
                  ARGR=DBLE(A(2))
               ENDIF
!
!       CASES WHERE THE ARGUMENT IS REAL
!
!
               IF (ARGI==0.0) THEN
!
!        CASES WHERE THE ARGUMENT IS REAL AND NEGATIVE
!
!
                  IF (ARGR<=0.0) THEN
!                 
!                 USE THE SERIES EXPANSION IF THE ARGUMENT IS TOO NEAR A POLE
!                 
!                 
                      DIFF=ABS(DBLE(NINT(ARGR))-ARGR)
                      IF (DIFF<=TWO*PRECIS) THEN
                         PFQ=HYPER(A,B,IP,IQ,Z,LNPFQ,IX,NSIGFIG)
                         RETURN
                      ENDIF
                  ENDIF
               ENDIF
            ENDDO
            GAM1=CGAMMA(B(1),LNPFQ)
            GAM2=CGAMMA(B(1)-A(1)-A(2),LNPFQ)
            GAM3=CGAMMA(B(1)-A(1),LNPFQ)
            GAM4=CGAMMA(B(1)-A(2),LNPFQ)
            GAM5=CGAMMA(A(1)+A(2)-B(1),LNPFQ)
            GAM6=CGAMMA(A(1),LNPFQ)
            GAM7=CGAMMA(A(2),LNPFQ)
            A1(1)=A(1)
            A1(2)=A(2)
            B1(1)=A(1)+A(2)-B(1)+ONE
            Z1=ONE-Z
            HYPER1=HYPER(A1,B1,IP,IQ,Z1,LNPFQ,IX,NSIGFIG)
            A1(1)=B(1)-A(1)
            A1(2)=B(1)-A(2)
            B1(1)=B(1)-A(1)-A(2)+ONE
            HYPER2=HYPER(A1,B1,IP,IQ,Z1,LNPFQ,IX,NSIGFIG)
            PFQ=GAM1*GAM2*HYPER1/(GAM3*GAM4)+(ONE-Z)**(B(1)-A(1)-A(2))
     +           *GAM1*GAM5*HYPER2/(GAM6*GAM7)
            RETURN
         ENDIF
      ENDIF
 30   PFQ=HYPER(A,B,IP,IQ,Z,LNPFQ,IX,NSIGFIG)
      RETURN
      END FUNCTION PFQ
      
!--   /bits.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     ****************************************************************
!     *                                                              *
!     *                   FUNCTION BITS                              *
!     *                                                              *
!     *                                                              *
!     *  Description : Determines the number of significant figures  *
!     *    of machine precision to arrive at the size of the array   *
!     *    the numbers must be stored in to get the accuracy of the  *
!     *    solution.                                                 *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      DOUBLE PRECISION FUNCTION BITS()
!*--BITS274
!
!*** Start of declarations rewritten by SPAG
!
! Local variables
!
      DOUBLE PRECISION BIT , BIT2
      INTEGER COUNT
!
!*** End of declarations rewritten by SPAG
!
!
!
      BIT=1.0
      COUNT=0
      COUNT=COUNT+1
      BIT2=BIT*2.0
      BIT=BIT2+1.0
      do while ((BIT-BIT2)/=0.0)
         COUNT=COUNT+1
         BIT2=BIT*2.0
         BIT=BIT2+1.0
      end do
      BITS=COUNT-3
      END FUNCTION BITS

!--   /hyper.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     ****************************************************************
!     *                                                              *
!     *                   FUNCTION HYPER                             *
!     *                                                              *
!     *                                                              *
!     *  Description : Function that sums the Gauss series.          *
!     *                                                              *
!     *  Subprograms called: ARMULT, ARYDIV, BITS, CMPADD, CMPMUL,   *
!     *                      IPREMAX.                                *
!     *                                                              *
!     ****************************************************************
!     
      FUNCTION HYPER(A,B,IP,IQ,Z,LNPFQ,IX,NSIGFIG)
!*--HYPER311
!
!*** Start of declarations rewritten by SPAG
!
! PARAMETER definitions
!
      INTEGER LENGTH
      PARAMETER (LENGTH=777)
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      INTEGER NOUT
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
      COMMON /IO    / NOUT
!
! Dummy arguments
!
      INTEGER IP , IQ , IX , LNPFQ , NSIGFIG
      COMPLEX*16 Z
      COMPLEX*16 A(IP) , B(IQ)
      COMPLEX*16 HYPER
!
! Local variables
!
      DOUBLE PRECISION ACCY , AI(10) , AI2(10) , AR(10) 
      DOUBLE PRECISION AR2(10) , CI(10) , CI2(10) , CNT , CR(10)
      DOUBLE PRECISION CR2(10) , CREAL , DENOMI(-1:LENGTH) 
      DOUBLE PRECISION DENOMR(-1:LENGTH) , DUM1 , DUM2 ,  EXPON
      DOUBLE PRECISION LOG2 , MX1 , MX2 , NUMI(-1:LENGTH)
      DOUBLE PRECISION NUMR(-1:LENGTH) , QI1(-1:LENGTH)  
      DOUBLE PRECISION QI2(-1:LENGTH) , QR1(-1:LENGTH) 
      DOUBLE PRECISION QR2(-1:LENGTH) , RI10 , RMAX , RR10 
      DOUBLE PRECISION SIGFIG , SUMI(-1:LENGTH) , SUMR(-1:LENGTH)
      DOUBLE PRECISION WK1(-1:LENGTH) , WK2(-1:LENGTH) 
      DOUBLE PRECISION WK3(-1:LENGTH) , WK4(-1:LENGTH) 
      DOUBLE PRECISION WK5(-1:LENGTH) , WK6(-1:LENGTH) , X
      DOUBLE PRECISION XI , XI2 , XL , XR , XR2
      DOUBLE PRECISION BITS
      COMPLEX*16 CDUM1 , CDUM2 , FINAL , OLDTEMP , TEMP , TEMP1
      COMPLEX CMPLX
      DOUBLE PRECISION DBLE , DMAX1
      COMPLEX*16 FACTOR
      INTEGER I , I1 , IBIT , ICOUNT , II10 , IR10 , IXCNT , L
      INTEGER LMAX NMACH , REXP
      INTEGER INT , NINT
      INTEGER IPREMAX
      REAL REAL
      integer goon1
      DOUBLE PRECISION foo1(-1:LENGTH),foo2(-1:LENGTH),bar1(-1:LENGTH),
     +     bar2(-1:LENGTH)
      CHARACTER msg(256)
!
!*** End of declarations rewritten by SPAG
!
!
!
      zero=0.0D0
      LOG2=LOG10(TWO)
      IBIT=INT(BITS())
      RMAX=TWO**(int(IBIT/2))
      SIGFIG=TWO**(int(IBIT/4))
!
      DO I1=1 , IP
         AR2(I1)=DBLE(A(I1))*SIGFIG
         AR(I1)=AINT(AR2(I1))
         AR2(I1)=ANINT((AR2(I1)-AR(I1))*RMAX)
         AI2(I1)=IMAG(A(I1))*SIGFIG
         AI(I1)=AINT(AI2(I1))
         AI2(I1)=ANINT((AI2(I1)-AI(I1))*RMAX)
      ENDDO
      DO I1=1 , IQ
         CR2(I1)=DBLE(B(I1))*SIGFIG
         CR(I1)=AINT(CR2(I1))
         CR2(I1)=ANINT((CR2(I1)-CR(I1))*RMAX)
         CI2(I1)=IMAG(B(I1))*SIGFIG
         CI(I1)=AINT(CI2(I1))
         CI2(I1)=ANINT((CI2(I1)-CI(I1))*RMAX)
      ENDDO
      XR2=DBLE(Z)*SIGFIG
      XR=AINT(XR2)
      XR2=ANINT((XR2-XR)*RMAX)
      XI2=IMAG(Z)*SIGFIG
      XI=AINT(XI2)
      XI2=ANINT((XI2-XI)*RMAX)
!
!     WARN THE USER THAT THE INPUT VALUE WAS SO CLOSE TO ZERO THAT IT
!     WAS SET EQUAL TO ZERO.
!
      DO I1=1 , IP
         IF ((DBLE(A(I1))/=0.0) .AND. (AR(I1)==0.0) .AND. 
     +        (AR2(I1)==0.0)) THEN
!         WRITE (NOUT,300) I1
      ENDIF
 300  FORMAT (1X,'h: WARNING - REAL PART OF A(',1I2,') WAS SET TO ZERO')
      IF ((IMAG(A(I1))/=0.0) .AND. (AI(I1)==0.0) .AND. (AI2(I1)==0.0))
     + THEN
!         WRITE (NOUT,301) I1
      ENDIF
 301  FORMAT (1X,'WARNING - IMAG PART OF A(',1I2,') WAS SET TO ZERO')
      ENDDO
      DO I1=1 , IQ
         IF ((DBLE(B(I1))/=0.0) .AND. (CR(I1)==0.0) .AND. 
     + (CR2(I1)==0.0)) THEN
!            WRITE (NOUT,302) I1
      ENDIF
 302  FORMAT (1X,'WARNING - REAL PART OF B(',1I2,') WAS SET TO ZERO')
      IF ((IMAG(B(I1))/=0.0) .AND. (CI(I1)==0.0) .AND. (CI2(I1)==0.0))
     +     THEN
!         WRITE (NOUT,303) I1
      ENDIF
 303  FORMAT (1X,'WARNING - IMAG PART OF B(',1I2,') WAS SET TO ZERO')
      ENDDO
      IF ((DBLE(Z)/=0.0) .AND. (XR==0.0) .AND. (XR2==0.0)) THEN
!         WRITE (NOUT,*) ' WARNING - REAL PART OF Z WAS SET TO ZERO'
         Z=CMPLX(0.0,IMAG(Z))
      ENDIF
      IF ((IMAG(Z)/=0.0) .AND. (XI==0.0) .AND. (XI2==0.0)) THEN
!         WRITE (NOUT,*) ' WARNING - IMAG PART OF Z WAS SET TO ZERO'
         Z=CMPLX(DBLE(Z),0.0)
      ENDIF
!
!
!     SCREENING OF NUMERATOR ARGUMENTS FOR NEGATIVE INTEGERS OR ZERO.
!     ICOUNT WILL FORCE THE SERIES TO TERMINATE CORRECTLY.
!
      NMACH=INT(LOG10(TWO**INT(BITS())))
      ICOUNT=-1
      DO I1=1 , IP
         IF ((AR2(I1)==0.0) .AND. (AR(I1)==0.0) .AND. 
     +        (AI2(I1)==0.0) .AND.  (AI(I1)==0.0)) THEN
            HYPER=CMPLX(ONE,0.0)
            RETURN
         ENDIF
      IF ((AI(I1)==0.0) .AND. (AI2(I1)==0.0) .AND. (REAL(A(I1))<0.0))
     +        THEN
      IF (ABS(REAL(A(I1))-DBLE(NINT(REAL(A(I1)))))<TEN**(-NMACH)) THEN
         IF (ICOUNT/=-1) THEN
            ICOUNT=MIN(ICOUNT,-NINT(REAL(A(I1))))
         ELSE
            ICOUNT=-NINT(REAL(A(I1)))
         ENDIF
      ENDIF
      ENDIF
      ENDDO
!
!     SCREENING OF DENOMINATOR ARGUMENTS FOR ZEROES OR NEGATIVE INTEGERS
!     .
!
      DO I1=1 , IQ
         IF ((CR(I1)==0.0) .AND. (CR2(I1)==0.0) .AND. (CI(I1)==0.0)
     + .AND. (CI2(I1)==0.0)) THEN
         WRITE (NOUT,304) I1
 304     FORMAT (1X,'ERROR - ARGUMENT B(',1I2,') WAS EQUAL TO ZERO')
         STOP
      ENDIF
      IF ((CI(I1)==0.0) .AND. (CI2(I1)==0.0) .AND. (REAL(B(I1))<0.0))
     +     THEN
         IF ((ABS(REAL(B(I1))-DBLE(NINT(REAL(B(I1)))))<TEN**(-NMACH))
     +        .AND. (ICOUNT>=-NINT(REAL(B(I1))) .OR. ICOUNT==-1)) THEN
            WRITE (NOUT,305) I1
 305        FORMAT (1X,'ERROR - ARGUMENT B(',1I2,') WAS A NEGATIVE', 
     +           ' INTEGER')
      STOP
      ENDIF
      ENDIF
      ENDDO
!
      NMACH=INT(LOG10(TWO**IBIT))
      NSIGFIG=MIN(NSIGFIG,INT(LOG10(TWO**IBIT)))
      ACCY=TEN**(-NSIGFIG)
      L=IPREMAX(A,B,IP,IQ,Z)
      IF (L/=1) THEN
!
!     First, estimate the exponent of the maximum term in the pFq series
!     .
!
         EXPON=0.0
         XL=DBLE(L)
         DO I=1 , IP
            EXPON=EXPON+DBLE(FACTOR(A(I)+XL-ONE))-DBLE(FACTOR(A(I)-ONE))
         ENDDO
         DO I=1 , IQ
            EXPON=EXPON-DBLE(FACTOR(B(I)+XL-ONE))+DBLE(FACTOR(B(I)-ONE))
         ENDDO
         EXPON=EXPON+XL*DBLE(LOG(Z))-DBLE(FACTOR(DCMPLX(XL,0.0)))
         LMAX=INT(LOG10(EXP(ONE))*EXPON)
         L=LMAX
!
!     Now, estimate the exponent of where the pFq series will terminate.
!
         TEMP1=CMPLX(ONE,0.0)
         CREAL=ONE
         DO I1=1 , IP
            TEMP1=TEMP1*CMPLX(AR(I1),AI(I1))/SIGFIG
         ENDDO
         DO I1=1 , IQ
            TEMP1=TEMP1/(CMPLX(CR(I1),CI(I1))/SIGFIG)
            CREAL=CREAL*CR(I1)
         ENDDO
         TEMP1=TEMP1*CMPLX(XR,XI)
!
!     Triple it to make sure.
!
         L=3*L
!
!     Divide the number of significant figures necessary by the number
!     of
!     digits available per array position.
!
!
         L=INT((2*L+NSIGFIG)/NMACH)+2
      ENDIF
!
!     Make sure there are at least 5 array positions used.
!
      L=MAX(L,5)
      L=MAX(L,IX)
!      write (6,*) ' Estimated value of L=',L

      IF ((L<0) .OR. (L>LENGTH)) THEN
         WRITE (NOUT,306) LENGTH
 306     FORMAT (1X,'ERROR IN FN HYPER: L MUST BE < ',1I4)
         STOP
      ENDIF
      IF (NSIGFIG>NMACH) THEN
         WRITE (NOUT,307) NMACH
 307     FORMAT (1X,' WARNING--THE NUMBER OF SIGNIFICANT FIGURES REQU',
     +        'ESTED',/,'IS GREATER THAN THE MACHINE PRECISION--',
     +        'FINAL ANSWER',/,'WILL BE ACCURATE TO ONLY',I3,' DIGITS')
      ENDIF
!
      SUMR(-1)=ONE
      SUMI(-1)=ONE
      NUMR(-1)=ONE
      NUMI(-1)=ONE
      DENOMR(-1)=ONE
      DENOMI(-1)=ONE
      DO I=0 , L+1
         SUMR(I)=0.0
         SUMI(I)=0.0
         NUMR(I)=0.0
         NUMI(I)=0.0
         DENOMR(I)=0.0
         DENOMI(I)=0.0
      ENDDO
      SUMR(1)=ONE
      NUMR(1)=ONE
      DENOMR(1)=ONE
      CNT=SIGFIG
      TEMP=CMPLX(0.0,0.0)
      OLDTEMP=TEMP
      IXCNT=0
      REXP=int(IBIT/2)
      X=REXP*(SUMR(L+1)-2)
      RR10=X*LOG2
      IR10=INT(RR10)
      RR10=RR10-IR10
      X=REXP*(SUMI(L+1)-2)
      RI10=X*LOG2
      II10=INT(RI10)
      RI10=RI10-II10
      DUM1=SIGN(SUMR(1)*RMAX*RMAX+SUMR(2)*RMAX+SUMR(3),SUMR(-1))
      DUM2=SIGN(SUMI(1)*RMAX*RMAX+SUMI(2)*RMAX+SUMI(3),SUMI(-1))
      DUM1=DUM1*10**RR10
      DUM2=DUM2*10**RI10
      CDUM1=CMPLX(DUM1,DUM2)
      X=REXP*(DENOMR(L+1)-2)
      RR10=X*LOG2
      IR10=INT(RR10)
      RR10=RR10-IR10
      X=REXP*(DENOMI(L+1)-2)
      RI10=X*LOG2
      II10=INT(RI10)
      RI10=RI10-II10
      DUM1=SIGN(DENOMR(1)*RMAX*RMAX+DENOMR(2)*RMAX+DENOMR(3),DENOMR(-1))
      DUM2=SIGN(DENOMI(1)*RMAX*RMAX+DENOMI(2)*RMAX+DENOMI(3),DENOMI(-1))
      DUM1=DUM1*10**RR10
      DUM2=DUM2*10**RI10
      CDUM2=CMPLX(DUM1,DUM2)
      TEMP=CDUM1/CDUM2
!
!     130 IF (IP .GT. 0) THEN
      goon1=1
      do while (goon1==1)
         goon1=0
 130     IF (ip<0) THEN
            IF (SUMR(1)<HALF) THEN
               MX1=SUMI(L+1)
            ELSEIF (SUMI(1)<HALF) THEN
               MX1=SUMR(L+1)
            ELSE
               MX1=MAX(SUMR(L+1),SUMI(L+1))
            ENDIF
            IF (NUMR(1)<HALF) THEN
               MX2=NUMI(L+1)
            ELSEIF (NUMI(1)<HALF) THEN
               MX2=NUMR(L+1)
            ELSE
               MX2=MAX(NUMR(L+1),NUMI(L+1))
            ENDIF
            IF (MX1-MX2>2.0) THEN
               IF (CREAL>=0.0) THEN
!              write (6,*) ' cdabs(temp1/cnt)=',cdabs(temp1/cnt)
!              
                  IF (ABS(TEMP1/CNT)<=ONE) THEN
                     CALL ARYDIV(SUMR,SUMI,DENOMR,DENOMI,
     +                    FINAL,L,LNPFQ,RMAX,IBIT)
                     HYPER=FINAL
                     return
                  ENDIF
               ENDIF
            ENDIF
         ELSE
            CALL ARYDIV(SUMR,SUMI,DENOMR,DENOMI,TEMP,L,LNPFQ,RMAX,IBIT)
!
!      First, estimate the exponent of the maximum term in the pFq
!      series.
!
            EXPON=0.0
            XL=DBLE(ixcnt)
            DO I=1 , IP
               EXPON=EXPON+DBLE(FACTOR(A(I)+XL-ONE))-
     +              DBLE(FACTOR(A(I)-ONE))
            ENDDO
            DO I=1 , IQ
               EXPON=EXPON-DBLE(FACTOR(B(I)+XL-ONE))+
     +              DBLE(FACTOR(B(I)-ONE))
            ENDDO
            EXPON=EXPON+XL*DBLE(LOG(Z))-DBLE(FACTOR(DCMPLX(XL,0.0)))
            LMAX=INT(LOG10(EXP(ONE))*EXPON)
            IF (ABS(OLDTEMP-TEMP)<ABS(TEMP*ACCY)) THEN
               CALL ARYDIV(SUMR,SUMI,DENOMR,DENOMI,FINAL,L,LNPFQ,
     +              RMAX,IBIT)
               HYPER=FINAL
               return
            ENDIF
            OLDTEMP=TEMP
         ENDIF
         IF (IXCNT/=ICOUNT) THEN
            IXCNT=IXCNT+1
            DO I1=1 , IQ
!
!      TAKE THE CURRENT SUM AND MULTIPLY BY THE DENOMINATOR OF THE NEXT
!
!      TERM, FOR BOTH THE MOST SIGNIFICANT HALF (CR,CI) AND THE LEAST
!
!      SIGNIFICANT HALF (CR2,CI2).
!
!
               CALL CMPMUL(SUMR,SUMI,CR(I1),CI(I1),QR1,QI1,
     +              WK1,WK2,WK3,WK4,WK5,WK6,L,RMAX)
               CALL CMPMUL(SUMR,SUMI,CR2(I1),CI2(I1),QR2,QI2,
     +              WK1,WK2,WK3,WK4,WK5,WK6,L,RMAX)
               QR2(L+1)=QR2(L+1)-1
               QI2(L+1)=QI2(L+1)-1
!
!      STORE THIS TEMPORARILY IN THE SUM ARRAYS.
!
!
               CALL CMPADD(QR1,QI1,QR2,QI2,SUMR,SUMI,WK1,L,RMAX)
            ENDDO
!
!
!     MULTIPLY BY THE FACTORIAL TERM.
!
            foo1=sumr
            foo2=sumr
            CALL ARMULT(foo1,CNT,foo2,WK6,L,RMAX)
            sumr=foo2
            foo1=SUMI
            foo2=SUMI
            CALL ARMULT(foo1,CNT,foo2,WK6,L,RMAX)
            sumi=foo2
!
!     MULTIPLY BY THE SCALING FACTOR, SIGFIG, TO KEEP THE SCALE CORRECT.
!
            DO I1=1 , IP-IQ
               foo1=SUMR
               foo2=SUMR
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               SUMR=foo2
               foo1=SUMI
               foo2=SUMI
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               SUMI=foo2
            ENDDO
            DO I1=1 , IQ
!
!      UPDATE THE DENOMINATOR.
!
!
               CALL CMPMUL(DENOMR,DENOMI,CR(I1),CI(I1),QR1,QI1,
     +              WK1,WK2,WK3,WK4,WK5,WK6,L,RMAX)
               CALL CMPMUL(DENOMR,DENOMI,CR2(I1),CI2(I1),
     +              QR2,QI2,WK1,WK2,WK3,WK4,WK5,WK6,L,RMAX)
               QR2(L+1)=QR2(L+1)-1
               QI2(L+1)=QI2(L+1)-1
               CALL CMPADD(QR1,QI1,QR2,QI2,DENOMR,DENOMI,WK1,L,RMAX)
            ENDDO
!
!
!     MULTIPLY BY THE FACTORIAL TERM.
!
            foo1=DENOMR
            foo2=DENOMR
            CALL ARMULT(foo1,CNT,foo2,WK6,L,RMAX)
            DENOMR=foo2
            foo1=DENOMI
            foo2=DENOMI
            CALL ARMULT(foo1,CNT,foo2,WK6,L,RMAX)
            DENOMI=foo2
!
!     MULTIPLY BY THE SCALING FACTOR, SIGFIG, TO KEEP THE SCALE CORRECT.
!
            DO I1=1 , IP-IQ
               foo1=DENOMR
               foo2=DENOMR
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               DENOMR=foo2
               foo1=DENOMI
               foo2=DENOMI
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               DENOMI=foo2
            ENDDO
!
!     FORM THE NEXT NUMERATOR TERM BY MULTIPLYING THE CURRENT
!     NUMERATOR TERM (AN ARRAY) WITH THE A ARGUMENT (A SCALAR).
!
            DO I1=1 , IP
               CALL CMPMUL(NUMR,NUMI,AR(I1),AI(I1),QR1,QI1,WK1,
     +              WK2,WK3,WK4,WK5,WK6,L,RMAX)
               CALL CMPMUL(NUMR,NUMI,AR2(I1),AI2(I1),QR2,QI2,
     +              WK1,WK2,WK3,WK4,WK5,WK6,L,RMAX)
               QR2(L+1)=QR2(L+1)-1
               QI2(L+1)=QI2(L+1)-1
               CALL CMPADD(QR1,QI1,QR2,QI2,NUMR,NUMI,WK1,L,RMAX)
            ENDDO
!
!     FINISH THE NEW NUMERATOR TERM BY MULTIPLYING BY THE Z ARGUMENT.
!
            CALL CMPMUL(NUMR,NUMI,XR,XI,QR1,QI1,WK1,WK2,
     +           WK3,WK4,WK5,WK6,L,RMAX)
            CALL CMPMUL(NUMR,NUMI,XR2,XI2,QR2,QI2,WK1,WK2,
     +           WK3,WK4,WK5,WK6,L,RMAX)
            QR2(L+1)=QR2(L+1)-1
            QI2(L+1)=QI2(L+1)-1
            CALL CMPADD(QR1,QI1,QR2,QI2,NUMR,NUMI,WK1,L,RMAX)
!
!     MULTIPLY BY THE SCALING FACTOR, SIGFIG, TO KEEP THE SCALE CORRECT.
!
            DO I1=1 , IQ-IP
               foo1=NUMR
               foo2=NUMR
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               NUMR=foo2
               foo1=NUMI
               foo2=NUMI
               CALL ARMULT(foo1,SIGFIG,foo2,WK6,L,RMAX)
               NUMI=foo2
            ENDDO
!
!     FINALLY, ADD THE NEW NUMERATOR TERM WITH THE CURRENT RUNNING
!     SUM OF THE NUMERATOR AND STORE THE NEW RUNNING SUM IN SUMR, SUMI.
!
            foo1=sumr
            foo2=sumr
            bar1=SUMI
            bar2=SUMI
            CALL CMPADD(foo1,bar1,NUMR,NUMI,foo2,bar2,WK1,L,RMAX)
            SUMI=bar2
            sumr=foo2
            
!
!     BECAUSE SIGFIG REPRESENTS "ONE" ON THE NEW SCALE, ADD SIGFIG
!     TO THE CURRENT COUNT AND, CONSEQUENTLY, TO THE IP ARGUMENTS
!     IN THE NUMERATOR AND THE IQ ARGUMENTS IN THE DENOMINATOR.
!
            CNT=CNT+SIGFIG
            DO I1=1 , IP
               AR(I1)=AR(I1)+SIGFIG
            ENDDO
            DO I1=1 , IQ
               CR(I1)=CR(I1)+SIGFIG
            ENDDO
            goon1=1
         ENDIF
      end do
 240  CALL ARYDIV(SUMR,SUMI,DENOMR,DENOMI,FINAL,L,LNPFQ,RMAX,IBIT)
!     write (6,*) 'Number of terms=',ixcnt
      HYPER=FINAL
      RETURN
      END FUNCTION HYPER
!--   /aradd.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ARADD                             *
!     *                                                              *
!     *                                                              *
!     *  Description : Accepts two arrays of numbers and returns     *
!     *    the sum of the array.  Each array is holding the value    *
!     *    of one number in the series.  The parameter L is the      *
!     *    size of the array representing the number and RMAX is     *
!     *    the actual number of digits needed to give the numbers    *
!     *    the desired accuracy.                                     *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ARADD(A,B,C,Z,L,RMAX)
!*--ARADD764
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      INTEGER L
      DOUBLE PRECISION RMAX
      DOUBLE PRECISION A(-1:*) , B(-1:*) , C(-1:*) , Z(-1:*)
!
! Local variables
!
      INTEGER EDIFF , I , J
!
!*** End of declarations rewritten by SPAG
!
!
!
      DO I=0 , L+1
         Z(I)=0.0
      ENDDO
      EDIFF=ANINT(A(L+1)-B(L+1))
      IF (ABS(A(1))<HALF .OR. EDIFF<=-L) THEN
         DO I=-1 , L+1
            C(I)=B(I)
         ENDDO
         IF (C(1)<HALF) THEN
            C(-1)=ONE
            C(L+1)=0.0
         ENDIF
         return
      ELSE
         IF (ABS(B(1))<HALF .OR. EDIFF>=L) THEN
            DO I=-1 , L+1
               C(I)=A(I)
            ENDDO
            IF (C(1)<HALF) THEN
               C(-1)=ONE
               C(L+1)=0.0
            ENDIF
            return
         ELSE
            Z(-1)=A(-1)
            goon300=1
            goon190=1
            IF (ABS(A(-1)-B(-1))>=HALF) THEN
               goon300=0
               IF (EDIFF>0) THEN
                  Z(L+1)=A(L+1)
               elseif (EDIFF<0) THEN
                  Z(L+1)=B(L+1)
                  Z(-1)=B(-1)
                  goon190=0
               Else
                  DO I=1 , L
                     IF (A(I)>B(I)) THEN
                        Z(L+1)=A(L+1)
                        exit
                     ENDIF
                     IF (A(I)<B(I)) THEN
                        Z(L+1)=B(L+1)
                        Z(-1)=B(-1)
                        goon190=0
                     ENDIF
                  ENDDO
               end IF
!     
            ELSEIF (EDIFF>0) THEN
               Z(L+1)=A(L+1)
               DO I=L , 1+EDIFF , -1
                  Z(I)=A(I)+B(I-EDIFF)+Z(I)
                  IF (Z(I)>=RMAX) THEN
                     Z(I)=Z(I)-RMAX
                     Z(I-1)=ONE
                  ENDIF
               ENDDO
               DO I=EDIFF , 1 , -1
                  Z(I)=A(I)+Z(I)
                  IF (Z(I)>=RMAX) THEN
                     Z(I)=Z(I)-RMAX
                     Z(I-1)=ONE
                  ENDIF
               ENDDO
               IF (Z(0)>HALF) THEN
                  DO I=L , 1 , -1
                     Z(I)=Z(I-1)
                  ENDDO
                  Z(L+1)=Z(L+1)+1
                  Z(0)=0.0
               ENDIF
            ELSEIF (EDIFF<0) THEN
               Z(L+1)=B(L+1)
               DO I=L , 1-EDIFF , -1
                  Z(I)=A(I+EDIFF)+B(I)+Z(I)
                  IF (Z(I)>=RMAX) THEN
                     Z(I)=Z(I)-RMAX
                     Z(I-1)=ONE
                  ENDIF
               ENDDO
               DO I=0-EDIFF , 1 , -1
                  Z(I)=B(I)+Z(I)
                  IF (Z(I)>=RMAX) THEN
                     Z(I)=Z(I)-RMAX
                     Z(I-1)=ONE
                  ENDIF
               ENDDO
               IF (Z(0)>HALF) THEN
                  DO I=L , 1 , -1
                     Z(I)=Z(I-1)
                  ENDDO
                  Z(L+1)=Z(L+1)+ONE
                  Z(0)=0.0
               ENDIF
            ELSE
               Z(L+1)=A(L+1)
               DO I=L , 1 , -1
                  Z(I)=A(I)+B(I)+Z(I)
                  IF (Z(I)>=RMAX) THEN
                     Z(I)=Z(I)-RMAX
                     Z(I-1)=ONE
                  ENDIF
               ENDDO
               IF (Z(0)>HALF) THEN
                  DO I=L , 1 , -1
                     Z(I)=Z(I-1)
                  ENDDO
                  Z(L+1)=Z(L+1)+ONE
                  Z(0)=0.0
               ENDIF
            ENDIF
            if (goon300==1) then
               I=I+1
               do while (Z(I)<HALF .AND. I<L+1)
                  I=I+1
               end do
               IF (I==L+1) THEN
                  Z(-1)=ONE
                  Z(L+1)=0.0
                  DO I=-1 , L+1
                     C(I)=Z(I)
                  ENDDO
                  IF (C(1)<HALF) THEN
                     C(-1)=ONE
                     C(L+1)=0.0
                  ENDIF
                  return
               ENDIF
               DO J=1 , L+1-I
                  Z(J)=Z(J+I-1)
               ENDDO
               DO J=L+2-I , L
                  Z(J)=0.0
               ENDDO
               Z(L+1)=Z(L+1)-I+1
               DO I=-1 , L+1
                  C(I)=Z(I)
               ENDDO
               IF (C(1)<HALF) THEN
                  C(-1)=ONE
                  C(L+1)=0.0
               ENDIF
               return
            end if
!     
            if (goon190==1) then
 190           IF (EDIFF>0) THEN
                  DO I=L , 1+EDIFF , -1
                     Z(I)=A(I)-B(I-EDIFF)+Z(I)
                     IF (Z(I)<0.0) THEN
                        Z(I)=Z(I)+RMAX
                        Z(I-1)=-ONE
                     ENDIF
                  ENDDO
                  DO I=EDIFF , 1 , -1
                     Z(I)=A(I)+Z(I)
                     IF (Z(I)<0.0) THEN
                        Z(I)=Z(I)+RMAX
                        Z(I-1)=-ONE
                     ENDIF
                  ENDDO
               ELSE
                  DO I=L , 1 , -1
                     Z(I)=A(I)-B(I)+Z(I)
                     IF (Z(I)<0.0) THEN
                        Z(I)=Z(I)+RMAX
                        Z(I-1)=-ONE
                     ENDIF
                  ENDDO
               ENDIF
               IF (Z(1)>HALF) THEN
                  DO I=-1 , L+1
                     C(I)=Z(I)
                  ENDDO
                  IF (C(1)<HALF) THEN
                     C(-1)=ONE
                     C(L+1)=0.0
                  ENDIF
                  return
               ENDIF
               I=1
               I=I+1
               do while (Z(I)<HALF .AND. I<L+1)
                  I=I+1
               end do
               IF (I==L+1) THEN
                  Z(-1)=ONE
                  Z(L+1)=0.0
                  DO I=-1 , L+1
                     C(I)=Z(I)
                  ENDDO
                  IF (C(1)<HALF) THEN
                     C(-1)=ONE
                     C(L+1)=0.0
                  ENDIF
                  return
               ENDIF
               DO J=1 , L+1-I
                  Z(J)=Z(J+I-1)
               ENDDO
               DO J=L+2-I , L
                  Z(J)=0.0
               ENDDO
               Z(L+1)=Z(L+1)-I+1
               DO I=-1 , L+1
                  C(I)=Z(I)
               ENDDO
               IF (C(1)<HALF) THEN
                  C(-1)=ONE
                  C(L+1)=0.0
               ENDIF
               return
            end if
         ENDIF
!     
 240     IF (EDIFF<0) THEN
            DO I=L , 1-EDIFF , -1
               Z(I)=B(I)-A(I+EDIFF)+Z(I)
               IF (Z(I)<0.0) THEN
                  Z(I)=Z(I)+RMAX
                  Z(I-1)=-ONE
               ENDIF
            ENDDO
            DO I=0-EDIFF , 1 , -1
               Z(I)=B(I)+Z(I)
               IF (Z(I)<0.0) THEN
                  Z(I)=Z(I)+RMAX
                  Z(I-1)=-ONE
               ENDIF
            ENDDO
         ELSE
            DO I=L , 1 , -1
               Z(I)=B(I)-A(I)+Z(I)
               IF (Z(I)<0.0) THEN
                  Z(I)=Z(I)+RMAX
                  Z(I-1)=-ONE
               ENDIF
            ENDDO
         ENDIF
      ENDIF
!     
 290  IF (Z(1)>HALF) THEN
         DO I=-1 , L+1
            C(I)=Z(I)
         ENDDO
         IF (C(1)<HALF) THEN
            C(-1)=ONE
            C(L+1)=0.0
         ENDIF
         return
      ENDIF
      I=1
 300  I=I+1
      do while (Z(I)<HALF .AND. I<L+1)
         I=I+1
      end do
      IF (I==L+1) THEN
         Z(-1)=ONE
         Z(L+1)=0.0
         DO I=-1 , L+1
            C(I)=Z(I)
         ENDDO
         IF (C(1)<HALF) THEN
            C(-1)=ONE
            C(L+1)=0.0
         ENDIF
         return
      ENDIF
      DO J=1 , L+1-I
         Z(J)=Z(J+I-1)
      ENDDO
      DO J=L+2-I , L
         Z(J)=0.0
      ENDDO
      Z(L+1)=Z(L+1)-I+1
 330  DO I=-1 , L+1
         C(I)=Z(I)
      ENDDO
 350  IF (C(1)<HALF) THEN
         C(-1)=ONE
         C(L+1)=0.0
      ENDIF
      END SUBROUTINE ARADD
!--   /arsub.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ARSUB                             *
!     *                                                              *
!     *                                                              *
!     *  Description : Accepts two arrays and subtracts each element *
!     *    in the second array from the element in the first array   *
!     *    and returns the solution.  The parameters L and RMAX are  *
!     *    the size of the array and the number of digits needed for *
!     *    the accuracy, respectively.                               *
!     *                                                              *
!     *  Subprograms called: ARADD                                   *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ARSUB(A,B,C,WK1,WK2,L,RMAX)
!*--ARSUB991
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      INTEGER L
      DOUBLE PRECISION RMAX
      DOUBLE PRECISION A(-1:*) , B(-1:*) , C(-1:*) , WK1(-1:*) 
      DOUBLE PRECISION  WK2(-1:*)
!
! Local variables
!
      INTEGER I
!
!*** End of declarations rewritten by SPAG
!
!
!
      DO I=-1 , L+1
         WK2(I)=B(I)
      ENDDO
      WK2(-1)=(-ONE)*WK2(-1)
      CALL ARADD(A,WK2,C,WK1,L,RMAX)
      END SUBROUTINE ARSUB
!--   /armult.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ARMULT                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Accepts two arrays and returns the product.   *
!     *    L and RMAX are the size of the arrays and the number of   *
!     *    digits needed to represent the numbers with the required  *
!     *    accuracy.                                                 *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ARMULT(A,B,C,Z,L,RMAX)
!*--ARMULT1038
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION B , RMAX
      INTEGER L
      DOUBLE PRECISION A(-1:*) , C(-1:*) , Z(-1:*)
!
! Local variables
!
      DOUBLE PRECISION B2 , CARRY
      INTEGER I
!
!*** End of declarations rewritten by SPAG
!
!
!
      Z(-1)=SIGN(ONE,B)*A(-1)
      B2=ABS(B)
      Z(L+1)=A(L+1)
      DO I=0 , L
         Z(I)=0.0
      ENDDO
      IF (B2<=EPS .OR. A(1)<=EPS) THEN
         Z(-1)=ONE
         Z(L+1)=0.0
      Else
         DO I=L , 1 , -1
            Z(I)=A(I)*B2+Z(I)
            IF (Z(I)>=RMAX) THEN
               CARRY=AINT(Z(I)/RMAX)
               Z(I)=Z(I)-CARRY*RMAX
               Z(I-1)=CARRY
            ENDIF
         ENDDO
         IF (Z(0)>=HALF) THEN
            DO I=L , 1 , -1
               Z(I)=Z(I-1)
            ENDDO
            Z(L+1)=Z(L+1)+ONE
            IF (Z(1)>=RMAX) THEN
               DO I=L , 1 , -1
                  Z(I)=Z(I-1)
               ENDDO
               CARRY=AINT(Z(1)/RMAX)
               Z(2)=Z(2)-CARRY*RMAX
               Z(1)=CARRY
               Z(L+1)=Z(L+1)+ONE
            ENDIF
            Z(0)=0.0
         ENDIF
      end IF
 60   DO I=-1 , L+1
         C(I)=Z(I)
      ENDDO
      IF (C(1)<HALF) THEN
         C(-1)=ONE
         C(L+1)=0.0
      ENDIF
      END SUBROUTINE ARMULT
!--   /cmpadd.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE CMPADD                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Takes two arrays representing one real and    *
!     *    one imaginary part, and adds two arrays representing      *
!     *    another complex number and returns two array holding the  *
!     *    complex sum.                                              *
!     *              (CR,CI) = (AR+BR, AI+BI)                        *
!     *                                                              *
!     *  Subprograms called: ARADD                                   *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE CMPADD(AR,AI,BR,BI,CR,CI,WK1,L,RMAX)
!*--CMPADD1123
!
!*** Start of declarations rewritten by SPAG
!
! Dummy arguments
!
      INTEGER L
      DOUBLE PRECISION RMAX
      DOUBLE PRECISION AI(-1:*) , AR(-1:*) , BI(-1:*) , BR(-1:*) 
      DOUBLE PRECISION CI(-1:*) , CR(-1:*) , WK1(-1:*)
!     
!*** End of declarations rewritten by SPAG
!
!
!
      CALL ARADD(AR,BR,CR,WK1,L,RMAX)
      CALL ARADD(AI,BI,CI,WK1,L,RMAX)
      END SUBROUTINE CMPADD
!--   /cmpsub.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE CMPSUB                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Takes two arrays representing one real and    *
!     *    one imaginary part, and subtracts two arrays representing *
!     *    another complex number and returns two array holding the  *
!     *    complex sum.                                              *
!     *              (CR,CI) = (AR+BR, AI+BI)                        *
!     *                                                              *
!     *  Subprograms called: ARADD                                   *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE CMPSUB(AR,AI,BR,BI,CR,CI,WK1,WK2,L,RMAX)
!*--CMPSUB1160
!
!*** Start of declarations rewritten by SPAG
!
! Dummy arguments
!
      INTEGER L
      DOUBLE PRECISION RMAX
      DOUBLE PRECISION AI(-1:*) , AR(-1:*) , BI(-1:*) , BR(-1:*) 
      DOUBLE PRECISION CI(-1:*) , CR(-1:*) , WK1(-1:*) , WK2(-1:*)
!
!*** End of declarations rewritten by SPAG
!
!
!
      CALL ARSUB(AR,BR,CR,WK1,WK2,L,RMAX)
      CALL ARSUB(AI,BI,CI,WK1,WK2,L,RMAX)
      END SUBROUTINE CMPSUB
!--   /cmpmul.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE CMPMUL                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Takes two arrays representing one real and    *
!     *    one imaginary part, and multiplies it with two arrays     *
!     *    representing another complex number and returns the       *
!     *    complex product.                                          *
!     *                                                              *
!     *  Subprograms called: ARMULT, ARSUB, ARADD                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE CMPMUL(AR,AI,BR,BI,CR,CI,WK1,WK2,CR2,D1,D2,WK6,L,RMAX)
!*--CMPMUL1196
!
!*** Start of declarations rewritten by SPAG
!
! Dummy arguments
!
      DOUBLE PRECISION BI , BR , RMAX , WK6(-1:*)
      INTEGER L
      DOUBLE PRECISION AI(-1:*) , AR(-1:*) , CI(-1:*) , CR(-1:*) 
      DOUBLE PRECISION CR2(-1:*) ,D1(-1:*) , D2(-1:*) , WK1(-1:*) 
      DOUBLE PRECISION WK2(-1:*)
!
! Local variables
!
      INTEGER I
!
!*** End of declarations rewritten by SPAG
!
!
!
      CALL ARMULT(AR,BR,D1,WK6,L,RMAX)
      CALL ARMULT(AI,BI,D2,WK6,L,RMAX)
      CALL ARSUB(D1,D2,CR2,WK1,WK2,L,RMAX)
      CALL ARMULT(AR,BI,D1,WK6,L,RMAX)
      CALL ARMULT(AI,BR,D2,WK6,L,RMAX)
      CALL ARADD(D1,D2,CI,WK1,L,RMAX)
      DO I=-1 , L+1
         CR(I)=CR2(I)
      ENDDO
      END SUBROUTINE CMPMUL
!--   /arydiv.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ARYDIV                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Returns the double precision complex number   *
!     *    resulting from the division of four arrays, representing  *
!     *    two complex numbers.  The number returned will be in one  *
!     *    of two different forms:  either standard scientific or as *
!     *    the log (base 10) of the number.                          *
!     *                                                              *
!     *  Subprograms called: CONV21, CONV12, EADD, ECPDIV, EMULT.    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ARYDIV(AR,AI,BR,BI,C,L,LNPFQ,RMAX,IBIT)
!*--ARYDIV1244
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      COMPLEX*16 C
      INTEGER IBIT , L , LNPFQ
      DOUBLE PRECISION RMAX
      DOUBLE PRECISION AI(-1:*) , AR(-1:*) , BI(-1:*) , BR(-1:*)
!
! Local variables
!
      DOUBLE PRECISION AE(2,2) , BE(2,2) , CE(2,2) , DUM1 , DUM2 , E1
      DOUBLE PRECISION E2 ,  E3 , N1 , N2 , N3 , PHI , RI10 , RR10 
      DOUBLE PRECISION TENMAX , X , X1 , X2
      COMPLEX*16 CDUM
      DOUBLE PRECISION DBLE
      REAL DNUM
      INTEGER II10 , IR10 , ITNMAX , REXP
      INTEGER INT
!
!*** End of declarations rewritten by SPAG
!
!
!
      REXP=int(IBIT/2)
      X=REXP*(AR(L+1)-2)
      RR10=X*LOG10(TWO)/LOG10(TEN)
      IR10=INT(RR10)
      RR10=RR10-IR10
      X=REXP*(AI(L+1)-2)
      RI10=X*LOG10(TWO)/LOG10(TEN)
      II10=INT(RI10)
      RI10=RI10-II10
      DUM1=SIGN(AR(1)*RMAX*RMAX+AR(2)*RMAX+AR(3),AR(-1))
      DUM2=SIGN(AI(1)*RMAX*RMAX+AI(2)*RMAX+AI(3),AI(-1))
      DUM1=DUM1*10**RR10
      DUM2=DUM2*10**RI10
      CDUM=CMPLX(DUM1,DUM2)
      CALL CONV12(CDUM,AE)
      AE(1,2)=AE(1,2)+IR10
      AE(2,2)=AE(2,2)+II10
      X=REXP*(BR(L+1)-2)
      RR10=X*LOG10(TWO)/LOG10(TEN)
      IR10=INT(RR10)
      RR10=RR10-IR10
      X=REXP*(BI(L+1)-2)
      RI10=X*LOG10(TWO)/LOG10(TEN)
      II10=INT(RI10)
      RI10=RI10-II10
      DUM1=SIGN(BR(1)*RMAX*RMAX+BR(2)*RMAX+BR(3),BR(-1))
      DUM2=SIGN(BI(1)*RMAX*RMAX+BI(2)*RMAX+BI(3),BI(-1))
      DUM1=DUM1*10**RR10
      DUM2=DUM2*10**RI10
      CDUM=CMPLX(DUM1,DUM2)
      CALL CONV12(CDUM,BE)
      BE(1,2)=BE(1,2)+IR10
      BE(2,2)=BE(2,2)+II10
      CALL ECPDIV(AE,BE,CE)
      IF (LNPFQ==0) THEN
         CALL CONV21(CE,C)
      ELSE
         CALL EMULT(CE(1,1),CE(1,2),CE(1,1),CE(1,2),N1,E1)
         CALL EMULT(CE(2,1),CE(2,2),CE(2,1),CE(2,2),N2,E2)
         CALL EADD(N1,E1,N2,E2,N3,E3)
         N1=CE(1,1)
         E1=CE(1,2)-CE(2,2)
         X2=CE(2,1)
!
!      TENMAX - MAXIMUM SIZE OF EXPONENT OF 10
!
!      THE FOLLOWING CODE CAN BE USED TO DETERMINE TENMAX, BUT IT
!
!      WILL LIKELY GENERATE AN IEEE FLOATING POINT UNDERFLOW ERROR
!
!      ON A SUN WORKSTATION.  REPLACE TENMAX WITH THE VALUE APPROPRIATE
!
!      FOR YOUR MACHINE.
!
!
         TENMAX=320
         ITNMAX=1
         DNUM=0.1D0
         ITNMAX=ITNMAX+1
         DNUM=DNUM*0.1D0
         do while (DNUM>0.0) 
            ITNMAX=ITNMAX+1
            DNUM=DNUM*0.1D0
         END do
         ITNMAX=ITNMAX-1
         TENMAX=DBLE(ITNMAX)
!
         IF (E1>TENMAX) THEN
            X1=TENMAX
         ELSEIF (E1<-TENMAX) THEN
            X1=0.0
         ELSE
            X1=N1*(TEN**E1)
         ENDIF
         IF (X2/=0.0) THEN
            PHI=ATAN2(X2,X1)
         ELSE
            PHI=0.0
         ENDIF
         C=CMPLX(HALF*(LOG(N3)+E3*LOG(TEN)),PHI)
      ENDIF
      END SUBROUTINE ARYDIV
!--   /emult.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE EMULT                             *
!     *                                                              *
!     *                                                              *
!     *  Description : Takes one base and exponent and multiplies it *
!     *    by another numbers base and exponent to give the product  *
!     *    in the form of base and exponent.                         *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE EMULT(N1,E1,N2,E2,NF,EF)
!*--EMULT1372
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION E1 , E2 , EF , N1 , N2 , NF
!
!*** End of declarations rewritten by SPAG
!
!
!
      NF=N1*N2
      EF=E1+E2
      IF (ABS(NF)>=TEN) THEN
         NF=NF/TEN
         EF=EF+ONE
      ENDIF
      END SUBROUTINE EMULT
!--   /ediv.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE EDIV                              *
!     *                                                              *
!     *                                                              *
!     *  Description : returns the solution in the form of base and  *
!     *    exponent of the division of two exponential numbers.      *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE EDIV(N1,E1,N2,E2,NF,EF)
!*--EDIV1412
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION E1 , E2 , EF , N1 , N2 , NF
!
!*** End of declarations rewritten by SPAG
!
!
!
      NF=N1/N2
      EF=E1-E2
      IF ((ABS(NF)<ONE) .AND. (NF/=ZERO)) THEN
         NF=NF*TEN
         EF=EF-ONE
      ENDIF
      END SUBROUTINE EDIV
!--   /eadd.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE EADD                              *
!     *                                                              *
!     *                                                              *
!     *  Description : Returns the sum of two numbers in the form    *
!     *    of a base and an exponent.                                *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE EADD(N1,E1,N2,E2,NF,EF)
!*--EADD1452
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION E1 , E2 , EF , N1 , N2 , NF
!
! Local variables
!
      DOUBLE PRECISION EDIFF
!
!*** End of declarations rewritten by SPAG
!
!
!
      EDIFF=E1-E2
      IF (EDIFF>36.0D0) THEN
         NF=N1
         EF=E1
      ELSEIF (EDIFF<-36.0D0) THEN
         NF=N2
         EF=E2
      ELSE
         NF=N1*(TEN**EDIFF)+N2
         EF=E2
         do
            IF (ABS(NF)<TEN) THEN
               do while ((ABS(NF)<ONE) .AND. (NF/=0.0)) 
                  NF=NF*TEN
                  EF=EF-ONE
               END do
               exit
            ELSE
               NF=NF/TEN
               EF=EF+ONE
            ENDIF
         end do
      ENDIF
      END SUBROUTINE EADD
!--   /esub.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ESUB                              *
!     *                                                              *
!     *                                                              *
!     *  Description : Returns the solution to the subtraction of    *
!     *    two numbers in the form of base and exponent.             *
!     *                                                              *
!     *  Subprograms called: EADD                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ESUB(N1,E1,N2,E2,NF,EF)
!*--ESUB1511
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION E1 , E2 , EF , N1 , N2 , NF
!
!*** End of declarations rewritten by SPAG
!
!
!
      CALL EADD(N1,E1,N2*(-ONE),E2,NF,EF)
      END SUBROUTINE ESUB
!--   /conv12.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE CONV12                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Converts a number from complex notation to a  *
!     *    form of a 2x2 real array.                                 *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE CONV12(CN,CAE)
!*--CONV121546
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      COMPLEX*16 CN
      DOUBLE PRECISION CAE(2,2)
!
! Local variables
!
      DOUBLE PRECISION DBLE
!
!*** End of declarations rewritten by SPAG
!
!
!
      CAE(1,1)=DBLE(CN)
      CAE(1,2)=0.0
      do
         IF (ABS(CAE(1,1))<TEN) THEN
            do
               IF ((ABS(CAE(1,1))>=ONE) .OR. (CAE(1,1)==0.0)) THEN
                  CAE(2,1)=IMAG(CN)
                  CAE(2,2)=0.0
                  do
                     IF (ABS(CAE(2,1))<TEN) THEN
                        do while ((ABS(CAE(2,1))<ONE) .AND. 
     +                       (CAE(2,1)/=0.0)) 
                           CAE(2,1)=CAE(2,1)*TEN
                           CAE(2,2)=CAE(2,2)-ONE
                        END do
                        exit
                     ELSE
                        CAE(2,1)=CAE(2,1)/TEN
                        CAE(2,2)=CAE(2,2)+ONE
                     ENDIF
                  end do
                  exit
               ELSE
                  CAE(1,1)=CAE(1,1)*TEN
                  CAE(1,2)=CAE(1,2)-ONE
               ENDIF
            end do
            exit
         ELSE
            CAE(1,1)=CAE(1,1)/TEN
            CAE(1,2)=CAE(1,2)+ONE
         ENDIF
      end do
      END SUBROUTINE CONV12
!--   /conv21.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE CONV21                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Converts a number represented in a 2x2 real   *
!     *    array to the form of a complex number.                    *
!     *                                                              *
!     *  Subprograms called: none                                    *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE CONV21(CAE,CN)
!*--CONV211611
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      INTEGER NOUT
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
      COMMON /IO    / NOUT
!
! Dummy arguments
!
      COMPLEX*16 CN
      DOUBLE PRECISION CAE(2,2)
!
! Local variables
!
      DOUBLE PRECISION DBLE
      DOUBLE PRECISION DNUM , TENMAX
      INTEGER ITNMAX
!
!*** End of declarations rewritten by SPAG
!
!
!
!     TENMAX - MAXIMUM SIZE OF EXPONENT OF 10
!
      ITNMAX=1
      DNUM=0.1D0
 1    ITNMAX=ITNMAX+1
      DNUM=DNUM*0.1D0
      do while  (DNUM>0.0) 
         ITNMAX=ITNMAX+1
         DNUM=DNUM*0.1D0
      END do
      ITNMAX=ITNMAX-2
      TENMAX=DBLE(ITNMAX)
!
      IF (CAE(1,2)>TENMAX .OR. CAE(2,2)>TENMAX) THEN
!      CN=CMPLX(TENMAX,TENMAX)
!
         WRITE (NOUT,300) ITNMAX
 300     FORMAT (' ERROR - VALUE OF EXPONENT REQUIRED FOR SUMMATION',
     +        ' WAS LARGER',/,' THAN THE MAXIMUM MACHINE EXPONENT ',
     + 1I3,/,' SUGGESTIONS:',/,' 1) RE-RUN USING LNPFQ=1.',/,
     + ' 2) IF YOU ARE USING A VAX, TRY USING THE',
     + ' FORTRAN/G_FLOATING OPTION')
         STOP
      ELSEIF (CAE(2,2)<-TENMAX) THEN
         CN=CMPLX(CAE(1,1)*(10**CAE(1,2)),0.0)
      ELSE
         CN=CMPLX(CAE(1,1)*(10**CAE(1,2)),CAE(2,1)*(10**CAE(2,2)))
      ENDIF
      RETURN
      END SUBROUTINE CONV21
!--   /ecpmul.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ECPMUL                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Multiplies two numbers which are each         *
!     *    represented in the form of a two by two array and returns *
!     *    the solution in the same form.                            *
!     *                                                              *
!     *  Subprograms called: EMULT, ESUB, EADD                       *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ECPMUL(A,B,C)
!*--ECPMUL1683
!
!*** Start of declarations rewritten by SPAG
!
! Dummy arguments
!
      DOUBLE PRECISION A(2,2) , B(2,2) , C(2,2)
!
! Local variables
!
      DOUBLE PRECISION C2(2,2) , E1 , E2 , N1 , N2
!
!*** End of declarations rewritten by SPAG
!
!
!
      CALL EMULT(A(1,1),A(1,2),B(1,1),B(1,2),N1,E1)
      CALL EMULT(A(2,1),A(2,2),B(2,1),B(2,2),N2,E2)
      CALL ESUB(N1,E1,N2,E2,C2(1,1),C2(1,2))
      CALL EMULT(A(1,1),A(1,2),B(2,1),B(2,2),N1,E1)
      CALL EMULT(A(2,1),A(2,2),B(1,1),B(1,2),N2,E2)
      CALL EADD(N1,E1,N2,E2,C(2,1),C(2,2))
      C(1,1)=C2(1,1)
      C(1,2)=C2(1,2)
      END SUBROUTINE ECPMUL
!--   /ecpdiv.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     
!     ****************************************************************
!     *                                                              *
!     *                 SUBROUTINE ECPDIV                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Divides two numbers and returns the solution. *
!     *    All numbers are represented by a 2x2 array.               *
!     *                                                              *
!     *  Subprograms called: EADD, ECPMUL, EDIV, EMULT               *
!     *                                                              *
!     ****************************************************************
!     
      SUBROUTINE ECPDIV(A,B,C)
!*--ECPDIV1724
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      DOUBLE PRECISION A(2,2) , B(2,2) , C(2,2)
!
! Local variables
!
      DOUBLE PRECISION B2(2,2) , C2(2,2) , E1 , E2 , E3 , N1 , N2 , N3
!
!*** End of declarations rewritten by SPAG
!
!
!
      B2(1,1)=B(1,1)
      B2(1,2)=B(1,2)
      B2(2,1)=-ONE*B(2,1)
      B2(2,2)=B(2,2)
      CALL ECPMUL(A,B2,C2)
      CALL EMULT(B(1,1),B(1,2),B(1,1),B(1,2),N1,E1)
      CALL EMULT(B(2,1),B(2,2),B(2,1),B(2,2),N2,E2)
      CALL EADD(N1,E1,N2,E2,N3,E3)
      CALL EDIV(C2(1,1),C2(1,2),N3,E3,C(1,1),C(1,2))
      CALL EDIV(C2(2,1),C2(2,2),N3,E3,C(2,1),C(2,2))
      END SUBROUTINE ECPDIV
!--   /ipremax.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     ****************************************************************
!     *                                                              *
!     *                   FUNCTION IPREMAX                           *
!     *                                                              *
!     *                                                              *
!     *  Description : Predicts the maximum term in the pFq series   *
!     *    via a simple scanning of arguments.                       *
!     *                                                              *
!     *  Subprograms called: none.                                   *
!     *                                                              *
!     ****************************************************************
!     
      FUNCTION IPREMAX(A,B,IP,IQ,Z)
!*--IPREMAX1770
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      INTEGER NOUT
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
      COMMON /IO    / NOUT
!
! Dummy arguments
!
      INTEGER IP , IQ
      COMPLEX*16 Z
      COMPLEX*16 A(IP) , B(IQ)
      INTEGER IPREMAX
!
! Local variables
!
      DOUBLE PRECISION DBLE
      DOUBLE PRECISION EXPON , XL , XMAX , XTERM
      COMPLEX*16 FACTOR
      INTEGER I , J
!
!*** End of declarations rewritten by SPAG
!
!
      XTERM=0
      DO J=1 , 100000
!
!      Estimate the exponent of the maximum term in the pFq series.
!
!
         EXPON=ZERO
         XL=DBLE(J)
         DO I=1 , IP
            EXPON=EXPON+DBLE(FACTOR(A(I)+XL-ONE))-DBLE(FACTOR(A(I)-ONE))
         ENDDO
         DO I=1 , IQ
            EXPON=EXPON-DBLE(FACTOR(B(I)+XL-ONE))+DBLE(FACTOR(B(I)-ONE))
         ENDDO
         EXPON=EXPON+XL*DBLE(LOG(Z))-DBLE(FACTOR(DCMPLX(XL,ZERO)))
         XMAX=LOG10(EXP(ONE))*EXPON
         IF ((XMAX<XTERM) .AND. (J>2)) THEN
            IPREMAX=J
            RETURN
         ENDIF
         XTERM=MAX(XMAX,XTERM)
      ENDDO
      WRITE (NOUT,*) ' ERROR IN IPREMAX--DID NOT FIND MAXIMUM EXPONENT'
      STOP
      END FUNCTION IPREMAX
!--   /factor.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     ****************************************************************
!     *                                                              *
!     *                   FUNCTION FACTOR                            *
!     *                                                              *
!     *                                                              *
!     *  Description : This function is the log of the factorial.    *
!     *                                                              *
!     *  Subprograms called: none.                                   *
!     *                                                              *
!     ****************************************************************
!     
      FUNCTION FACTOR(Z)
!*--FACTOR1836
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
! Dummy arguments
!
      COMPLEX*16 Z
      COMPLEX*16 FACTOR, CGAMMA
!
! Local variables
!
      DOUBLE PRECISION DBLE
      DOUBLE PRECISION PI
!
!*** End of declarations rewritten by SPAG
!
!
      IF (((DBLE(Z)==ONE) .AND. (DIMAG(Z)==ZERO)) .OR. 
     + (ABS(ABS(Z)-ZERO)<=1D-12)) THEN
         FACTOR=DCMPLX(ZERO,ZERO)
         RETURN
      ENDIF
      IF (REAL(Z)<=2.0) THEN
         FACTOR=CGAMMA(Z+1,1)
         RETURN
      ENDIF
      PI=TWO*TWO*ATAN(ONE)
      FACTOR=HALF*LOG(TWO*PI)+(Z+HALF)*LOG(Z)-Z+(ONE/(12.0D0*Z))
     +     *(ONE-(ONE/(30.D0*Z*Z))*(ONE-(TWO/(7.0D0*Z*Z))))
      END FUNCTION FACTOR
!--   /cgamma.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     ****************************************************************
!     *                                                              *
!     *                   FUNCTION CGAMMA                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Calculates the complex gamma function.  Based *
!     *     on a program written by F.A. Parpia published in Computer*
!     *     Physics Communications as the `GRASP2' program (public   *
!     *     domain).                                                 *
!     *                                                              *
!     *                                                              *
!     *  Subprograms called: none.                                   *
!     *                                                              *
!     ****************************************************************
      FUNCTION CGAMMA(ARG,LNPFQ)
!
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
!*--CGAMMA1884
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      INTEGER NOUT
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
      COMMON /IO    / NOUT
!
! Dummy arguments
!
      COMPLEX*16 ARG
      INTEGER LNPFQ
      COMPLEX*16 CGAMMA
!
! Local variables
!
      DOUBLE PRECISION ARGI , ARGR , ARGUI , ARGUI2 , ARGUM , ARGUR 
      DOUBLE PRECISION ARGUR2 , CLNGI , CLNGR , DIFF , DNUM , EXPMAX
      DOUBLE PRECISION FAC , FACNEG , FD(7) , FN(7) , HLNTPI , OBASQ
      DOUBLE PRECISION OBASQI , OBASQR , OVLFAC , OVLFI , OVLFR , PI
      DOUBLE PRECISION PRECIS , RESI , RESR , TENMAX , TENTH , TERMI
      DOUBLE PRECISION TERMR , TWOI , ZFACI , ZFACR
      DOUBLE PRECISION DBLE
      LOGICAL FIRST , NEGARG
      INTEGER I , ITNMAX
      INTEGER NINT
!
!*** End of declarations rewritten by SPAG
!
!
!
!----------------------------------------------------------------------*
!     *
!     THESE ARE THE BERNOULLI NUMBERS B02, B04, ..., B14, EXPRESSED AS *
!     RATIONAL NUMBERS. FROM ABRAMOWITZ AND STEGUN, P. 810.            *
!     *
      DATA FN/1.0D00 , -1.0D00 , 1.0D00 , -1.0D00 , 5.0D00 , 
     +     -691.0D00 , 7.0D00/
      DATA FD/6.0D00 , 30.0D00 , 42.0D00 , 30.0D00 , 66.0D00 , 
     + 2730.0D00 , 6.0D00/
!
!----------------------------------------------------------------------*
!
      DATA HLNTPI/1.0D00/
!
      DATA FIRST/.TRUE./
!
      DATA TENTH/0.1D00/
!
      ARGR=DBLE(ARG)
      ARGI=DIMAG(ARG)
!
!     ON THE FIRST ENTRY TO THIS ROUTINE, SET UP THE CONSTANTS REQUIRED
!     FOR THE REFLECTION FORMULA (CF. ABRAMOWITZ AND STEGUN 6.1.17) AND
!     STIRLING'S APPROXIMATION (CF. ABRAMOWITZ AND STEGUN 6.1.40).
!
      first=.true.
      IF (FIRST) THEN
         PI=4.0D0*ATAN(ONE)
!
!      SET THE MACHINE-DEPENDENT PARAMETERS:
!
!
!      TENMAX - MAXIMUM SIZE OF EXPONENT OF 10
!
!
         ITNMAX=1
         DNUM=TENTH
 10      ITNMAX=ITNMAX+1
         DNUM=DNUM*TENTH
         do while (DNUM>0.0) 
            ITNMAX=ITNMAX+1
            DNUM=DNUM*TENTH
         END do
         ITNMAX=ITNMAX-1
         TENMAX=DBLE(ITNMAX)
!
!      EXPMAX - MAXIMUM SIZE OF EXPONENT OF E
!
!
         DNUM=TENTH**ITNMAX
         EXPMAX=-LOG(DNUM)
!
!      PRECIS - MACHINE PRECISION
!
!
         PRECIS=ONE
 20      PRECIS=PRECIS/TWO
         DNUM=PRECIS+ONE
         do while (DNUM>ONE) 
            PRECIS=PRECIS/TWO
            DNUM=PRECIS+ONE
         END do
         PRECIS=TWO*PRECIS
!
         HLNTPI=HALF*LOG(TWO*PI)
!
         DO I=1 , 7
            FN(I)=FN(I)/FD(I)
            TWOI=TWO*DBLE(I)
            FN(I)=FN(I)/(TWOI*(TWOI-ONE))
         ENDDO
!
         FIRST=.FALSE.
!
      ENDIF
!
!     CASES WHERE THE ARGUMENT IS REAL
!
      IF (ARGI==0.0) THEN
!
!      CASES WHERE THE ARGUMENT IS REAL AND NEGATIVE
!
!
         IF (ARGR<=0.0) THEN
!
!       STOP WITH AN ERROR MESSAGE IF THE ARGUMENT IS TOO NEAR A POLE
!
!
            DIFF=ABS(DBLE(NINT(ARGR))-ARGR)
            IF (DIFF<=TWO*PRECIS) THEN
               WRITE (NOUT,300)
               WRITE (NOUT,301) ARGR , ARGI
 301           FORMAT (' ARGUMENT (',1P,1D14.7,',',1D14.7,
     +              ') TOO CLOSE TO A', ' POLE.')
               STOP 'here: 010801'
            ELSE
!
!        OTHERWISE USE THE REFLECTION FORMULA (ABRAMOWITZ AND STEGUN 6.1
!        .17)
!        TO ENSURE THAT THE ARGUMENT IS SUITABLE FOR STIRLING'S
!
!        FORMULA
!
!
               ARGUM=PI/(-ARGR*SIN(PI*ARGR))
               IF (ARGUM<0.0) THEN
                  ARGUM=-ARGUM
                  CLNGI=PI
               ELSE
                  CLNGI=0.0
               ENDIF
               FACNEG=LOG(ARGUM)
               ARGUR=-ARGR
               NEGARG=.TRUE.
!
            ENDIF
!
!       CASES WHERE THE ARGUMENT IS REAL AND POSITIVE
!
!
         ELSE
!
            CLNGI=0.0
            ARGUR=ARGR
            NEGARG=.FALSE.
!
         ENDIF
!
!      USE ABRAMOWITZ AND STEGUN FORMULA 6.1.15 TO ENSURE THAT
!
!      THE ARGUMENT IN STIRLING'S FORMULA IS GREATER THAN 10
!
!
         OVLFAC=ONE
         do while (ARGUR<TEN)
            OVLFAC=OVLFAC*ARGUR
            ARGUR=ARGUR+ONE
         end do
!
!      NOW USE STIRLING'S FORMULA TO COMPUTE LOG (GAMMA (ARGUM))
!
!
         CLNGR=(ARGUR-HALF)*LOG(ARGUR)-ARGUR+HLNTPI
         FAC=ARGUR
         OBASQ=ONE/(ARGUR*ARGUR)
         DO I=1 , 7
            FAC=FAC*OBASQ
            CLNGR=CLNGR+FN(I)*FAC
         ENDDO
!
!      INCLUDE THE CONTRIBUTIONS FROM THE RECURRENCE AND REFLECTION
!
!      FORMULAE
!
!
         CLNGR=CLNGR-LOG(OVLFAC)
         IF (NEGARG) THEN
            CLNGR=FACNEG-CLNGR
         ENDIF
!
      ELSE
!
!      CASES WHERE THE ARGUMENT IS COMPLEX
!
!
         ARGUR=ARGR
         ARGUI=ARGI
         ARGUI2=ARGUI*ARGUI
!
!      USE THE RECURRENCE FORMULA (ABRAMOWITZ AND STEGUN 6.1.15)
!
!      TO ENSURE THAT THE MAGNITUDE OF THE ARGUMENT IN STIRLING'S
!
!      FORMULA IS GREATER THAN 10
!
!
         OVLFR=ONE
         OVLFI=0.0
 60      ARGUM=SQRT(ARGUR*ARGUR+ARGUI2)
         do while (ARGUM<TEN)
            TERMR=OVLFR*ARGUR-OVLFI*ARGUI
            TERMI=OVLFR*ARGUI+OVLFI*ARGUR
            OVLFR=TERMR
            OVLFI=TERMI
            ARGUR=ARGUR+ONE
            ARGUM=SQRT(ARGUR*ARGUR+ARGUI2)
         END do
!
!      NOW USE STIRLING'S FORMULA TO COMPUTE LOG (GAMMA (ARGUM))
!
!
         ARGUR2=ARGUR*ARGUR
         TERMR=HALF*LOG(ARGUR2+ARGUI2)
         TERMI=ATAN2(ARGUI,ARGUR)
         CLNGR=(ARGUR-HALF)*TERMR-ARGUI*TERMI-ARGUR+HLNTPI
         CLNGI=(ARGUR-HALF)*TERMI+ARGUI*TERMR-ARGUI
         FAC=(ARGUR2+ARGUI2)**(-2)
         OBASQR=(ARGUR2-ARGUI2)*FAC
         OBASQI=-TWO*ARGUR*ARGUI*FAC
         ZFACR=ARGUR
         ZFACI=ARGUI
         DO I=1 , 7
            TERMR=ZFACR*OBASQR-ZFACI*OBASQI
            TERMI=ZFACR*OBASQI+ZFACI*OBASQR
            FAC=FN(I)
            CLNGR=CLNGR+TERMR*FAC
            CLNGI=CLNGI+TERMI*FAC
            ZFACR=TERMR
            ZFACI=TERMI
         ENDDO
!
!      ADD IN THE RELEVANT PIECES FROM THE RECURRENCE FORMULA
!
!
         CLNGR=CLNGR-HALF*LOG(OVLFR*OVLFR+OVLFI*OVLFI)
         CLNGI=CLNGI-ATAN2(OVLFI,OVLFR)
!
      ENDIF
      IF (LNPFQ==1) THEN
         CGAMMA=CMPLX(CLNGR,CLNGI)
         RETURN
      ENDIF
!
!     NOW EXPONENTIATE THE COMPLEX LOG GAMMA FUNCTION TO GET
!     THE COMPLEX GAMMA FUNCTION
!
      IF ((CLNGR<=EXPMAX) .AND. (CLNGR>=-EXPMAX)) THEN
         FAC=EXP(CLNGR)
      ELSE
         WRITE (NOUT,300)
         WRITE (NOUT,302) CLNGR
 302     FORMAT (' ARGUMENT TO EXPONENTIAL FUNCTION (',
     +        1P,1D14.7,') OUT OF RANGE.')
         STOP '010802'
      ENDIF
      RESR=FAC*COS(CLNGI)
      RESI=FAC*SIN(CLNGI)
      CGAMMA=CMPLX(RESR,RESI)
!
      RETURN
!
 300  FORMAT (' ***** ERROR IN SUBROUTINE CGAMMA *****')
!
      END FUNCTION CGAMMA
      
      
      
      
      
      
      
      
      
      
      
!--   /bldat1.f90  processed by SPAG 6.53Rc at 14:58 on 26 Jul 2004
!     
!     ****************************************************************
!     *                                                              *
!     *                 BLOCK DATA BLDAT1                            *
!     *                                                              *
!     *                                                              *
!     *  Description : Sets of frequently used numbers in a common   *
!     *    block.  This makes it easier to convert the code to a     *
!     *    single precision version.                                 *
!     *                                                              *
!     ****************************************************************
!     
      BLOCKDATA BLDAT1
!*--BLDAT12173
!
!*** Start of declarations rewritten by SPAG
!
! COMMON variables
!
      DOUBLE PRECISION EPS , HALF , ONE , TEN , TWO , ZERO
      COMMON /CONSTS/ ZERO , HALF , ONE , TWO , TEN , EPS
!
!*** End of declarations rewritten by SPAG
!
!
      DATA ZERO , HALF , ONE , TWO , TEN , EPS/0.0D0 , 
     + 0.5D0 , 1.0D0 , 2.0D0 , 10.0D0 , 1.0D-10/
      END BLOCKDATA
!     
      
      
      
