% Script for eLife manuscript "Dopaminergic, neural and computational contributions to
% probabilistic reward learning in old age"
% this is the script that selects the  best iteration for all the behavioural
% models and computes the iBIC. Should be run in the folder with the model output files. 

% Script by Peter Dayan, Lieke de Boer and Marc Guitart-Masip, 2016
clear all

load '/home/ALDRECENTRUM/lieke.deboer/Documents/DAD/behaviour/TAB/tab_modelling/fit_models_fminsearch/form/tab_datap.mat'
addpath /home/ALDRECENTRUM/lieke.deboer/Documents/DAD/behaviour/TAB/tab_modelling/fit_models_fminsearch/form


dt = '161227_EM_';


fm{1} = 'llba';W
fm{2} = 'llbac';
fm{3} = 'llbacf';  % a model that forgets the unchosen option with a forgetting rate
fm{4} = 'llbbdist1p'; % this model learns p(reward) for each bandit as a beta distribution with equal alpha and beta parameter
fm{5} = 'llbbdist2p'; % as preceeding but with different alpha and beta parameter for the beta distribution
fm{6} = 'llbbdist2p_b';    % beta distribution + choice kernel
fm{7} = 'llbbdist2p_V';  % beta distribution + choice kernel + confidence bonus to chosen option on t-1
fm{8} = 'llbbdist2p_c'; % beta distribution + choice kernel + conficence on t-1 modulates inverse temp on t
fm{9} = 'llbbdist2p_V2';    % value of unchosen option on previous trial is modified according to the current uncertainty of that option (unchosen on previous trial)
fm{10} = 'llbbdist2p_vc';   % value of chosen option on previous trial is modified according to the current uncertainty of that option (chosen on previous trial)

Npar=[2 3 4 2 3 4 4 4 4 5];

docomp = 1;
Nsample = 2000;


for model=7%size(fm,2)
    pl=[];
    for ite=1:8
        load ([dt '-' fm{model} '-ite' num2str(ite)]);
        pl(ite)=PL(end);
    end
    
    [x y]=min(pl);
    SelectIte(model)=y;
    load ([dt '-' fm{model} '-ite' num2str(y)]);
    Np = Npar(model);
    Nsj = length(A);
    ld = [dt '-' fm{model} '-ite' num2str(y)];
    
    if docomp
        oo = ones(1,Nsample);
        muo = mu*oo; nuo = nu*oo;
        
        rand('seed',sum(100*clock));
        LLi=zeros(Nsample,1);
        ddl = zeros(Np,Nsj);
        
        for sj=1:length(A);
            fprintf('subject %i \r',sj)
            
            a=A{sj};
            r=R{sj};
            
            est = diag(sqrt(nu))*randn(Np,Nsample)+mu*ones(1,Nsample);
            for k=1:Nsample;
                LLi(k)=feval(fm{model},est(:,k),a,r,Z,0);
                if ~mod(k,50);fprintf('model %i subject %i sample %i\r',model,sj,k);end
            end
            iL(sj) = log(sum(exp(-LLi))/Nsample);
        end
        
        
        % compute integrated BIC
        for k=1:length(A); Nch(k)=length(A{k});end; Nch = Nch(:);
        bici  = -2*sum(iL)   + 2*Np*log(sum(Nch)) % integrated BIC
        
        eval(['save ' ld '_meanerror bici iL mu nu E ld fm model']);
    end  
end