function [l] = llbbdist2p_vc (x, a, r, Z,doprior)
np = length(x);
beta = exp(x(1));
w = 1./(1+exp(-x(2)));
f = 1./(1+exp(-x(3)));
cfd = x(4);
v = x(5); 
%fprintf('c=%2d, b=%f, w=%f, f=%f, c=%f\n',counter,beta,w,f,cfd);
if doprior
    lp = -1/2 * (x-Z.mu)'*Z.nui*(x-Z.mu) - 1/2*log(1/det(Z.nui/(2*pi))); %
else
    lp=0;
end

% initialize
l=0;

Q = ones(2,2);
qs = [0 0];

for t=1:length(a)
    
    q(1)=Q(1,1)/sum(Q(1,:));
    q(2)=Q(2,1)/sum(Q(2,:));
    
    V(1) = (Q(1,1)*Q(1,2))/((Q(1,1)+Q(1,2))^2*(Q(1,1)+Q(1,2)+1));
    V(2) = (Q(2,1)*Q(2,2))/((Q(2,1)+Q(2,2))^2*(Q(2,1)+Q(2,2)+1));
    
    q = q + qs;

    if (t>1)
      q(3-a(t-1))=q(3-a(t-1))+v*V(3-a(t-1));
    end
    
    q = beta*(q);
    
    l0 = max(q);
    la = q(a(t)) - l0 - log(sum(exp(q-l0)));
    l = l + la;
    
    c=conf(Q(1,1),Q(1,2),Q(2,1),Q(2,2));

    qs = [0 0];
%     qs(a(t)) = cfd*(3*c-1+a(t)*(1-2*c));
    qs(3-a(t)) = cfd*(2*c-1)*(3-2*a(t)); % this makes c(chosen)-c(unchosen)
    
    Q(a(t),:)=w+(1-w)*Q(a(t),:);
    Q(a(t),2-r(t))=Q(a(t),2-r(t))+1;
    Q(3-a(t),:)=f+(1-f)*Q(3-a(t),:);   
end
l  = -l  - sum(lp);

function c=conf(a1,b1,a2,b2,choice)
global counter;
%global xx;
% c=conf(a1,b1,a2,b2,choice)
% given two beta distributions (a1,b1) and (a2,b2) and choice={1,2}
% works out the probability that a sample from the chosen beta dist
% is bigger than a sample from the unchosen one
% this uses quadrature; the answer is also a hypergeometric function
%x=0:.001:1; % original x=0:.00001:1;
%dx=xx(2)-xx(1);
%
%if (choice==1)
%    c=sum(betapdf(xx,a1,b1).*betacdf(xx,a2,b2))*dx;
%else
%    c=sum(betacdf(xx,a1,b1).*betapdf(xx,a2,b2))*dx;
%end
if (max([a1 b1 a2 b2])>70)
  c=conff(a1,b1,a2,b2);
else 
  c=tryout(a1,b1,a2,b2);
end
