//Measure the volume of C1 signal outside of C4 signal in the selected area.
//by Richard Butler, Gurdon Institute Imaging Facility

//Constants
SIGMA = 2;		//Gaussian sigma (µm)
C1_METHOD = "Otsu";	//C1 autothreshold method
C4_THRESHOLD = 10;	//C4 threshold
CELL_RADIUS = 6;	//radius used to estimate cell count (µm)

function volume(c){
	selectWindow("C"+c);
	hex = "#33";	//alpha
	if(c==1){
		hex += "00FFFF";
	}
	else if(c==4){
		hex += "FF00FF";
	}
	run("Overlay Options...", "stroke=none width=0 fill="+hex+" set");
	vol = 0;
	for(i=1;i<=Z;i++){
		selectWindow("C"+c);
		run("Select None");
		setSlice(i);
		run("Create Selection");
		run("Make Inverse");
		if(selectionType!=-1){
			getSelectionBounds(roiXmod, roiYmod, _, _);
			getStatistics(area);
			vol += area;
			selectWindow(title);
			Stack.setPosition(1, i, 1);
			run("Restore Selection");
			setSelectionLocation(roiX+roiXmod,roiY+roiYmod);
			run("Add Selection...");
			Stack.setPosition(4, i, 1);
			run("Add Selection...");
		}
	}
	return vol * voxD;
}

title = getTitle();
getDimensions(W,H,C,Z,T);
getVoxelSize(voxW, voxH, voxD, unit);
if(matches(unit,"[Mm]icro.*")){unit = fromCharCode(0xb5)+"m";}
if(C!=4){exit("4 channels required.");}
if(selectionType()!=0&&selectionType()!=1&&selectionType()!=2&&selectionType()!=4){exit("Area selection required.");}
setBatchMode(true);
getSelectionBounds(roiX, roiY, roiW, roiH);
run("Overlay Options...", "stroke=FF00FF width=2 fill=none set");
for(z=1;z<=Z;z++){
	Stack.setPosition(1,z,1);
	run("Add Selection...");
}
setBackgroundColor(0, 0, 0);
setOption("BlackBackground", true);
run("Options...", "iterations=1 count=1 black edm=Overwrite do=Nothing");
Stack.setChannel(1);
run("Duplicate...", "title=C1 duplicate channels=1-1 slices=1-"+Z);
run("Gaussian Blur...", "sigma="+SIGMA+" scaled stack");
if(selectionType()!=-1){run("Clear Outside", "stack");}
run("Select None");
run("8-bit");
setAutoThreshold(C1_METHOD+" dark stack");
run("Convert to Mask", "method="+C1_METHOD+" background=Dark black");
selectWindow(title);
Stack.setChannel(4);
run("Duplicate...", "title=C4 duplicate channels=4-4 slices=1-"+Z);
run("Gaussian Blur...", "sigma="+SIGMA+" scaled stack");
if(selectionType()!=-1){run("Clear Outside", "stack");}
run("Select None");
run("8-bit");
setThreshold(C4_THRESHOLD, pow(2,16));
run("Convert to Mask", "method=Default background=Dark black");
run("Open", "stack");
run("Fill Holes", "stack");

setForegroundColor(255, 255, 255);
for(z=1;z<=Z;z++){
	setSlice(z);
	run("Select None");
	getMinAndMax(min,max);
	if(max!=0){
		run("Points from Mask");	//hackro
		Roi.getCoordinates(points, _);
		if(points.length>2){
			run("Convex Hull");
			run("Fill", "slice");
			run("Select None");
		}
	}
}
run("Select None");

imageCalculator("Subtract stack", "C1","C4");
C1vol = volume(1);
C4vol = volume(4);
C1count = C1vol/((4/3)*PI*pow(CELL_RADIUS,3));
selectWindow("C1"); close();
selectWindow("C4"); close();
selectWindow(title);
run("Select None");
setBatchMode("exit and display");
print(title+"\t ("+((roiX+(roiW/2))*voxW)+", "+((roiY+(roiH/2))*voxH)+")");
print("C1 outside C4 volume = \t"+C1vol+"\t "+unit+fromCharCode(179)+" : estimated cell count = "+C1count);
print("C4 volume = \t"+C4vol+"\t "+unit+fromCharCode(179));
print((C1count/C4vol)+" C1 cells outside C4 per "+unit+fromCharCode(179)+" C4 signal");
print((C1vol/(C1vol+C4vol)*100)+" % C1 outside C4 in C1 + C4 signal volume");
print("C1V:C4V = "+(C1vol/C4vol));
print("~~~~~~~~~~~~~~~~~~~~");