(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 7.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    201332,       3894]
NotebookOptionsPosition[    200093,       3853]
NotebookOutlinePosition[    200514,       3869]
CellTagsIndexPosition[    200471,       3866]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"A", "[", 
     RowBox[{
     "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "m_", ",", "T_"}], "]"}],
     ":=", 
    RowBox[{"1", "/", 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Exp", "[", 
        RowBox[{"number", 
         RowBox[{"(", 
          RowBox[{"f0", "+", 
           RowBox[{"f1", 
            RowBox[{"(", 
             RowBox[{"T", "-", "T0"}], ")"}]}], "-", 
           RowBox[{"m", 
            RowBox[{"(", 
             RowBox[{"g0", "+", 
              RowBox[{"g1", 
               RowBox[{"(", 
                RowBox[{"T", "-", "T0"}], ")"}]}]}], ")"}]}]}], ")"}]}], 
        "]"}]}], ")"}]}]}], ";", 
   RowBox[{"(*", " ", 
    RowBox[{
     RowBox[{
     "this", " ", "is", " ", "the", " ", "methylation", " ", "level", " ", 
      "that", " ", "will", " ", "give", " ", "activity", " ", "A0"}], ",", 
     " ", 
     RowBox[{
     "for", " ", "the", " ", "current", " ", "set", " ", "of", " ", 
      "parameters"}]}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mmsol", "[", 
     RowBox[{
     "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "A0_", ",", "TmT0_"}], 
     "]"}], ":=", 
    FractionBox[
     RowBox[{"f0", "+", 
      RowBox[{"f1", " ", "TmT0"}], "-", 
      RowBox[{
       RowBox[{"Log", "[", 
        FractionBox[
         RowBox[{"1", "-", "A0"}], "A0"], "]"}], "/", "number"}]}], 
     RowBox[{"g0", "+", 
      RowBox[{"g1", " ", "TmT0"}]}]]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.680377431251096*^9, 3.680377459694656*^9}, {
   3.6803778623174057`*^9, 3.6803780001181946`*^9}, {3.680378058370407*^9, 
   3.680378155875219*^9}, {3.6803781985938168`*^9, 3.6803782280379868`*^9}, {
   3.680378297733489*^9, 3.680378302204027*^9}, {3.6804829897072563`*^9, 
   3.6804831757994547`*^9}, {3.6827670126812687`*^9, 3.682767048271674*^9}, 
   3.683657798454614*^9, 3.684003785072163*^9, {3.6961861457451463`*^9, 
   3.6961861481816244`*^9}, {3.709528826865529*^9, 3.709528828484771*^9}}],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
    "I", " ", "want", " ", "to", " ", "add", " ", "the", " ", "possibility", 
     " ", "of", " ", "slowing", " ", "down", " ", "of", " ", "both", " ", 
     "methylation", " ", "and", " ", 
     RowBox[{"demethylation", ".", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
        RowBox[{"The", " ", "equation", " ", "is", "\[IndentingNewLine]", 
         RowBox[{"dm", "/", "dt"}]}], " ", "=", " ", 
        RowBox[{
         RowBox[{"\[Gamma]_R", " ", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"mtot", "-", "m"}], ")"}], "/", 
           RowBox[{"(", 
            RowBox[{"mtot", "-", "m", "+", "n0"}], ")"}]}], 
          RowBox[{"(", 
           RowBox[{"1", "-", "A"}], ")"}]}], " ", "-", " ", 
         RowBox[{"\[Gamma]_B", " ", 
          RowBox[{"m", "/", 
           RowBox[{"(", 
            RowBox[{"m", "+", "n0"}], ")"}]}], "A", "\[IndentingNewLine]", 
          "A", "*", " ", "obeys", "  ", "\[Gamma]_R", " ", 
          RowBox[{"(", 
           RowBox[{"1", "-", "A"}]}]}]}]}], "*)"}], " ", 
      RowBox[{"-", " ", 
       RowBox[{"\[Gamma]_B", " ", "A", "*"}]}]}]}], " ", "=", " ", "0"}], ",",
    " ", 
   RowBox[{
    RowBox[{"or", "   ", 
     RowBox[{"\[Gamma]_R", "/", "\[Gamma]_B"}]}], " ", "=", "  ", 
    RowBox[{"A", "*", 
     RowBox[{"/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"A", "*"}]}], " ", ")"}]}]}]}], "    ", ",", 
   RowBox[{
    RowBox[{
    "so", " ", "the", " ", "steady", " ", "state", " ", "equation", "  ", 
     "becomes", " ", "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"mtot", "-", "m"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"mtot", "-", "m", "+", "n0"}], ")"}]}], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", "A"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"A", "*"}]}], " ", ")"}]}]}], " ", "=", " ", 
    RowBox[{
     RowBox[{"m", "/", 
      RowBox[{"(", 
       RowBox[{"m", "+", "n0"}], ")"}]}], 
     RowBox[{"A", "/", "A"}], "*"}]}]}], "       ", "*)"}]], "Input",
 CellChangeTimes->{{3.6834948784275775`*^9, 3.6834949327939515`*^9}, {
   3.683494967380206*^9, 3.6834949915299373`*^9}, {3.6834950440204763`*^9, 
   3.6834951347590227`*^9}, {3.683495166671217*^9, 3.6834953184285927`*^9}, {
   3.6834953490270014`*^9, 3.683495443594767*^9}, 3.683906774063036*^9, {
   3.7095489382879925`*^9, 3.7095489540083284`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"dAdT", "[", 
    RowBox[{"f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "m_", ",", "T_"}],
     "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "f1"}], "+", 
      RowBox[{"g1", " ", "m"}]}], ")"}], 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "-", 
        RowBox[{"A", "[", 
         RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
         "]"}]}], ")"}], 
      RowBox[{"A", "[", 
       RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
       "]"}]}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAdTn", "[", 
    RowBox[{
    "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", "mguess_"}], 
    "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "A1"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"m", "+", "mavail"}], ")"}]}], 
            RowBox[{"A1", "/", "A0"}]}]}], ",", 
          RowBox[{
           RowBox[{"A", "[", 
            RowBox[{
            "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
            "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"A1", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"dAdT", "[", 
      RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", 
       RowBox[{"sol", "[", 
        RowBox[{"[", 
         RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "T"}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]A", "[", 
    RowBox[{
    "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
     "\[CapitalDelta]T_", ",", "mguess_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "A1"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"m", "+", "mavail"}], ")"}]}], 
            RowBox[{"A1", "/", "A0"}]}]}], ",", 
          RowBox[{
           RowBox[{"A", "[", 
            RowBox[{
            "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
            "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"A1", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{"T", "+", "\[CapitalDelta]T"}]}], "]"}], "-", 
      RowBox[{"sol", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]Am", "[", 
     RowBox[{
     "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
      "\[CapitalDelta]T_", ",", "mguess_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"sol", "=", 
       RowBox[{"FindRoot", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"mtot", "-", "m"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "A1"}], ")"}], "/", 
              RowBox[{"(", 
               RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
            RowBox[{
             RowBox[{"m", "/", 
              RowBox[{"(", 
               RowBox[{"m", "+", "mavail"}], ")"}]}], 
             RowBox[{"A1", "/", "A0"}]}]}], ",", 
           RowBox[{
            RowBox[{"A", "[", 
             RowBox[{
             "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
             "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"{", 
            RowBox[{"A1", ",", 
             RowBox[{"1", "/", "3"}]}], "}"}], ",", 
           RowBox[{"{", 
            RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"A", "[", 
          RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", 
           RowBox[{"sol", "[", 
            RowBox[{"[", 
             RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", 
           RowBox[{"T", "+", "\[CapitalDelta]T"}]}], "]"}], "-", 
         RowBox[{"sol", "[", 
          RowBox[{"[", 
           RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ",", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}]}], "}"}]}], ")"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]Aperfect", "[", 
     RowBox[{
     "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
      "\[CapitalDelta]T_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"ms", "=", 
       RowBox[{"mmsol", "[", 
        RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", "A0", ",", 
         RowBox[{"T", "-", "T0"}]}], "]"}]}], ";", 
      RowBox[{
       RowBox[{"A", "[", 
        RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", "ms", ",", 
         RowBox[{"T", "+", "\[CapitalDelta]T"}]}], "]"}], " ", "-", "A0"}]}], 
     ")"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"dAdTnorm", "[", 
      RowBox[{"f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_"}], "]"}], ":=", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"sol", "=", 
        RowBox[{"FindRoot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"(", 
               RowBox[{"1", "-", "A0"}], ")"}], "/", "A0"}], "\[Equal]", 
             RowBox[{
              RowBox[{
               RowBox[{"(", 
                RowBox[{"mtot", "-", "m"}], ")"}], "/", 
               RowBox[{"(", 
                RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
              RowBox[{
               RowBox[{"(", 
                RowBox[{"1", "-", "A1"}], ")"}], "/", "A1"}]}]}], ",", 
            RowBox[{
             RowBox[{"A", "[", 
              RowBox[{
              "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
              "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"A1", ",", 
              RowBox[{"1", "/", "3"}]}], "}"}], ",", 
            RowBox[{"{", 
             RowBox[{"m", ",", "7"}], "}"}]}], "}"}]}], "]"}]}], ";", 
       RowBox[{
        RowBox[{"dAdT", "[", 
         RowBox[{"f0", ",", "f1", ",", "g0", ",", "g1", ",", 
          RowBox[{"sol", "[", 
           RowBox[{"[", 
            RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "T"}], "]"}], "/", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], ")"}]}], ";"}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"dAdTnCluster", "[", 
    RowBox[{
    "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
     "mguess_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"dAdTn", "[", 
       RowBox[{"f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        RowBox[{"mguess", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "+", 
      RowBox[{"3", 
       RowBox[{"dAdTn", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"3", 
       RowBox[{"dAdTn", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"dAdTn", "[", 
       RowBox[{"f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        RowBox[{"mguess", "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ")"}], "/", "8"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]ACluster", "[", 
    RowBox[{
    "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
     "\[CapitalDelta]T_", ",", "mguess_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[CapitalDelta]A", "[", 
       RowBox[{
       "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "\[CapitalDelta]T", ",", 
        RowBox[{"mguess", "[", 
         RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "+", 
      RowBox[{"3", 
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"3", 
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "+", 
      RowBox[{"\[CapitalDelta]A", "[", 
       RowBox[{
       "f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "\[CapitalDelta]T", ",", 
        RowBox[{"mguess", "[", 
         RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}], ")"}], "/", "8"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]AClusterm", "[", 
     RowBox[{
     "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
      "\[CapitalDelta]T_", ",", "mguess_"}], "]"}], ":=", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"\[CapitalDelta]A1", "=", 
       RowBox[{"\[CapitalDelta]Am", "[", 
        RowBox[{
        "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
         "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], ";", 
      RowBox[{"\[CapitalDelta]A2", "=", 
       RowBox[{"\[CapitalDelta]Am", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], ";", 
      RowBox[{"\[CapitalDelta]A3", "=", 
       RowBox[{"\[CapitalDelta]Am", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1", 
         ",", "g0", ",", "g1", ",", "T", ",", "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
      RowBox[{"\[CapitalDelta]A4", "=", 
       RowBox[{"\[CapitalDelta]Am", "[", 
        RowBox[{
        "f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
         "\[CapitalDelta]T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], ";", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{"\[CapitalDelta]A1", "[", 
            RowBox[{"[", "1", "]"}], "]"}], "+", 
           RowBox[{"3", 
            RowBox[{"\[CapitalDelta]A2", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "+", 
           RowBox[{"3", 
            RowBox[{"\[CapitalDelta]A3", "[", 
             RowBox[{"[", "1", "]"}], "]"}]}], "+", 
           RowBox[{"\[CapitalDelta]A4", "[", 
            RowBox[{"[", "1", "]"}], "]"}]}], ")"}], "/", "8"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"\[CapitalDelta]A1", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"\[CapitalDelta]A2", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"\[CapitalDelta]A3", "[", 
           RowBox[{"[", "1", "]"}], "]"}], ",", 
          RowBox[{"\[CapitalDelta]A4", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "}"}]}], "}"}]}], ")"}]}], ";"}],
   "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"msol", "[", 
    RowBox[{
    "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", "mguess_"}], 
    "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "A1"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"m", "+", "mavail"}], ")"}]}], 
            RowBox[{"A1", "/", "A0"}]}]}], ",", 
          RowBox[{
           RowBox[{"A", "[", 
            RowBox[{
            "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
            "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"A1", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"sol", "[", 
      RowBox[{"[", 
       RowBox[{"2", ",", "2"}], "]"}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Asol", "[", 
    RowBox[{
    "f0_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", "mguess_"}], 
    "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "A1"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"m", "+", "mavail"}], ")"}]}], 
            RowBox[{"A1", "/", "A0"}]}]}], ",", 
          RowBox[{
           RowBox[{"A", "[", 
            RowBox[{
            "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
            "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"A1", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{"sol", "[", 
      RowBox[{"[", 
       RowBox[{"1", ",", "2"}], "]"}], "]"}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mClusterTar", "[", 
    RowBox[{
    "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
     "mguess_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"3", " ", 
        RowBox[{"msol", "[", 
         RowBox[{"f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", "3", 
        RowBox[{"msol", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", "f1",
           ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"1", " ", "3", 
        RowBox[{"msol", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1",
           ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"0", " ", 
        RowBox[{"msol", "[", 
         RowBox[{"f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}], ")"}], "/", "8"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"mClusterTsr", "[", 
    RowBox[{
    "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
     "mguess_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"0", " ", 
        RowBox[{"msol", "[", 
         RowBox[{"f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "1", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"1", " ", "3", 
        RowBox[{"msol", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", "f1",
           ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"2", " ", "3", 
        RowBox[{"msol", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1",
           ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"msol", "[", 
         RowBox[{"f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "4", "]"}], "]"}]}], "]"}]}]}], ")"}], "/", "8"}], 
    "/", 
    RowBox[{"(", 
     RowBox[{"3", "/", "2"}], ")"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"mCluster", "[", 
     RowBox[{
     "f01_", ",", "f02_", ",", "f1_", ",", "g0_", ",", "g1_", ",", "T_", ",", 
      "mguess_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"mClusterTsr", "[", 
        RowBox[{
        "f01", ",", "f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
         "mguess"}], "]"}], "+", 
       RowBox[{"mClusterTar", "[", 
        RowBox[{
        "f01", ",", "f02", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
         "mguess"}], "]"}]}], ")"}], "/", "2"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "I", " ", "do", " ", "for", " ", "the", " ", 
    "normalization"}], " ", "*)"}], " "}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"\[CapitalDelta]A\[CapitalDelta]f", "[", 
    RowBox[{
    "f0_", ",", "f\[CapitalDelta]f_", ",", "f1_", ",", "g0_", ",", "g1_", ",",
      "T_", ",", "mguess_"}], "]"}], ":=", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"sol", "=", 
      RowBox[{"FindRoot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"mtot", "-", "m", "+", "mavail"}], ")"}]}], 
            RowBox[{
             RowBox[{"(", 
              RowBox[{"1", "-", "A1"}], ")"}], "/", 
             RowBox[{"(", 
              RowBox[{"1", "-", "A0"}], " ", ")"}]}]}], " ", "==", " ", 
           RowBox[{
            RowBox[{"m", "/", 
             RowBox[{"(", 
              RowBox[{"m", "+", "mavail"}], ")"}]}], 
            RowBox[{"A1", "/", "A0"}]}]}], ",", 
          RowBox[{
           RowBox[{"A", "[", 
            RowBox[{
            "f0", ",", "f1", ",", "g0", ",", "g1", ",", "m", ",", "T"}], 
            "]"}], "\[Equal]", "A1"}]}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"A1", ",", 
            RowBox[{"1", "/", "3"}]}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"m", ",", "mguess"}], "}"}]}], "}"}]}], "]"}]}], ";", 
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{"f\[CapitalDelta]f", ",", "f1", ",", "g0", ",", "g1", ",", 
        RowBox[{"sol", "[", 
         RowBox[{"[", 
          RowBox[{"2", ",", "2"}], "]"}], "]"}], ",", "T"}], "]"}], "-", 
      RowBox[{"sol", "[", 
       RowBox[{"[", 
        RowBox[{"1", ",", "2"}], "]"}], "]"}]}]}], ")"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"\[CapitalDelta]ACluster\[CapitalDelta]f", "[", 
     RowBox[{
     "f01_", ",", "f\[CapitalDelta]f_", ",", "f02_", ",", "f1_", ",", "g0_", 
      ",", "g1_", ",", "T_", ",", "mguess_"}], "]"}], ":=", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{"\[CapitalDelta]A\[CapitalDelta]f", "[", 
        RowBox[{
        "f01", ",", "f\[CapitalDelta]f", ",", "f1", ",", "g0", ",", "g1", ",",
          "T", ",", 
         RowBox[{"mguess", "[", 
          RowBox[{"[", "1", "]"}], "]"}]}], "]"}], "+", 
       RowBox[{"3", 
        RowBox[{"\[CapitalDelta]A\[CapitalDelta]f", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f01"}], "+", "f02"}], ")"}], "/", "3"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f\[CapitalDelta]f"}], "+", "f02"}], ")"}], "/", 
           "3"}], ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "2", "]"}], "]"}]}], "]"}]}], "+", 
       RowBox[{"3", 
        RowBox[{"\[CapitalDelta]A\[CapitalDelta]f", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"2", "f02"}], "+", "f01"}], ")"}], "/", "3"}], ",", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{"f\[CapitalDelta]f", "+", 
             RowBox[{"2", "f02"}]}], ")"}], "/", "3"}], ",", "f1", ",", "g0", 
          ",", "g1", ",", "T", ",", 
          RowBox[{"mguess", "[", 
           RowBox[{"[", "3", "]"}], "]"}]}], "]"}]}]}], ")"}], "/", "8"}]}], 
   ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", "\[IndentingNewLine]",
   "\[IndentingNewLine]"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6803782498112574`*^9, 3.6803782851545725`*^9}, {
   3.682705318069563*^9, 3.682705397772929*^9}, {3.6827054384597406`*^9, 
   3.682705464055406*^9}, {3.6827059764952*^9, 3.6827059805620832`*^9}, {
   3.6827063490942326`*^9, 3.682706370143772*^9}, {3.6827066214431663`*^9, 
   3.6827066772026787`*^9}, {3.682709935350041*^9, 3.682710102068488*^9}, {
   3.6827101791143584`*^9, 3.682710180159729*^9}, {3.682710326028117*^9, 
   3.682710373797835*^9}, {3.6827143424911423`*^9, 3.6827143766676764`*^9}, {
   3.682767065500813*^9, 3.6827670950314536`*^9}, {3.6834629288070726`*^9, 
   3.683463097416506*^9}, 3.68346334116576*^9, {3.6834959546427045`*^9, 
   3.683496020823251*^9}, {3.683496109787139*^9, 3.683496115001995*^9}, {
   3.6834961530384912`*^9, 3.683496159445272*^9}, {3.6834965478188295`*^9, 
   3.683496569117898*^9}, {3.683496600673244*^9, 3.683496641231366*^9}, {
   3.68349951217002*^9, 3.683499598475339*^9}, {3.683499948783972*^9, 
   3.6834999488679085`*^9}, {3.695470844355943*^9, 3.6954708782731547`*^9}, {
   3.6954712340220523`*^9, 3.6954713019141245`*^9}, {3.6954713638009987`*^9, 
   3.6954714335100784`*^9}, {3.6954716710623894`*^9, 
   3.6954716846977797`*^9}, {3.6959069132924075`*^9, 
   3.6959069212679253`*^9}, {3.6960659001941805`*^9, 3.6960659146689367`*^9}, 
   3.696066230459838*^9, {3.696068009856619*^9, 3.6960682405842357`*^9}, {
   3.6960690762599955`*^9, 3.69606913472832*^9}, 3.696074375863367*^9, {
   3.6960746063082347`*^9, 3.6960747318665333`*^9}, {3.696074767672621*^9, 
   3.6960747682069216`*^9}, 3.6960748531178265`*^9, {3.696074885499361*^9, 
   3.696074917387074*^9}, 3.6961466166416*^9, {3.6961473821183243`*^9, 
   3.6961473852763023`*^9}, {3.6961474210522957`*^9, 
   3.6961475296382084`*^9}, {3.696147571042222*^9, 3.696147574414231*^9}, {
   3.6961476049673643`*^9, 3.696147612875143*^9}, {3.696147685804612*^9, 
   3.696147847198661*^9}, {3.696148036241291*^9, 3.6961480451218023`*^9}, {
   3.6961483597847776`*^9, 3.6961483965487647`*^9}, {3.6961484303624315`*^9, 
   3.696148455665407*^9}, {3.696160588394356*^9, 3.6961606070520487`*^9}, {
   3.6961637238534145`*^9, 3.6961637325629373`*^9}, {3.696163771217167*^9, 
   3.6961638123142123`*^9}, 3.6961638448085003`*^9, {3.6963249677672853`*^9, 
   3.696325289044533*^9}, {3.6963253478408117`*^9, 3.69632534847921*^9}, {
   3.6964159717150345`*^9, 3.6964160197346935`*^9}, {3.6964160567810526`*^9, 
   3.6964160607211103`*^9}, {3.6964885275460973`*^9, 3.696488536659082*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.6961453659668837`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"number", "=", "5"}], ";", 
  RowBox[{"mavail", "=", "2"}], ";", 
  RowBox[{"mtot", "=", "8"}], ";", 
  RowBox[{"A0", "=", 
   RowBox[{"1", "/", "3"}]}], ";", 
  RowBox[{"T0", "=", "24"}], ";", 
  RowBox[{"f01", "=", "0.0"}], ";", 
  RowBox[{"f020", "=", "0.0"}], ";", 
  RowBox[{"f021", "=", "0.3"}], ";", 
  RowBox[{"f022", "=", "0.1"}], ";", 
  RowBox[{"f023", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "0.24"}], ";", 
  RowBox[{"g0", "=", "0.00"}], ";", 
  RowBox[{"g1", "=", "0.04"}], ";", 
  RowBox[{"Tmin", "=", 
   RowBox[{"T0", "-", 
    RowBox[{"g0", "/", "g1"}], "+", "0.1"}]}], ";", 
  RowBox[{"Tmax", "=", "42"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mg", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "]"}]}], ";", 
  RowBox[{"mg1", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "0", ",", "8", ",", "8"}], "]"}]}], ";", 
  RowBox[{"mg2", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "8", ",", "8", ",", "8"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tnorm", "=", "Tmin"}], ";", 
   RowBox[{"mavail", "=", "2"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"calculating", " ", "the", " ", "normalization"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tnorm", "=", "Tmin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mnorm", "=", 
   RowBox[{"msol", "[", 
    RowBox[{"f020", ",", "f1", ",", "g0", ",", "g1", ",", "Tnorm", ",", "4"}],
     "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Anorm", "=", 
   RowBox[{
    RowBox[{"A", "[", 
     RowBox[{
     "f023", ",", "f1", ",", "g0", ",", "g1", ",", "mnorm", ",", "Tnorm"}], 
     "]"}], "-", 
    RowBox[{"A", "[", 
     RowBox[{
     "f020", ",", "f1", ",", "g0", ",", "g1", ",", "mnorm", ",", "Tnorm"}], 
     "]"}]}]}], ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6961595383681507`*^9, 3.6961595394592705`*^9}, {
   3.696159596619074*^9, 3.6961597675596695`*^9}, {3.696159804195939*^9, 
   3.6961598591147428`*^9}, {3.6961599111625757`*^9, 3.696159961337556*^9}, {
   3.6961600095175605`*^9, 3.6961604381974916`*^9}, {3.696160475598798*^9, 
   3.696160526837951*^9}, {3.6964886224711437`*^9, 3.69648871775953*^9}, {
   3.696488756979175*^9, 3.6964887571953707`*^9}, {3.696488824981637*^9, 
   3.696488829373088*^9}, {3.6964899770450277`*^9, 3.6964900144457254`*^9}, {
   3.6965725976130066`*^9, 3.696572602318158*^9}, 3.696574137784149*^9, {
   3.6965741721716905`*^9, 3.6965742231046443`*^9}, {3.6965744005883512`*^9, 
   3.696574402041581*^9}, 3.6970177763555813`*^9, {3.704345101582159*^9, 
   3.7043451033068323`*^9}, 3.709547605132372*^9, 3.7095477212632537`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Fig", ".", " ", "4"}], "A"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{"Show", "[", 
   RowBox[{
    RowBox[{"Plot", "[", " ", 
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
        "f020", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "3", ",", 
         "0.5"}], "]"}], "/", "Anorm"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.6"}], ",", "1"}], "}"}]}], ",", 
      RowBox[{"AxesOrigin", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Tmin", ",", "0"}], "}"}]}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", "\"\<Temperature\>\"", "}"}]}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
        "f021", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "3", ",", 
         "0.5"}], "]"}], "/", "Anorm"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
        "f022", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "3", ",", 
         "8"}], "]"}], "/", "Anorm"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
    RowBox[{"Plot", "[", 
     RowBox[{
      RowBox[{
       RowBox[{"\[CapitalDelta]A", "[", 
        RowBox[{
        "f023", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "3", ",", 
         "8"}], "]"}], "/", "Anorm"}], ",", 
      RowBox[{"{", 
       RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
      RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
    RowBox[{"Graphics", "[", 
     RowBox[{"Text", "[", 
      RowBox[{"\"\<Single Receptor, with slowing down of adaptation\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"35", ",", "0.6"}], "}"}]}], "]"}], "]"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.6835014427738285`*^9, 3.683501569873051*^9}, {
   3.6835017014187574`*^9, 3.6835017930146856`*^9}, {3.68350182796502*^9, 
   3.683502069286942*^9}, {3.68350210555875*^9, 3.683502128303955*^9}, 
   3.6835043562936*^9, {3.683506835885662*^9, 3.683506840136598*^9}, {
   3.683507496517191*^9, 3.6835075239218783`*^9}, {3.6835075633700495`*^9, 
   3.6835075644167347`*^9}, {3.6835075989419837`*^9, 3.683507603751831*^9}, {
   3.6835076382501307`*^9, 3.6835076383412046`*^9}, 3.6835078641952715`*^9, {
   3.6835079019661036`*^9, 3.683507902997943*^9}, 3.6835079419174943`*^9, {
   3.683508105904919*^9, 3.6835081660063467`*^9}, {3.6835082016532106`*^9, 
   3.6835082317182617`*^9}, {3.6835082645706606`*^9, 
   3.6835082729144893`*^9}, {3.683509623938531*^9, 3.68350964759626*^9}, {
   3.683509741859211*^9, 3.6835097440156264`*^9}, {3.6835098090191135`*^9, 
   3.683509812652262*^9}, {3.6835098720660515`*^9, 3.6835098810502386`*^9}, {
   3.683509943912233*^9, 3.6835099498609195`*^9}, {3.68351002239785*^9, 
   3.6835100225585575`*^9}, {3.683510266607168*^9, 3.6835103237031174`*^9}, {
   3.683510357498146*^9, 3.6835104666438084`*^9}, {3.683594360466648*^9, 
   3.683594386334036*^9}, {3.6835944469598427`*^9, 3.683594476007958*^9}, {
   3.683594528928777*^9, 3.6835945323589334`*^9}, 3.683594658565593*^9, {
   3.6835949947323203`*^9, 3.683594995771978*^9}, {3.6835950891302958`*^9, 
   3.6835951009613233`*^9}, {3.683595523784546*^9, 3.6835955296352396`*^9}, {
   3.683595694698431*^9, 3.6835956987264657`*^9}, {3.6835958680522523`*^9, 
   3.683595873615878*^9}, {3.6835961563052807`*^9, 3.6835961563625336`*^9}, {
   3.6835972533967648`*^9, 3.683597263072562*^9}, {3.6835973317759676`*^9, 
   3.6835973367713346`*^9}, {3.683597818732327*^9, 3.683597823129239*^9}, {
   3.6835981353249846`*^9, 3.6835981388875756`*^9}, {3.6835985579790964`*^9, 
   3.6835985632262297`*^9}, {3.683598665161738*^9, 3.683598669552127*^9}, {
   3.683598780692557*^9, 3.6835987852156963`*^9}, {3.6836299957565374`*^9, 
   3.683630001220872*^9}, {3.6836300385218463`*^9, 3.683630042588726*^9}, {
   3.683630401963069*^9, 3.683630404973195*^9}, 3.683633606944186*^9, {
   3.683633658927637*^9, 3.683633681398108*^9}, {3.683633719324916*^9, 
   3.6836337193738155`*^9}, 3.6836337494042397`*^9, {3.6836337843559885`*^9, 
   3.683633787498341*^9}, {3.6836344074201365`*^9, 3.683634407616298*^9}, {
   3.683634439988351*^9, 3.6836344427119017`*^9}, {3.683634478047845*^9, 
   3.6836345482108173`*^9}, {3.68363458223936*^9, 3.6836345825185757`*^9}, {
   3.6836348284237537`*^9, 3.68363483170503*^9}, {3.683635000401408*^9, 
   3.6836350035712023`*^9}, {3.683635109247984*^9, 3.683635112732794*^9}, {
   3.683635933922764*^9, 3.6836359376777506`*^9}, {3.6836361354337826`*^9, 
   3.6836361808510447`*^9}, {3.6836368048385525`*^9, 3.683636846278961*^9}, {
   3.6836369120845222`*^9, 3.6836369220459337`*^9}, 3.683637185370449*^9, {
   3.68433655544131*^9, 3.6843366513951063`*^9}, 3.684337190686813*^9, {
   3.6843373447367773`*^9, 3.684337373949052*^9}, {3.6843374150053673`*^9, 
   3.6843374590750957`*^9}, {3.6843374959908953`*^9, 3.6843375199838552`*^9}, 
   3.6843401328627005`*^9, {3.684340435390169*^9, 3.6843404443950357`*^9}, {
   3.684340492327779*^9, 3.684340557246831*^9}, {3.684340662031311*^9, 
   3.684340722781742*^9}, 3.6843407630708404`*^9, 3.68434082512884*^9, {
   3.684342993707099*^9, 3.6843430038158245`*^9}, 3.68434304512975*^9, {
   3.6843430761929836`*^9, 3.684343136572733*^9}, {3.695472245727811*^9, 
   3.6954722977836137`*^9}, {3.695734720050849*^9, 3.6957347621132264`*^9}, 
   3.6959073045317426`*^9, 3.6959073454383335`*^9, {3.695964558314753*^9, 
   3.695964571272908*^9}, 3.6959646034315434`*^9, {3.695964639737603*^9, 
   3.6959646400382805`*^9}, {3.6959646707074194`*^9, 
   3.6959646708383374`*^9}, {3.696071037136807*^9, 3.696071052836323*^9}, {
   3.696071242819821*^9, 3.6960712702465205`*^9}, {3.696072315102068*^9, 
   3.696072321966756*^9}, {3.6960740096265297`*^9, 3.696074045973341*^9}, {
   3.696074100303479*^9, 3.6960741207519836`*^9}, {3.696074188656378*^9, 
   3.696074190676506*^9}, {3.6960745593018546`*^9, 3.696074575498434*^9}, 
   3.6961406863899937`*^9, {3.696140993883959*^9, 3.696140996565113*^9}, {
   3.6961451470661793`*^9, 3.6961451535704875`*^9}, {3.696146273439144*^9, 
   3.696146288838646*^9}, {3.696330804116786*^9, 3.696330813757516*^9}, {
   3.696330982401066*^9, 3.6963309893803234`*^9}, {3.6963310227235594`*^9, 
   3.6963310278693714`*^9}, {3.6963310676411695`*^9, 
   3.6963310921345525`*^9}, {3.6963311950395737`*^9, 3.6963312361561565`*^9}, 
   3.696331316768264*^9, {3.6964879216668158`*^9, 3.696487934183776*^9}, {
   3.696574271860086*^9, 3.6965742860676937`*^9}, 3.6965743447276673`*^9, {
   3.709547740263053*^9, 3.7095477694449267`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwdxwk4VYsaxnGEKBkOKVcdRClUCt21dvR99l6hUoZKKVOi3ETdpA4ds8rU
NZQhqXYSkkpZ5plkm4nQjtoy7ZIplGS43fs+z/95n5+K4zlLZyEBAYHrv/vf
069WCFRtJFDg/xuHZREPt8prE3jB3q2912cM1IMjymKMCPzr73iz4oURSJcN
D5k1JvB13TvLiKER0HgYauG4h8Cc7uhmj5YR2FJ5rW+bKYEr6AuBockjsEMg
YGmrBYGvPEfYrcYjQP3taSZlS6D84Hb8GPcVHC7afQz3IDAgvldHzHgYLEuK
h2U8CTzXUeivtm0YKFHFmfhLBFps0su0URyGjQmd0ileBOYPZVsrj3+B8SJz
ZrEfgfFru75/S/wC/ktYj76GE+hVltr5YvozsGPUXfenELi1NO0it5QPMe+v
Xm57RKCogGIEK5MPwWr9QdZpBLaVf1Wqvs0Hl1x2knMGgUEG/v+U8eSDNleh
ySeLwBt8kSu1WnwoV5HY9qyYwNCbh14msYeAlzX+XfItgQ43m3R4CYPQ38PU
uNJBYEbNiRvrwgaBvyzWdqiTQN2VhfGXrgzCuBP5qoxL4AxP+PBBu0EQUAiM
Ps8jsGdG6Fa32iAoB8hqvRkmkHBtiFmVMwAOFjtOxAqReKdyLjigtx+cfENu
CQqTuMZq9TynvR9cnnBr3ERIjJ7yllXi9MN5Eb8tRmIkPp5KqPj+rB/8C2p+
fV9BYlnehXwLn35gq1jHHVUg8e4JP62Ha/rh48SVekVtEicdH8qpOfdB+dTA
O/9tJKqwa4b3H+sD9g8z/sB2Ep25pXZBZn3gMK8qkqVHYrLt/TZpRh/wxBp2
UTtJBI9qJVrqt5XWvDxrRGLqRre2FSWfgLe/OKHEhsSwVpmW+0qfoNx8Q9o6
OxJVXcTn18p/AvbBqJzr9iR+myp4+0jiEzhYO72xcCSxYmza8s3PXuA5SUgM
nibxpUT7QlL7b1+x8ZP0INHxQ+vlkfBe6H0852wfSiLzRZzVOsFe2H7qdd6n
MBJvqx5cvnSGB4HrosRPRZB4bEJvz/QoD9bdUX16NpJEwb5A9dFuHpyM2Dvl
FUvi0wKvAbMCHgy4JwTeekCi3BbVizUePPiso3u/toDERrHlfx398BEmSly7
dL6Q6C1XMOw72wOH7DZZ3B0msXvK10Z/pAdyFwZrRUdIfL5+2kWE1wPe4Fj0
bozE0iPdCoXVPSBUcfSe3zSJ3DtbWJnRPSD3ardTvQADOZxu/TTNHiDqlMYd
VzFQ4OfzBwmnu8G/o21pDMXA6qvo/3KOC5baE1UKRgysqlhsEJ/gwvowSf8H
xgz8MmC/znWAC3UGe2ay9jLwniGT3tfEBblHpfxmcwaybRtXBrG5kObxuHaF
LQO93KYVy4240CTtFx7qycCZNU+DVRLfwdp9GlIBqQy0HNnVsPlYFzR426cK
pjNwjcNJ5nvzLvDOuGUQ+JiBV+YtuyONu6BLfNE1KJOBtJ/2cUm9LojhtHGu
vmSglkldir10F4ga+QSGlTLwLI5FmHI6YRRbpm92MLBxOkJd0aATSndc6k4V
3YlXD1l+EyM7oGdD0Skrh53oGjYnzYpoh2Ueo5y4ip1o9B9jH/XFN5BT9Q++
wxp9NJLPyzUsawWncP3GE576+E7r6CRmtoDKc9Owybf6GJTBP9C1txlsOg8L
S2kbIIOd2zsU3wipx/dbFUUboLOeqajKZD1MWjHc700YIGcs49mZgDootVJm
Ld+3Cz1VO4LS99RCwsupMbHMXWgzVHspXJ4D439UWkeJAiZMNVXrytSAVbPP
nXQXQDX3SyukJF9DudDWhz84gG118dsn1arh4N2vOi4yiN/uC6ob2byCA0OE
0Fom4vMeaBiLqYKQbMHncecQ048uuET3VwK1s7pUMwnxlt7kaendlbB0wo8R
2oC4+k9bs8iHFSC+Ke/Wk5+ILCLf/oF8BfwROXAsTsMQJ9hdFSHXy+FulmRw
0jFD3B2bODG0pBxOH6LDT183ROVkHH2sXAbEBovF2TxDjDUmmg/rloKJ9xmL
gwOGWCi6da+sUwlwQ31Fa2SYuErRgRGZXAweNaHqS5hMvBxvejDqfRHsuy6j
LnyOiXB2g6ubZhFoeEbFNN5non6aE3vlpUIwGQjvPt7IxD0HOioU3xYAXzow
VGSWif6FzVlRuwog8sy55MsaLNS8aWXLTc4HT6N3t58dYeFFPY3UTavz4aQ5
Y/5pCAtTAibck0Ly4M3KuCpOPgtlhYcSlwvlgb+tu0v6AAuDg/fFdYTmwo42
Ay9zeQotA4jZUYlc0KwPdSlhUeglqSn2590ceODbUrj7PIUCIhVvC3RyQMlB
0iuOTSFllDbcUU1DdxVnZWYjhfUnJJ3hJA1dds7Onk0UxghVekeeoKH9p2DO
rmYKM0Sluj7a09Cwdeeh1hYKQ6c2/yvAhoaiO09jvrdROPD4Rl/NYRoSPWKk
DLkUZqke2+RoQoO1qo14xyCFBUeu+dZvpuFQ6czR+0MUWqTsd1bTosHcOjbd
hU9hpLpftI8GDSaRTca/PlOYeba7QFudBuIXXlMeoXCrU7JJojINq9vWL3Gd
pHCWH2DmLUuDnHulpe4UhXEmU8GdMjRIi9snz/+2dkvFgq40DWKQYBj1nUJ3
C82ycQkafmQs88/5SaE/0+nfrqI0fNud1uw7S2Fj5/uaOmEaRnksJZNfFMqt
3eSosYSGQXmfUu4chXmnhBy/LGbDpxcKkinzFCodcKvZu5ANH0xzbd0WKDTK
dD3/ZC4buEOWT3csUlgjNGIj8SsbOgLH5hZ/O66dF+H2Mxv+C30bAWo=
       
       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkGs4lAkYQBtJUUsJrbDGztZsqmcU6ZthzDszX2WTiuTeUJKJol3UtpXQ
hWm0StuU9LknuZdbzMNbtNHKyCplligrXadEriNrf5znPOfvsdgV5hqoMWPG
DOdp/rfqQnVasjEBe+qClvUGKPAAo0pMMyFgnzqmvsVTgZ9vVa7aa0qAuQtj
T42zAr+0ltUT5gRIMyaGU9YqUK1X3P/0BwLuq+elBc1VoE5CFsvIigD2xlNh
wtJmZJ5MwKT1BJj0PKv01mxG/whRtzScAAHd0Pq7oibsKfk0rPuEAN6bfGbe
aCN2DxxpMrFiQ8TpX5/Tqu7jixvqQD8JG4Rr6RZHH9zDgZqQZ9Zv2aDfOjjS
N1yH0e1ts5NIDhgc7/nw17G7aOZkqReTw4G9TaePECZ3sNb2YGeOlh0c3ObK
2q2swa6l8j3u/nZgqhltSnsvR51wVaPsrh1ccu/N4i6sxvL6xa/9Te0hb8SO
xU64jbul9s07I+3Bb1HgyllrKtGieNOZwSf2QKh87hj2l6Pv0+2aelZcSLoX
035GUYY5Ps7u8vNcKBUmpCfLS3HQnROaOsAFv8lSK2i4hbXudOFcJwegJceK
+CM38fKtoY9zChzgS5uluODHm/hJv87rnBYPDEXhJ1MOlaB7y7GUXDEPzpuN
Oz06W4x3NFhZI408uFfE/cZgcxFuo95bixcAVO04Iz3MLsTN/YSGmQDgg+zs
iZrvCzC+lFYsCwOYp34g2mWVj6Tdn7XLrwKkCaumVC55OHvgOEfyEIC6WESN
h91A7WWVf+SPAdjUrXHg5uWifmKft8ySD6la1XxVz3WkSnRPXvXmQ1Y3bcsm
5nUMciuTBsXxgdWyRDx0IgeJpS5T45V8MKh4X5LaeQ0dfwt22dbHh9GNT/J7
Ha+hUhKl1bBAAK7E8aOBmI3hDRLmTIEAMi3pZk2rstEpbgFTM0wAo4pe5oay
LLSMPJfUnCYAnedfJS9WZ6Fjn7TTp1kAi9hb3nZjJr6eHyuZNS6AS9csGDZu
mZgYHJZ5yFIIsU68rsp/MzByfUdykYcQhNohbq4xGRiwlTNZGC+EuGL/CM/F
Gfi3oay+8bYQ9v2UV1hdlY7RO0LFuX1CGPQvE3sHpKNtG/fwViMSphI7yuO1
03F5k0RcIyTBuCXgBuOXNMyIelS97gAJZ432cn2VqWjur3tYlk7CiX9MD2nY
p2JnfaNhQTMJc3I6ujoKKXwmCgyMVJDAkK14F5xP4eMxWrlDCwkVb9aL1LkU
PmTZubU+ImGMExpJz6ZQnlKYNNxGAk/Vunv/FQqvhCfp8ZUk0FO9Vi+Oo9CL
4avd/ooE+cKQrlp/Ct1qRz3T+klgaZpH+Ioo3Op1MVf8moR3cb/vH/eh0DFR
sWHiDQlRLyF+rQeFxAScpn8goTPC07vCmcJv25bMDBkk4ev2ZN/7HAoNQutc
bYZImLezf2EwQeF8bb/MyelWyg+u0LWlcA7vMv/cMAkWDRPRHqsoHMnTiS4f
I+HnlfrlKiaFn9ddb4kaJ6FwQ1f4xSUUqnqE5o4TJAx7sC7YMyh8ZXSsVqkm
IV0xd1D6HYUvbxrrZk9O/xoNsrYxpfD5pood+7+SMJSraus0plDZ71poO0WC
1cP4x6cWUdge+1E9Nd1EgPkaliGF/wEWUWT4
       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkns41AkXx2URct90t6I7W0Rm/X6Dc2bmRzbZkIQUya2rykubCikJXZiN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       "]]}}, {}, {}}, {{{}, {}, 
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1nk4VVsUAHAzFaKBKE9UlAZD5d19iIVLigrJo4SkiJKXKAmXF0IemSIK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       
       "]]}}, {}, {}}, 
   InsetBox["\<\"Single Receptor, with slowing down of adaptation\"\>", \
{35, 0.6}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{24.1, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {
     FormBox["\"Temperature\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{24.1, 41.99999963469388}, {-0.6, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.684343095202218*^9, 3.6843431406516323`*^9, 3.691333592147726*^9, 
   3.6914289913046017`*^9, 3.6914297545871754`*^9, 3.69142992870963*^9, 
   3.6954702890236025`*^9, 3.695472271717758*^9, {3.6957254274698906`*^9, 
   3.695725444999177*^9}, 3.695734104619454*^9, {3.695734715317174*^9, 
   3.6957347934540763`*^9}, 3.6959052644514294`*^9, 3.6959073515390825`*^9, {
   3.695964498740551*^9, 3.695964516383277*^9}, {3.695964560544012*^9, 
   3.695964573041044*^9}, 3.6959646050951242`*^9, 3.695964641940031*^9, 
   3.6959646726844997`*^9, 3.69606359972081*^9, 3.6960636471547146`*^9, 
   3.696063748031866*^9, 3.6960709620445127`*^9, 3.6960710154615197`*^9, {
   3.696071056878344*^9, 3.696071074823805*^9}, 3.696071112559358*^9, {
   3.696071244855031*^9, 3.6960712718190126`*^9}, 3.696071875100865*^9, 
   3.6960719896256213`*^9, 3.6960720522908106`*^9, {3.6960720954143095`*^9, 
   3.69607214921235*^9}, 3.696072243164256*^9, {3.69607227942291*^9, 
   3.69607232388818*^9}, 3.696072772087146*^9, {3.696074037080409*^9, 
   3.6960740478794427`*^9}, {3.6960741031204348`*^9, 3.696074122613122*^9}, 
   3.6960741925370836`*^9, {3.6960745614599023`*^9, 3.6960745775232973`*^9}, {
   3.69614066994611*^9, 3.6961406885601096`*^9}, 3.6961410012788715`*^9, {
   3.6961451584336762`*^9, 3.6961451731873937`*^9}, 3.6961454187751985`*^9, 
   3.696145865084695*^9, 3.696146229051596*^9, 3.696146292082163*^9, 
   3.696159268833627*^9, 3.696166580701759*^9, 3.696172818835393*^9, {
   3.6961861741972265`*^9, 3.696186194081176*^9}, 3.696330692396529*^9, 
   3.6963307239032874`*^9, 3.696330758814691*^9, 3.6963308159042*^9, 
   3.6963309923379364`*^9, 3.6963310300727305`*^9, 3.69633109369816*^9, {
   3.696331203905567*^9, 3.6963312381013575`*^9}, 3.6963313190012565`*^9, 
   3.6964118183958454`*^9, 3.6964872075338125`*^9, 3.6964872687083797`*^9, 
   3.6964873689655933`*^9, 3.6964874232738414`*^9, {3.69648783770794*^9, 
   3.6964878533439407`*^9}, {3.6964878838030157`*^9, 3.696487906271001*^9}, 
   3.6964879378874874`*^9, {3.696487976188324*^9, 3.696487997461481*^9}, 
   3.696572495648219*^9, 3.6965740739144945`*^9, 3.696574146161449*^9, {
   3.6965741797872934`*^9, 3.6965742321151147`*^9}, {3.696574274642383*^9, 
   3.696574346457137*^9}, 3.6965744067872925`*^9, 3.696760754419715*^9, 
   3.6970177979922194`*^9, 3.704344944499889*^9, 3.704345009768714*^9, 
   3.704345042716315*^9, {3.704345092981292*^9, 3.704345108630142*^9}, 
   3.706597049842003*^9, {3.706598149526887*^9, 3.7065981676480627`*^9}, 
   3.7067620166449566`*^9, 3.7067621357376747`*^9, 3.7067641776420803`*^9, 
   3.7084930262842517`*^9, {3.709547594930146*^9, 3.7095476233323917`*^9}, 
   3.7095477047862177`*^9, 3.7095477702576084`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Now", " ", "show", " ", "methylation", " ", "levels"}], ",", " ", 
    RowBox[{
     RowBox[{"Figure", " ", "4"}], "-", 
     RowBox[{"Figure", " ", "Supplement", " ", "1", "A"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", 
    RowBox[{
     RowBox[{"Plot", "[", " ", 
      RowBox[{
       RowBox[{"msol", "[", 
        RowBox[{
        "f020", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "0.5"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"0", ",", "8"}], "}"}]}], ",", 
       RowBox[{"AxesOrigin", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Tmin", ",", "0"}], "}"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", "Automatic"}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<Temperature\>\"", ",", "\"\<Methylation\>\""}], "}"}]}],
        ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"msol", "[", 
        RowBox[{
        "f021", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "0.5"}], 
        "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"msol", "[", 
        RowBox[{"f022", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "8"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
     RowBox[{"Plot", "[", 
      RowBox[{
       RowBox[{"msol", "[", 
        RowBox[{"f023", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "8"}],
         "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<Methylation levels - single receptor\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"Graphics", "[", 
      RowBox[{"Text", "[", 
       RowBox[{"\"\<with slowing down of adaptation\>\"", ",", 
        RowBox[{"{", 
         RowBox[{"35", ",", "2"}], "}"}]}], "]"}], "]"}]}], "]"}], 
   "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{
  3.684261397151025*^9, {3.6954709414832335`*^9, 3.695471050961542*^9}, {
   3.6954723118344603`*^9, 3.69547233031421*^9}, {3.6959648722673163`*^9, 
   3.6959648750834827`*^9}, {3.6964117603240123`*^9, 3.696411782966482*^9}, {
   3.696411914456359*^9, 3.6964119571018047`*^9}, {3.6964119876089444`*^9, 
   3.696412040227379*^9}, 3.696415485901184*^9, {3.6964883404427223`*^9, 
   3.696488358586337*^9}, {3.6965745204736857`*^9, 3.696574608527624*^9}, {
   3.7095479359609766`*^9, 3.709547987606793*^9}, {3.709548683136944*^9, 
   3.7095487349008713`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xk0lokXB3D7zrvwPpMiSVRmioZ4nufF+/V6qBEzSEoIWTKJTDJaRqQa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       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVzns01HkABXBkJ2x5VDrfmakkS9t0ilQahpk7Mz9lE0uhF1FrNHQ8dser
h1mqXU0UqSZSzLLbS9J6NMU22dRhN5ImppX0nGhthBCx9rd/3HPP5597ru2O
2PUSIwMDAx86/3fv8erCPCYXd7drV678hY04uxtSQzYXHzgDX6mK2RgoVy+L
nMOFSWOe6bQiNoZaKuu4NlyMaB8e0RewMW5R1qX7gguVVfYNVS4bZpnFjrOd
uHDwOTyTm8nGwoOZt3JWc2FX4GjUK2MjLH7bswwZFzbnoxYoPNl4fvX9sHkr
F9PDYl9/2cPCs/6999hOrggUZFS8KWLhxcVxSajCFa3yPyOdI1jov7nr8fK/
XSEb5m0wWcpCapt2ag7lhvQ16jmrDFmY682xSDvnBmOd0ihZx4TGJbHjHIMH
xv07Ck4lE08daiKCwnjw5tmaRZ9iwkzW26D8nQe/V8knzfcxUVXH6g6b444g
H7NJuYSJ8Az3pu0J7nDJ1f6m8WfCtmzd4cFWd/Sk1Ncc4zMRrAs0tnDywEnv
GtuUpUyc2+oTVHPMA1/nFbTVzmNiMMgtpqDfAxUkWf6HJf0naL74c28+QpIu
bXxrzERu+Yc+k8t8VBy4Wjh/lOD9jNubsxkC7Gx5O2HSRxDUnJJ/QSpAXiB/
z8fXBLVGjsUjDQIkGi7q6HxCsOHsP8ulVsCQk/tRg0cEvl1co7kiwLd6VsnM
RoJDFYZlylhgcF6yj9NdAop3V7P4DFCyzjmwU0Mwtf97N0Uj4BdhLZVdJzBd
pD5RMgpYLX01ra2cYEaWfouSI8Qe/pMFNqUEZ6+aHzyzRYgV4ZVJ7ecJdgZU
ZuxMFyLJJHR8VTEB18F/ckwthPx0tCa5gMBrT5T/Br0QDnELLL1OE7Qr5Ix6
KxGM5412blcSyOoVC6eIRBj6t288JIfAO91qoXGsCKIT9obNRwk4Cdk5TYUi
pN3oHrbLoPf0GR1bm0TocdLJXqQTdFvuV3w2JkJeWyv/0UGCrKjYoiSOGJbs
43ElaQQJq//Ku7JRDPvvoiLa5QTf+LlNlB4SI3h6VXzfXoKH1sq6hutijEyq
yp13E6SGxEgv6MXoXaUQ1iYSuGg9dvvNpuA5dOvliniCxfcU0ptiCrLw0PB3
3xL8JH9Q7RlH4SJDzqqPJbAJM9+tVFFQ6ZuMFdEEHXUN1pebKDCOZF/8YRfB
420SScJ9Cplja3X7aD8aNaziN1MIaElkxNNudOQFtDyg4OdvG7mDdk1+ac6w
lkJ4rVogoH1almMhbKewRp+/bDSKYLNdsGnbGwpqhdY+hnaA5uOmwi4Kh0Tm
aRLafptPXpB2U/D1L3saTNsr6/6aT28p3LG2y/emzf2EH+e/o3Cqrt5hEW2i
tZ+ya5CC66bq1NeRBLNibq9f8YFClYHzwBPalqahRRO0HxaaSbS0TQS5wuxh
Crrop763aY9cMkutGqWQZmSwXEV7wPN8s3yMwiWSWHaKdu9zsY3XJwrTU9cu
yaL9ZnaKpn2cQmv/tCVy2i9/ZZr/PEHBLmDsSgLtznXXQqL/pXBATTlH027v
Wl/qMkmB09BzLZx22/6+8UnaMc597sG0/wM5VBLt
       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0Hk4VfsaB3CRqcGw99p7nZKL3FREosFau813b4ucDFdSxy4hbUMRTlKn
esTVZBsiOa4MIU2KpJPTgH0qGXYZKtnFUTpOhmZuISR33T9+z+/5PO/7fH/v
7zUJjPQKUlVRUdnLnv/fay1KvgWpU1BVU3Hc48FB6OXOhp2sI3TUFamso9Tj
rJy1KORXeHD0fuIg/lbDxMhsCszTqti6EA4KTSRZPnMoYEXuB5VEDrqHDjw0
sKZQ4fJiusF9Du586e2IX0ah8JfZj/Ia2P7Rfw302lC4nJNXNuchBwGTpupX
V1AIbWlWTH/CwSutJntGQCHKVHmuqJu10bxr4c4UZFankr+PsXavzq7xpeBb
5VF92IKLO55mF+b7UUj1NrE4YMVF4fr0ymP+FFw9jjzYuYyLAIn0ybpACvJ3
f95cs4qLV9JZs/pCKBx6c8S4Vcz6gG+cTjQFZYC+k42Ei7/YdfjLKLw7a3xh
7yEubILrb/QkUSh3DKDsjnKRMD9dOziFgoPsrHg4kYv5uaZl4WkUXk+NtkuP
c7EtZe2Xfb9SkI6oyuee4qI3Ijshs4iCccNxt/4yLt7YLi9Q3KKgWTPSbdnO
BT04OehWRaG/aMkx2TMukkobxI+qKQT986i0p4ML8wWb+5R/UNim2tae/JKL
MH6C5es6CpduRhvK+7n48LW16vtjdv95ksizY1wM1YQ9t33L+tySDf8xIODt
t3hd/jsK+5lCZZwhgd+/9yk0PlCoGjosDTYisN8hsKrjE4UrZl0VlqYEVO/6
nI4bpsD7Nhx8zpwAcd9J+lCFRmT7PxoFFAG7B0aDgSRrquI0uYFAvLJNM4Oh
cbcm4WcikYCX9VDtHGca7Svqq6/LCCxI0okvWkOjnijetT6ZwAPhj1+vrqUx
vDZvYcpxNv+cfKDVk4Zq6aXRt5kELkSXKGZvofG3tZF5QBGBFr24ZFkMDbt4
g7pVtwgYuprr/vs8DU2l/WmNXgJN+/3PT7tIQ8N6Ksm1j/3PpUxhQgmNkEG1
oLR+As+1p8IOldLYYLm9j/uWQEZjW+ORazToSRUnvU8ENJxjE5LkNMj6orxn
Xwl8xKPhk0oaq5N8c0pm8iBfuafrvIYAu+Hmk2vFw8G1BTmztQQ4vfXGhpNL
eXDwa/TZrS2A11hgcZI1D3eOzG0XzRLgQnqMzV4bHu49lTd36QtQcd1kuctK
Hup3af7BMRRA/UBv8AMhDy1XsosO2gqQN+Hu7+3GwwuzquCNAQIsCu5eeSaE
hxnRHxuz7gqwp2N47p+5PFTWzh0ImLcaJfm38lLqeJAmr27eGrMa3T0nzyx4
w4NJuVvS53a2rr/s0NgMPnyfbZiuay1ESqLNpadmfJzf7L6x6oQQO3TGBaUi
Pj5vpCNODwkRmLyIZynhQ77R2HGmqz0qXQ6nDIbzkX3tyyetUnvM69It8I3n
Y5BzT5Ku4YAfFEaVnel8bGyNzb0Y6gBpRkOlZREfd1SXFo82OkBrcVyWspyP
9fnvbUP1Aesr2S1R1Xx49NupGoqBnpywYn0FH4m/TSvPigTcR8I8v7fxwQjq
5BZ5wPxIscn4Cz40h+JoWRNAie7/xh3gQ3vxjczLY4BZglK3Z5APTlrvpixz
EUzfZQY/HuMj/6rO4bxNImQuNpzQVCUR4n09OeSYCEX3PqsKtUnYma2bGr8h
QuoV3qYcPRIu+3esW98rQs0Jr/d8kkSn7KBGg74Yb//6RWhoSCK6QbZQTSzG
1ffyVA9TEq7H9BdOjxQjemaqjWIRCfOY9IzmAjFKdK7eD7di83qTuzY3i/G6
e6R2py2JAb0Emfq4GIk1Qn8DOxJpOyLP7DV3RNBtpmpoNYkY545TV35yxK7i
/lCISGzzpCfLEh3h7HwoqtKJxBNeVm3jTUeE0yr1PT+SiN8SEXqx1xEmjUpF
vjuJlW3CfZ58Bq5ft7+JXUfC4qEstMaRAfH3qtfD3iSKDj667RTFgGevdY32
IWEUoLMvq5BBX1OiVvFmEl21jbzSZgahrntPVviReO4XFBTTwkBQvnVUzvrp
2LRK+1YGAz/rS5pYNy0VeD9+xOC9Ry2vn3VVblnGSBsD94m43fP8SeREZ+iK
OhloGHU0HGUtMfXVVvYxaPr2SiEJIOEt/+pT0M/ANCSxP5i1p+TXi6EDDMbL
NdR2s3ZJa1kz8YaB7rQk2+Os7SZw1PgD+96J2/vvsf6hbYFa2GcGYil9xnwr
CSLintfyLwy2p6blr2Ktp+1/ZpL1Ir37WQxrLYdsUfoIA0NBc4If69FLM+Ir
xxgMKiJEGaz/63Sh9eA4AxNps0UB64+vHI1cJth5D+sSpaz7+LHyzm8Mbobj
ZR3rnoo5OmcnGZgJre88Yf3S7fctO78z2HpevbCbdWe/V9nKKQYnltyNfc9a
mfDp2xTr6+u3ScZY/w9MjzGF
       "]]}}, {}, {}}, {{{}, {}, 
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVz2s0lAkAxnFENeq4tKj3nYs6ojXtZqaLxnWemXkrpTZhlQilQRem04yV
LEZ00TgHU2yJVFpNYitFFzHiOOYkuihKKltH2mqHSVGu++6H5/zP7+Mzb5vM
X2piZGS0jt7/1R+7XXySECA8QeRufpeDPQ63YoyZAgTUWzHC6jn4XHmDv4Ml
gF74p/qqloOvj643CuwFGPShOjbWcTBmebmvc74A0vmKuWdrODDPKnGx4wnA
3sS951TNwYKMLK16pQAa29qWiTIOIhRhr1VyAchTnbN7j3HQc2VgyOKpACzF
s1xpGAevDUktTJ4bXi7qdLzzIwd/XxyThme6QcpI+bjTwIahdtezJR/cUKIV
b4m7xoayo32amnLHupEnns372GD7ci3TSt3BT9JvT3Jjo871t+7SqR5QB8vs
CsdYeOlUExUU4YHo9DX9F5tYMJfrdfl3PRBe9XNscRYLVY3k+wiWJ2avd22z
2szCdpVn69Z4T/pHpPKnhSzMu7z26OBTT0wLGUHAKBOhnb+aWvK8UOZs8iLx
EROlIeuCanK9wNlmWznzAhODQe5xpw1e6G/YmrZcyURd0FzJDF9vzFbu1oSG
MXGi8kv/9HJvtI1xnpt7MjEwqyE4Z6oQht/L7xAcJoIeJJ/SxAiR48g63DBJ
ot7EpWRYJ8TpOczT+rckAoo+LYmxBoSzVvLzWkj80icwYYuBl9UpFfcrSRy5
Znw5XwZEXx21tSwiQXk01S0sBP4oWsb7coTENEOqe+Z9QNOQs2S7ggTD+cbx
S9+BS8d3GK/eRmJWdu/mfK4IRqk937TrSRRdscgo3CyCcqBwItebRHTgdVX0
YRH4ehujSBcSAqcNkyM3RCj/IdK2yZ6Ez/6dGwJ6RZjwHivRW5PoykyZ2mwt
Rq7y92VTzEjImzMXTBGLEaY7e7NsmIDvYesFpjIxBMwkRttHAtz4HHVrsRh9
fgMZqtcEfHpV3SGtYnTy9qUXPyHw3upAptmIGGlFAfKIewSyd8rOJXAluPnN
0UGrJRC/8vnJvzZKENJ0bD+qCUT6uY9XHJGA+27SNKqcwGPb/EbdTQmck7LT
HUoIKLfExWh6JcizzFv6vICAa7tXop8dhSCFOnC5msDClsyYWgkFGVnBTjxK
4GzKw9sr9lBYEy9PcU4nYB9hkZh/hkJA/PmqQ0kEuht1tuWtFOYddzApUxB4
FiaVxrdROBge+0lF+8l34yrvBxQUBWkvYmnfd/EIfPSQQsErUx2fds2pCvVQ
OwUuf2PXLTmBArnaUtRFIVvDe3tvL4Fgh1BGxzsKfuZDyQN7CATWfdtU3EdB
ZxM1+Zi2X3CeJuY9hd2Lkw9W0fbJbls1+g+FRf6FxftpC0ZxaO6/FKRvUmeY
0Z7T7jhl1yCFvX4f60kZAZu4Bv+lXyjskPhmjccRsGKEnxunLWSKQntoTxee
EOUMUdjg9oFRSnu4zFxZ9Z3ClVSbQj7tzysuPEgZofC1zyzLhra+R2LvM0ph
Zm2GcjiWwDu75LquMQraBKeEWtpvrhIW58cp8CSrEs/QfrW2ekvsBAVylSE1
nXZXn3+F6ySFxQkOqijaHQf6xyZpJzd3F6ym/R/2xhHX
       "]]}}, {}, {}}, 
   InsetBox["\<\"Methylation levels - single receptor\"\>", {35, 3}], 
   InsetBox["\<\"with slowing down of adaptation\"\>", {35, 2}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{24.1, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Methylation\"", TraditionalForm], None}, {
     FormBox["\"Temperature\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{24.1, 41.99999963469388}, {0, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.696574584294769*^9, 3.696574609462783*^9}, 
   3.697017882100314*^9, 3.7065981952073326`*^9, {3.708493087160493*^9, 
   3.708493116195725*^9}, 3.708615819233927*^9, {3.709547946840191*^9, 
   3.709547965142951*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"Now", " ", "Mixed", " ", "clusters"}], ",", "  ", 
    RowBox[{
     RowBox[{"Fig", ".", " ", "4"}], "B"}]}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"number", "=", "5"}], ";", 
    RowBox[{"mavail", "=", "2"}], ";", 
    RowBox[{"mtot", "=", "8"}], ";", 
    RowBox[{"A0", "=", 
     RowBox[{"1", "/", "3"}]}], ";", 
    RowBox[{"T0", "=", "24"}], ";", 
    RowBox[{"f01", "=", "0.0"}], ";", 
    RowBox[{"f020", "=", "0.0"}], ";", 
    RowBox[{"f021", "=", "0.2"}], ";", 
    RowBox[{"f022", "=", "0.3"}], ";", 
    RowBox[{"f023", "=", "3.0"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"f1", "=", "0.24"}], ";", 
    RowBox[{"g0", "=", "0.00"}], ";", 
    RowBox[{"g1", "=", "0.04"}], ";", 
    RowBox[{"Tmin", "=", 
     RowBox[{"T0", "-", 
      RowBox[{"g0", "/", "g1"}], "+", "0.1"}]}], ";", 
    RowBox[{"Tmax", "=", "42"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mg", "=", 
     RowBox[{"List", "[", 
      RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "]"}]}], ";", 
    RowBox[{"mg1", "=", 
     RowBox[{"List", "[", 
      RowBox[{"0", ",", "0", ",", "8", ",", "8"}], "]"}]}], ";", 
    RowBox[{"mg2", "=", 
     RowBox[{"List", "[", 
      RowBox[{"0", ",", "8", ",", "8", ",", "8"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnorm", "=", "Tmin"}], ";", 
    RowBox[{"mavail", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"calculating", " ", "the", " ", "normalization"}], " ", "*)"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Tnorm", "=", "Tmin"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"Anorm", "=", 
     RowBox[{"\[CapitalDelta]ACluster\[CapitalDelta]f", "[", 
      RowBox[{
      "f020", ",", "f023", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", 
       "Tnorm", ",", "mg"}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6825352320996284`*^9, 3.6825352863434577`*^9}, {
   3.682535317667988*^9, 3.6825353475919085`*^9}, {3.6825353809195437`*^9, 
   3.6825354148547983`*^9}, {3.682535460224168*^9, 3.6825354958848095`*^9}, {
   3.6825365611096883`*^9, 3.6825366307231355`*^9}, {3.682536670351015*^9, 
   3.682536694596828*^9}, {3.682537023193471*^9, 3.6825370625373926`*^9}, {
   3.6825371143191032`*^9, 3.6825373640135555`*^9}, {3.682537406497302*^9, 
   3.682537436572092*^9}, {3.6825374703950524`*^9, 3.682537567539488*^9}, {
   3.682537597968102*^9, 3.682537825660362*^9}, {3.682537858087181*^9, 
   3.682537860547151*^9}, {3.6825379111920753`*^9, 3.6825379443666053`*^9}, {
   3.6825380087108393`*^9, 3.682538009598631*^9}, {3.6825380995127945`*^9, 
   3.682538103772444*^9}, {3.682538163093614*^9, 3.6825382272767906`*^9}, 
   3.6825382670463514`*^9, {3.6825383028792486`*^9, 3.68253838451512*^9}, 
   3.682538464852768*^9, 3.6826847141375694`*^9, 3.6826849319448853`*^9, 
   3.6826849850152016`*^9, {3.682685059035279*^9, 3.6826851175739713`*^9}, {
   3.6826851734468136`*^9, 3.6826851845604496`*^9}, {3.6826852176624427`*^9, 
   3.6826852328159866`*^9}, {3.682685271768137*^9, 3.6826852903192434`*^9}, {
   3.682685321616153*^9, 3.6826853483751974`*^9}, {3.6826853856160846`*^9, 
   3.6826854118031693`*^9}, {3.6826855061808653`*^9, 
   3.6826855347621584`*^9}, {3.682685602681464*^9, 3.682685630464272*^9}, 
   3.6826856635049367`*^9, {3.6826857127595415`*^9, 3.682685712974677*^9}, 
   3.68268589682548*^9, {3.6826864000856266`*^9, 3.682686452804558*^9}, {
   3.6826865191587143`*^9, 3.6826865662126923`*^9}, {3.6826866357748237`*^9, 
   3.682686636438309*^9}, 3.682686724536451*^9, {3.6826868378130417`*^9, 
   3.682686907329131*^9}, {3.6826869524158335`*^9, 3.682687159473338*^9}, {
   3.68268719938052*^9, 3.6826872115568843`*^9}, {3.6826872700208116`*^9, 
   3.6826874181469536`*^9}, {3.6827064530219965`*^9, 3.682706529777432*^9}, {
   3.6827070394097805`*^9, 3.682707065130992*^9}, {3.682707136336276*^9, 
   3.682707174743582*^9}, {3.682709544189739*^9, 3.6827095598960004`*^9}, {
   3.682709615030701*^9, 3.682709617576748*^9}, {3.6827096548313255`*^9, 
   3.68270983997371*^9}, {3.6827104948771887`*^9, 3.6827105093376427`*^9}, {
   3.6827105418262005`*^9, 3.682710544194585*^9}, {3.6827131405963006`*^9, 
   3.6827131568084126`*^9}, 3.682714253744093*^9, {3.6827154154180393`*^9, 
   3.682715427414542*^9}, {3.682725949538505*^9, 3.682725954946944*^9}, {
   3.6827260410148144`*^9, 3.6827260459996347`*^9}, 3.6827266930195336`*^9, {
   3.6827267536144066`*^9, 3.682726780797901*^9}, 3.682726817730174*^9, {
   3.6827268951069026`*^9, 3.6827269195603313`*^9}, {3.682726954889087*^9, 
   3.68272698593671*^9}, 3.6827271015100546`*^9, {3.6827271409259167`*^9, 
   3.6827271582006035`*^9}, {3.6827271943130937`*^9, 3.6827271994483585`*^9}, 
   3.6827272544055505`*^9, {3.6827273481978226`*^9, 3.68272736290546*^9}, {
   3.682727413041479*^9, 3.682727426449709*^9}, {3.6827275578330173`*^9, 
   3.682727585384539*^9}, {3.682727618521365*^9, 3.682727654867692*^9}, {
   3.6827276908769865`*^9, 3.682727719405594*^9}, {3.682727795513173*^9, 
   3.682727814575512*^9}, {3.6827288120566635`*^9, 3.682728812603665*^9}, {
   3.6834633039603243`*^9, 3.6834633177606173`*^9}, {3.683463671078239*^9, 
   3.683463711113473*^9}, {3.683463750230669*^9, 3.683463861609986*^9}, {
   3.6834639050198307`*^9, 3.683463919771969*^9}, {3.6834966639903383`*^9, 
   3.683496682006337*^9}, {3.6834967170381193`*^9, 3.6834967186655397`*^9}, 
   3.683496768414067*^9, 3.6834968079584723`*^9, {3.6834968460138493`*^9, 
   3.6834968697523613`*^9}, {3.6834969020340137`*^9, 3.683496957919488*^9}, {
   3.683496989311179*^9, 3.6834970295335445`*^9}, 3.683499920390975*^9, {
   3.6835021640912104`*^9, 3.683502185335653*^9}, 3.683502224145131*^9, {
   3.6835022561376762`*^9, 3.6835022681374655`*^9}, {3.683504274972628*^9, 
   3.683504300934317*^9}, {3.6835043940256395`*^9, 3.683504426590349*^9}, {
   3.6835044791267*^9, 3.6835044800764556`*^9}, {3.683506804016662*^9, 
   3.6835068114169226`*^9}, {3.6835068886999464`*^9, 3.6835068943227034`*^9}, 
   3.6835073295069294`*^9, {3.6835073596274166`*^9, 3.683507397108658*^9}, {
   3.683508407326458*^9, 3.6835084146174326`*^9}, {3.6835105334354515`*^9, 
   3.6835105516894655`*^9}, {3.683589240414019*^9, 3.683589247363758*^9}, {
   3.6835893416136956`*^9, 3.683589344512293*^9}, {3.683589391250499*^9, 
   3.6835893932344093`*^9}, 3.6835948672900267`*^9, {3.683595203707719*^9, 
   3.6835952055708427`*^9}, {3.6835952695710173`*^9, 3.683595270531065*^9}, {
   3.6835960468745937`*^9, 3.6835960473313837`*^9}, {3.683598265149637*^9, 
   3.6835982652795286`*^9}, {3.683598332002686*^9, 3.683598334573929*^9}, {
   3.6835984237873755`*^9, 3.68359842559363*^9}, {3.6836315095008483`*^9, 
   3.683631513923896*^9}, {3.683631725170721*^9, 3.683631729299243*^9}, {
   3.6836317638130846`*^9, 3.6836317655349007`*^9}, 3.6836338267426863`*^9, 
   3.6836502882344*^9, {3.6836503499159527`*^9, 3.6836503537330117`*^9}, 
   3.6836504036628428`*^9, {3.6839068735576715`*^9, 3.683906874055438*^9}, {
   3.683915181165773*^9, 3.683915181613423*^9}, 3.68411016169005*^9, {
   3.684110226602546*^9, 3.684110230329721*^9}, {3.6841102892235217`*^9, 
   3.6841103161767807`*^9}, {3.6841762134425535`*^9, 
   3.6841762684023433`*^9}, {3.684262501095686*^9, 3.6842625034879827`*^9}, 
   3.684262642983977*^9, 3.684264686142319*^9, {3.68426471773942*^9, 
   3.6842647227528763`*^9}, {3.684265050732479*^9, 3.6842650560040846`*^9}, {
   3.6842651064390244`*^9, 3.6842651187619414`*^9}, {3.6842652078938055`*^9, 
   3.6842652113532457`*^9}, 3.684265257507209*^9, {3.684265535338214*^9, 
   3.6842655393152175`*^9}, 3.6843255268534746`*^9, {3.6843257713186626`*^9, 
   3.684325787340805*^9}, {3.6843258527772036`*^9, 3.684325940767081*^9}, {
   3.6843260158814497`*^9, 3.6843260535639744`*^9}, {3.6843262144527025`*^9, 
   3.684326243477689*^9}, {3.6843262822149787`*^9, 3.6843263094350405`*^9}, 
   3.6843263735545626`*^9, 3.6843264113536196`*^9, {3.6843264901005497`*^9, 
   3.6843264906549435`*^9}, {3.6843265455262747`*^9, 3.684326548251256*^9}, {
   3.6843266013127146`*^9, 3.684326602252088*^9}, {3.684326643049778*^9, 
   3.684326672774681*^9}, {3.684326703466401*^9, 3.684326704478752*^9}, {
   3.684326741677846*^9, 3.6843267417564073`*^9}, {3.6843268030469313`*^9, 
   3.684326804779685*^9}, {3.6843268388119307`*^9, 3.6843268407118173`*^9}, {
   3.684326897696911*^9, 3.684326899996645*^9}, {3.6843304515229907`*^9, 
   3.6843304771696615`*^9}, {3.684330766968238*^9, 3.6843307697622857`*^9}, {
   3.684330825411683*^9, 3.684330897769313*^9}, {3.684330965212263*^9, 
   3.684330981096937*^9}, {3.684331016059127*^9, 3.6843310360244904`*^9}, {
   3.6843331848211436`*^9, 3.684333254447751*^9}, {3.684333290128461*^9, 
   3.68433329123965*^9}, {3.6843334972138386`*^9, 3.6843335470133924`*^9}, {
   3.6843335871029534`*^9, 3.6843336224903784`*^9}, {3.684333669431011*^9, 
   3.6843336714919744`*^9}, 3.684333710722498*^9, {3.6843337548674593`*^9, 
   3.684333764657854*^9}, {3.68433382196092*^9, 3.684333824182129*^9}, {
   3.684333888674942*^9, 3.6843338887942066`*^9}, {3.6843339247938304`*^9, 
   3.684333927948724*^9}, {3.6843339628506722`*^9, 3.684333967648592*^9}, {
   3.6843340232783046`*^9, 3.684334025521907*^9}, {3.684334070234514*^9, 
   3.684334073049552*^9}, {3.6843341144103465`*^9, 3.6843341178002024`*^9}, {
   3.6843341524801817`*^9, 3.6843341525366993`*^9}, {3.6843341874036956`*^9, 
   3.684334196474905*^9}, {3.6843342442404203`*^9, 3.6843343558395195`*^9}, 
   3.6843343862690415`*^9, {3.68433443423285*^9, 3.684334462792938*^9}, {
   3.684334496215224*^9, 3.6843344972407417`*^9}, 3.6843345789892154`*^9, {
   3.684334664871003*^9, 3.684334693168705*^9}, 3.6843347350661354`*^9, {
   3.6843347882162523`*^9, 3.6843347895613747`*^9}, 3.684334844140048*^9, {
   3.684335225309676*^9, 3.6843352895041857`*^9}, {3.6843362114080424`*^9, 
   3.6843362121569777`*^9}, 3.6843364659598837`*^9, {3.684501189964034*^9, 
   3.684501208904088*^9}, {3.695471911786522*^9, 3.695471942041325*^9}, {
   3.6959649089502754`*^9, 3.695964925044392*^9}, {3.695965032898813*^9, 
   3.6959650333778505`*^9}, {3.695965076508998*^9, 3.695965080554229*^9}, {
   3.6959651847004476`*^9, 3.695965249625012*^9}, {3.695965352661894*^9, 
   3.69596550853874*^9}, {3.695965558040332*^9, 3.695965583846273*^9}, {
   3.6959656237913246`*^9, 3.6959656789741783`*^9}, {3.695965755994721*^9, 
   3.695965844084791*^9}, {3.6959658822359877`*^9, 3.695965946267577*^9}, {
   3.6960647842299013`*^9, 3.6960648117870855`*^9}, {3.69606484364481*^9, 
   3.696064879351149*^9}, {3.696064929952259*^9, 3.69606495744658*^9}, {
   3.696065165460205*^9, 3.696065250680169*^9}, {3.696065329926016*^9, 
   3.696065331844243*^9}, {3.6960653873008084`*^9, 3.69606544000671*^9}, {
   3.6960666295587716`*^9, 3.6960667091177845`*^9}, {3.696067570332199*^9, 
   3.696067576698513*^9}, 3.69606916432605*^9, {3.696148534180535*^9, 
   3.6961486122550497`*^9}, {3.6961666128839483`*^9, 3.696166613852022*^9}, {
   3.6961862725833936`*^9, 3.696186278218486*^9}, {3.6961863306813745`*^9, 
   3.696186422170828*^9}, {3.696241322098359*^9, 3.696241340031139*^9}, {
   3.696241477967839*^9, 3.696241509401063*^9}, {3.6962415905544376`*^9, 
   3.696241653553361*^9}, {3.6962417155320835`*^9, 3.6962417182640076`*^9}, {
   3.6962417505894027`*^9, 3.696241750869881*^9}, {3.6962417825422263`*^9, 
   3.6962417866717916`*^9}, {3.6962418177303905`*^9, 3.696241822897452*^9}, {
   3.696249271228676*^9, 3.696249285460362*^9}, {3.6962493559652433`*^9, 
   3.6962493567669764`*^9}, 3.6962495034404416`*^9, {3.696249680358407*^9, 
   3.696249680444501*^9}, {3.69625031210766*^9, 3.696250315732831*^9}, 
   3.696250385764454*^9, 3.696250496256843*^9, {3.6962505353336687`*^9, 
   3.696250563810774*^9}, 3.6962517260065317`*^9, {3.696251767581411*^9, 
   3.6962519017981496`*^9}, {3.6962519556804404`*^9, 
   3.6962519694139986`*^9}, {3.6962520156601744`*^9, 
   3.6962520594677763`*^9}, {3.6962521276815324`*^9, 3.6962521792153893`*^9}, 
   3.6962522363474164`*^9, {3.6962522757220345`*^9, 3.6962522989501314`*^9}, 
   3.6962523290006447`*^9, {3.696252364721099*^9, 3.6962523979975557`*^9}, {
   3.6962525588162127`*^9, 3.696252575973627*^9}, 3.6962527276570616`*^9, 
   3.69627492953573*^9, {3.6963200122514267`*^9, 3.6963200415550823`*^9}, {
   3.696320073072132*^9, 3.696320073303255*^9}, 3.696320113457*^9, {
   3.696320168045394*^9, 3.6963202572428184`*^9}, {3.696320287516848*^9, 
   3.6963202911116*^9}, {3.696320330299333*^9, 3.6963204160315857`*^9}, {
   3.696328116868992*^9, 3.6963281204883976`*^9}, {3.709548083801281*^9, 
   3.7095480999437037`*^9}, {3.709548282846122*^9, 3.7095482926237946`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalDelta]ACluster", "[", 
       RowBox[{
       "f01", ",", "f020", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "3", ",", "mg"}], "]"}], "/", "Anorm"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.2"}], ",", "0.6"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Tmin", ",", "0"}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Temperature, arbitrary units\>\"", ",", "None"}], "}"}]}],
      ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalDelta]ACluster", "[", 
       RowBox[{
       "f01", ",", "f021", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "3", ",", "mg2"}], "]"}], "/", "Anorm"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalDelta]ACluster", "[", 
       RowBox[{
       "f01", ",", "f022", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "3", ",", "mg1"}], "]"}], "/", "Anorm"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"\[CapitalDelta]ACluster", "[", 
       RowBox[{
       "f01", ",", "f023", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", 
        "3", ",", "mg1"}], "]"}], "/", "Anorm"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{
     "\"\<Mixed Receptors, with slowing down of adaptation\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"35", ",", "0.4"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6825352320996284`*^9, 3.6825352863434577`*^9}, {
   3.682535317667988*^9, 3.6825353475919085`*^9}, {3.6825353809195437`*^9, 
   3.6825354148547983`*^9}, {3.682535460224168*^9, 3.6825354958848095`*^9}, {
   3.6825365611096883`*^9, 3.6825366307231355`*^9}, {3.682536670351015*^9, 
   3.682536694596828*^9}, {3.682537023193471*^9, 3.6825370625373926`*^9}, {
   3.6825371143191032`*^9, 3.6825373640135555`*^9}, {3.682537406497302*^9, 
   3.682537436572092*^9}, {3.6825374703950524`*^9, 3.682537567539488*^9}, {
   3.682537597968102*^9, 3.682537825660362*^9}, {3.682537858087181*^9, 
   3.682537860547151*^9}, {3.6825379111920753`*^9, 3.6825379443666053`*^9}, {
   3.6825380087108393`*^9, 3.682538009598631*^9}, {3.6825380995127945`*^9, 
   3.682538103772444*^9}, {3.682538163093614*^9, 3.6825382272767906`*^9}, 
   3.6825382670463514`*^9, {3.6825383028792486`*^9, 3.68253838451512*^9}, 
   3.682538464852768*^9, 3.6826847141375694`*^9, 3.6826849319448853`*^9, 
   3.6826849850152016`*^9, {3.682685059035279*^9, 3.6826851175739713`*^9}, {
   3.6826851734468136`*^9, 3.6826851845604496`*^9}, {3.6826852176624427`*^9, 
   3.6826852328159866`*^9}, {3.682685271768137*^9, 3.6826852903192434`*^9}, {
   3.682685321616153*^9, 3.6826853483751974`*^9}, {3.6826853856160846`*^9, 
   3.6826854118031693`*^9}, {3.6826855061808653`*^9, 
   3.6826855347621584`*^9}, {3.682685602681464*^9, 3.682685630464272*^9}, 
   3.6826856635049367`*^9, {3.6826857127595415`*^9, 3.682685712974677*^9}, 
   3.68268589682548*^9, {3.6826864000856266`*^9, 3.682686452804558*^9}, {
   3.6826865191587143`*^9, 3.6826865662126923`*^9}, {3.6826866357748237`*^9, 
   3.682686636438309*^9}, 3.682686724536451*^9, {3.6826868378130417`*^9, 
   3.682686907329131*^9}, {3.6826869524158335`*^9, 3.682687159473338*^9}, {
   3.68268719938052*^9, 3.6826872115568843`*^9}, {3.6826872700208116`*^9, 
   3.6826874181469536`*^9}, {3.6827064530219965`*^9, 3.682706529777432*^9}, {
   3.6827070394097805`*^9, 3.682707065130992*^9}, {3.682707136336276*^9, 
   3.682707174743582*^9}, {3.682709544189739*^9, 3.6827095598960004`*^9}, {
   3.682709615030701*^9, 3.682709617576748*^9}, {3.6827096548313255`*^9, 
   3.68270983997371*^9}, {3.6827104948771887`*^9, 3.6827105093376427`*^9}, {
   3.6827105418262005`*^9, 3.682710544194585*^9}, {3.6827131405963006`*^9, 
   3.6827131568084126`*^9}, 3.682714253744093*^9, {3.6827154154180393`*^9, 
   3.682715427414542*^9}, {3.682725949538505*^9, 3.682725954946944*^9}, {
   3.6827260410148144`*^9, 3.6827260459996347`*^9}, 3.6827266930195336`*^9, {
   3.6827267536144066`*^9, 3.682726780797901*^9}, 3.682726817730174*^9, {
   3.6827268951069026`*^9, 3.6827269195603313`*^9}, {3.682726954889087*^9, 
   3.68272698593671*^9}, 3.6827271015100546`*^9, {3.6827271409259167`*^9, 
   3.6827271582006035`*^9}, {3.6827271943130937`*^9, 3.6827271994483585`*^9}, 
   3.6827272544055505`*^9, {3.6827273481978226`*^9, 3.68272736290546*^9}, {
   3.682727413041479*^9, 3.682727426449709*^9}, {3.6827275578330173`*^9, 
   3.682727585384539*^9}, {3.682727618521365*^9, 3.682727654867692*^9}, {
   3.6827276908769865`*^9, 3.682727719405594*^9}, {3.682727795513173*^9, 
   3.682727814575512*^9}, {3.6827288120566635`*^9, 3.682728812603665*^9}, {
   3.6834633039603243`*^9, 3.6834633177606173`*^9}, {3.683463671078239*^9, 
   3.683463711113473*^9}, {3.683463750230669*^9, 3.683463861609986*^9}, {
   3.6834639050198307`*^9, 3.683463919771969*^9}, {3.6834966639903383`*^9, 
   3.683496682006337*^9}, {3.6834967170381193`*^9, 3.6834967186655397`*^9}, 
   3.683496768414067*^9, 3.6834968079584723`*^9, {3.6834968460138493`*^9, 
   3.6834968697523613`*^9}, {3.6834969020340137`*^9, 3.683496957919488*^9}, {
   3.683496989311179*^9, 3.6834970295335445`*^9}, 3.683499920390975*^9, {
   3.6835021640912104`*^9, 3.683502185335653*^9}, 3.683502224145131*^9, {
   3.6835022561376762`*^9, 3.6835022681374655`*^9}, {3.683504274972628*^9, 
   3.683504300934317*^9}, {3.6835043940256395`*^9, 3.683504426590349*^9}, {
   3.6835044791267*^9, 3.6835044800764556`*^9}, {3.683506804016662*^9, 
   3.6835068114169226`*^9}, {3.6835068886999464`*^9, 3.6835068943227034`*^9}, 
   3.6835073295069294`*^9, {3.6835073596274166`*^9, 3.683507397108658*^9}, {
   3.683508407326458*^9, 3.6835084146174326`*^9}, {3.6835105334354515`*^9, 
   3.6835105516894655`*^9}, {3.683589240414019*^9, 3.683589247363758*^9}, {
   3.6835893416136956`*^9, 3.683589344512293*^9}, {3.683589391250499*^9, 
   3.6835893932344093`*^9}, 3.6835948672900267`*^9, {3.683595203707719*^9, 
   3.6835952055708427`*^9}, {3.6835952695710173`*^9, 3.683595270531065*^9}, {
   3.6835960468745937`*^9, 3.6835960473313837`*^9}, {3.683598265149637*^9, 
   3.6835982652795286`*^9}, {3.683598332002686*^9, 3.683598334573929*^9}, {
   3.6835984237873755`*^9, 3.68359842559363*^9}, {3.6836315095008483`*^9, 
   3.683631513923896*^9}, {3.683631725170721*^9, 3.683631729299243*^9}, {
   3.6836317638130846`*^9, 3.6836317655349007`*^9}, 3.6836338267426863`*^9, 
   3.6836502882344*^9, {3.6836503499159527`*^9, 3.6836503537330117`*^9}, 
   3.6836504036628428`*^9, {3.6839068735576715`*^9, 3.683906874055438*^9}, {
   3.683915181165773*^9, 3.683915181613423*^9}, 3.68411016169005*^9, {
   3.684110226602546*^9, 3.684110230329721*^9}, {3.6841102892235217`*^9, 
   3.6841103161767807`*^9}, {3.6841762134425535`*^9, 
   3.6841762684023433`*^9}, {3.684262501095686*^9, 3.6842625034879827`*^9}, 
   3.684262642983977*^9, 3.684264686142319*^9, {3.68426471773942*^9, 
   3.6842647227528763`*^9}, {3.684265050732479*^9, 3.6842650560040846`*^9}, {
   3.6842651064390244`*^9, 3.6842651187619414`*^9}, {3.6842652078938055`*^9, 
   3.6842652113532457`*^9}, 3.684265257507209*^9, {3.684265535338214*^9, 
   3.6842655393152175`*^9}, 3.6843255268534746`*^9, {3.6843257713186626`*^9, 
   3.684325787340805*^9}, {3.6843258527772036`*^9, 3.684325940767081*^9}, {
   3.6843260158814497`*^9, 3.6843260535639744`*^9}, {3.6843262144527025`*^9, 
   3.684326243477689*^9}, {3.6843262822149787`*^9, 3.6843263094350405`*^9}, 
   3.6843263735545626`*^9, 3.6843264113536196`*^9, {3.6843264901005497`*^9, 
   3.6843264906549435`*^9}, {3.6843265455262747`*^9, 3.684326548251256*^9}, {
   3.6843266013127146`*^9, 3.684326602252088*^9}, {3.684326643049778*^9, 
   3.684326672774681*^9}, {3.684326703466401*^9, 3.684326704478752*^9}, {
   3.684326741677846*^9, 3.6843267417564073`*^9}, {3.6843268030469313`*^9, 
   3.684326804779685*^9}, {3.6843268388119307`*^9, 3.6843268407118173`*^9}, {
   3.684326897696911*^9, 3.684326899996645*^9}, {3.6843304515229907`*^9, 
   3.6843304771696615`*^9}, {3.684330766968238*^9, 3.6843307697622857`*^9}, {
   3.684330825411683*^9, 3.684330897769313*^9}, {3.684330965212263*^9, 
   3.684330981096937*^9}, {3.684331016059127*^9, 3.6843310360244904`*^9}, {
   3.6843331848211436`*^9, 3.684333254447751*^9}, {3.684333290128461*^9, 
   3.68433329123965*^9}, {3.6843334972138386`*^9, 3.6843335470133924`*^9}, {
   3.6843335871029534`*^9, 3.6843336224903784`*^9}, {3.684333669431011*^9, 
   3.6843336714919744`*^9}, 3.684333710722498*^9, {3.6843337548674593`*^9, 
   3.684333764657854*^9}, {3.68433382196092*^9, 3.684333824182129*^9}, {
   3.684333888674942*^9, 3.6843338887942066`*^9}, {3.6843339247938304`*^9, 
   3.684333927948724*^9}, {3.6843339628506722`*^9, 3.684333967648592*^9}, {
   3.6843340232783046`*^9, 3.684334025521907*^9}, {3.684334070234514*^9, 
   3.684334073049552*^9}, {3.6843341144103465`*^9, 3.6843341178002024`*^9}, {
   3.6843341524801817`*^9, 3.6843341525366993`*^9}, {3.6843341874036956`*^9, 
   3.684334196474905*^9}, {3.6843342442404203`*^9, 3.6843343558395195`*^9}, 
   3.6843343862690415`*^9, {3.68433443423285*^9, 3.684334462792938*^9}, {
   3.684334496215224*^9, 3.6843344972407417`*^9}, 3.6843345789892154`*^9, {
   3.684334664871003*^9, 3.684334693168705*^9}, 3.6843347350661354`*^9, {
   3.6843347882162523`*^9, 3.6843347895613747`*^9}, 3.684334844140048*^9, {
   3.684335225309676*^9, 3.6843352895041857`*^9}, {3.6843362114080424`*^9, 
   3.6843362121569777`*^9}, 3.6843364659598837`*^9, {3.684501189964034*^9, 
   3.684501208904088*^9}, {3.695471911786522*^9, 3.695471942041325*^9}, {
   3.6959649089502754`*^9, 3.695964925044392*^9}, {3.695965032898813*^9, 
   3.6959650333778505`*^9}, {3.695965076508998*^9, 3.695965080554229*^9}, {
   3.6959651847004476`*^9, 3.695965249625012*^9}, {3.695965352661894*^9, 
   3.69596550853874*^9}, {3.695965558040332*^9, 3.695965583846273*^9}, {
   3.6959656237913246`*^9, 3.6959656789741783`*^9}, {3.695965755994721*^9, 
   3.695965844084791*^9}, {3.6959658822359877`*^9, 3.695965946267577*^9}, {
   3.6960647842299013`*^9, 3.6960648117870855`*^9}, {3.69606484364481*^9, 
   3.696064879351149*^9}, {3.696064929952259*^9, 3.69606495744658*^9}, {
   3.696065165460205*^9, 3.696065250680169*^9}, {3.696065329926016*^9, 
   3.696065331844243*^9}, {3.6960653873008084`*^9, 3.69606544000671*^9}, {
   3.6960666295587716`*^9, 3.6960667091177845`*^9}, {3.696067570332199*^9, 
   3.696067576698513*^9}, 3.69606916432605*^9, {3.696148534180535*^9, 
   3.6961486122550497`*^9}, {3.696148654755697*^9, 3.6961486660297475`*^9}, 
   3.6961863060677023`*^9, 3.696241387669946*^9, {3.696241527668543*^9, 
   3.696241528731682*^9}, {3.6962526000430813`*^9, 3.6962526006501927`*^9}, {
   3.696276829251639*^9, 3.6962768347225857`*^9}, {3.7095481270004396`*^9, 
   3.7095481554072647`*^9}, {3.709548329967773*^9, 3.709548354503903*^9}}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd1Hs41IkaB3CXDGOLLmxJUrls6XRqQ/n9jN4XP9IdWesWcp1i6Tmz2oYT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       
       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVj3s4lAkbxh0iJNTXYRXr0Am1my+29b4Oz8O8ibT7OZQ2OQxGlJbFzrZs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       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVkHs4lAkbxpFjn4SkREQHRQedfN534nmMN1mxOeWwCckpomK1V5TRVFsO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       "]]}}, {}, {}}, {{{}, {}, 
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0Hk01XkYBnDbkDLZhhNqaIgGEyn8ru373nt/xIlwazQqjSnKlpSU7DW2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       "]]}}, {}, {}}, 
   InsetBox["\<\"Mixed Receptors, with slowing down of adaptation\"\>", \
{35, 0.4}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{24.1, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {
     FormBox["\"Temperature, arbitrary units\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{24.1, 41.99999963469388}, {-0.2, 0.6}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6825377042753234`*^9, 3.6825378047865534`*^9}, {
   3.682537844152254*^9, 3.6825378640712457`*^9}, {3.682537921918868*^9, 
   3.682537948625601*^9}, 3.6825380130645313`*^9, 3.6825381070126824`*^9, 
   3.6825381659216676`*^9, {3.682538204822571*^9, 3.6825382311517863`*^9}, 
   3.682538270049757*^9, 3.6825383059461184`*^9, {3.682538336148203*^9, 
   3.682538388105871*^9}, 3.6825384698862715`*^9, 3.6826846836241093`*^9, 
   3.68268471607164*^9, 3.682684934126251*^9, 3.6826849877929945`*^9, {
   3.682685061943986*^9, 3.682685122050044*^9}, {3.6826851765038986`*^9, 
   3.682685186162768*^9}, {3.682685220247908*^9, 3.6826852344292154`*^9}, {
   3.682685273307128*^9, 3.6826852922080197`*^9}, 3.6826853232381725`*^9, 
   3.6826853561111693`*^9, {3.682685387045112*^9, 3.6826854133091435`*^9}, {
   3.6826855080231495`*^9, 3.6826855358891716`*^9}, 3.6826856321138945`*^9, 
   3.682685665678402*^9, 3.682685715178295*^9, 3.6826867271388903`*^9, {
   3.6826869918960056`*^9, 3.682687004525793*^9}, {3.6826870830788565`*^9, 
   3.682687163637389*^9}, {3.682687202301669*^9, 3.682687214387579*^9}, {
   3.6826872789738245`*^9, 3.6826874216227093`*^9}, 3.682706543908762*^9, 
   3.6827070064109*^9, 3.682707076617086*^9, 3.6827071815130997`*^9, 
   3.6827095066281614`*^9, 3.6827095770327024`*^9, 3.682709622769586*^9, {
   3.6827097861770144`*^9, 3.6827098102300224`*^9}, 3.682709844366061*^9, 
   3.6827104274861927`*^9, 3.682710513745129*^9, 3.682710548565708*^9, 
   3.682712659679181*^9, 3.6827131597447863`*^9, 3.6827142567151937`*^9, 
   3.6827148942860346`*^9, 3.682715430459979*^9, 3.682725958974327*^9, 
   3.6827260499421253`*^9, 3.6827267016085978`*^9, {3.6827267583692164`*^9, 
   3.682726785136529*^9}, 3.6827268261885643`*^9, 3.6827269274053564`*^9, 
   3.682726994183693*^9, 3.68272710674852*^9, 3.6827271715976076`*^9, 
   3.682727203703224*^9, 3.682727258574351*^9, 3.682727366239787*^9, 
   3.682727430221654*^9, 3.6827275897961493`*^9, {3.6827276234948783`*^9, 
   3.6827276684987755`*^9}, {3.682727702151721*^9, 3.6827277228968287`*^9}, {
   3.6827277990865107`*^9, 3.682727818250458*^9}, 3.682728543871354*^9, 
   3.682728625528308*^9, 3.682728816246604*^9, 3.683463288583415*^9, 
   3.683463320879715*^9, 3.68346348108924*^9, 3.683463555938262*^9, {
   3.6834636835466776`*^9, 3.6834637127816086`*^9}, 3.683463763464962*^9, 
   3.683463795569095*^9, 3.68346382942412*^9, 3.6834638813543873`*^9, 
   3.683463938890834*^9, 3.6834957701047955`*^9, 3.683495809568323*^9, 
   3.683496049700411*^9, 3.6834961399052563`*^9, 3.683496174384391*^9, 
   3.6834966896600113`*^9, 3.6834967333211875`*^9, 3.6834967800584917`*^9, 
   3.6834968141356525`*^9, {3.6834968565928235`*^9, 3.6834969675570884`*^9}, 
   3.683497006127779*^9, 3.683497038699297*^9, {3.6834999055409737`*^9, 
   3.683499923461649*^9}, {3.6835021659878154`*^9, 3.683502188264169*^9}, 
   3.683502283545128*^9, {3.6835042870158367`*^9, 3.6835043149143753`*^9}, {
   3.683504407531855*^9, 3.6835044372519665`*^9}, 3.683504502903627*^9, 
   3.683506819464319*^9, 3.6835069025455933`*^9, 3.68350741410402*^9, 
   3.6835078396937094`*^9, 3.6835083415544653`*^9, 3.6835084418033514`*^9, 
   3.683509783442175*^9, 3.6835098474990225`*^9, 3.683509915616766*^9, 
   3.6835099928329296`*^9, 3.683510072062817*^9, 3.6835105102754216`*^9, 
   3.6835105697691193`*^9, 3.6835892785200834`*^9, 3.683589365246749*^9, 
   3.683589431889057*^9, 3.683594905597217*^9, 3.6835950561450577`*^9, 
   3.6835951751550407`*^9, 3.6835952441467485`*^9, 3.683595301957374*^9, 
   3.6835956749581203`*^9, 3.68359602172596*^9, 3.683596078839198*^9, 
   3.683597915176831*^9, 3.683598075344754*^9, 3.683598248839739*^9, 
   3.6835982934135556`*^9, 3.6835983990887165`*^9, 3.683598455708118*^9, 
   3.6835986149065695`*^9, 3.683598757848324*^9, 3.6836298362780275`*^9, 
   3.6836301314277706`*^9, 3.683630299873329*^9, 3.683630750533778*^9, 
   3.6836309264913025`*^9, 3.6836315470755296`*^9, 3.6836317945722537`*^9, 
   3.6836503742804613`*^9, 3.683906847978554*^9, 3.6839068908545575`*^9, 
   3.6839151895592966`*^9, 3.683916006591753*^9, 3.6841101372616596`*^9, 
   3.6841101954315968`*^9, 3.6841102561675105`*^9, 3.684110338660243*^9, 
   3.684147378295786*^9, 3.6841762515565863`*^9, 3.684262486956566*^9, 
   3.6842625233023195`*^9, 3.6842626743795147`*^9, 3.6842629087753363`*^9, 
   3.684264661593049*^9, 3.68426470125734*^9, 3.684264738336096*^9, 
   3.684264835285263*^9, 3.684265030780424*^9, 3.6842650704267178`*^9, 
   3.684265128317525*^9, 3.6842652212274303`*^9, 3.6842652670222597`*^9, 
   3.6842656476488004`*^9, 3.6842657057212005`*^9, 3.684266064661744*^9, 
   3.68432559135177*^9, {3.6843258013124266`*^9, 3.684325826731043*^9}, 
   3.684325869158456*^9, {3.6843259234504347`*^9, 3.6843259481446705`*^9}, 
   3.6843261088467875`*^9, 3.6843262300683002`*^9, 3.6843304580513353`*^9, 
   3.6843304887206464`*^9, 3.684330784143308*^9, {3.6843308912087708`*^9, 
   3.6843309043489203`*^9}, {3.684330974434531*^9, 3.684330987010805*^9}, {
   3.684331026714185*^9, 3.6843310449622355`*^9}, 3.684333205825423*^9, {
   3.6843332438070097`*^9, 3.6843332630361967`*^9}, 3.684333300926334*^9, 
   3.684333521109614*^9, 3.6843335719943733`*^9, 3.684333607668949*^9, 
   3.68433364256085*^9, 3.6843336893699822`*^9, 3.6843337290506034`*^9, 
   3.6843337811725135`*^9, 3.6843338402442026`*^9, 3.684333905071615*^9, 
   3.684333943823601*^9, 3.6843339834941807`*^9, 3.684334042314645*^9, 
   3.684334094782034*^9, {3.6843341436966996`*^9, 3.684334168566319*^9}, 
   3.6843342153356314`*^9, {3.684334368552739*^9, 3.684334398204999*^9}, {
   3.684334449055837*^9, 3.68433447710149*^9}, 3.6843345155151377`*^9, 
   3.6843345887988663`*^9, {3.6843346807649813`*^9, 3.684334704456746*^9}, 
   3.684334744131782*^9, 3.6843348019506884`*^9, 3.6843348537620554`*^9, 
   3.6843352996454782`*^9, 3.684335985860016*^9, 3.6843360214072676`*^9, 
   3.684336353259012*^9, 3.6843431822418766`*^9, 3.684501222635729*^9, 
   3.6914299929849057`*^9, 3.6954707521639814`*^9, {3.695471915831217*^9, 
   3.6954719450171967`*^9}, 3.6957261870833883`*^9, 3.695734146000513*^9, {
   3.695964912331169*^9, 3.695964927429231*^9}, 3.6959650361458187`*^9, 
   3.6959650840765395`*^9, {3.6959651899627385`*^9, 3.6959652520705214`*^9}, {
   3.695965360819952*^9, 3.6959655108727674`*^9}, {3.695965559883821*^9, 
   3.6959655857167935`*^9}, {3.6959656262966957`*^9, 
   3.6959656810345883`*^9}, {3.695965761642248*^9, 3.695965846284938*^9}, {
   3.6959658846401625`*^9, 3.6959659484319067`*^9}, {3.6960653798895826`*^9, 
   3.696065442664607*^9}, 3.6960663482739096`*^9, {3.6960666332979584`*^9, 
   3.6960666804619827`*^9}, 3.696066711767707*^9, 3.696067580685891*^9, 
   3.696069167421094*^9, 3.696069851955881*^9, 3.6961485904407234`*^9, 
   3.6961486380269427`*^9, 3.6961486686638336`*^9, 3.696154190803546*^9, {
   3.6961593229327693`*^9, 3.696159342390279*^9}, 3.696166620721505*^9, 
   3.6961862263222237`*^9, {3.696186283929405*^9, 3.696186309086426*^9}, {
   3.6961863398427224`*^9, 3.696186427212988*^9}, 3.696241181841468*^9, {
   3.696241223342574*^9, 3.6962412410558767`*^9}, {3.6962412863818793`*^9, 
   3.6962414149117575`*^9}, {3.6962414458338137`*^9, 3.696241552777676*^9}, {
   3.6962415986841793`*^9, 3.6962416671227107`*^9}, 3.696241722368284*^9, 
   3.696241756415522*^9, 3.6962417956579843`*^9, 3.69624182848764*^9, {
   3.696249281160615*^9, 3.696249293749263*^9}, 3.696250349905506*^9, 
   3.6962503948595233`*^9, {3.6962505142777023`*^9, 3.6962505710246043`*^9}, 
   3.6962506677435813`*^9, 3.696251733430617*^9, {3.6962517732830963`*^9, 
   3.6962518479877048`*^9}, {3.6962518787029753`*^9, 3.696251906913789*^9}, {
   3.696251943390951*^9, 3.6962520828567495`*^9}, 3.6962521333555193`*^9, {
   3.6962521660762143`*^9, 3.696252185794046*^9}, 3.696252245008179*^9, 
   3.696252282736162*^9, {3.696252313863819*^9, 3.6962523350280476`*^9}, {
   3.696252376068293*^9, 3.6962525271770496`*^9}, {3.6962525646624603`*^9, 
   3.696252603981387*^9}, 3.696252737040271*^9, 3.696252815413725*^9, 
   3.6962768008159*^9, 3.6962768369812465`*^9, {3.6963200239759765`*^9, 
   3.6963200793265476`*^9}, 3.696320124206134*^9, {3.696320181301473*^9, 
   3.6963202350710306`*^9}, 3.6963202737381983`*^9, {3.696320316719373*^9, 
   3.6963203702417765`*^9}, {3.6963204020130315`*^9, 3.696320423647176*^9}, 
   3.6963267528760796`*^9, 3.6963283849957347`*^9, 3.6964887959132595`*^9, 
   3.7065985201381426`*^9, 3.7067642398627987`*^9, {3.7095481107750955`*^9, 
   3.709548134258727*^9}, 3.7095482979503756`*^9, {3.7095483476173506`*^9, 
   3.709548356334857*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"And", " ", "their", " ", "methylation", " ", "levels"}], ",", 
   "  ", 
   RowBox[{
    RowBox[{"Figure", " ", "4"}], "-", 
    RowBox[{"Figure", " ", "Supplement", " ", "1", "B"}]}]}], " ", 
  "*)"}]], "Input",
 CellChangeTimes->{{3.7095485272090483`*^9, 3.7095485461094155`*^9}, {
  3.709548725105984*^9, 3.7095487273892097`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"Plot", "[", " ", 
    RowBox[{
     RowBox[{"msol", "[", 
      RowBox[{"f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "0.5"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"0", ",", "8"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Tmin", ",", "0"}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", "Automatic"}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Temperature\>\"", ",", "\"\<Methylation\>\""}], "}"}]}], 
     ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"msol", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "f01"}], "+", "f023"}], ")"}], "/", "3"}], ",", "f1", 
       ",", "g0", ",", "g1", ",", "T", ",", "0.5"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"msol", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", "f023"}], "+", "f01"}], ")"}], "/", "3"}], ",", "f1", 
       ",", "g0", ",", "g1", ",", "T", ",", "8"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Green"}]}], "]"}], ",", 
   RowBox[{"Plot", "[", 
    RowBox[{
     RowBox[{"msol", "[", 
      RowBox[{"f023", ",", "f1", ",", "g0", ",", "g1", ",", "T", ",", "8"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"T", ",", "Tmin", ",", "Tmax"}], "}"}], ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<Methylation levels - different trimers\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"34", ",", "2"}], "}"}]}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.696447269714406*^9, 3.696447272956709*^9}, 
   3.6964473267933846`*^9, {3.696447378980421*^9, 3.6964474030359197`*^9}, {
   3.696489075827852*^9, 3.6964891309079695`*^9}, {3.6965041259116416`*^9, 
   3.6965042242218137`*^9}, 3.7095485762127647`*^9}],

Cell[BoxData[
 GraphicsBox[{{{{}, {}, 
     {GrayLevel[0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV1Xk0lokXB3D7zrvwPpMiSVRmioZ4nufF+/V6qBEzSEoIWTKJTDJaRqQa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       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[1, 0, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwVzns01HkABXBUQnvMTGeJfr+ZX5LsaltKxxnvOzNfNZQaJa2JiMj2MFpL
2VZJqUQHQx49Vk9ENXpMFocedmtKopTy2FIto9cgsz081v72j3vu+Zxz/7g2
EYrlUUYGBgb+bP5vXW5NcZG1EA2c2t2aPgZxttUxhpQQn2WaxFrWHy5VzfuR
FuL9pYKIC6z/eXClQcgIkRS5eVYe61GOSvtklhB+7ftkYazNMk85WjoJEW9j
vkivZWC/J/OacqEQUt/SHCvW4T+veZ4RL8QUnqDat4dBd+XAR/PHQoS4/v3o
dTeD54PbGyknVzSO7/Rz7mLw4uxoVFi6K17cDSnva2MwWLfxqfMbVxjcWjkz
oIVBSlvrZCVxw5S9Ad9L7jDgL3bg7Cpxw5lD0sTU6wzqXRK7SozdEa03Gj97
lcFfs2ujg8Ld4dg9s9PzHPs3XqfJv+EOvXqrOqGYgbphel847YG5Zdy1xkoG
6zI8mtYmeMBr7HWIfDcDG9WSA0OPPUD73oqq2MIg5MnKiRwnT1iafl6SGMag
ZLV/UG2OJ85oO8VPfRkMBbnF/jboiV+dc5T189k/QTMkUxZ7wVEcrsqnGBRe
0vebnPNCO7dG98iAwcDUm8HZxt4I2JXmn9grQFBz8pGyGG+opCv8cjQCXDdy
PPVJ443cSXYXqHIBVhx75xzDA8qbL1e/yRRgqVZoxBcDncyizLJNAuy/bKjK
VwB35s19OHepAMT9z/o5R4EsIx8LOycBJg/udEu/BxzYWtebyxHA9NuqvIov
gHaT4ZB8kI+pWT3yfAcRTvfHNela+DhWab7nqFyEtmm8LdkX+VgfeCVj/T4R
KqO5ls15fAhnB4wPV4nw3cgpdyTyIf1lQ8CKHhEKfO4Ph8r56EjfYXybJ0Z0
aWpDhTcf8bfT7SeIxdBn5fj8ZMvH4n08+4kKMdIC04paTflwSMhWNhWLsdrG
RfxER0Pak9G1ukmM3rcKTkQbjT5uavqkYXZvZu9ldY1G1gbFya0OEqStu6su
LKGRsLC96MIqCeZzB/YrsmlEytzGzu+XgJlgVzInicZDi/wGze8SvJHxM3iR
NFJCY2PKeiQQRZVWTltGw6XVM0lmSSBfuGkN7UZjTmN6TJ2EQNXvX2BrT+PE
jpYanziCO5KLcmsLGky4eVL+cQIzXvZuGyMaXQ0ai3NNBA9cpCnDAxSeromK
SrhPQC9wtlCxfvTFUO3VTDDULrkSyfqeo3vggxaC4YPN3KZ+CrVHzis/thKY
lEZIjusoHI5XckQdBI0FJgel7ygE24aYtvUSSINflRzXUgis//xDsZYg+e2q
5CDWsuBDZTF9BFxtXehXrKVZ9xeNvCaYfmyVx7ZeCsIR7J3xnsD6RF6crIeC
VavdhI1DBJO23b1s9IrC17E3ly/QE+zyy/2m+iUFrmnYyTHWFaedSxWsTbwL
RdkfCbYn6290vaDwqdwsRf2FQHDWd3NVN4UPPqXNO4YJ7hWfcIplreuWMNIR
gsOef4zNYt1rmVzfMUpQaBipVj6n8PKitfnpMYK6wc5iX9bPllwN3fwvgZa2
zjNg3aFdft5lnGBnn5Wy6hmFttT+0XHWgpr2oljW/wFdYx9m
       
       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[0, 1, 0], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwV0n0w1HkcB/BsrnA3ROH0cF96tjW3muJ+nt+7+1WcMmKTbLGpPXuaYk6u
kQjTxZ4u2nBFpQfj4S7plHOluJg7RpG4llv0cHda5FnIIvf1x2c+85r3zGc+
n5mPTWiEn5w3b968Hazm+sD5+7kXrThkuGukbbMEkavuKfSWcei1TPWY80hp
+aavl3MICxUI5jz27G4NRzic3+THm/O0SYm2dTWH8eHZglZmozM3BBZ2HJ6V
jw2pmdedOlOl2sphcbhlzHNm2dHgl6lRHFZuOytrZn51e2jc+DmHCWnoi3rm
l8Oxj5fZOaKzxbCqmvl10bQ8ROmIDTpk3GMefniobXOvI1Yf61l8izlB3bJQ
RZ0QYqktuMa8wptvkpjvhF0DnImKudLh2478Bc5Qetm7JTB3rq34KkDmjG4D
gcHhuX2jBuqyHjnD+svaPglzWc3SbtlyF0h4nZ1OzAdTXRr2R7tAmjcSs4LZ
pmT796PPXeBjv+3K+w8Ee1t36ZvYucLDWtXWxJwv3RFQcc4V6c26wSvMowFO
R64Mu8LIb71OzlwZYC3+2NsNwoKOq+uZL5S+GzS46YY0m6iy9hmCIbPqPekL
3GG/5VZxCnPA07icQoU7AivUKdbMv/MENybq3LGUpyktmibwv9y3WWEKyAtH
y22ZfbQcb4UI6PxGFq6cIki5o1eSFQHsW/YopkNHQJ3/qNxwCTj6X9FrK+aF
wyedlE8A84b6nLWTBIa25Rk/TwIK/UB9m/cEZmldQVl8ISLFaa6acYLLt41P
XQoSwu+LXu+wMYIwyd3UsGQh+s988rlmlIBbu3NWVy6EcWIKr2+YwPN4+E7/
LiE4+Up++yCBRhm/oNZUhDJy1veHfoKoWuW6+SIRCmZ65Hd6CbyTTdfpR7Dc
Jc70ppaAH52uasgVoa+rp3HoXzavK7VD2iDCHXfvxJmXBN2LkpQf6USYqPzM
4kY7QVp4xPVjfDGW6PwFEjVB9Na/L97aLUZbiXlqbRPBAV+nmeIUMbpKfnxg
Wk/QbJ5VU/ebGNlGmmsV1eyf9h1RFHaJMRvJ07OrIHBocY3xtaAY3HU6yKGU
YMNjpeKhmOJg+gNjsyKCa/FN9z0iKRwsbCZDcwmIzDgm6ypFZvPRjYszCDpq
6sxvNlDEb80b+TOFoC1YLo9upLhUf1KrYv5rUq/M7SnFWW1SYzDzE4Gz5FkT
xQmVYdR4MkFFTrFqvIUiZ2qvxRrm7CiViVBDUar2qjv5HcGeVXsN1W8ofDOl
b/lJBJLK94G5WgpHb0v+WCKB757MQkU3RYKHj7SK2TOtcdtUD0VfkGOmPzM3
hdPW/RQyA0lYbALBpy1r5h8apSh8uya5Lp5gyZFqvy3vKJYHDw2cY15kGHJ9
htmh9aCXlNnA/YIwfZzi+PRudX8cwcRPRgllkxTvsh/4mjGPeBQ8jddR7L+7
0af9BMHAKzHxnKKwPRDilsf8xiKuUjNNoeRZTdgz//OLlXHeDLvXOb/qQyzB
i+2/7jv8gWIymxdby6zR+hU7zFJEbt9km86sThqcnmVuibevD2T+H9UgNBE=

       "]]}}, {}, {}}, {{{}, {}, 
     {RGBColor[0, 0, 1], AbsoluteThickness[1.6], Opacity[1.], 
      LineBox[CompressedData["
1:eJwd0mtI02EUBvC5TDNB09KolIpKaYYOhNi1nf23huEqby3amrdSx4RZLQuL
tETSaWJZDSWnlro0y0s3y+lcXtCYpqaWK2NFjYXVzLTmtfW+fTg8/L4czgNn
a2JaVBKZRCKFosFpu95aUbqBBreyK3UOx2ZY8my0vt1Og2ShvBV79ZWqEF8q
DTrUwc+xA3OudBQLaPAlTPsUO/50rLlASQO28GAz9semn388xmigHJNUY5un
zxs3Uekg2nVEjf2pbikpTkUHgbfqMvZ0e+p46CQdOuebT2FffDPiWsxnQKoz
X4rtH07xvKRlwL5CCYGt331mQuvCBB+DZhv2hwBdsiieCXGWM+T/9yptfeoX
TIhKfz/+F/lJ18av8X4skGvN9djHC1gDCeksqInZkoG9tVGYPzPGgjbOWTr2
0beHnD2pbEgUdMwuI2sl+0W6a2yQ2TPKsWdEDEX5NBvW238zsfWiLTz38D1Q
5/RyeAm55OHs1Kr7e0A6WijE/undeeSqCwe+rS1tW0QWDV64VSvjwJPRYVds
Azmkyt7HgQYqk76AHK35HirzArCzpOJ55ANWGtmfAHDLqiTmkPMeOTWq0wC6
F9etsyPzmT36oDIAX0qD/jey63QWQ9UPUASx3rPIbjtbbtTPAxgzPvB+IXsX
WcRqChc+tgQ7ppA1TR45ZWIuTEm+pfxATol5XJCSy4WSflPZJDItINKx0MIF
w42cTVbksHPyyGgLF9YY7kZ+Rn6nynTp9SLgpfiVuxlZ2asKXEEQ4E4abzQh
h+d6BTqnEUC1JlhHkCnpV4sHKlChe0E1/XifpWBCMkCAq8LZ2I38dU22auUC
AcZWhU2HXCRPu3OWwoPwGs1QE3K6wFTacJgHhhnOYDXysQjG8oM8HrSYBe03
kV/7qLv6nvGgQUHKzcH/JFXIai080Dra504i7x5hZ0T48uGgn61ZjBxkVMna
eXzoMQ3lc5FvZw617j3BB2J8Z8gOZJJ+NLn6PB/+RH8e9kP+B5S+jnQ=
       
       "]]}}, {}, {}}, 
   InsetBox["\<\"Methylation levels - different trimers\"\>", {34, 2}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{24.1, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["\"Methylation\"", TraditionalForm], None}, {
     FormBox["\"Temperature\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{
   "DefaultBoundaryStyle" -> Automatic, "DefaultMeshStyle" -> 
    AbsolutePointSize[6], "ScalingFunctions" -> None, 
    "CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{24.1, 41.99999963469388}, {0, 8}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6964473371363*^9, 3.6964474050689135`*^9, 3.6964891320077806`*^9, {
   3.6965041428236437`*^9, 3.696504175692754*^9}, 3.69650422545083*^9, 
   3.6965728375908184`*^9, 3.7065972580743484`*^9, 3.706597735772788*^9, 
   3.706598881075778*^9, 3.709548443921052*^9, {3.7095485532763205`*^9, 
   3.709548577075748*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{"Mow", " ", "mixed", " ", "receptors"}], ",", " ", 
   RowBox[{"but", " ", "perfect", " ", "adaptation"}], ",", " ", 
   RowBox[{
    RowBox[{"Figure", " ", "4"}], "-", 
    RowBox[{"Figure", " ", "Supplement", " ", "2"}]}]}], " ", "*)"}]], "Input",\

 CellChangeTimes->{{3.709548861313873*^9, 3.7095488751592507`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"number", "=", "5"}], ";", 
  RowBox[{"mavail", "=", "2"}], ";", 
  RowBox[{"mtot", "=", "8"}], ";", 
  RowBox[{"A0", "=", 
   RowBox[{"1", "/", "3"}]}], ";", 
  RowBox[{"T0", "=", "24"}], ";", 
  RowBox[{"f01", "=", "0"}], ";", 
  RowBox[{"f020", "=", "0"}], ";", 
  RowBox[{"f022", "=", "0.15"}], ";", 
  RowBox[{"f021", "=", "0.35"}], ";", 
  RowBox[{"f023", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f1", "=", "0.24"}], ";", 
  RowBox[{"g0", "=", "0.00"}], ";", 
  RowBox[{"g1", "=", "0.04"}], ";", 
  RowBox[{"Tmin", "=", 
   RowBox[{"T0", "-", 
    RowBox[{"g0", "/", "g1"}], "+", "0.1"}]}], ";", 
  RowBox[{"Tmax", "=", "42"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"mg", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "0", ",", "0", ",", "0"}], "]"}]}], ";", 
  RowBox[{"mg1", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "0", ",", "8", ",", "8"}], "]"}]}], ";", 
  RowBox[{"mg2", "=", 
   RowBox[{"List", "[", 
    RowBox[{"0", ",", "8", ",", "8", ",", "8"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"Tnorm", "=", "Tmin"}], ";", 
   RowBox[{"mavail", "=", "0"}], ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"calculating", " ", "the", " ", "normalization"}], " ", 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Tnorm", "=", "Tmin"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Anorm", "=", 
   RowBox[{"\[CapitalDelta]ACluster\[CapitalDelta]f", "[", 
    RowBox[{
    "f020", ",", "f023", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", 
     "T", ",", "mg"}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Table\[CapitalDelta]A0", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Table\[CapitalDelta]A1", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Table\[CapitalDelta]A2", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"Table\[CapitalDelta]A3", "=", 
   RowBox[{"{", "}"}]}], ";", 
  RowBox[{"\[CapitalDelta]T", "=", "0.02"}], ";", 
  RowBox[{"Ndig", "=", "4"}], ";", 
  RowBox[{"mg5", "=", 
   RowBox[{"{", 
    RowBox[{"5", ",", "5", ",", "5", ",", "5"}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"T", "=", "Tmax"}], ",", 
    RowBox[{"T", ">", "Tmin"}], ",", 
    RowBox[{"T", "=", 
     RowBox[{"T", "-", "\[CapitalDelta]T"}]}], ",", 
    RowBox[{"Table\[CapitalDelta]A0", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"Table\[CapitalDelta]A0", ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", " ", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalDelta]ACluster", "[", 
             RowBox[{
             "f020", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", 
              ",", "3", ",", "mg5"}], "]"}], "/", "Anorm"}], ",", "Ndig"}], 
          "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"T", "=", "Tmax"}], ",", 
    RowBox[{"T", ">", "Tmin"}], ",", 
    RowBox[{"T", "=", 
     RowBox[{"T", "-", "\[CapitalDelta]T"}]}], ",", 
    RowBox[{"Table\[CapitalDelta]A1", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"Table\[CapitalDelta]A1", ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", " ", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalDelta]ACluster", "[", 
             RowBox[{
             "f021", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", 
              ",", "3", ",", "mg5"}], "]"}], "/", "Anorm"}], ",", "Ndig"}], 
          "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"T", "=", "Tmax"}], ",", 
    RowBox[{"T", ">", "Tmin"}], ",", 
    RowBox[{"T", "=", 
     RowBox[{"T", "-", "\[CapitalDelta]T"}]}], ",", 
    RowBox[{"Table\[CapitalDelta]A2", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"Table\[CapitalDelta]A2", ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", " ", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalDelta]ACluster", "[", 
             RowBox[{
             "f022", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", 
              ",", "3", ",", "mg5"}], "]"}], "/", "Anorm"}], ",", "Ndig"}], 
          "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";", 
  RowBox[{"For", "[", 
   RowBox[{
    RowBox[{"T", "=", "Tmax"}], ",", 
    RowBox[{"T", ">", "Tmin"}], ",", 
    RowBox[{"T", "=", 
     RowBox[{"T", "-", "\[CapitalDelta]T"}]}], ",", 
    RowBox[{"Table\[CapitalDelta]A3", "=", 
     RowBox[{"Append", "[", 
      RowBox[{"Table\[CapitalDelta]A3", ",", 
       RowBox[{"{", 
        RowBox[{"T", ",", " ", 
         RowBox[{"N", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"\[CapitalDelta]ACluster", "[", 
             RowBox[{
             "f023", ",", "f01", ",", "f1", ",", "g0", ",", "g1", ",", "T", 
              ",", "3", ",", "mg5"}], "]"}], "/", "Anorm"}], ",", "Ndig"}], 
          "]"}]}], "}"}]}], "]"}]}]}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Show", "[", 
  RowBox[{
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table\[CapitalDelta]A0", ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1"}], ",", "1"}], "}"}]}], ",", 
     RowBox[{"AxesOrigin", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Tmin", ",", "0"}], "}"}]}], ",", 
     RowBox[{"FrameTicks", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"Automatic", ",", "Automatic"}], "}"}]}], ",", 
     RowBox[{"FrameLabel", "\[Rule]", 
      RowBox[{"{", "\"\<Temperature\>\"", "}"}]}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Green"}], ",", 
     RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}], " ", ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table\[CapitalDelta]A1", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Blue"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table\[CapitalDelta]A2", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}]}], "]"}], ",", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"Table\[CapitalDelta]A3", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Black"}]}], "]"}], ",", 
   RowBox[{"Graphics", "[", 
    RowBox[{"Text", "[", 
     RowBox[{"\"\<mixed receptors, with perfect adaptation\>\"", ",", 
      RowBox[{"{", 
       RowBox[{"35", ",", "0.6"}], "}"}]}], "]"}], "]"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6963264127270217`*^9, 3.6963265418798957`*^9}, {
   3.69632681947392*^9, 3.6963268471983647`*^9}, {3.6963279730082035`*^9, 
   3.696328001237593*^9}, {3.6963280525209284`*^9, 3.696328056817179*^9}, {
   3.6963281574120345`*^9, 3.6963281866558743`*^9}, {3.6963284655137277`*^9, 
   3.696328485697776*^9}, 3.6963285222029085`*^9, {3.6963285593576527`*^9, 
   3.696328664213275*^9}, {3.6963286954886913`*^9, 3.696328777936417*^9}, {
   3.6963303693134165`*^9, 3.6963303978226337`*^9}, {3.6963304304016657`*^9, 
   3.6963304306688375`*^9}, {3.6963304663227887`*^9, 3.696330504549904*^9}, {
   3.6964893253749247`*^9, 3.69648938526818*^9}, {3.6964894315438433`*^9, 
   3.696489575237809*^9}, {3.6964896383509145`*^9, 3.696489758916506*^9}, {
   3.7086651358926687`*^9, 3.7086651646922455`*^9}, {3.7095487740712676`*^9, 
   3.7095488338213882`*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {{}, 
     {RGBColor[0, 1, 0], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJwl2mVUFA8bhnEM7MYWsRUDBRXdvp8NxcRuRP42drdY2B3YjR3YLeruAkt3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       
       "]]}, {}}, {}, {}, {{}, {}}}, {{}, {{}, 
     {RGBColor[0, 0, 1], PointSize[0.007333333333333334], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJwl2ndcTY8fx/FsMorI3juVzd33c+69dvYqu0JIKpGdzJIvyQqZ3dG97b3r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       "]]}, {}}, {}, {}, {{}, {}}}, {{}, {{}, 
     {RGBColor[1, 0, 0], PointSize[0.0055000000000000005`], AbsoluteThickness[
      1.6], PointBox[CompressedData["
1:eJwl2mVYFA0bhmEERVEMxC5E7G6WrfvZQCywFTtfW8HA7u5uxcBGlC26G5GU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       
       "]]}, {}}, {}, {}, {{}, {}}}, {{}, {{}, 
     {GrayLevel[0], PointSize[0.0055000000000000005`], AbsoluteThickness[1.6],
       PointBox[CompressedData["
1:eJwl2ndcTY8fx/GMkPFtyIiM7K+93X0/955DRlbZsvfeoVRKhMi3iOyQLVtI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       "]]}, {}}, {}, {}, {{}, {}}}, 
   InsetBox["\<\"mixed receptors, with perfect adaptation\"\>", {35, 0.6}]},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{24.1, 0.},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {
     FormBox["\"Temperature\"", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  ImagePadding->All,
  Method->{"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& ), "CopiedValueFunction" -> ({
        (Part[{{Identity, Identity}, {Identity, Identity}}, 1, 2][#]& )[
         Part[#, 1]], 
        (Part[{{Identity, Identity}, {Identity, Identity}}, 2, 2][#]& )[
         Part[#, 2]]}& )}},
  PlotRange->{{24.1, 42.}, {-1, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6964893307459245`*^9, 3.696489432279188*^9, {3.6964894698154593`*^9, 
   3.6964894980768857`*^9}, {3.6964895352091703`*^9, 
   3.6964895757934103`*^9}, {3.6964896421050544`*^9, 
   3.6964896757865057`*^9}, {3.6964897079185605`*^9, 3.6964897268104005`*^9}, 
   3.696489760051068*^9, 3.696582587564105*^9, 3.704344718863399*^9, 
   3.7065977187645693`*^9, 3.7086650962497215`*^9, {3.7086651418222427`*^9, 
   3.708665166002946*^9}, {3.7095488193809643`*^9, 3.7095488409817295`*^9}}]
}, Open  ]]
},
WindowSize->{1368, 829},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 2054, 54, 117, "Input"],
Cell[2602, 76, 2503, 64, 107, "Input"],
Cell[5108, 142, 27009, 727, 1000, "Input"],
Cell[32120, 871, 70, 1, 30, "Input"],
Cell[32193, 874, 2788, 67, 183, "Input"],
Cell[CellGroupData[{
Cell[35006, 945, 7262, 130, 107, "Input"],
Cell[42271, 1077, 16468, 281, 264, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[58776, 1363, 3184, 77, 126, "Input"],
Cell[61963, 1442, 11063, 198, 262, "Output"]
}, Open  ]],
Cell[73041, 1643, 12737, 197, 164, "Input"],
Cell[CellGroupData[{
Cell[85803, 1844, 11801, 188, 88, "Input"],
Cell[97607, 2034, 19794, 318, 264, "Output"]
}, Open  ]],
Cell[117416, 2355, 391, 10, 30, "Input"],
Cell[CellGroupData[{
Cell[117832, 2369, 2461, 63, 88, "Input"],
Cell[120296, 2434, 9647, 177, 262, "Output"]
}, Open  ]],
Cell[129958, 2614, 376, 9, 30, "Input"],
Cell[CellGroupData[{
Cell[130359, 2627, 7271, 183, 297, "Input"],
Cell[137633, 2812, 62444, 1038, 264, "Output"]
}, Open  ]]
}
]
*)

