function lifespanCalc()
% lifespanCalc processes and saves
% the lifespans and baseline and stimulated activity
%
% LSCell contains lifespans for each worm
% al contains stimulated activity
% bl contains baselien activity
%
% Saved Excel data descriptions
% Lifespans contains lifespan vectors for each experimental condition
% AverageBaselineActivity contains average activity before light for 100
% frames
% AverageStimulatedActivity contains average activity after light for 100
% frames
% MaxBaselineActivity contains 95th percentile of activity before light
% MaxStimulatedActivity contains 95th percentile of activity after light
% MeanDifferenceActivity contains the difference between average activity
% after and before light
% MaxDifferenceActivity contains the difference between max activity after
% and before light
close all

foldername=uigetdir('Select Directory with .mat files');

cd(foldername)
filenames=uigetfile('*.mat','MultiSelect', 'on','Select the .mat files');

%%% Designate which wells correspond to which experimental conditions

% Change which wells correspond to which experimental conditions here
% Wells are numbered sequentially across from 1 to 240

% roi{1}=1:60;
% roi{2}=61:120;
% roi{3}=121:180;
% roi{4}=181:240;
roi{1}=1:30;
roi{2}=roi{1}+30;
roi{3}=roi{2}+30;
roi{4}=roi{3}+30;
roi{5}=roi{4}+30;
roi{6}=roi{5}+30;
roi{7}=roi{6}+30;
roi{8}=roi{7}+30;
numGenotypes=length(roi);

%
%
%%%

a=inputdlg('Please enter a file name to save the processed data:');
savename=(a{1});


b=inputdlg('Please enter experiment start day');
expstartday=str2num(b{1});

% make time vector
timept(1)=expstartday;
load imageTimeArray
dayv=imageTimeArray(:,3);
hourv=imageTimeArray(:,4);
for i=1:length(filenames)
    templ=length(filenames{i});
    
    % cut off the "pdata" in the beginning and ".mat" at the end
    % in order to get just the number
    filenum(i)=str2num(filenames{i}(6:(templ-4)));
    
    if i>1
        timeelapsed=(dayv(filenum(i))-dayv(filenum(i-1)));
        if timeelapsed>=0
            timept(i)=timept(i-1)+timeelapsed;
        else
            timept(i)=timept(i-1)+dayv(filenum(i))+31-dayv(filenum(i-1));
        end
    end
end
for i=1:length(filenames)
    templ=length(filenames{i});
    filenum(i)=str2num(filenames{i}(6:(templ-4)));
    timept(i)=timept(i)+hourv(filenum(i))/24;
end

framestouse=100;
%lastbeforelight=180;
%firstafterlight=184;

for i=1:length(filenames)
    load(filenames{i})
    pdata(pdata<0)=NaN;
    ll=length(pdata);
    lastbeforelight=round(ll/2)-1;
    firstafterlight=round(ll/2)+1;
    
    for j=1:240
        bl(i,j)=nanmean(pdata((lastbeforelight-framestouse):lastbeforelight,j));
        al(i,j)=nanmean(pdata((firstafterlight):(firstafterlight+framestouse),j));
        
        bm(i,j)=prctile(pdata(1:lastbeforelight,j),90);
        am(i,j)=prctile(pdata(firstafterlight:end,j),90);
    end
end

figure;
imagesc(al)
% add code here either asking user to select bad time points, or do it
% automatically

a=inputdlg('Please enter any regions of interest to censor (e.g. [3 61 198]):');
tomakenan=str2num(a{1});
al(:,tomakenan)=NaN;
bl(:,tomakenan)=NaN;
am(:,tomakenan)=NaN;
bm(:,tomakenan)=NaN;


a=inputdlg('Please enter any time points to censor (e.g. [ 30 31]):');
tomakenan=str2num(a{1});
al(tomakenan,:)=NaN;
bl(tomakenan,:)=NaN;
am(tomakenan,:)=NaN;
bm(tomakenan,:)=NaN;

% Initialize lifespan
ls=zeros(1,240);

% Find final timepoint of movement for each worm
% Base this on the stimulated activity
for j=1:240
    try
        
        temp=find(am(:,j)>0);
        lstemp=temp(end)+1;
        temp2=find(bm(:,j)>0);
        lstemp2=temp2(end)+1;
        lstemp=max([lstemp lstemp2]);
 
        ls(j)=timept(lstemp);

        bl(lstemp:end,j)=NaN;
        al(lstemp:end,j)=NaN;
        bm(lstemp:end,j)=NaN;
        am(lstemp:end,j)=NaN;
    catch
        ls(j)=NaN;
    end
   %display(num2str(j))
end

%try
for i=1:numGenotypes
    LSCell{i}=ls(roi{i});
    alc{i}=al(:,roi{i});
    blc{i}=bl(:,roi{i});
    alm{i}=am(:,roi{i});
    blm{i}=bm(:,roi{i});
    
    meandiff{i}=al(:,roi{i})-bl(:,roi{i});
    maxdiff{i}=am(:,roi{i})-bm(:,roi{i});
end

% Create lifespan curve

finalTime = 60; % total number of days to consider
pointsPerDay = 2; % time points per day
%lifespanTimeVector = [0:1/pointsPerDay:finalTime];
lifespanTimeVector = timept;
lifespanCurveMatrix = zeros(length(lifespanTimeVector),numGenotypes);

j=1;
for i = lifespanTimeVector
    for z = 1:numGenotypes
        currs=sum(isfinite(LSCell{z}));
        lifespanCurveMatrix(j,z) = 1-length(find(LSCell{z}<=i))/currs;
    end
    j=j+1;
end

% save lifespan vector, and matrices with baseline and stimulated activity

% .mat file
save(savename,'LSCell','blc','alc','blm','alm','meandiff','maxdiff','lifespanCurveMatrix','timept')

% three separate excel files
xlswrite([savename '_Lifespans'],[LSCell{1}' LSCell{2}' LSCell{3}' LSCell{4}'])
xlswrite([savename '_AverageBaselineActivity'],[blc{1}; blc{2}; blc{3}; blc{4};])
xlswrite([savename '_AverageStimulatedActivity'],[alc{1}; alc{2}; alc{3}; alc{4};])
xlswrite([savename '_MaxBaselineActivity'],[blm{1}; blm{2}; blm{3}; blm{4};])
xlswrite([savename '_MaxStimulatedActivity'],[alm{1}; alm{2}; alm{3}; alm{4};])
xlswrite([savename '_MeanDifferenceActivity'],[meandiff{1}; meandiff{2}; meandiff{3}; meandiff{4};])
xlswrite([savename '_MaxDifferenceActivity'],[maxdiff{1}; maxdiff{2}; maxdiff{3}; maxdiff{4};])
xlswrite([savename '_LSCurve'],[timept; lifespanCurveMatrix'])




