% lifespanMap.m produces lifespan activity heat maps for each experimental
% condition
% Assumes 4 experimental conditions
% By Matt Churgin. Last updated 22 Sep 2016

clear all
close all

close all
foldername=uigetdir('Select Directory with .mat files');

cd(foldername)
filename=uigetfile('*.mat','MultiSelect', 'on','Select the .mat files');
load(filename)

for i=1:4
    figure
    [y j]=sort(LSCell{i});
    j(isnan(y))=[];
    
    imagesc(timept,1:length(j),alc{i}(:,j)')
    hold on
    plot(LSCell{i}(j),1:length(j),'wx','LineWidth',3)
    colorbar
    xlabel('Time (Days)')
    ylabel('Worm #')
    set(gca,'FontSize',15)
end