clear all
close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];

for j=1:8
    figure
    [x y]=size(SL{j});
    plot(t,nanmean(BL{j},2),'--','Color',c{j},'LineWidth',2)
    hold on
    plot(t,nanmean(SL{j},2),'-','Color',c{j},'LineWidth',2)
    xlabel('Time (Days)')
    ylabel('Activity (Pixels Moved)')
    legend('Spontaneous Locomotion','Stimulated Locomotion')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    
    figure
    plot(t,nanmean(RD{j},2),'--','Color',c{j},'LineWidth',2)
    hold on
    plot(t,nanmean(L{j},2),'-','Color',c{j},'LineWidth',2)
    xlabel('Time (Days)')
    ylabel('Time (Seconds)')
    legend('Response Duration','Response Latency')
    legend boxoff
    box off
    set(gca,'FontSize',15)
end
%% plot average behavior for worms with different lifespans

clear all
close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
myshape{1}='-';
myshape{2}='--';
myshape{3}='o-';
myshape{4}='--';
myshape{5}='*-';

tiles=4;
for z=1:8
    figure
    for j=1:tiles
        
        jj=prctile(LSC{z},100/tiles*(j-1));
        jj2=prctile(LSC{z},100/tiles*j);
        
        temp=find((LSC{z}>jj).*(LSC{z}<(jj2)));
        
        
        days=[5:5:45];
        
        for i=1:length(days)
            inds(i)=max(find(t<=days(i)));
        end
        
        
            barB{z}(1,:)=nanmean(BL{z}(1:inds(1),temp),1);
            barS{z}(1,:)=nanmean(SL{z}(1:inds(1),temp),1);
            barR{z}(1,:)=nanmean(RD{z}(1:inds(1),temp),1);
            barL{z}(1,:)=nanmean(L{z}(1:inds(1),temp),1);
            barL2{z}(1,:)=nanmean(L2{z}(1:inds(1),temp),1);
            barRT{z}(1,:)=nanmean(RT{z}(1:inds(1),temp),1);
        
        
            for i=2:length(inds)
                barB{z}(i,:)=nanmean(BL{z}(inds(i-1):inds(i),temp),1);
                barS{z}(i,:)=nanmean(SL{z}(inds(i-1):inds(i),temp),1);
                barR{z}(i,:)=nanmean(RD{z}(inds(i-1):inds(i),temp),1);
                barL{z}(i,:)=nanmean(L{z}(inds(i-1):inds(i),temp),1);
                barL2{z}(i,:)=nanmean(L2{z}(inds(i-1):inds(i),temp),1);
                barRT{z}(i,:)=nanmean(RT{z}(inds(i-1):inds(i),temp),1);
            end
        
        
        for i=1:length(days)
            
                BM{z}(i)=nanmean(barB{z}(i,:));
                BS{z}(i)=nanstd(barB{z}(i,:));
                SM{z}(i)=nanmean(barS{z}(i,:));
                SS{z}(i)=nanstd(barS{z}(i,:));
                RM{z}(i)=nanmean(barR{z}(i,:));
                RS{z}(i)=nanstd(barR{z}(i,:));
                LM{z}(i)=nanmean(barL{z}(i,:));
                LS{z}(i)=nanstd(barL{z}(i,:));
                LM2{z}(i)=nanmean(barL2{z}(i,:));
                LS2{z}(i)=nanstd(barL2{z}(i,:));
                RT2{z}(i)=nanmean(barRT{z}(i,:));
                RS2{z}(i)=nanstd(barRT{z}(i,:));
            
        end
        
        
       if j==1     
           % errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
            hold on
            errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color',c{z},'LineWidth',2,'MarkerSize',10)
           %errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color','r','LineWidth',2,'MarkerSize',10)
            xlabel('Time (Days)')
            ylabel('Stimulated Activity (Pixels Moved)')
            legend('Lowest Quartile','Highest Quartile')
            legend boxoff
            box off
            set(gca,'FontSize',15)
            axis([0 45 0 450])
       elseif j==4            
           hold on
            errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color',c{z},'LineWidth',2,'MarkerSize',10)
            %errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color',[0 0.6 0],'LineWidth',2,'MarkerSize',10)
            xlabel('Time (Days)')
            ylabel('Stimulated Activity (Pixels Moved)')
            %legend('Lowest Quartile','Highest Quartile')
            legend('Short-lived','Long-lived')
            legend boxoff
            box off
            set(gca,'FontSize',15)
            axis([0 50 0 400])
       end
   
    clear temp barB barS barR barL barL2 barRT
     end
end

%% plot n2 high and low quartiles with daf-16 

clear all
close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
tiles=4;



days=[5:5:45];

for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end


for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:8
    if j==1
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),LSC{j}<prctile(LSC{j},25)),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    else
        barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    end
end
for j=1:8
    for i=2:length(inds)
        if j==1
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),LSC{j}<prctile(LSC{j},25)),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        else
            barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        end
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        LM2{j}(i)=nanmean(barL2{j}(i,:));
        LS2{j}(i)=nanstd(barL2{j}(i,:));
         RT2{j}(i)=nanmean(barRT{j}(i,:));
        RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
end


errorbar(days,SM{1},SS{1}/sqrt(length(barS{1})),'Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,SM{2},SS{2}/sqrt(length(barS{2})),'--','Color',c{2},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Stimulated Activity (Pixels Moved)')
legend('N2 (Lowest Quartile)','\it{daf-16}')
legend boxoff
box off
set(gca,'FontSize',15)
axis([0 50 0 400])

%% plot highest n2 quartile and daf-2

clear all
%close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
tiles=4;



days=[5:5:45];

for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end


for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:8
    if j==1
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),LSC{j}>prctile(LSC{j},75)),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    else
        barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    end
end
for j=1:8
    for i=2:length(inds)
        if j==1
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),LSC{j}>prctile(LSC{j},75)),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        else
            barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        end
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        LM2{j}(i)=nanmean(barL2{j}(i,:));
        LS2{j}(i)=nanstd(barL2{j}(i,:));
         RT2{j}(i)=nanmean(barRT{j}(i,:));
        RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
end

figure
errorbar(days,SM{1},SS{1}/sqrt(length(barS{1})),'Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,SM{3},SS{3}/sqrt(length(barS{3})),'--','Color',c{3},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Stimulated Activity (Pixels Moved)')
legend('N2 (Highest Quartile)','\it{daf-2}')
legend boxoff
box off
set(gca,'FontSize',15)
axis([0 50 0 400])
%% activity heat maps sorted by Lifespan
clear all
close all
load pooled_DA837

for j=1%:8
    [a1 a2]=sort(LSC{j});
    [x y]=size(SL{j});
    
    

    figure
    
    imagesc(t,1:y,SL{j}(:,a2)',[0 500])
    hold on
    plot(LSC{j}(a2),1:y,'wx','LineWidth',2)
    colorbar
    xlabel('Time (Days)')
    ylabel('Worm #')
    axis([1.5 31 1 y])
    set(gca,'FontSize',15)
    
    figure
    
    imagesc(t,1:y,BL{j}(:,a2)',[0 500])
    hold on
    plot(LSC{j}(a2),1:y,'wx','LineWidth',2)
    colorbar
    xlabel('Time (Days)')
    ylabel('Worm #')
    axis([1.5 31 1 y])
    set(gca,'FontSize',15)
%     
%     figure
%    
%     imagesc(t,1:y,L{j}(:,a2)',[0 10])
%     hold on
%     plot(LSC{j}(a2),1:y,'wx','LineWidth',2)
%     colorbar
%     xlabel('Time (Days)')
%     ylabel('Worm #')
%     axis([1.5 1.2*max(LSC{j}) 1 y])
%     set(gca,'FontSize',15)
end

numGenotypes=8;
finalTime = 31; % total number of days to consider
pointsPerDay = 2; % time points per day
lifespanTimeVector = [0:1/pointsPerDay:finalTime];
lifespanCurveMatrix = zeros(length(lifespanTimeVector),numGenotypes);
for i = lifespanTimeVector
    for z = 1%:numGenotypes
        hsb{z}(hsb{z}<2)=NaN;
        hsd{z}(hsd{z}<2)=NaN;
        hsl{z}(hsl{z}<2)=NaN;
        hss{z}(hss{z}<2)=NaN;
        
        currs=sum(isfinite(LSC{z}));
        currb=sum(isfinite(hsb{z}));
        currss=sum(isfinite(hss{z}));
        currd=sum(isfinite(hsd{z}));
        currl=sum(isfinite(hsl{z}));
        lifespanCurveMatrix(j,z) = 1-length(find(LSC{z}<=i))/currs;
        HSBMatrix(j,z) = 1-length(find(hsb{z}<=i))/currb;
        HSSMatrix(j,z) = 1-length(find(hss{z}<=i))/currss;
        HSDMatrix(j,z) = 1-length(find(hsd{z}<=i))/currd;
        HSLMatrix(j,z) = 1-length(find(hsl{z}<=i))/currl;
    end
    j=j+1;
end
figure

plot(lifespanTimeVector,lifespanCurveMatrix(:,1),'Color','k','LineWidth',3)
xlabel('Time (Days)')
ylabel('Fraction Alive')
box off
axis([0 31 0 1.01])
set(gca,'FontSize',15)
%% investigate latency
clear all
close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];


for j=1:8
    figure
    plot(t,nanmean(L{j},2),'Color',c{j},'LineWidth',2)
end

for j=1:8
    for i=1:length(LSC{j})
   plot(t,L{j}(:,i),'Color',c{j},'LineWidth',2)
   pause
    end
end


%% bar graphs
clear all
close all
load pooled_DA837


c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
days=[5:5:40];

for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:8
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
end
for j=1:8
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        LM2{j}(i)=nanmean(barL2{j}(i,:));
        LS2{j}(i)=nanstd(barL2{j}(i,:));
         RT2{j}(i)=nanmean(barRT{j}(i,:));
        RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
end


figure
for j=1:8
    for i=1:length(days)
        model_series(i,j)=BM{j}(i);
        model_error(i,j)=BS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:8
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',days)
xlabel('Time (Days)')
ylabel('Spontaneous Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
legend boxoff
set(gca,'FontSize',15)


figure
for j=1:8
    for i=1:length(days)
        model_series(i,j)=SM{j}(i);
        model_error(i,j)=SS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:8
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',days)
xlabel('Time (Days)')
ylabel('Stimulated Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
legend boxoff
set(gca,'FontSize',15)



figure
for j=1:8
    for i=1:length(days)
        model_series(i,j)=RM{j}(i);
        model_error(i,j)=RS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:8
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',days)
xlabel('Time (Days)')
ylabel('Response Duration (Seconds)')
%axis([0 8 0 0.3])
legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
legend boxoff
set(gca,'FontSize',15)


figure
for j=1:8
    for i=1:length(days)
        model_series(i,j)=LM{j}(i);
        model_error(i,j)=LS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:8
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',days)
xlabel('Time (Days)')
ylabel('Response Latency (Seconds)')
%axis([0 8 0 0.3])
legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
legend boxoff
set(gca,'FontSize',15)
%%
clear all
close all
load pooled_DA837


c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
days=[5:5:45];

for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:8
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RD{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
    barL2{j}(1,:)=nanmean(L2{j}(1:inds(1),:),1);
    barRT{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
end
for j=1:8
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RD{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
        barL2{j}(i,:)=nanmean(L2{j}(inds(i-1):inds(i),:),1);
         barRT{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        LM2{j}(i)=nanmean(barL2{j}(i,:));
        LS2{j}(i)=nanstd(barL2{j}(i,:));
         RT2{j}(i)=nanmean(barRT{j}(i,:));
        RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
end

for j=1:8
figure
errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,SM{j},SS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2)
xlabel('Time (Days)')
ylabel('Activity (Pixels Moved)')
legend('Spontaneous Locomotion','Stimulated Locomotion')
legend boxoff
box off
set(gca,'FontSize',15)
axis([0 50 0 400])
end


for j=1:8
figure
hold on
errorbar(days,LM{j},LS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2,'MarkerSize',10)
%errorbar(days,RM{j},RS{j}/sqrt(length(barB{j})),'x:','Color',c{j},'LineWidth',2,'MarkerSize',10)

errorbar(days,RT2{j},RS2{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Time (Seconds)')
legend('Response Latency','Response Duration')
legend boxoff
box off
set(gca,'FontSize',15)
axis([0 50 0 900])
end

figure
errorbar(days,BM{1},BS{1}/sqrt(length(barS{1})),'-','Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,BM{2},BS{2}/sqrt(length(barS{2})),':','Color',c{2},'LineWidth',2,'MarkerSize',10)
errorbar(days,BM{3},BS{3}/sqrt(length(barS{3})),'--','Color',c{3},'LineWidth',2,'MarkerSize',10)
hold on
xlabel('Time (Days)')
ylabel('Spontaneous Activity (Pixels Moved)')

box off
set(gca,'FontSize',15)
legend('N2','\it{daf-16}','\it{daf-2}')
legend boxoff
axis([0 50 0 250])


figure
errorbar(days,SM{1},SS{1}/sqrt(length(barS{1})),'-','Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,SM{2},SS{2}/sqrt(length(barS{2})),':','Color',c{2},'LineWidth',2,'MarkerSize',10)
errorbar(days,SM{3},SS{3}/sqrt(length(barS{3})),'--','Color',c{3},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Stimulated Activity (Pixels Moved)')
legend('N2','\it{daf-16}','\it{daf-2}')
legend boxoff
axis([0 50 0 360])
box off
set(gca,'FontSize',15)




figure

errorbar(days,RT2{1},RS2{1}/sqrt(length(barS{1})),'-','Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,RT2{2},RS2{2}/sqrt(length(barS{2})),':','Color',c{2},'LineWidth',2,'MarkerSize',10)
errorbar(days,RT2{3},RS2{3}/sqrt(length(barS{3})),'--','Color',c{3},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Response Duration (Seconds)')
box off
set(gca,'FontSize',15)
legend('N2','\it{daf-16}','\it{daf-2}')
legend boxoff
axis([0 50 0 450])

figure
errorbar(days,LM{1},LS{1}/sqrt(length(barS{1})),'-','Color',c{1},'LineWidth',2,'MarkerSize',10)
hold on
errorbar(days,LM{2},LS{2}/sqrt(length(barS{2})),':','Color',c{2},'LineWidth',2,'MarkerSize',10)
errorbar(days,LM{3},LS{3}/sqrt(length(barS{3})),'--','Color',c{3},'LineWidth',2,'MarkerSize',10)
xlabel('Time (Days)')
ylabel('Response Latency (Seconds)')
box off
set(gca,'FontSize',15)
legend('N2','\it{daf-16}','\it{daf-2}')
legend boxoff
axis([0 50 0 800])