clear all
close all
load pooled_RNAi
c{1}=[0 0 0];
c{2}=[0.8 0 0.7];
c{3}=[0.95 0.5 0.1];
c{4}=[0.5 0.3 0.75];
c{5}=[0.5 0.8 0.2];
c{6}=[0.8 0.2 0.3];
c{7}=[0.9 0.8 0.2];
c{8}=[0.3 0.9 0.6];
c{9}=[0 .2 .9];


for j=1:9
    figure
    
    plot(t,nanmean(BL{j},2),'--','Color',c{j},'LineWidth',2)
    hold on
    plot(t,nanmean(SL{j},2),'-','Color',c{j},'LineWidth',2)
    xlabel('Time (Days)')
    ylabel('Activity (Pixels Moved)')
    legend('Spontaneous Locomotion','Stimulated Locomotion')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    
    figure
    plot(t,nanmean(RD{j},2),'--','Color',c{j},'LineWidth',2)
    hold on
    plot(t,nanmean(L{j},2),'-','Color',c{j},'LineWidth',2)
    xlabel('Time (Days)')
    ylabel('Time (Seconds)')
    legend('Response Duration','Response Latency')
    legend boxoff
    box off
    set(gca,'FontSize',15)
end

%% activity heat maps sorted by Lifespan
clear all
close all
load pooled_RNAi

for j=1:9
    [a1 a2]=sort(LSC{j});
    [x y]=size(SL{j});
   
    figure
    
    imagesc(t,1:y,SL{j}(:,a2)',[0 500])
    hold on
    plot(LSC{j}(a2),1:y,'wx','LineWidth',2)
    colorbar
    xlabel('Time (Days)')
    ylabel('Worm #')
    axis([1.5 1.05*max(LSC{j}) 1 y])
    set(gca,'FontSize',15)
end
%% bar graphs
clear all
close all
load pooled_RNAi


c{1}=[0 0 0];
c{2}=[0.8 0 0.7];
c{3}=[0.95 0.5 0.1];
c{4}=[0.5 0.3 0.75];
c{5}=[0.5 0.8 0.2];
c{6}=[0.8 0.2 0.3];
c{7}=[0.9 0.8 0.2];
c{8}=[0.3 0.9 0.6];
c{9}=[0 .2 .9];

days=[10:10:20];
for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:9
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    barBR{j}(1,:)=nanmean(RB{j}(1:inds(1),:),1);
    barBR{j}(1,:)=nanmean(RB{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
end
for j=1:9
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        barBR{j}(i,:)=nanmean(RB{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
    end
end

for i=1:length(days)
    for j=1:9
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        RM2{j}(i)=nanmean(barBR{j}(i,:));
        RS2{j}(i)=nanstd(barBR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
    end
end


figure
for j=1:9
    for i=[1 length(days)]
        model_series(i,j)=BM{j}(i);
        model_error(i,j)=BS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:9
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Spontaneous Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)


figure
for j=1:9
    for i=[1 length(days)]
        model_series(i,j)=SM{j}(i);
        model_error(i,j)=SS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:9
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Stimulated Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)



figure
for j=1:9
    for i=[1 length(days)]
        model_series(i,j)=RM{j}(i);
        model_error(i,j)=RS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:9
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Response Duration (Seconds)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)


figure
for j=1:9
    for i=[1 length(days)]
        model_series(i,j)=LM{j}(i);
        model_error(i,j)=LS{j}(i)/sqrt(length(barB{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:9
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Response Latency (Seconds)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)



figure
for j=1:9
    for i=[1 length(days)]
        model_series(i,j)=RM2{j}(i);
        model_error(i,j)=RS2{j}(i)/sqrt(length(barBR{j}));
    end
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:9
    set(h(j),'FaceColor',c{j})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Response Duration (Baseline) (Seconds)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)

%% simpler bar graphs
clear all
close all
load pooled_RNAi


c{1}=[0 0 0];
c{2}=[0.8 0 0.7];
c{3}=[0.95 0.5 0.1];
c{4}=[0.5 0.3 0.75];
c{5}=[0.5 0.8 0.2];
c{6}=[0.8 0.2 0.3];
c{7}=[0.9 0.8 0.2];
c{8}=[0.3 0.9 0.6];
c{9}=[0 .2 .9];
toplot=[1 7 2 8];
%toplot=[1 4 3 6];
days=[10:10:20];
for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:9
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    barBR{j}(1,:)=nanmean(RB{j}(1:inds(1),:),1);
    barBR{j}(1,:)=nanmean(RB{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
end
for j=1:9
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        barBR{j}(i,:)=nanmean(RB{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
    end
end

for i=1:length(days)
    for j=1:9
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        RM2{j}(i)=nanmean(barBR{j}(i,:));
        RS2{j}(i)=nanstd(barBR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
    end
end


figure
k=1;
for j=toplot
    for i=[1 length(days)]
        model_series(i,k)=BM{j}(i);
        model_error(i,k)=BS{j}(i)/sqrt(length(barB{j}));
    end
    k=k+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:(k-1)
    set(h(j),'FaceColor',c{toplot(j)})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Spontaneous Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)


figure
k=1;
for j=toplot
    for i=[1 length(days)]
        model_series(i,k)=SM{j}(i);
        model_error(i,k)=SS{j}(i)/sqrt(length(barB{j}));
    end
    k=k+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:(k-1)
    set(h(j),'FaceColor',c{toplot(j)})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Stimulated Locomotion (Pixels Moved)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)



figure
k=1
for j=toplot
    for i=[1 length(days)]
        model_series(i,k)=RM{j}(i);
        model_error(i,k)=RS{j}(i)/sqrt(length(barB{j}));
    end
    k=k+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:(k-1)
    set(h(j),'FaceColor',c{toplot(j)})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Response Duration (Seconds)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)


figure
k=1;
for j=toplot
    for i=[1 length(days)]
        model_series(i,k)=LM{j}(i);
        model_error(i,k)=LS{j}(i)/sqrt(length(barB{j}));
    end
    k=k+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
for j=1:(k-1)
    set(h(j),'FaceColor',c{toplot(j)})
end
set(get(gca,'YLabel'),'String','Quiescent Fraction')
lh = legend('Fasting','Feeding');
set(lh,'Location','BestOutside','Orientation','vertical')
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
box off
%set(gca,'YTick',[0:0.1:1])
%set(gca,'XTick',[1:length(days)])
set(gca,'XTickLabel',[])
%xlabel('Time (Days)')
ylabel('Response Latency (Seconds)')
%axis([0 8 0 0.3])
legend('N2+EV','\it{daf-2+EV}','\it{odr-10+EV}','N2+daf-2 RNAi','\it{daf-2+daf-2 RNAi}','\it{odr-10+daf-2 RNAi}','N2+odr-10 RNAi','\it{daf-2+odr-10 RNAi}','\it{odr-10+odr-10 RNAi}');
legend boxoff
set(gca,'FontSize',20)


%% line graphs
clear all
close all
load pooled_RNAi


c{1}=[0 0 0];
c{2}=[0.8 0 0.7];
c{3}=[0.95 0.5 0.1];
c{4}=[0.5 0.3 0.75];
c{5}=[0.5 0.8 0.2];
c{6}=[0.8 0.2 0.3];
c{7}=[0.9 0.8 0.2];
c{8}=[0.3 0.9 0.6];
c{9}=[0 .2 .9];

days=[5:5:55];
for i=1:length(days)
    inds(i)=max(find(t<=days(i)));
end

for j=1:9
    barB{j}(1,:)=nanmean(BL{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SL{j}(1:inds(1),:),1);
    barR{j}(1,:)=nanmean(RT{j}(1:inds(1),:),1);
    barBR{j}(1,:)=nanmean(RB{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(L{j}(1:inds(1),:),1);
end
for j=1:9
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BL{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SL{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RT{j}(inds(i-1):inds(i),:),1);
        barBR{j}(i,:)=nanmean(RB{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(L{j}(inds(i-1):inds(i),:),1);
    end
end

for i=1:length(days)
    for j=1:9
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        RM2{j}(i)=nanmean(barBR{j}(i,:));
        RS2{j}(i)=nanstd(barBR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
    end
end

for j=1:9
   figure
   errorbar(days,BM{j},BS{j}/sqrt(length(LSC{j})),'LineWidth',2)
   hold on
   errorbar(days,SM{j},SS{j}/sqrt(length(LSC{j})),'LineWidth',2)
   
   figure
   errorbar(days,RM{j},RS{j}/sqrt(length(LSC{j})),'LineWidth',2)
   hold on
   errorbar(days,RM2{j},RS2{j}/sqrt(length(LSC{j})),'LineWidth',2)
   errorbar(days,LM{j},LS{j}/sqrt(length(LSC{j})),'LineWidth',2)
end