%% resample all behavior data in time from 0 to 100% of lifespan
clear all
close all
clear all
close all
load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];


trs=[1:length(t)]/length(t);

for j=1:8
    [x y]=size(SL{j});
    for i=1:y
        temp=find(isnan(BL{j}(:,i)));
        BLR{j}(:,i)=resample(BL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        SLR{j}(:,i)=resample(SL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        LLR{j}(:,i)=resample(L{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        RTR{j}(:,i)=resample(RT{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
    end
end

%%
close all
for j=1
    [a1 a2]=sort(LSC{j});
    
    %    figure
    %     imagesc(trs,1:y,SLR{j}(:,a2)',[0 500])
    %     colorbar
    %     xlabel('Time (Fraction of Life)')
    %     ylabel('Worm #')
    %     axis([trs(1) 1 1 y])
    %     set(gca,'FontSize',15)
    [x y]=size(SL{j});
    figure
    imagesc(t,1:y,SL{j}(:,a2)',[0 500])
    colorbar
    hold on
    plot(LSC{j}(a2),1:y,'wx','LineWidth',2)
    xlabel('Time (Days)')
    ylabel('Worm #')
    %axis([trs(1) 1 1 y])
    set(gca,'FontSize',15)
    
     figure
    imagesc(trs,1:y,SLR{j}(:,a2)',[0 500])
    colorbar
    xlabel('Time (Fraction of Life)')
    ylabel('Worm #')
    axis([trs(1) 1 1 y])
    set(gca,'FontSize',15)
end
%% plot all together
close all
days=[trs(1):0.1:1.1];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
end


for j=1:8
    barB{j}(1,:)=nanmean(BLR{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),:),1);
    %barB{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}<=0.5*max(LSC{j})),1);
    %barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}>0.5*max(LSC{j})),1);
    barR{j}(1,:)=nanmean(RTR{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(LLR{j}(1:inds(1),:),1);
    %barR{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}<=0.5*max(LSC{j})),1);
    %barL{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}>0.5*max(LSC{j})),1);
end
for j=1:8
    for i=2:length(inds)
        barB{j}(i,:)=nanmean(BLR{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),:),1);
        %barB{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}<=0.5*max(LSC{j})),1);
        %barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}>0.5*max(LSC{j})),1);
        barR{j}(i,:)=nanmean(RTR{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),:),1);
        %barR{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}<=0.5*max(LSC{j})),1);
        %barL{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}>0.5*max(LSC{j})),1);
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        %         LM2{j}(i)=nanmean(barL2{j}(i,:));
        %         LS2{j}(i)=nanstd(barL2{j}(i,:));
        %          RT2{j}(i)=nanmean(barRT{j}(i,:));
        %         RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
end
days=days-trs(1);

for j=1:8
    figure
    errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
    hold on
    errorbar(days,SM{j},SS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2)
    xlabel('Time (Fraction of Life)')
    ylabel('Activity (Pixels Moved)')
    legend('Spontaneous Locomotion','Stimulated Locomotion')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([0 1.02 0 400])
end


for j=1:8
    figure
    hold on
    errorbar(days,LM{j},LS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2,'MarkerSize',10)
    errorbar(days,RM{j},RS{j}/sqrt(length(barB{j})),'x:','Color',c{j},'LineWidth',2,'MarkerSize',10)
    
    %errorbar(days,RT2{j},RS2{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
    xlabel('Time (Fraction of Life)')
    ylabel('Time (Seconds)')
    legend('Response Latency','Response Duration')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([0 1.02 0 900])
end

%% plot behavior curve based on quartiles
close all
clear temp barB barS barR barL barL2 barRT
c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];
myshape{1}='-';
myshape{2}='--';
myshape{3}='o-';
myshape{4}='--';
myshape{5}='*-';

tiles=4;
for z=1:8
    figure
    for j=1:tiles
        
        jj=prctile(LSC{z},100/tiles*(j-1));
        jj2=prctile(LSC{z},100/tiles*j);
        
        temp=find((LSC{z}>jj).*(LSC{z}<(jj2)));
        
        
        days=[trs(1):0.1:1.1];
        
        for i=1:length(days)
            inds(i)=max(find(trs<=days(i)));
        end
        
        
            barB{z}(1,:)=nanmean(BLR{z}(1:inds(1),temp),1);
            barS{z}(1,:)=nanmean(SLR{z}(1:inds(1),temp),1);
            barR{z}(1,:)=nanmean(RTR{z}(1:inds(1),temp),1);
            barL{z}(1,:)=nanmean(LLR{z}(1:inds(1),temp),1);
           
        
        
            for i=2:length(inds)
                barB{z}(i,:)=nanmean(BLR{z}(inds(i-1):inds(i),temp),1);
                barS{z}(i,:)=nanmean(SLR{z}(inds(i-1):inds(i),temp),1);
                barR{z}(i,:)=nanmean(RTR{z}(inds(i-1):inds(i),temp),1);
                barL{z}(i,:)=nanmean(LLR{z}(inds(i-1):inds(i),temp),1);
              
            end
        
        
        for i=1:length(days)
            
                BM{z}(i)=nanmean(barB{z}(i,:));
                BS{z}(i)=nanstd(barB{z}(i,:));
                SM{z}(i)=nanmean(barS{z}(i,:));
                SS{z}(i)=nanstd(barS{z}(i,:));
                RM{z}(i)=nanmean(barR{z}(i,:));
                RS{z}(i)=nanstd(barR{z}(i,:));
                LM{z}(i)=nanmean(barL{z}(i,:));
                LS{z}(i)=nanstd(barL{z}(i,:));
                
            
        end
        STIM{z}{j}=SM{z};
        STIMS{z}{j}=SS{z};
        STIML{z}{j}=(barS{z});
        
        
          if j==1  
           % errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
            hold on
            errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color',c{z},'LineWidth',2,'MarkerSize',10)
            xlabel('Time (Fraction of Life)')
            ylabel('Stimulated Activity (Pixels Moved)')
            %legend('Quartile 1','Quartile 2','Quartile 3','Quartile 4')
            %legend('Lifespan Below Median','Lifespan Above Median')
            legend('Lowest Quartile','Highest Quartile')
            legend boxoff
            box off
            set(gca,'FontSize',15)
            axis([0 1.1 0 400])
            set(gca,'YTick',[0:100:400])
          elseif j==4
                          hold on
            errorbar(days,SM{z},SS{z}/sqrt(length(barS{z})),myshape{j},'Color',c{z},'LineWidth',2,'MarkerSize',10)
            xlabel('Time (Fraction of Life)')
            ylabel('Stimulated Activity (Pixels Moved)')
            %legend('Quartile 1','Quartile 2','Quartile 3','Quartile 4')
            %legend('Lifespan Below Median','Lifespan Above Median')
            legend('Lowest Quartile','Highest Quartile')
            legend boxoff
            box off
            set(gca,'FontSize',15)
            axis([0 1.1 0 400])
            set(gca,'YTick',[0:100:400])
          end
        
    %plot(t,nanmean(BL{j},2),'--','Color',c{j},'LineWidth',2)
%     hold on
%     plot(t,nanmean(L{z}(:,temp),2),myshape{j},'LineWidth',2)
%     xlabel('Time (Days)')
%     ylabel('Activity (Pixels Moved)')
%     legend('Quartile 1','Quartile 2','Quartile 3','Quartile 4')
%     legend boxoff
%     box off
%     set(gca,'FontSize',15)
    
%     figure
%     plot(t,nanmean(RD{j},2),'--','Color',c{j},'LineWidth',2)
%     hold on
%     plot(t,nanmean(L{j},2),'-','Color',c{j},'LineWidth',2)
%     xlabel('Time (Days)')
%     ylabel('Time (Seconds)')
%     legend('Response Duration','Response Latency')
%     legend boxoff
%     box off
%     set(gca,'FontSize',15)
    clear temp barB barS barR barL barL2 barRT
     end
end
%%

for z=[1 3]
    for j=[1 4]
        figure
        if j==1
            errorbar(days,STIM{z}{j},STIMS{z}{j}/sqrt(length(STIML{z}{j})),'Color','r','LineWidth',2,'MarkerSize',10)
            legend('Short-lived')
            legend boxoff
        else
            errorbar(days,STIM{z}{j},STIMS{z}{j}/sqrt(length(STIML{z}{j})),'Color',[0 0.7 0],'LineWidth',2,'MarkerSize',10)
            legend('Long-lived')
            legend boxoff
        end
        xlabel('Time (Fraction of Life)')
        ylabel('Stimulated Activity (Pixels Moved)')
        set(gca,'FontSize',15)
        axis([-0.05 1.05 0 400])
        box off
    end
end

%% separate by upper and lower halves

close all
days=[trs(1):0.1:1.1];
forslope=[3:5];
forslope2=[6:10];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
end


for j=1:8
    
    barB{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}<=prctile(LSC{j},25)),1);
    barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}>prctile(LSC{j},75)),1);
    
    barR{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}<=prctile(LSC{j},50)),1);
    barL{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}>prctile(LSC{j},50)),1);
end
for j=1:8
    for i=2:length(inds)
        
        barB{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}<=prctile(LSC{j},25)),1);
        barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}>prctile(LSC{j},75)),1);
        
        barR{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}<=prctile(LSC{j},50)),1);
        barL{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}>prctile(LSC{j},50)),1);
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        %         LM2{j}(i)=nanmean(barL2{j}(i,:));
        %         LS2{j}(i)=nanstd(barL2{j}(i,:));
        %          RT2{j}(i)=nanmean(barRT{j}(i,:));
        %         RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
    
end


for j=1:8
    [EM{j} EM2{j}]=polyfit(days(forslope),BM{j}(forslope),1);
    EM{j}=EM{j}(1);
    [ES{j} ES2{j}]=polyfit(days(forslope),SM{j}(forslope),1);
    ES{j}=ES{j}(1);
    
    [PM{j} PM2{j}]=polyfit(days(forslope2),BM{j}(forslope2),1);
    PM{j}=PM{j}(1);
    [PS{j} PS2{j}]=polyfit(days(forslope2),SM{j}(forslope2),1);
    PS{j}=PS{j}(1);
    
end

days=days-trs(1);

for j=1:8
    figure
    errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
    hold on
    errorbar(days,SM{j},SS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2)
    xlabel('Time (Fraction of Life)')
    ylabel('Stimulated Activity (Pixels Moved)')
    legend('Short-Lived','Long-Lived')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([0 1.02 0 450])
end


% for j=1:8
% figure
% hold on
% errorbar(days,LM{j},LS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2,'MarkerSize',10)
% errorbar(days,RM{j},RS{j}/sqrt(length(barB{j})),'x:','Color',c{j},'LineWidth',2,'MarkerSize',10)
%
% %errorbar(days,RT2{j},RS2{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
% xlabel('Time (PFraction of Life)')
% ylabel('Time (Seconds)')
% legend('Short-Lived','Long-Lived')
% legend boxoff
% box off
% set(gca,'FontSize',15)
% axis([0 1.02 0 900])
% end

%% compare long-lived and short-lived early/late slopes
close all
clear all

load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];

trs=[1:length(t)]/length(t);

for j=1:8
    [x y]=size(SL{j});
    for i=1:y
        temp=find(isnan(BL{j}(:,i)));
        BLR{j}(:,i)=resample(BL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        SLR{j}(:,i)=resample(SL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        LLR{j}(:,i)=resample(L{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        RTR{j}(:,i)=resample(RT{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
    end
end

days=[trs(1):0.1:1.1];
forslope=[3:7];
forslope2=[7:11];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
end


for j=1:8
    
    barB{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}<=prctile(LSC{j},25)),1);
    barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}>=prctile(LSC{j},75)),1);
    
    barR{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}<=prctile(LSC{j},50)),1);
    barL{j}(1,:)=nanmean(LLR{j}(1:inds(1),LSC{j}>prctile(LSC{j},50)),1);
end
for j=1:8
    for i=2:length(inds)
        
        barB{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}<=prctile(LSC{j},25)),1);
        barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}>=prctile(LSC{j},75)),1);
        
        barR{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}<=prctile(LSC{j},50)),1);
        barL{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),LSC{j}>prctile(LSC{j},50)),1);
    end
end

for i=1:length(days)
    for j=1:8
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        RM{j}(i)=nanmean(barR{j}(i,:));
        RS{j}(i)=nanstd(barR{j}(i,:));
        LM{j}(i)=nanmean(barL{j}(i,:));
        LS{j}(i)=nanstd(barL{j}(i,:));
        %         LM2{j}(i)=nanmean(barL2{j}(i,:));
        %         LS2{j}(i)=nanstd(barL2{j}(i,:));
        %          RT2{j}(i)=nanmean(barRT{j}(i,:));
        %         RS2{j}(i)=nanstd(barRT{j}(i,:));
    end
    
end


shortEarlySlopes=cell(1,8);
longEarlySlopes=cell(1,8);
shortLateSlopes=cell(1,8);
longLateSlopes=cell(1,8);
for j=1:8
    [x y]=size(barB{j});
    [x2 y2]=size(barS{j});
    for i=1:y
        [temp temp2]=polyfit(days(forslope),barB{j}(forslope,i)',1);
        shortEarlySlopes{j}=[shortEarlySlopes{j} -.1*temp(1)];
        [temp temp2]=polyfit(days(forslope2),barB{j}(forslope2,i)',1);
        shortLateSlopes{j}=[shortLateSlopes{j} -.1*temp(1)];
    end
    for i=1:y2
        [temp temp2]=polyfit(days(forslope),barS{j}(forslope,i)',1);
        longEarlySlopes{j}=[longEarlySlopes{j} -.1*temp(1)];
        [temp temp2]=polyfit(days(forslope2),barS{j}(forslope2,i)',1);
        longLateSlopes{j}=[longLateSlopes{j} -.1*temp(1)];
    end
end



figure
j=1;
for i=[1 2 3 4 5 6 8]
    
    temp1=longLateSlopes{i}-longEarlySlopes{i};
    temp2=shortLateSlopes{i}-shortEarlySlopes{i};
    model_series(j,1)=mean(temp2);
    model_error(j,1)=std(temp2)/sqrt(length(temp2));
    model_series(j,2)=mean(temp1);
    model_error(j,2)=std(temp1)/sqrt(length(temp1));
    j=j+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
    set(h(1),'FaceColor',[1 1 1])
    set(h(2),'FaceColor',[0.5 0.5 0.5])
% for j=1:8
%     set(h(j),'FaceColor',c{j})
% end
set(get(gca,'YLabel'),'String','Change in Decline Rate (Pixels/Life Fraction)')
set(gca,'XTickLabel',[])
set(gca,'XTick',[])
set(gca,'FontSize',15)
legend('Lowest Quartile','Highest Quartile')
legend boxoff
box off
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
%axis([0 9 0 550])





figure
j=1;
for i=[1 2 3 4 5 6 8]
    
    model_series(j,1)=mean(shortEarlySlopes{j});
    model_error(j,1)=std(shortEarlySlopes{j})/sqrt(length(shortEarlySlopes{j}));
    model_series(j,2)=mean(shortLateSlopes{j});
    model_error(j,2)=std(shortLateSlopes{j})/sqrt(length(shortLateSlopes{j}));
    
    model_series(j,3)=mean(longEarlySlopes{j});
    model_error(j,3)=std(longEarlySlopes{j})/sqrt(length(longEarlySlopes{j}));
    model_series(j,4)=mean(longLateSlopes{j});
    model_error(j,4)=std(longLateSlopes{j})/sqrt(length(longLateSlopes{j}));
    j=j+1;
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
    set(h(1),'FaceColor',[1 1 1])
    set(h(2),'FaceColor',[0.5 0.5 0.5])
    set(h(3),'FaceColor',[0.8 0.8 0.8])
    set(h(4),'FaceColor',[0.3 0.3 0.3])
% for j=1:8
%     set(h(j),'FaceColor',c{j})
% end
set(get(gca,'YLabel'),'String','Activity Decline Rate (Pixels/Life Fraction)')
set(gca,'XTickLabel',[])
set(gca,'XTick',[])
set(gca,'FontSize',15)
legend('Lowest Quartile Early Life','Lowest Quartile Late Life','Highest Quartile Early Life','Highest Quartile Late Life')
legend boxoff
box off
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
%axis([0 9 0 550])

for j=1:8
[a1 b1{j} c1]=ttest2(shortEarlySlopes{j},longEarlySlopes{j});
[a2 b2{j} c2]=ttest2(shortLateSlopes{j},longLateSlopes{j});
[a2 b3{j} c2]=ttest2(shortEarlySlopes{j},shortLateSlopes{j});
[a2 b4{j} c2]=ttest2(longEarlySlopes{j},longLateSlopes{j});
[a2 b5{j} c2]=ttest2(shortLateSlopes{j}-shortEarlySlopes{j},longLateSlopes{j}-longEarlySlopes{j});
end

%% plot change in decay rate versus life span
close all
clear all

load pooled_DA837

c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];

trs=[1:length(t)]/length(t);

for j=1:8
    [x y]=size(SL{j});
    for i=1:y
        temp=find(isnan(BL{j}(:,i)));
        BLR{j}(:,i)=resample(BL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        SLR{j}(:,i)=resample(SL{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        LLR{j}(:,i)=resample(L{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
        RTR{j}(:,i)=resample(RT{j}(1:(temp(1)-1),i),length(t),temp(1)-1);
    end
end

days=[trs(1):0.1:1.1];
forslope=[3:7];
forslope2=[7:11];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
end


for j=1:8
    
    barB{j}(1,:)=nanmean(BLR{j}(1:inds(1),:),1);
    barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),:),1);
     barR{j}(1,:)=nanmean(RTR{j}(1:inds(1),:),1);
    barL{j}(1,:)=nanmean(LLR{j}(1:inds(1),:),1);
end
for j=1:8
    for i=2:length(inds)
        
        barB{j}(i,:)=nanmean(BLR{j}(inds(i-1):inds(i),:),1);
        barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),:),1);
        barR{j}(i,:)=nanmean(RTR{j}(inds(i-1):inds(i),:),1);
        barL{j}(i,:)=nanmean(LLR{j}(inds(i-1):inds(i),:),1);
    end
end

sEarlySlopes=cell(1,8);
lEarlySlopes=cell(1,8);
bEarlySlopes=cell(1,8);
rEarlySlopes=cell(1,8);
sLateSlopes=cell(1,8);
lLateSlopes=cell(1,8);
bLateSlopes=cell(1,8);
rLateSlopes=cell(1,8);
for j=1:8
    [x y]=size(barB{j});
    
    for i=1:y
        [temp temp2]=polyfit(days(forslope),barB{j}(forslope,i)',1);
        bEarlySlopes{j}=[bEarlySlopes{j} -temp(1)];
        [temp temp2]=polyfit(days(forslope2),barB{j}(forslope2,i)',1);
        bLateSlopes{j}=[bLateSlopes{j} -temp(1)];
        
        [temp temp2]=polyfit(days(forslope),barS{j}(forslope,i)',1);
        sEarlySlopes{j}=[sEarlySlopes{j} -.1*temp(1)];
        [temp temp2]=polyfit(days(forslope2),barS{j}(forslope2,i)',1);
        sLateSlopes{j}=[sLateSlopes{j} -.1*temp(1)];
%         
        %use the following to calculate absolute decline rate
%         [temp temp2]=polyfit(days(forslope)*LSC{j}(i),barS{j}(forslope,i)',1);
%         sEarlySlopes{j}=[sEarlySlopes{j} -temp(1)];
%         [temp temp2]=polyfit(days(forslope2)*LSC{j}(i),barS{j}(forslope2,i)',1);
%         sLateSlopes{j}=[sLateSlopes{j} -temp(1)];
        
                [temp temp2]=polyfit(days(forslope),barL{j}(forslope,i)',1);
        lEarlySlopes{j}=[lEarlySlopes{j} -temp(1)];
        [temp temp2]=polyfit(days(forslope2),barL{j}(forslope2,i)',1);
        lLateSlopes{j}=[lLateSlopes{j} -temp(1)];
        
                [temp temp2]=polyfit(days(forslope),barR{j}(forslope,i)',1);
        rEarlySlopes{j}=[rEarlySlopes{j} -temp(1)];
        [temp temp2]=polyfit(days(forslope2),barR{j}(forslope2,i)',1);
        rLateSlopes{j}=[rLateSlopes{j} -temp(1)];
    end

end


for j=1:8
    bratechange{j}=bLateSlopes{j}-bEarlySlopes{j};
    sratechange{j}=sLateSlopes{j}-sEarlySlopes{j};
    lratechange{j}=lLateSlopes{j}-lEarlySlopes{j};
    rratechange{j}=rLateSlopes{j}-rEarlySlopes{j};
end
%
close all

myshape{1}='o-';
myshape{2}='s-';
myshape{3}='^-';
myshape{4}='d-';
myshape{5}='<-';
myshape{6}='p-';
myshape{7}='x-';
myshape{8}='h-';
C{1}=[1 0 0];
C{2}=[0 0 0];
x=0:1:50;
tiles=4;
for z=[1 2 3 4 5 6 8]
    [rt pt]=corrcoef(LSC{z},bratechange{z});
    rb{z}=rt(1,2);
    pb{z}=pt(1,2);
        [rt pt]=corrcoef(LSC{z},sratechange{z});
    rs{z}=rt(1,2);
    ps{z}=pt(1,2);
        [rt pt]=corrcoef(LSC{z},lratechange{z});
    rl{z}=rt(1,2);
    pl{z}=pt(1,2);
        [rt pt]=corrcoef(LSC{z},rratechange{z});
    rr{z}=rt(1,2);
    pr{z}=pt(1,2);
    
    for j=1:tiles

        jj=prctile(LSC{z},100/tiles*(j-1));
        jj2=prctile(LSC{z},100/tiles*j);
        %temp=find((LSC{z}>=jj).*(LSC{z}<=(jj2)));
        if j==1
            temp=find((LSC{z}>=jj).*(LSC{z}<=(jj2)));
        elseif j==2
            temp=find((LSC{z}>jj).*(LSC{z}<(jj2)));
        elseif j==3
            temp=find((LSC{z}>=jj).*(LSC{z}<(jj2)));
        elseif j==4
            temp=find((LSC{z}>=jj).*(LSC{z}<=(jj2)));
        end
        
        BinLSCell{z}(j)=nanmean(LSC{z}(temp));
        BinLSCellStd{z}(j)=nanstd(LSC{z}(temp))/sqrt(length(temp));
        
        
        BinHSS{z}(j)=nanmean(sratechange{z}(temp));
        BinHSSStd{z}(j)=nanstd(sratechange{z}(temp))/sqrt(length(temp));
        
         
        BinHSB{z}(j)=nanmean(bratechange{z}(temp));
        BinHSBStd{z}(j)=nanstd(bratechange{z}(temp))/sqrt(length(temp));
        
        BinHSD{z}(j)=nanmean(rratechange{z}(temp));
        BinHSDStd{z}(j)=nanstd(rratechange{z}(temp))/sqrt(length(temp));
        
        BinHSL{z}(j)=nanmean(lratechange{z}(temp));
        BinHSLStd{z}(j)=nanstd(lratechange{z}(temp))/sqrt(length(temp));
        
        
        clear temp
        
    end
    %BinLSCell{z}(BinLSCell{z}==0)=NaN;
    %BinHSS{z}(BinHSS{z}==0)=NaN;
%     
%    figure 
%     errorbar(BinLSCell{z},BinHSB{z},BinHSBStd{z},myshape{2},'Color',C{2},'LineWidth',2,'MarkerSize',10)
%     hold on
%     errorbar(BinLSCell{z},BinHSS{z},BinHSSStd{z},myshape{1},'LineWidth',2,'MarkerSize',10)
%     errorbar(BinLSCell{z},BinHSD{z},BinHSDStd{z},myshape{3},'LineWidth',2,'MarkerSize',10)
%  %  errorbar(BinLSCell{z},BinHSTD{z},BinHSTDStd{z},myshape{7},'LineWidth',2,'MarkerSize',10) 
%    % errorbar(BinLSCell{z},BinHSL2{z},BinHSL2Std{z},myshape{5},'LineWidth',2,'MarkerSize',10)
%    % errorbar(BinLSCell{z},BinHSBD{z},BinHSBDStd{z},myshape{6},'LineWidth',2,'MarkerSize',10)
%    errorbar(BinLSCell{z},BinHSL{z},BinHSLStd{z},myshape{4},'LineWidth',2,'MarkerSize',10) 
%  legend('Spontaneous Locomotion','Stimulated Locomotion','Respone Duration','Response Latency')
%     xlabel('Lifespan (Days)')
%     ylabel('Change in Decline Rate (Late-Early Life)')
%    axis([0.9*min(BinLSCell{z}) 1.1*max(BinLSCell{z}) 1.5*min([BinHSL{z} BinHSS{z} BinHSB{z} BinHSD{z}]) 1.5*max([BinHSL{z} BinHSS{z} BinHSB{z} BinHSD{z}])])
%     set(gca,'Fontsize',15)
%     box off
%     legend boxoff
      
    errorbar(BinLSCell{z},BinHSS{z},BinHSSStd{z},myshape{z},'Color',c{z},'LineWidth',2,'MarkerSize',10)
    hold on
    xlabel('Lifespan (Days)')
    ylabel('Change in Decline Rate (Pixels/Life Fraction)')
  set(gca,'Fontsize',15)
    box off
    
    legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
    %legend('N2','\it{daf-16}','\it{daf-2}')
    legend boxoff
    axis([6 44 -81 45])
    
  
end
%%
load earlyLifeActivity
figure
myshape{1}='o';
myshape{2}='s';
myshape{3}='^';
myshape{4}='d';
myshape{5}='<';
myshape{6}='p';
myshape{7}='x';
myshape{8}='h';
tempL=[];
tempS=[];
tempSp=[];
tempSt=[];
tempRD=[];
tempLa=[];
tempSpV=[];
tempStV=[];
tempRDV=[];
tempLaV=[];

for z=[1 2 3 4 5 6 8]
    plot(LSC{z},sratechange{z},myshape{z},'Color',c{z},'LineWidth',2,'MarkerSize',5)
    hold on
    tempL=[tempL LSC{z}];
    tempS=[tempS sratechange{z}];
    tempSp=[tempSp earlySpontAct{z}];
    tempSt=[tempSt earlyStimAct{z}];
    tempRD=[tempRD earlyRD{z}];
    tempLa=[tempLa earlyL{z}];
    tempSpV=[tempSpV VearlySpontAct{z}];
    tempStV=[tempStV VearlyStimAct{z}];
    tempRDV=[tempRDV VearlyRD{z}];
    tempLaV=[tempLaV VearlyL{z}];
end
xlabel('Lifespan (Days)')
ylabel('Change in Decline Rate (Pixels/Life Fraction)')
set(gca,'Fontsize',15)
box off

legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
legend boxoff
axis([4 48 -160 180])
