function []=responseLatency(savename)
% measure response latency

foldername=uigetdir('Select Directory with .mat files');

cd(foldername)

filenames=uigetfile('*.mat','MultiSelect', 'on','Select the .mat files');
%
lightonindex=182;
smoothkernel=1;


for j=1:length(filenames)
    load(filenames{j})
    try
        tstart=find(mean(pdata(lightonindex:end,:),2)>0);
        tstart=tstart(1);
        for i=1:240
            tempact=conv(pdata((lightonindex+tstart):end,i),ones(1,smoothkernel)/smoothkernel,'same');
            tempbase=conv(pdata(1:lightonindex,i),ones(1,smoothkernel)/smoothkernel,'same');
            tmax=prctile(tempact,95);
            
            tpt=find(tempact>=1);
            tpt2=find(tempact>tmax/2);
            rbase(j,i)=5*sum(tempbase>0);
            rtot(j,i)=5*sum(tempact>0);
            if tpt
                latency(j,i)=5*tpt(1);
                latency2(j,i)=5*tpt2(1);
                rdur(j,i)=5*sum(tempact>5*tmax/10);
            else
                latency(j,i)=900;
                latency2(j,i)=900;
                rdur(j,i)=0;
            end
            
        end
    catch
        latency(j,:)=NaN;
        latency2(j,:)=NaN;
        rdur(j,:)=NaN;
        rbase(j,:)=NaN;
        rtot(j,:)=NaN;
    end
end


save(savename,'latency', 'latency2', 'rdur','rbase','rtot')