%%  Analyze behavior on paraquat
close all

days=[trs(1):0.1:1.1];
days9=[trs9(1):0.1:1.1];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
    inds9(i)=max(find(trs9<=days9(i)));
end


for j=1:4
    %barB{j}(1,:)=nanmean(AR{j}(1:inds(1),find(LS1{j}>=prctile(LS1{j},50))),1);
   barB{j}(1,:)=nanmean(AR{j}(1:inds(1),:),1);
   
   barB9{j}(1,:)=nanmean(AR9{j}(1:inds9(1),:),1);
    %barB{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}<=0.5*max(LSC{j})),1);
    %barS{j}(1,:)=nanmean(SLR{j}(1:inds(1),LSC{j}>0.5*max(LSC{j})),1);
   
end
for j=1:4
    for i=2:length(inds)
        %barB{j}(i,:)=nanmean(AR{j}(inds(i-1):inds(i),find(LS1{j}>=prctile(LS1{j},50))),1);
        barB{j}(i,:)=nanmean(AR{j}(inds(i-1):inds(i),:),1);
        barB9{j}(i,:)=nanmean(AR9{j}(inds9(i-1):inds9(i),:),1);
        %barB{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}<=0.5*max(LSC{j})),1);
        %barS{j}(i,:)=nanmean(SLR{j}(inds(i-1):inds(i),LSC{j}>0.5*max(LSC{j})),1);
    end
end

for i=1:length(days)
    for j=1:4
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        
        BM9{j}(i)=nanmean(barB9{j}(i,:));
        BS9{j}(i)=nanstd(barB9{j}(i,:));
       
    end
end
days=days-trs(1);
days9=days9-trs9(1);

for j=1:4
%     figure
%     errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'-','Color',c{j},'LineWidth',2,'MarkerSize',10)
%    
%     xlabel('Time (Fraction of Life)')
%     ylabel('Activity (Pixels Moved)')
%     
%     box off
%     set(gca,'FontSize',15)
%     axis([0 1.02 0 400])

    figure
    errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'-','Color',c{j},'LineWidth',2,'MarkerSize',10)
    hold on
    errorbar(days9,BM9{j},BS9{j}/sqrt(length(barB9{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
   
    xlabel('Time (Fraction of Life)')
    ylabel('Activity (Pixels Moved)')
    legend('Paraquat added Day 1','Paraquat added Day 9')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([0 1.02 0 400])
end

save resampled_paraquat days BM BS barB days9 BM9 BS9 barB9

%%

bEarlySlopes=cell(1,8);

bLateSlopes=cell(1,8);
forslope=[3:7];
forslope2=[7:11];

for j=1:4
    [x y]=size(barB{j});
    
    for i=1:y
        [temp temp2]=polyfit(days(forslope),barB{j}(forslope,i)',1);
        bEarlySlopes{j}=[bEarlySlopes{j} -.1*temp(1)];
        [temp temp2]=polyfit(days(forslope2),barB{j}(forslope2,i)',1);
        bLateSlopes{j}=[bLateSlopes{j} -.1*temp(1)];
   end

end


for j=1:4
    bratechange{j}=bLateSlopes{j}-bEarlySlopes{j};

end
LSC=LS1;
close all
myshape{1}='o-';
myshape{2}='s-';
myshape{3}='^-';
myshape{4}='d-';

C{1}=[1 0 0];
C{2}=[0 0 0];
x=0:1:50;
tiles=4;
figure
for z=1:4
    [rt pt]=corrcoef(LSC{z},bratechange{z});
    rb{z}=rt(1,2);
    pb{z}=pt(1,2);

    
    for j=1:tiles

        jj=prctile(LSC{z},100/tiles*(j-1));
        jj2=prctile(LSC{z},100/tiles*j);
        
        temp=find((LSC{z}>jj).*(LSC{z}<(jj2)));
        
        BinLSCell{z}(j)=nanmean(LSC{z}(temp));
        BinLSCellStd{z}(j)=nanstd(LSC{z}(temp))/sqrt(length(temp));
        
        
    
        BinHSB{z}(j)=nanmean(bratechange{z}(temp));
        BinHSBStd{z}(j)=nanstd(bratechange{z}(temp))/sqrt(length(temp));
        
        
        clear temp
        
    end
    %BinLSCell{z}(BinLSCell{z}==0)=NaN;
    %BinHSS{z}(BinHSS{z}==0)=NaN;
 
    errorbar(BinLSCell{z},BinHSB{z},BinHSBStd{z},myshape{z},'Color',c{z},'LineWidth',2,'MarkerSize',10)
    hold on
    
    xlabel('Survival (Hours)')
    ylabel('Change in Decline Rate (Pixels/Life Fraction)')
   %axis([0.8*min(BinLSCell{z}) 1.1*max(BinLSCell{z}) 2.25*min([BinHSB{z}]) 2.25*abs(max([BinHSB{z}]))])
    set(gca,'Fontsize',15)
    box off
    legend boxoff
    legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}','\it{tax-4}','\it{unc-31}','\it{lite-1}')
    legend boxoff
    %text(4,15,'HS=LS','FontSize',15)
    %text(5,2,'HS=LS/2','FontSize',15)
end


%% separate by upper and lower halves

close all
days=[trs(1):0.1:1.1];
forslope=[3:7];
forslope2=[7:11];

for i=1:length(days)
    inds(i)=max(find(trs<=days(i)));
end


for j=1:4
    
    barB{j}(1,:)=nanmean(AR{j}(1:inds(1),LS1{j}<=prctile(LS1{j},25)),1);
    barS{j}(1,:)=nanmean(AR{j}(1:inds(1),LS1{j}>prctile(LS1{j},75)),1);
    
    
end
for j=1:4
    for i=2:length(inds)
        
        barB{j}(i,:)=nanmean(AR{j}(inds(i-1):inds(i),LS1{j}<=prctile(LS1{j},25)),1);
        barS{j}(i,:)=nanmean(AR{j}(inds(i-1):inds(i),LS1{j}>prctile(LS1{j},75)),1);
        
        
    end
end

for i=1:length(days)
    for j=1:4
        BM{j}(i)=nanmean(barB{j}(i,:));
        BS{j}(i)=nanstd(barB{j}(i,:));
        SM{j}(i)=nanmean(barS{j}(i,:));
        SS{j}(i)=nanstd(barS{j}(i,:));
        
    end
    
end


for j=1:4
    [EM{j} EM2{j}]=polyfit(days(forslope),BM{j}(forslope),1);
    EM{j}=EM{j}(1);
    [ES{j} ES2{j}]=polyfit(days(forslope),SM{j}(forslope),1);
    ES{j}=ES{j}(1);
    
    [PM{j} PM2{j}]=polyfit(days(forslope2),BM{j}(forslope2),1);
    PM{j}=PM{j}(1);
    [PS{j} PS2{j}]=polyfit(days(forslope2),SM{j}(forslope2),1);
    PS{j}=PS{j}(1);
    
end

days=days-trs(1);

for j=1:4
    figure
    errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2,'MarkerSize',10)
    hold on
    errorbar(days,SM{j},SS{j}/sqrt(length(barB{j})),'Color',c{j},'LineWidth',2)
    xlabel('Time (Fraction of Life)')
    ylabel('Stimulated Activity (Pixels Moved)')
    legend('Short-Lived','Long-Lived')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([0 1.02 0 450])
end


