clear all
close all
c{1}=[0 0 0];
c{2}=[1 0 0];
c{3}=[0.8 0 0.7];
c{4}=[0.2 0.7 0.3];
c{5}=[0.6 0.3 0.1];
c{6}=[0.3 0.8 0.9];
c{7}=[0.1 0.4 0.8];
c{8}=[0.9 0.6 0.2];

load resampled_paraquat

load resampledDA837_aging

for j=1:8
    figure
    
    errorbar(days,SM{j},SS{j}/sqrt(length(barS{j})),'Color',c{j},'LineWidth',2)
    
    hold on
    errorbar(days,BM{j},BS{j}/sqrt(length(barB{j})),'--','Color',c{j},'LineWidth',2)
    errorbar(days9,BM9{j},BS9{j}/sqrt(length(barB9{j})),'o-','Color',c{j},'LineWidth',2,'MarkerSize',10)
    xlabel('Time (Fraction of Experiment)')
    ylabel('Activity (Pixels Moved)')
    legend('Normal Aging','Paraqaut Added Day 1','Paraquat Added Day 9')
    legend boxoff
    box off
    set(gca,'FontSize',15)
    axis([-.1 1.1 0 400])
end

figure
for j=1:4
   diff{j}=abs(SM{j}-BM{j})./(SM{j}+BM{j}); 
   
   BM{j}=BM{j}+mean(SM{j}-BM{j});
   diff2{j}=abs(SM{j}-BM{j})./(SM{j}+BM{j}); 
   hold on
   plot(days,diff2{j},'Color',c{j},'LineWidth',2)
    xlabel('Time (Fraction of Experiment)')
    ylabel('Activity (Pixels Moved)')
    box off
    set(gca,'FontSize',15)
    %axis([-.1 1.1 0 400])
end
 legend('N2','\it{daf-16}','\it{daf-2}','\it{age-1}')
    legend boxoff
   
%% compare early and late slopes for normal aging and paraquat added day1

clear all
close all
load normalaging_early_late_decline_rates
load paraquat_day1_early_late_decline_rates



figure
for j=1:8
    
    
    model_series(j,1)=nanmean(sEarlySlopes{j});
    model_error(j,1)=nanstd(sEarlySlopes{j})/sqrt(length(sEarlySlopes{j}));
    model_series(j,2)=nanmean(sLateSlopes{j});
    model_error(j,2)=nanstd(sLateSlopes{j})/sqrt(length(sLateSlopes{j}));
        
    model_series(j,3)=nanmean(bEarlySlopes{j});
    model_error(j,3)=nanstd(bEarlySlopes{j})/sqrt(length(bEarlySlopes{j}));
    model_series(j,4)=nanmean(bLateSlopes{j});
    model_error(j,4)=nanstd(bLateSlopes{j})/sqrt(length(bLateSlopes{j}));
    
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
    set(h(1),'FaceColor',[1 1 1])
    set(h(2),'FaceColor',[0.5 0.5 0.5])
% for j=1:8
%     set(h(j),'FaceColor',c{j})
% end
set(get(gca,'YLabel'),'String','Decline Rate (Pixels/Time)')
set(gca,'XTickLabel',[])
set(gca,'XTick',[])
set(gca,'FontSize',15)
legend('Normal Aging Early','Normal Aging Late','Paraquat Early','Paraquat Late')
legend boxoff
box off
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
%axis([0 9 0 550])


clear model_series model_error

figure
for j=1:8
    bratechange{j}=bLateSlopes{j}-bEarlySlopes{j};
    sratechange{j}=sLateSlopes{j}-sEarlySlopes{j};
    
    model_series(j,1)=nanmean(sratechange{j});
    model_error(j,1)=nanstd(sratechange{j})/sqrt(length(sratechange{j}));
    model_series(j,2)=nanmean(bratechange{j});
    model_error(j,2)=nanstd(bratechange{j})/sqrt(length(bratechange{j}));

   [a b{j} c]=ttest2(sratechange{j},bratechange{j}); 
end

h = bar(model_series);
set(h,'BarWidth',1);    % The bars will now touch each other
%set(gca,'YGrid','on')
set(gca,'GridLineStyle','-')
%set(gca,'XTicklabel','')
    set(h(1),'FaceColor',[1 1 1])
    set(h(2),'FaceColor',[0.5 0.5 0.5])
% for j=1:8
%     set(h(j),'FaceColor',c{j})
% end
set(get(gca,'YLabel'),'String','Change in Decline Rate (Late-Early) (Pixels/Time)')
set(gca,'XTickLabel',[])
set(gca,'XTick',[])
set(gca,'FontSize',15)
legend('Normal Aging','Paraquat')
legend boxoff
box off
hold on;
numgroups = size(model_series, 1);
numbars = size(model_series, 2);
groupwidth = min(0.8, numbars/(numbars+1.5));
for i = 1:numbars
    % Based on barweb.m by Bolu Ajiboye from MATLAB File Exchange
    x = (1:numgroups) - groupwidth/2 + (2*i-1) * groupwidth / (2*numbars);  % Aligning error bar with individual bar
    errorbar(x, model_series(:,i), model_error(:,i), 'k.', 'LineWidth',2);
end
%axis([0 9 0 550])

