% Blue Light Stimulation Control with Labjack
% Matt Churgin
% Fang-Yen Lab, University of Pennsylvania
% Use these cells to control light with Labjack
% If using a Nidaq instead, please scroll down to cell 4

% Initialize LabJack
ljud_LoadDriver; % Loads LabJack UD Function Library
ljud_Constants; % Loads LabJack UD constant file
[Error ljHandle] = ljud_OpenLabJack(LJ_dtU3,LJ_ctUSB,'1',1); % Returns ljHandle for open LabJack
Error_Message(Error) % Check for and display any Errros

%Start by using the pin_configuration_reset IOType so that all
%pin assignments are in the factory default condition.
Error = ljud_ePut (ljHandle, LJ_ioPIN_CONFIGURATION_RESET, 0, 0, 0);
Error_Message(Error)



%% Core Codes ----------------
% Switch  LED
Switch1 =0;% 0 o
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)

%%

j=1;

ledontime=10;

ontimes=[11 45; 23 45];

Switch1 = 0;
Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, Switch1, 0);
Error_Message(Error)

while j==1
  
    currt=clock;
    if currt(4)==ontimes(1,1) && currt(5)==ontimes(1,2)
         display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) '. Turning light on.'])
        ONclock(:,i)=clock;
        %Turn led on
        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 4, 0);
        Error_Message(Error)
        % Wait  ledontime
        pause(ledontime)
        % turn led off
        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
        Error_Message(Error)
        pause(60)
    elseif currt(4)==ontimes(2,1) && currt(5)==ontimes(2,2)
        display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) '. Turning light on.'])
        ONclock(:,i)=clock;
        %Turn led on
        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 4, 0);
        Error_Message(Error)
        % Wait  ledontime
        pause(ledontime)
        % turn led off
        Error = ljud_ePut(ljHandle, LJ_ioPUT_DAC, 0, 0, 0);
        Error_Message(Error)
        pause(60)
    end
    display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) ':' num2str(round(currt(6)))])
   pause(1)
end








%%
% Blue Light Stimulation Control with Nidaq
% Use these cells to control light using Nidaq


devices=daq.getDevices;
s=daq.createSession('ni');
addAnalogOutputChannel(s,'Dev1',0,'Voltage');

%% Core Codes ----------------
% Switch  LED
Switch1 =0;% 0 o
outputSingleScan(s,Switch1)


%%

j=1;

ledontime=10;

ontimes=[11 45; 23 45];

while j==1
    currt=clock;
    if currt(4)==ontimes(1,1) && currt(5)==ontimes(1,2)
        display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) '. Turning light on.'])
        %Turn led on
        outputSingleScan(s,4)
        % Wait  ledontime
        pause(ledontime)
        % turn led off
        outputSingleScan(s,0)
        pause(60)
    elseif currt(4)==ontimes(2,1) && currt(5)==ontimes(2,2)
        display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) '. Turning light on.'])
        %Turn led on
        outputSingleScan(s,4)
        % Wait  ledontime
        pause(ledontime)
        % turn led off
        outputSingleScan(s,0)
        pause(60)
    end
    display(['current time is ' num2str(currt(4)) ':' num2str(currt(5)) ':' num2str(round(currt(6)))])
    pause(1)
end








