function [ Onset ] = OnsetDetect( Force , SampFreq)
% OnsetDetect: Movement onset detection based on the algorithm recommended
% by Teasdale et al (1993)
%   This algorithm first locates the sample at which the force derivative exceeds 
%   10% of its maximum value (Vmax). Then it traces back from this point and stops 
%   at the first sample (S) less than or equal to Vmax/10 - Vmax/100. Next the algorithm 
%   determines the standard deviation of the series between sample 1 and sample S (SD). 
%   Working back from S, onset is the first sample less than or equal to S-SD

DForce          = diff(Force)./(1/SampFreq);
[Vmax,Vmax_ind] = max(DForce);
DForce_int      = DForce(1:Vmax_ind);
DForce_int_rev  = DForce_int (end: -1:1);
S               = (Vmax/10)-(Vmax/100);
S_ind           = find(DForce_int_rev < S, 1 );
sd              = std(DForce_int(1:end-S_ind));
onset_rev_ind   = S_ind + find(DForce_int_rev(S_ind:end) < (S-sd), 1 );
Onset           = length(DForce_int)-onset_rev_ind;

end

