(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.4' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     25342,        621]
NotebookOptionsPosition[     24517,        588]
NotebookOutlinePosition[     24877,        604]
CellTagsIndexPosition[     24834,        601]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[TextData[{
 StyleBox["Ultrasensitivity lifted by CheB phosphorylation feedback\n", 
  "Title"],
 "In this script, we use the analysis of Goldbeter and Koshland (PNAS 1981) \
and Emonet and Cluzel (PNAS 2008) to describe the activity A due to push-pull \
activity of CheB and CheR."
}], "Text",
 CellChangeTimes->{{3.687711462712253*^9, 3.687711544861236*^9}, 
   3.7143017437980633`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"A", "[", 
   RowBox[{"u_", ",", "v_", ",", "J_", ",", "K_"}], "]"}], "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"2", "u", " ", "K"}], ")"}], "/", 
   RowBox[{"(", 
    RowBox[{"v", "-", "u", "+", 
     RowBox[{"v", " ", "J"}], " ", "+", 
     RowBox[{"u", " ", "K"}], " ", "+", 
     RowBox[{"Sqrt", "[", 
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"v", "-", "u", "+", 
          RowBox[{"v", " ", "J"}], " ", "+", 
          RowBox[{"u", " ", "K"}]}], ")"}], "2"], "-", 
       RowBox[{"4", 
        RowBox[{"(", 
         RowBox[{"v", "-", "u"}], ")"}], "u", " ", "K"}]}], "]"}]}], 
    ")"}]}]}]], "Input"],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", "K", " ", "u"}], 
  RowBox[{
   RowBox[{"-", "u"}], "+", 
   RowBox[{"K", " ", "u"}], "+", "v", "+", 
   RowBox[{"J", " ", "v"}], "+", 
   SqrtBox[
    RowBox[{
     RowBox[{
      RowBox[{"-", "4"}], " ", "K", " ", "u", " ", 
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "u"}], "+", "v"}], ")"}]}], "+", 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"-", "u"}], "+", 
        RowBox[{"K", " ", "u"}], "+", "v", "+", 
        RowBox[{"J", " ", "v"}]}], ")"}], "2"]}]]}]]], "Output",
 CellChangeTimes->{3.68771177405264*^9, 3.690113711918496*^9, 
  3.6914052258821707`*^9, 3.691471190603266*^9, 3.714301748627483*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"logspace", "[", 
   RowBox[{"a_", ",", "b_", ",", "n_"}], "]"}], ":=", 
  RowBox[{"10.0", "^", 
   RowBox[{"Range", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"b", "-", "a"}], ")"}], "/", 
      RowBox[{"(", 
       RowBox[{"n", "-", "1"}], ")"}]}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.687710345569628*^9, 3.687710368801834*^9}, {
   3.687710559699741*^9, 3.687710568384795*^9}, 3.687710610884457*^9, 
   3.6877106481317*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Manipulate", "[", 
    RowBox[{
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "RoverB", ",", "BP", ",", "ACTIVITY", ",", "ACTIVITY2", ",", 
         "ACTIVITY3"}], "}"}], ",", "\[IndentingNewLine]", 
       RowBox[{
        RowBox[{"RoverB", "=", " ", 
         RowBox[{"logspace", "[", 
          RowBox[{
           RowBox[{"-", "0.5"}], ",", "1", ",", "50"}], "]"}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"BP", "=", 
         RowBox[{"Map", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Bp", "/.", 
             RowBox[{
              RowBox[{"NSolve", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{
                   RowBox[{"kdp", " ", "Bp"}], "\[Equal]", 
                   RowBox[{
                    RowBox[{
                    RowBox[{"A", "[", 
                    RowBox[{
                    RowBox[{"kr", " ", "rOverB", " ", "Bt"}], ",", 
                    RowBox[{
                    RowBox[{"gain", " ", "kb", " ", "Bp"}], " ", "+", " ", 
                    RowBox[{"1", 
                    RowBox[{"(", 
                    RowBox[{"Bt", "-", "Bp"}], ")"}], "kb"}]}], ",", " ", 
                    "Kr", ",", " ", "Kb"}], "]"}], "^", "alpha"}], " ", "kp", 
                    " ", 
                    RowBox[{"(", 
                    RowBox[{"Bt", "-", "Bp"}], ")"}]}]}], "&&", 
                  RowBox[{"Bp", "\[GreaterEqual]", "0"}]}], "/.", 
                 RowBox[{"rOverB", "\[Rule]", "#"}]}], ",", "Bp", ",", 
                "Reals"}], "]"}], "[", 
              RowBox[{"[", "1", "]"}], "]"}]}], "&"}], ",", "RoverB"}], 
          "]"}]}], ";", "\[IndentingNewLine]", 
        RowBox[{"ACTIVITY", "=", 
         RowBox[{
          RowBox[{"A", "[", 
           RowBox[{
            RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
            RowBox[{
             RowBox[{"kb2", " ", 
              RowBox[{"(", 
               RowBox[{"Bt", "-", "Bp"}], ")"}]}], "+", 
             RowBox[{"gain", " ", "kb2", " ", "Bp"}]}], ",", " ", "Kr", ",", 
            " ", "Kb"}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Bp", " ", "\[Rule]", "BP"}], ",", 
            RowBox[{"kb2", "\[Rule]", "kb"}], ",", 
            RowBox[{"roverB", "\[Rule]", "RoverB"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ACTIVITY2", "=", 
         RowBox[{
          RowBox[{"A", "[", 
           RowBox[{
            RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
            RowBox[{"1", "kb2", " ", "Bp"}], ",", " ", "Kr", ",", " ", "Kb"}],
            "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Bp", " ", "\[Rule]", "Bt"}], ",", 
            RowBox[{"kb2", "\[Rule]", "kb"}], ",", 
            RowBox[{"roverB", "\[Rule]", "RoverB"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ACTIVITY3", "=", 
         RowBox[{
          RowBox[{"A", "[", 
           RowBox[{
            RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
            RowBox[{"gainC", " ", "kb2", " ", "Bp"}], ",", " ", "Kr", ",", 
            " ", "Kbc"}], "]"}], "/.", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Bp", " ", "\[Rule]", "Bt"}], ",", 
            RowBox[{"kb2", "\[Rule]", "kb"}], ",", 
            RowBox[{"roverB", "\[Rule]", "RoverB"}]}], "}"}]}]}], ";", 
        "\[IndentingNewLine]", 
        RowBox[{"ListLogLinearPlot", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{
             RowBox[{"{", 
              RowBox[{"RoverB", ",", "ACTIVITY"}], "}"}], "//", "Transpose"}],
             ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"RoverB", ",", "ACTIVITY2"}], "}"}], "//", 
             "Transpose"}], ",", 
            RowBox[{
             RowBox[{"{", 
              RowBox[{"RoverB", ",", "ACTIVITY3"}], "}"}], "//", 
             "Transpose"}]}], "}"}], ",", 
          RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
          RowBox[{"AxesLabel", "->", 
           RowBox[{"{", 
            RowBox[{
             RowBox[{"CheR", "/", "CheB"}], ",", "activity"}], "}"}]}], ",", 
          RowBox[{"PlotLegends", " ", "\[Rule]", " ", 
           RowBox[{"{", 
            RowBox[{"\"\<WT\>\"", ",", "\"\<D56E\>\"", ",", "\"\<CheBc\>\""}],
             "}"}]}]}], "]"}]}]}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kr", ",", "3"}], "}"}], ",", "0.01", ",", "10"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Kr", ",", "0.03"}], "}"}], ",", "0.01", ",", "10"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kb", ",", "3"}], "}"}], ",", "0.01", ",", "10"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Kbc", ",", "0.20"}], "}"}], ",", "0.01", ",", "10"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Kb", ",", "0.03"}], "}"}], ",", "0.01", ",", "10"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Bt", ",", "1"}], "}"}], ",", "0.001", ",", "1"}], "}"}], ",",
      "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kp", ",", "0.17"}], "\[IndentingNewLine]", "}"}], ",", 
       "0.01", ",", "10"}], "}"}], ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"kdp", ",", "0.37"}], "}"}], ",", "0.01", ",", "10"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"gain", ",", "15"}], "}"}], ",", "1", ",", "200"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"gainC", ",", "7"}], "}"}], ",", "1", ",", "200"}], "}"}], 
     ",", "\[IndentingNewLine]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"alpha", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "2", ",", "3"}], "}"}]}], "}"}], ",", 
     RowBox[{"SynchronousUpdating", " ", "\[Rule]", " ", "False"}]}], "]"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]"}]}]], "Input",
 CellChangeTimes->{{3.68771064168572*^9, 3.68771064196017*^9}, {
   3.687710747898134*^9, 3.687710748863722*^9}, {3.68771086744352*^9, 
   3.68771086951437*^9}, {3.687711071478848*^9, 3.687711196218746*^9}, 
   3.6877112276814547`*^9, {3.687711299775363*^9, 3.6877113412412*^9}, {
   3.687711787785812*^9, 3.687711795920444*^9}, 3.688981421035645*^9, {
   3.688982552331953*^9, 3.688982555466729*^9}, {3.688984205801405*^9, 
   3.6889842443520412`*^9}, {3.688984402990528*^9, 3.6889844265013437`*^9}, {
   3.68898453464028*^9, 3.6889845490626698`*^9}, {3.688984650905035*^9, 
   3.6889846667458057`*^9}, {3.6890712914215183`*^9, 3.689071353041616*^9}, {
   3.6890714408192787`*^9, 3.689071447906981*^9}, {3.689072008553658*^9, 
   3.689072008726095*^9}, {3.6901137649456*^9, 3.690113816716002*^9}, 
   3.691405258253525*^9, {3.6914052982650423`*^9, 3.691405298528064*^9}, {
   3.691405339366354*^9, 3.6914053928892307`*^9}, {3.691412523703071*^9, 
   3.691412556827115*^9}, {3.691412597806088*^9, 3.691412618926126*^9}, {
   3.691412703979183*^9, 3.691412744424808*^9}, {3.691412830614731*^9, 
   3.6914128371825533`*^9}, {3.6914132406629953`*^9, 3.6914132898737793`*^9}, 
   3.691422580165593*^9, {3.691426026949802*^9, 3.691426081460676*^9}, {
   3.691426508746373*^9, 3.691426511273082*^9}, {3.6914265637847843`*^9, 
   3.691426564198399*^9}, {3.6914266084897327`*^9, 3.691426630218845*^9}, 
   3.691426818505416*^9, {3.691426876939068*^9, 3.691426936047995*^9}, {
   3.69142788856805*^9, 3.6914278894207582`*^9}, {3.691428016186514*^9, 
   3.691428017184721*^9}, {3.6914281591127377`*^9, 3.691428159213255*^9}, {
   3.6914712226119547`*^9, 3.6914713466045713`*^9}, {3.691471378158989*^9, 
   3.691471390053823*^9}, {3.691471452026259*^9, 3.691471452088759*^9}, {
   3.6914715508059*^9, 3.691471594854652*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`alpha$$ = 1, $CellContext`Bt$$ = 
    1, $CellContext`gain$$ = 15, $CellContext`gainC$$ = 7, $CellContext`kb$$ =
     3, $CellContext`Kb$$ = 0.03, $CellContext`Kbc$$ = 
    0.2, $CellContext`kdp$$ = 0.37, $CellContext`kp$$ = 
    0.17, $CellContext`kr$$ = 3, $CellContext`Kr$$ = 0.03, Typeset`show$$ = 
    True, Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`kr$$], 3}, 0.01, 10}, {{
       Hold[$CellContext`Kr$$], 0.03}, 0.01, 10}, {{
       Hold[$CellContext`kb$$], 3}, 0.01, 10}, {{
       Hold[$CellContext`Kbc$$], 0.2}, 0.01, 10}, {{
       Hold[$CellContext`Kb$$], 0.03}, 0.01, 10}, {{
       Hold[$CellContext`Bt$$], 1}, 0.001, 1}, {{
       Hold[$CellContext`kp$$], 0.17}, 0.01, 10}, {{
       Hold[$CellContext`kdp$$], 0.37}, 0.01, 10}, {{
       Hold[$CellContext`gain$$], 15}, 1, 200}, {{
       Hold[$CellContext`gainC$$], 7}, 1, 200}, {{
       Hold[$CellContext`alpha$$], 1}, {0, 1, 2, 3}}}, Typeset`size$$ = {
    435., {109., 114.}}, Typeset`update$$ = 0, Typeset`initDone$$, 
    Typeset`skipInitDone$$ = True, $CellContext`kr$10542$$ = 
    0, $CellContext`Kr$10543$$ = 0, $CellContext`kb$10544$$ = 
    0, $CellContext`Kbc$10545$$ = 0, $CellContext`Kb$10546$$ = 
    0, $CellContext`Bt$10547$$ = 0, $CellContext`kp$10548$$ = 
    0, $CellContext`kdp$10549$$ = 0, $CellContext`gain$10550$$ = 
    0, $CellContext`gainC$10551$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`alpha$$ = 1, $CellContext`Bt$$ = 
        1, $CellContext`gain$$ = 15, $CellContext`gainC$$ = 
        7, $CellContext`kb$$ = 3, $CellContext`Kb$$ = 
        0.03, $CellContext`Kbc$$ = 0.2, $CellContext`kdp$$ = 
        0.37, $CellContext`kp$$ = 0.17, $CellContext`kr$$ = 
        3, $CellContext`Kr$$ = 0.03}, "ControllerVariables" :> {
        Hold[$CellContext`kr$$, $CellContext`kr$10542$$, 0], 
        Hold[$CellContext`Kr$$, $CellContext`Kr$10543$$, 0], 
        Hold[$CellContext`kb$$, $CellContext`kb$10544$$, 0], 
        Hold[$CellContext`Kbc$$, $CellContext`Kbc$10545$$, 0], 
        Hold[$CellContext`Kb$$, $CellContext`Kb$10546$$, 0], 
        Hold[$CellContext`Bt$$, $CellContext`Bt$10547$$, 0], 
        Hold[$CellContext`kp$$, $CellContext`kp$10548$$, 0], 
        Hold[$CellContext`kdp$$, $CellContext`kdp$10549$$, 0], 
        Hold[$CellContext`gain$$, $CellContext`gain$10550$$, 0], 
        Hold[$CellContext`gainC$$, $CellContext`gainC$10551$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> 
      Module[{$CellContext`RoverB$, $CellContext`BP$, $CellContext`ACTIVITY$, \
$CellContext`ACTIVITY2$, $CellContext`ACTIVITY3$}, $CellContext`RoverB$ = \
$CellContext`logspace[-0.5, 1, 50]; $CellContext`BP$ = 
         Map[ReplaceAll[$CellContext`Bp, 
            Part[
             NSolve[
              ReplaceAll[
               
               And[$CellContext`kdp$$ $CellContext`Bp == \
$CellContext`A[$CellContext`kr$$ $CellContext`rOverB $CellContext`Bt$$, \
$CellContext`gain$$ $CellContext`kb$$ $CellContext`Bp + 
                    1 ($CellContext`Bt$$ - $CellContext`Bp) \
$CellContext`kb$$, $CellContext`Kr$$, $CellContext`Kb$$]^$CellContext`alpha$$ \
$CellContext`kp$$ ($CellContext`Bt$$ - $CellContext`Bp), $CellContext`Bp >= 
                0], $CellContext`rOverB -> #], $CellContext`Bp, Reals], 
             1]]& , $CellContext`RoverB$]; $CellContext`ACTIVITY$ = ReplaceAll[
           $CellContext`A[$CellContext`kr$$ $CellContext`roverB \
$CellContext`Bt$$, $CellContext`kb2 ($CellContext`Bt$$ - $CellContext`Bp) + \
$CellContext`gain$$ $CellContext`kb2 $CellContext`Bp, $CellContext`Kr$$, \
$CellContext`Kb$$], {$CellContext`Bp -> $CellContext`BP$, $CellContext`kb2 -> \
$CellContext`kb$$, $CellContext`roverB -> $CellContext`RoverB$}]; \
$CellContext`ACTIVITY2$ = ReplaceAll[
           $CellContext`A[$CellContext`kr$$ $CellContext`roverB \
$CellContext`Bt$$, 
            1 $CellContext`kb2 $CellContext`Bp, $CellContext`Kr$$, \
$CellContext`Kb$$], {$CellContext`Bp -> $CellContext`Bt$$, $CellContext`kb2 -> \
$CellContext`kb$$, $CellContext`roverB -> $CellContext`RoverB$}]; \
$CellContext`ACTIVITY3$ = ReplaceAll[
           $CellContext`A[$CellContext`kr$$ $CellContext`roverB \
$CellContext`Bt$$, $CellContext`gainC$$ $CellContext`kb2 $CellContext`Bp, \
$CellContext`Kr$$, $CellContext`Kbc$$], {$CellContext`Bp -> \
$CellContext`Bt$$, $CellContext`kb2 -> $CellContext`kb$$, $CellContext`roverB -> \
$CellContext`RoverB$}]; ListLogLinearPlot[{
           Transpose[{$CellContext`RoverB$, $CellContext`ACTIVITY$}], 
           Transpose[{$CellContext`RoverB$, $CellContext`ACTIVITY2$}], 
           Transpose[{$CellContext`RoverB$, $CellContext`ACTIVITY3$}]}, 
          PlotRange -> Full, 
          AxesLabel -> {$CellContext`CheR/$CellContext`CheB, \
$CellContext`activity}, PlotLegends -> {"WT", "D56E", "CheBc"}]], 
      "Specifications" :> {{{$CellContext`kr$$, 3}, 0.01, 
         10}, {{$CellContext`Kr$$, 0.03}, 0.01, 10}, {{$CellContext`kb$$, 3}, 
         0.01, 10}, {{$CellContext`Kbc$$, 0.2}, 0.01, 
         10}, {{$CellContext`Kb$$, 0.03}, 0.01, 10}, {{$CellContext`Bt$$, 1}, 
         0.001, 1}, {{$CellContext`kp$$, 0.17}, 0.01, 
         10}, {{$CellContext`kdp$$, 0.37}, 0.01, 
         10}, {{$CellContext`gain$$, 15}, 1, 200}, {{$CellContext`gainC$$, 7},
          1, 200}, {{$CellContext`alpha$$, 1}, {0, 1, 2, 3}}}, 
      "Options" :> {SynchronousUpdating -> False}, "DefaultOptions" :> {}],
     ImageSizeCache->{723., {168., 174.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    SynchronousInitialization->True,
    UndoTrackedVariables:>{Typeset`show$$, Typeset`bookmarkMode$$},
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{{3.691413246377548*^9, 3.691413291399334*^9}, {
   3.691426013941908*^9, 3.691426082190563*^9}, 3.6914265122001762`*^9, 
   3.6914265653064117`*^9, {3.691426610025114*^9, 3.691426631496381*^9}, 
   3.691426820015448*^9, {3.691426861774377*^9, 3.691426937567922*^9}, 
   3.691427906011504*^9, 3.6914280178433237`*^9, 3.691428162880404*^9, {
   3.691471198311355*^9, 3.691471348021974*^9}, {3.691471379698678*^9, 
   3.6914713911138573`*^9}, 3.691471453538692*^9, {3.691471558343419*^9, 
   3.6914715955941563`*^9}, 3.714301755306045*^9}]
}, Open  ]],

Cell["Generate data with parameters fixed", "Text",
 CellChangeTimes->{{3.687711438744782*^9, 3.68771144363941*^9}, {
   3.687711570397983*^9, 3.687711602645756*^9}, 3.691471622023685*^9, {
   3.7143017657652473`*^9, 3.7143018074527187`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"chosenParams", "=", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"kr", "\[Rule]", "3"}], ",", 
    RowBox[{"Kr", "\[Rule]", "0.03"}], ",", 
    RowBox[{"kb", "\[Rule]", "3"}], ",", 
    RowBox[{"Kb", "\[Rule]", "0.03"}], ",", 
    RowBox[{"Kbc", "\[Rule]", "0.2"}], ",", 
    RowBox[{"Bt", "\[Rule]", "1"}], ",", 
    RowBox[{"kp", "\[Rule]", "0.17"}], ",", 
    RowBox[{"kdp", "\[Rule]", "0.37"}], ",", 
    RowBox[{"alpha", "\[Rule]", "1"}], ",", 
    RowBox[{"gain", "\[Rule]", "15"}], ",", 
    RowBox[{"gainc", "\[Rule]", "7"}]}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"RoverB", "=", " ", 
   RowBox[{"logspace", "[", 
    RowBox[{
     RowBox[{"-", "1"}], ",", "1", ",", "1000"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"BP", "=", 
   RowBox[{"Map", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"Bp", "/.", 
       RowBox[{
        RowBox[{"NSolve", "[", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{"kdp", " ", "Bp"}], "\[Equal]", 
              RowBox[{
               RowBox[{
                RowBox[{"A", "[", 
                 RowBox[{
                  RowBox[{"kr", " ", "rOverB", " ", "Bt"}], ",", 
                  RowBox[{
                   RowBox[{"gain", " ", "kb", " ", "Bp"}], " ", "+", " ", 
                   RowBox[{"1", 
                    RowBox[{"(", 
                    RowBox[{"Bt", "-", "Bp"}], ")"}], "kb"}]}], ",", " ", 
                  "Kr", ",", " ", "Kb"}], "]"}], "^", "alpha"}], " ", "kp", 
               " ", 
               RowBox[{"(", 
                RowBox[{"Bt", "-", "Bp"}], ")"}]}]}], "&&", 
             RowBox[{"Bp", "\[GreaterEqual]", "0"}]}], "/.", 
            RowBox[{"rOverB", "\[Rule]", "#"}]}], "/.", "chosenParams"}], ",",
           "Bp", ",", "Reals"}], "]"}], "[", 
        RowBox[{"[", "1", "]"}], "]"}]}], "&"}], ",", "RoverB"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ACTIVITY", "=", 
   RowBox[{
    RowBox[{
     RowBox[{"A", "[", 
      RowBox[{
       RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
       RowBox[{
        RowBox[{"1", "kb2", " ", 
         RowBox[{"(", 
          RowBox[{"Bt", "-", "Bp"}], ")"}]}], "+", 
        RowBox[{"gain", " ", "kb2", " ", "Bp"}]}], ",", " ", "Kr", ",", " ", 
       "Kb"}], "]"}], "/.", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Bp", " ", "\[Rule]", "BP"}], ",", 
       RowBox[{"kb2", "\[Rule]", "kb"}], ",", 
       RowBox[{"roverB", "\[Rule]", "RoverB"}]}], "}"}]}], "/.", 
    "chosenParams"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ACTIVITY2", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{
        RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
        RowBox[{"1", "kb2", " ", "Bp"}], ",", " ", "Kr", ",", " ", "Kb"}], 
       "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Bp", " ", "\[Rule]", "Bt"}], ",", 
        RowBox[{"kb2", "\[Rule]", "kb"}]}], "}"}]}], "/.", "chosenParams"}], "/.", 
    RowBox[{"{", 
     RowBox[{"roverB", "\[Rule]", "RoverB"}], "}"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ACTIVITY3", "=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"A", "[", 
       RowBox[{
        RowBox[{"kr", " ", "roverB", " ", "Bt"}], ",", 
        RowBox[{"gainc", " ", "kb2", " ", "Bp"}], ",", " ", "Kr", ",", " ", 
        "Kbc"}], "]"}], "/.", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Bp", " ", "\[Rule]", "Bt"}], ",", 
        RowBox[{"kb2", "\[Rule]", "kb"}]}], "}"}]}], "/.", "chosenParams"}], "/.", 
    RowBox[{"{", 
     RowBox[{"roverB", "\[Rule]", "RoverB"}], "}"}]}]}], ";"}]}], "Input",
 CellChangeTimes->{
  3.687711415549411*^9, {3.687711665700055*^9, 3.687711693158101*^9}, {
   3.688981430697791*^9, 3.6889814387777357`*^9}, {3.691421609639765*^9, 
   3.691421612678136*^9}, {3.691421666687683*^9, 3.6914217067062483`*^9}, {
   3.691421741236779*^9, 3.691421776253974*^9}, {3.6914218282739964`*^9, 
   3.691421849274193*^9}, {3.691422584210853*^9, 3.691422584362318*^9}, {
   3.691427535483959*^9, 3.691427539387753*^9}, {3.691428183814938*^9, 
   3.691428201661429*^9}, {3.691471418807364*^9, 3.6914714189027643`*^9}, {
   3.691471525739056*^9, 3.6914715263150663`*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"kr", "\[Rule]", "3"}], ",", 
   RowBox[{"Kr", "\[Rule]", "0.03`"}], ",", 
   RowBox[{"kb", "\[Rule]", "3"}], ",", 
   RowBox[{"Kb", "\[Rule]", "0.03`"}], ",", 
   RowBox[{"Kbc", "\[Rule]", "0.2`"}], ",", 
   RowBox[{"Bt", "\[Rule]", "1"}], ",", 
   RowBox[{"kp", "\[Rule]", "0.17`"}], ",", 
   RowBox[{"kdp", "\[Rule]", "0.37`"}], ",", 
   RowBox[{"alpha", "\[Rule]", "1"}], ",", 
   RowBox[{"gain", "\[Rule]", "15"}], ",", 
   RowBox[{"gainc", "\[Rule]", "7"}]}], "}"}]], "Output",
 CellChangeTimes->{3.687711811382224*^9, 3.6889814426433477`*^9, 
  3.691421858639935*^9, 3.69142258553596*^9, 3.691422723003055*^9, 
  3.691427571105504*^9, 3.691427818696553*^9, 3.6914282027071733`*^9, 
  3.691428333109029*^9, 3.691471627176334*^9, 3.714301768054566*^9}]
}, Open  ]],

Cell["\<\
Finally, store these values in a .mat file to use for plotting and further \
analysis.\
\>", "Text",
 CellChangeTimes->{{3.687711621737384*^9, 3.687711636255157*^9}, {
  3.6877120057665052`*^9, 3.68771201548596*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\</Users/Keegstra/Dropbox/PhD/FRET_paper/data/CheB/GBKwithFeedback2.mat\>\
\"", ",", 
   RowBox[{"{", 
    RowBox[{"RoverB", ",", "ACTIVITY", ",", "ACTIVITY2", ",", "ACTIVITY3"}], 
    "}"}], ",", "\"\<Table\>\""}], "]"}]], "Input",
 CellChangeTimes->{3.691421618958102*^9}],

Cell[BoxData["\<\"/Users/Keegstra/Dropbox/PhD/FRET_paper/data/CheB/\
GBKwithFeedback2.mat\"\>"], "Output",
 CellChangeTimes->{
  3.691421924261126*^9, 3.691422695824534*^9, {3.691422761301776*^9, 
   3.691422776107451*^9}, {3.691427657628406*^9, 3.691427662229056*^9}, 
   3.691428378819751*^9, 3.691471659567189*^9}]
}, Open  ]]
},
WindowSize->{808, 603},
WindowMargins->{{178, Automatic}, {Automatic, 13}},
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 392, 8, 160, "Text"],
Cell[CellGroupData[{
Cell[975, 32, 681, 21, 35, "Input"],
Cell[1659, 55, 704, 21, 55, "Output"]
}, Open  ]],
Cell[2378, 79, 514, 14, 32, "Input"],
Cell[CellGroupData[{
Cell[2917, 97, 8397, 198, 621, "Input"],
Cell[11317, 297, 6864, 118, 359, "Output"]
}, Open  ]],
Cell[18196, 418, 242, 3, 30, "Text"],
Cell[CellGroupData[{
Cell[18463, 425, 4312, 114, 306, "Input"],
Cell[22778, 541, 808, 17, 54, "Output"]
}, Open  ]],
Cell[23601, 561, 226, 5, 30, "Text"],
Cell[CellGroupData[{
Cell[23852, 570, 329, 8, 54, "Input"],
Cell[24184, 580, 317, 5, 32, "Output"]
}, Open  ]]
}
]
*)

