function MakeControls(obj)

import siman.*;
parentPanel = obj.PanelID;
margin = siman.UIHelper.PANEL_MARGIN;
pos = get(parentPanel, 'Position');
top = pos(4)-margin-siman.UIHelper.PANEL_TOP_OFFSET;
source = obj.CellDef;

children = get(parentPanel, 'Children');
delete(children);

controlParams.ParentPanel = parentPanel;
controlParams.DataObject = source;
controlParams.Controller = source;

location = [margin top];

% Show notice of no definition
if isempty(source)
    siman.UIHelper.MakeLabel(['No cell definition'], ...
                    location, controlParams);
    return
end

% Add main controls that won't change

controlParams.Width = 100;
location = siman.UIHelper.MakeLabeledPopup('Orientation', 'Format:', ...
    location, controlParams);

controlParams.Width = 100;
location = siman.UIHelper.MakeLabeledPopup('Type', 'Method:', ...
    location, controlParams);


location(2) = location(2) - 10; % Spacing between control groups

switch source.Orientation
    case 'linescan'    
        switch source.Type
            case 'manual'
                controlParams.Width = 60;
                location = siman.UIHelper.MakeLabeledTextbox('ManualLowerEdge', 'Lower edge:', ...
                    location, controlParams);

                location = siman.UIHelper.MakeLabeledTextbox('ManualUpperEdge', 'Upper edge:', ...
                    location, controlParams);
            case 'threshold'
                controlParams.Width = 120;
                location = siman.UIHelper.MakeLabeledPopup('ThresholdType', 'Threshold type:', ...
                    location, controlParams);

                switch source.ThresholdType
                    case 'image units'
                        controlParams.Width = 60;
                        location = siman.UIHelper.MakeLabeledTextbox('Threshold_DataUnits', 'Exact threshold:', ...
                            location, controlParams);
                    case 'percentile'
                        controlParams.Width = 60;
                        location = siman.UIHelper.MakeLabeledTextbox('Threshold_Percentile', 'Percentile threshold:', ...
                            location, controlParams);
                        location = siman.UIHelper.MakeLabeledIndicator('Threshold_Actual', 'Exact threshold:', ...
                            location, controlParams);
                end
        end
    case '2-d'    
        switch source.Type
            case 'manual'
            case 'threshold'
                controlParams.Width = 120;
                location = siman.UIHelper.MakeLabeledPopup('ThresholdType', 'Threshold type:', ...
                    location, controlParams);

                switch source.ThresholdType
                    case 'image units'
                        controlParams.Width = 60;
                        location = siman.UIHelper.MakeLabeledTextbox('Threshold_DataUnits', 'Exact threshold:', ...
                            location, controlParams);
                    case 'percentile'
                        controlParams.Width = 60;
                        location = siman.UIHelper.MakeLabeledTextbox('Threshold_Percentile', 'Percentile threshold:', ...
                            location, controlParams);
                        location = siman.UIHelper.MakeLabeledIndicator('Threshold_Actual', 'Exact threshold:', ...
                            location, controlParams);
                end
        end
        controlParams.Width = 40;
        [nextLevelLocation, h] = siman.UIHelper.MakeLabeledTextbox('MinSize', 'Size limits:  Min', ...
            location, controlParams);

        pos = get(h, 'Position');
        controlParams.Width = 40;
        location(1) = pos(1) + pos(3) + 10;
        siman.UIHelper.MakeLabeledTextbox('MaxSize', 'Max', ...
            location, controlParams);

end
