function DrawCell(obj, ax)

switch obj.Orientation
    case 'linescan'
        DrawLinescanCell(obj, ax);
    case '2-d'
        Draw2dCell(obj, ax);
end
end


function Draw2dCell(obj, ax)
    h = zeros(numel(obj.Outlines));
    for i = 1:length(obj.Outlines)
        outline = obj.Outlines{i};
        x = outline(:,2);
        y = outline(:,1);
        lineWidth = 2;
        color = [.6 1 .6];
        z = ones(numel(x),1) * 2;
        h(i) = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth, 'HitTest', 'off');
    end
end


function DrawLinescanCell(obj, ax)
%     source = obj.RawDataSource;
%     cellDef = source.CellDefinition;
%     
%     axesid = obj.AxesID;
%     color = obj.CellColor;
%     alpha = .75;
%     imSize = obj.ImageSize;
%     edgeLimit = imSize(2);
%     linescanLength = imSize(1);
%     height = imSize(1);
%     
%     lowerEdge = cellDef.LowerEdge;
%     upperEdge = cellDef.UpperEdge;
%     if isinf(upperEdge)
%         upperEdge = edgeLimit;
%     end
%     
%     %type = obj.CellIndicatorType;
%     type = 'outline';
%     switch type
%         case 'mask'
%             xLower = [1 lowerEdge lowerEdge 1];
%             xUpper = [upperEdge edgeLimit edgeLimit upperEdge];
%             yLower = [1 1 linescanLength linescanLength];
%             %yLower = lim([1 1 2 2]);
%             yUpper = yLower;
%             [xLower, yLower] = obj.ConvertPointsToPlot(xLower, yLower);
%             [xUpper, yUpper] = obj.ConvertPointsToPlot(xUpper, yUpper);
%             z = [1 1 1 1]*10;
%             h = [];
%             if lowerEdge > 1
%                 h = patch(xLower, yLower, z, 'Parent', axesid, 'FaceAlpha', alpha, 'FaceColor', color);
%             end
%             if upperEdge < edgeLimit
%                 h(end + 1) = patch(xUpper, yUpper, z, 'Parent', axesid, 'FaceAlpha', alpha, 'FaceColor', color);
%             end
%         case 'outline'
%             xpoints1 = [lowerEdge lowerEdge];
%             xpoints2 = [upperEdge upperEdge];
%             ypoints1 = [1 height];
%             ypoints2 = [1 height];
%             [xpoints1, ypoints1] = obj.ConvertPointsToPlot(xpoints1, ypoints1);
%             [xpoints2, ypoints2] = obj.ConvertPointsToPlot(xpoints2, ypoints2);
%             h = line(xpoints1, ypoints1, [1 1], 'Parent', axesid, 'Color', color);
%             h(2) = line(xpoints2, ypoints2, [1 1], 'Parent', axesid, 'Color', color);
%     end
%     obj.CellGraphics = h;
end