function doc_node = ProduceReport(obj, container)

method = container.GetLastDetectionMethod(obj.FeatureType);
if isempty(method)
    warndlg('This file does not have a last known detection method');
    return;
end

filename = siman.FileIOHelper.ChooseOutputFile({'*.xml', 'Xml files'}, obj, 'LastFeatureReport');
if isempty(filename)
    return
end
[filePath, name] = fileparts(filename);

xslStylesheetSource = siman.FileIOHelper.ChooseInputFile({'*.xsl', 'Xsl Style files'}, obj, ...
    'LastFeatureReportStyleSheet', 'Choose report style sheet');
if isempty(xslStylesheetSource)
    return
end

% Create resources directory (subdirectory where all stylesheets, images, etc. are kept)
resourcesDir = [name '_resources'];
resourcesFullpath = fullfile(filePath, resourcesDir);
if ~exist(resourcesDir, 'dir')
    [success, message] = mkdir(resourcesFullpath);
    if ~success
        warndlg(['Could not create resources folder:' message]);
        return
    end
end

% Copy stylesheet into resources directory
[~, name, ext] = fileparts(xslStylesheetSource);
xslStylesheetDest = fullfile(filePath, resourcesDir, [name ext]);
xslStylesheetLink = fullfile(resourcesDir, [name ext]);
[success, message] = copyfile(xslStylesheetSource, xslStylesheetDest);
if ~success
    warndlg(['Could not create copy of xsl style sheet:' message]);
    return
end

% Copy stylesheet into resources directory
cssStylesheetName = 'reportStyles.css';
cssStylesheetSource = fullfile(siman.FileIOHelper.GetSimanPath(), 'reports', cssStylesheetName);
cssStylesheetDest = fullfile(resourcesFullpath, cssStylesheetName);
cssStylesheetLink = fullfile(resourcesDir, cssStylesheetName);
[success, message] = copyfile(cssStylesheetSource, cssStylesheetDest);
if ~success
    warndlg(['Could not create copy of css style sheet:' message]);
    return
end



% Set up overall xml document model 
doc_node = com.mathworks.xml.XMLUtils.createDocument('featurereport');
context = siman.ReportContext;
obj.ReportContext = context;
context.FeatureManager = obj;
context.FeatureType = obj.FeatureType;
context.DocNode = doc_node;
context.Source = container;
context.Method = method;

root = doc_node.getDocumentElement();
root.setAttribute('resourcespath', resourcesDir);
context.ResourcesDir = resourcesDir;
context.ResourcesFullPath = resourcesFullpath;
root.setAttribute('cssfilename', cssStylesheetName);
root.setAttribute('name', container.Name);
target = 'xml-stylesheet';
data = ['type="text/xsl" href="' xslStylesheetLink '"'];
styleInstruction = doc_node.createProcessingInstruction(target, data);
root.getParentNode().insertBefore(styleInstruction, root);

% Setup figure for creating report images
context.FigureBuffer = figure();
set(context.FigureBuffer, 'Color', [1 1 1], 'Position', [100 200 100 100]);
grabber = siman.ImageGrabber;
grabber.FigureID = context.FigureBuffer;
context.ImageGrabber = grabber;

% Add the content
container.GenerateFeatureReport(context);

% Write the file
xmlwrite(filename, doc_node);

% Cleanup
delete(context.FigureBuffer);
context.FigureBuffer = [];

web(filename, '-browser'); % Open report in external browser











