function ResetColor(obj)

def = obj.CurrentProcessingDef;
if isempty(def)
    return
end

if def.IsRGB
    return
end

switch obj.Colormap
    otherwise
        colormap(obj.Colormap);
end

dataLimits = double(obj.ImageDataLimits);
if ~isempty(dataLimits) %CHECK temporary fix for issue with no data limits
    mode = obj.ColorLimMode;
    switch mode
        case 'auto'
            lim = dataLimits;
        case 'manual'
            lim = [obj.ColorLim_Lower obj.ColorLim_Upper];
        case 'manual percent'
            percent = [obj.ColorPercentLim_Lower obj.ColorPercentLim_Upper];
            if percent(1) > 1
                percent(1) = percent(1)/100;
            end
            if percent(2) > 1
                percent(2) = percent(2)/100;
            end
            dataRange = dataLimits(2) - dataLimits(1);
            lim = percent .* dataRange + dataLimits(1);
        case 'manual percentile'
            percent = [obj.ColorPercentileLim_Lower obj.ColorPercentileLim_Upper];
            if percent(1) < 1
                percent(1) = percent(1)*100;
            end
            if percent(2) < 1
                percent(2) = percent(2)*100;
            end
            data = double(obj.FullImage(:));
            lim = prctile(data, percent);
    end
    if lim(1) == lim(2)
        if lim(1) == 0
            lim(2) = 1;
        else
            lim(1) = lim(1) - 0.5;
            lim(2) = lim(2) + 0.5;
        end
    end
    obj.ColorLimActual_Lower = lim(1);
    obj.ColorLimActual_Upper = lim(2);
    set(obj.AxesID, 'CLim', lim);
end


