function CreateXML(obj, context, op_node)

docNode = context.DocNode;

op_node.setAttribute('type', obj.Type);
switch lower(obj.Type)
    case 'subtract background'
        createParameterNode(docNode, op_node, 'Background value', obj.BackgroundValue);
    case 'median filter'
        createParameterNode(docNode, op_node, 'Filter shape', obj.MedianFilterType);
        switch obj.MedianFilterType
            case 'equal sides'
                createParameterNode(docNode, op_node, 'Filter width', obj.MedianFilterWidth);
            case 'independent sides'
            case 'custom'
        end
    case 'calculate baseline'
        createParameterNode(docNode, op_node, 'Baseline calculation method', obj.BaselineCalcMethod);
        switch obj.BaselineCalcMethod
            case 'minimum region'
                createParameterNode(docNode, op_node, 'Minimum region width', obj.BaselineMinimumRegionWidth);
            case 'manual region'
                createParameterNode(docNode, op_node, 'Region start', obj.BaselineManualRegionStart);
                createParameterNode(docNode, op_node, 'Region stop', obj.BaselineManualRegionStop);
            case 'sliding region'
                createParameterNode(docNode, op_node, 'Sliding region width', obj.BaselineSlidingRegionWidth);
            case 'rolling ball'
                createParameterNode(docNode, op_node, 'Rolling ball radius', obj.BaselineRollingRadius);
        end
    case 'baseline normalization'
        createParameterNode(docNode, op_node, 'Baseline normalization method', obj.BaselineNormMethod);
    case 'threshold'
        createParameterNode(docNode, op_node, 'Threshold method', obj.ThresholdType);
        switch obj.ThresholdType
            case 'fixed value'
                createParameterNode(docNode, op_node, 'Threshold', obj.ThresholdValue);
            case 'baseline st dev'
                createParameterNode(docNode, op_node, 'Threshold st dev', obj.ThresholdValue);
            case 'baseline percent'
                createParameterNode(docNode, op_node, 'Threshold percent', obj.ThresholdValue);
        end
    case 'morph'
        createParameterNode(docNode, op_node, 'Morph type', obj.MorphType);
        switch obj.MorphType
            case {'dilate', 'erode', 'close', 'open'}
                obj.MorphKernel.CreateXML(docNode, op_node, 'Morph filter');
            case {'dilate with threshold', 'erode with threshold'}
                createParameterNode(docNode, op_node, 'Morph threshold type', obj.MorphThresholdType);
                switch obj.MorphThresholdType
                    case 'percent'
                        createParameterNode(docNode, op_node, 'Morph threshold percent', obj.MorphThresholdPercent);
                end
                createParameterNode(docNode, op_node, 'Morph threshold used', obj.MorphThresholdActual);
                obj.MorphKernel.CreateXML(docNode, op_node, 'Morph filter');
        end
    case 'swap dimensions'
        createParameterNode(docNode, op_node, 'Swap dimensions', obj.SwapDimensions);
    case 'collapse dimension'
        createParameterNode(docNode, op_node, 'Collapse dimension', obj.CollapseDimension);
    case 'convert to ca'
        createParameterNode(docNode, op_node, 'Calcium conversion method', obj.ConvertCaMethod);
        switch obj.ConvertCaMethod
            case {'resting'}
                createParameterNode(docNode, op_node, 'Resting concentration', obj.ConvertCaRestingConc);
                createParameterNode(docNode, op_node, 'Kd', obj.ConvertCaKd);
            case {'fmin-fmax'}
                createParameterNode(docNode, op_node, 'fMax', obj.ConvertCaFMax);
                createParameterNode(docNode, op_node, 'Rf', obj.ConvertCaRf);
        end
        
    case 'restore original'
                
    otherwise
        createParameterNode(docNode, op_node, 'Unknown report operation', obj.Type);
end



