classdef Spark < siman.Feature
    % Must be a subclass of handle
    properties
        PeakAmplitude;
        PeakIndex;
        PeakXIndex;
        PeakYIndex;
        WaveformStartIndex;
        WaveformStopIndex;
        Area;
        
        LowerXBound;
        UpperXBound;
        LowerYBound;
        UpperYBound;
        WaveformStartOffset;
        WaveformStopOffset;
        Waveform;
        Thumbnail;
        RegionIndexes;
        RegionXIndexes;
        RegionYIndexes;
        
        Outlines;
        
        Baseline;
        BaselineRangeWidth;
        OnsetIndex;
        TimeToPeak;
        Index_DecayTo50;
        TimeTo50Decay;
        Index_DecayTo90;
        TimeTo90Decay;
    end
    
    methods
        % Constructor
        function obj = Spark()
            obj.Type = 'spark';
        end
        
        function h = Draw(obj, ax, plot)
            for i = 1:length(obj.Outlines)
                outline = obj.Outlines{i};
                y = outline(:,1);
                x = outline(:,2);
                [x, y] = plot.ConvertPointsToPlot(x, y);
                if obj.IsSelected
                    lineWidth = 2;
                    color = [1 .7 1];
                else
                    lineWidth = 1;
                    color = [1 .4 1];
                end
                z = ones(numel(x),1) * 2;
                h = line(x, y, z, 'Parent', ax, 'Color', color, 'LineWidth', lineWidth);
            end
        end
        
        function str = GetListString(obj)
            str = [obj.Name ' (' num2str(obj.PeakAmplitude) ')'];
        end
        
        function list = GetExportPropList(obj)
            list = {'PeakAmplitude', 'PeakXIndex', 'PeakYIndex'};
        end
        
        function data = GetExportData(obj)
            data = obj.Waveform;
        end
        
        function hit = HitTest(obj, area, plot)
            x = obj.RegionXIndexes;
            y = obj.RegionYIndexes;
            point1 = floor(area(1, [1 2]));
            point2 = ceil(area(2, [1 2]));
            hit = any(point1(2) <= y & point2(2) >= y & point1(1) <= x & point2(1) >= x);
        end
        
        function ans = IsInView(obj, area)
            ans = true;
        end
        
        function point = CenteredPoint(obj, point)
            point = [0, 0];
        end
    end
end







