function UpdateGraph(obj)

axesID = obj.GraphAxesID;
thumbnailAxesID = obj.ThumbnailAxesID;
list = obj.GetFeatureList();
count = list.Count;
cla(axesID);
cla(thumbnailAxesID);
if count == 0
    return;
end
manager = obj.GetManager();
method = manager.FeatureDetectionMethod;
thumbnail = [];
viewAll = obj.ViewAll;
drawnCount = 0;
for i = 1:count
    feature = list.ElementAt(i);
    isSelected = feature.IsSelected;
    timeConversion = method.UnitConversion_Time;
    [xData, yData] = feature.GetGraphData();
    if ~isempty(yData) && (viewAll || isSelected)
        drawnCount = drawnCount + 1;
        if isSelected && viewAll
            lineWidth = 3;
            color = [1 0 0];
        else
            lineWidth = 1;
            color = [0 0 0];
        end
        if isSelected || ~viewAll
            thumbnail = feature.Thumbnail;
        end
            
        xData = x .* timeConversion;
        h = line('Parent', axesID, 'XData', xData, 'YData', yData, 'Color', color, 'LineWidth', lineWidth);
        
    end
end
if drawnCount > 0
    set(axesID, 'XLim', [xData(1) xData(end)]);
end

if isempty(thumbnail)
    return;
end

imagesc('CData', thumbnail, 'Parent', thumbnailAxesID);
set(thumbnailAxesID, 'DataAspectRatio', [1 1 1]);